<?php function jw_tmpl_banners__banner(){ ?>
<?php
$args = jaw_template_get_var('args', array());
$instance = jaw_template_get_var('instance');
if(isset($instance['custom_banner'])){
        jwRender::get_banner('custom_'.$instance['custom_banner']);
}?>
<?php } ?>
<?php function jw_tmpl_banners__banner_background(){ ?>
<?php

$link_right = jwOpt::get_option('background_banner_link_right', 'http://');
$link_left = jwOpt::get_option('background_banner_link_left', 'http://');

$target = jwOpt::get_option('background_banner_target', '_blank');

if (strlen($link_left) > 0 && $link_left != 'http://') {
    echo '<a target="' . esc_attr($target) . '" class="background_banner_link left" href="' . esc_url($link_left) . '"></a>';
}
if (strlen($link_right) > 0 && $link_right != 'http://') {
    echo '<a target="' . esc_attr($target) . '" class="background_banner_link right" href="' . esc_url($link_right) . '"></a>';
} ?>
<?php } ?>
<?php function jw_tmpl_blog__archive(){ ?>
<?php
global $wp_query;

$term_id = jaw_template_get_var('termid','0');

$singlepost_preset = 'post-preset-' . jwOpt::get_option('main_color');

if (is_category()) {
    
   
    $singlepost_preset = 'post-preset-' . jwOpt::checkDefaultPreset(array(jwOpt::get_option('content_color', '_default', 'category', $term_id), jwOpt::get_option('main_color')),'color');
  
    echo jwUtils::customizer_preview_preset("Archive", jwOpt::checkDefaultPreset(array(jwOpt::get_option('content_color', '_default', 'category', $term_id), jwOpt::get_option('main_color')),'color'));

    if (jwOpt::get_option('cat_title_bar', '1', 'category', $term_id) != '0' && jwOpt::get_option('title_position', 'content', 'category', $term_id) == 'top') {
        echo jaw_get_template_part('category-header', 'blog');
    }
    $content = jwOpt::get_option('featured_top_revo_shortcodes', '', 'category', $term_id);
    if (isset($content['2_content']) && $content['2_content'] != '') {
        echo '<div class="builder-section jw-tax-featured-top ' . esc_attr(jwLayout::col_class(12)) . ' '.esc_attr($singlepost_preset).'">';
        echo '<div class="row">';
		echo do_shortcode($content['2_content']);
	    echo '</div>';
        echo '</div>'; 
    }
}

echo '<div id="content" class="' . esc_attr(jwLayout::content_class() . ' ' . jwLayout::content_layout() . ' builder-section archive-content ' . jwOpt::get_option('blog_bar_type') . ' ' . get_post_type() . ' '. $singlepost_preset).'">';
?>
<div  class="row"> 

    <?php    $archive_preset = jwOpt::get_option('archive_preset', '_default');

    if (is_category()) {
        $archive_preset = jwOpt::checkDefaultPreset(array(jwOpt::get_option('category_preset', '_default', 'category', $term_id), jwOpt::get_option('archive_preset')),'category');
     
        if (jwOpt::get_option('cat_title_bar', '1', 'category', $term_id) != '0' && jwOpt::get_option('title_position', 'content', 'category', $term_id) == 'content') {
            echo jaw_get_template_part('category-header', 'blog');
        }
        
        $content = jwOpt::get_option('featured_content_revo_shortcodes', '', 'category', $term_id);
        if (isset($content['2_content']) && $content['2_content'] != '') {
            echo '<div class="builder-section jw-tax-featured-content ' . esc_attr(jwLayout::col_class(12) . ' '. $singlepost_preset).'">';
            echo '<div class="row">';
    		echo do_shortcode($content['2_content']);
    	    echo '</div>';
            echo '</div>'; 
        }
    } else if (is_tag()) {
        ?>
        <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>  builder-section jw-page-title">
            <h1 ><?php echo single_cat_title('', false); ?></h1>
        </div>
        <?php
        $cat_desc = tag_description();
        if (strlen($cat_desc) > 0) {
            echo '<div class="' . esc_attr(jwLayout::col_class(12)) . ' builder-section">';
            echo '<div class="row">';
            echo '<div class="' . esc_attr(jwLayout::col_class(12)) . ' jw-tax-description">';
            ?>

            <?php echo $cat_desc; ?>

            <?php
            echo '</div>';
            echo '</div>';
            echo '</div>';
        }
    }
    $wp_query->pagination = jwOpt::getPresetValue('blog_pagination', 'infinitemore', 'category', $archive_preset);
    $wp_query->type = jwOpt::getPresetValue('boxes_type', 'classical', 'category', $archive_preset);
    $wp_query->columns = round(12 / jwOpt::getPresetValue('posts_columns', '1', 'category', $archive_preset));
    $wp_query->letter_excerpt = jwOpt::getPresetValue('letter_excerpt', '-1', 'category', $archive_preset);
    $wp_query->title_h = jwOpt::getPresetValue('title_h', '3', 'category', $archive_preset);
    $wp_query->letter_excerpt_title = jwOpt::getPresetValue('letter_excerpt_title', '-1', 'category', $archive_preset);
    $wp_query->blog_category_inimage = jwOpt::getPresetValue('blog_category_inimage', '1', 'category', $archive_preset);
    $wp_query->blog_comments_inimage = jwOpt::getPresetValue('blog_comments_inimage', '1', 'category', $archive_preset);

    $wp_query->blog_metadate = jwOpt::getPresetValue('blog_metadate', '1', 'category', $archive_preset);
    $wp_query->blog_meta_author = jwOpt::getPresetValue('blog_meta_author', '0', 'category', $archive_preset);
    $wp_query->blog_comments_count = jwOpt::getPresetValue('blog_comments_count', '0', 'category', $archive_preset);
    $wp_query->blog_meta_category = jwOpt::getPresetValue('blog_meta_category', '0', 'category', $archive_preset);
    $wp_query->blog_meta_like = jwOpt::getPresetValue('blog_meta_like', '0', 'category', $archive_preset);
    $wp_query->blog_ratings = jwOpt::getPresetValue('blog_ratings', '0', 'category', $archive_preset);
    $wp_query->blog_readers = jwOpt::getPresetValue('blog_readers', '1', 'category', $archive_preset);
    $wp_query->blog_featured_post = jwOpt::getPresetValue('blog_featured_post', '1', 'category', $archive_preset);
    $wp_query->clickable_image = jwOpt::getPresetValue('clickable_image', '0', 'category', $archive_preset);

    echo '<div class="' . esc_attr(jwLayout::col_class(12)) . ' builder-section">';  
    echo '<div class="row">';
    echo '<div class="' . esc_attr(jwLayout::col_class(12)) . ' ' . esc_attr($singlepost_preset) . '">';

    if (is_category() || is_tag() || is_date()) {
        jaw_template_set_data($wp_query);
        echo jaw_get_template_part('blog');
    } else {
        echo jaw_get_template_part('custom', 'custom-posts');
    }
    echo '</div>';
    echo '</div>';
    echo '</div>';
    ?>  
</div>



</div><!-- End Content row -->
<?php } ?>
<?php function jw_tmpl_blog__author_bottom(){ ?>
<?php
global $jaw_data;
?>

<div class="row jaw-about-author">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="admin_info" role="main" itemtype="http://schema.org/Person" itemscope itemprop="author">
            <div class="author_info">
                <div class="author_desc">
                    <div class="author_image">
                        <a href="<?php echo get_author_posts_url(jaw_template_get_var('id')); ?>"><?php echo get_avatar(jaw_template_get_var('id')); ?></a>
                    </div>
                    <div class="author-details">
                        <div class="author-first-line" >
                            <span class="author_name" itemprop="name"><a href="<?php echo get_author_posts_url(jaw_template_get_var('id')); ?>"><?php echo jaw_template_get_var('nicename'); ?></a></span>
                            <?php
                            if (get_the_author_meta('facebook', jaw_template_get_var('id')) ||
                                    get_the_author_meta('twitter', jaw_template_get_var('id')) ||
                                    get_the_author_meta('google', jaw_template_get_var('id')) ||
                                    get_the_author_meta('youtube', jaw_template_get_var('id')) ||
                                    get_the_author_meta('linkedin', jaw_template_get_var('id')) ||
                                    get_the_author_meta('vimeo', jaw_template_get_var('id')) ||
                                    get_the_author_meta('flickr', jaw_template_get_var('id'))) {
                                ?>
                                <ul class="socialshare-icon">
                                    <?php if (get_the_author_meta('facebook', jaw_template_get_var('id'))) { ?>
                                        <li>
                                            <a class="link-facebook" target="_blank" href="<?php echo get_the_author_meta('facebook', jaw_template_get_var('id')) ?>">
                                                <span class="jaw-icon-facebook4"></span>
                                            </a>
                                        </li>
                                    <?php } ?>
                                    <?php if (get_the_author_meta('twitter', jaw_template_get_var('id'))) { ?>
                                        <li>
                                            <a class="link-twitter" target="_blank" href="<?php echo get_the_author_meta('twitter', jaw_template_get_var('id')) ?>">
                                                <span class="jaw-icon-twitter3"></span>
                                            </a>
                                        </li>
                                    <?php } ?>                            
                                    <?php if (get_the_author_meta('google', jaw_template_get_var('id'))) { ?>
                                        <li>
                                            <a class="link-google" target="_blank" href="<?php echo get_the_author_meta('google', jaw_template_get_var('id')) ?>">
                                                <span class="jaw-icon-google-plus4"></span>
                                            </a>
                                        </li>
                                    <?php } ?>

                                    <?php if (get_the_author_meta('youtube', jaw_template_get_var('id'))) { ?>
                                        <li>
                                            <a class="link-youtube" target="_blank" href="<?php echo get_the_author_meta('youtube', jaw_template_get_var('id')) ?>">
                                                <span class="jaw-icon-youtube"></span>
                                            </a>
                                        </li>
                                    <?php } ?>

                                    <?php if (get_the_author_meta('linkedin', jaw_template_get_var('id'))) { ?>
                                        <li>
                                            <a class="link-linkedin" target="_blank" href="<?php echo get_the_author_meta('linkedin', jaw_template_get_var('id')) ?>">
                                                <span class="jaw-icon-linkedin"></span>
                                            </a>
                                        </li>
                                    <?php } ?> 

                                    <?php if (get_the_author_meta('vimeo', jaw_template_get_var('id'))) { ?>
                                        <li>
                                            <a class="link-vimeo" target="_blank" href="<?php echo get_the_author_meta('vimeo', jaw_template_get_var('id')) ?>">
                                                <span class="jaw-icon-vimeo3"></span>
                                            </a>
                                        </li>
                                    <?php } ?>  

                                    <?php if (get_the_author_meta('flickr', jaw_template_get_var('id'))) { ?>
                                        <li>
                                            <a class="link-flickr" target="_blank" href="<?php echo get_the_author_meta('flickr', jaw_template_get_var('id')) ?>">
                                                <span class="jaw-icon-flickr4"></span>
                                            </a>
                                        </li>
                                    <?php } ?>  

                                    <?php if (get_the_author_meta('pinterest', jaw_template_get_var('id'))) { ?>
                                        <li>
                                            <a class="link-pinterest" target="_blank" href="<?php echo get_the_author_meta('pinterest', jaw_template_get_var('id')) ?>">
                                                <span class="jaw-icon-pinterest"></span>
                                            </a>
                                        </li>
                                    <?php } ?>  
                                    <?php if (get_the_author_meta('instagram', jaw_template_get_var('id'))) { ?>
                                        <li>
                                            <a class="link-instagram" target="_blank" href="<?php echo get_the_author_meta('instagram', jaw_template_get_var('id')) ?>">
                                                <span class="jaw-icon-instagram"></span>
                                            </a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            <?php } ?>
                        </div>
                        <?php if (get_the_author_meta('profession', jaw_template_get_var('id'))) { ?>
                            <div class="author_proff"><?php echo get_the_author_meta('profession', jaw_template_get_var('id')); ?></div>
                        <?php } ?> 
                        <div class="author_description"><p><?php echo get_the_author_meta("description", jaw_template_get_var('id')); ?></p></div>
                        <div class="clear"></div>
                    </div>

                    <div class="clear"></div>
                </div>
            </div>
            <div class="clear"></div>
        </div><!-- End Content row -->

    </div>
</div>
<?php } ?>
<?php function jw_tmpl_blog__banner_gallery(){ ?>
<?php if (jwOpt::get_option('banner_gallery_type', 'image') == 'image') { ?>
    <div class="type-ads postbottom "  >
        <div class="box">
            <div class="post_banner">   
                <a href="<?php echo esc_url(jwOpt::get_option('banner_gallery_link', 'http://')); ?>"    target="<?php echo esc_attr(jwOpt::get_option('banner_gallery_target', '_blank')); ?>">
                    <img src="<?php echo esc_url(jwOpt::get_option('banner_gallery', '')); ?>">
                </a>
            </div>
        </div>
    </div>  
<?php } else { 
    $google_ads = jwOpt::get_option('banner_gallery_google', '#');
    if ($google_ads != "#") {
    ?>
         <div class="type-ads google_ads_bottom postbottom"  >
   
            <div class="box">
                <div class="google_ads">
                    <?php echo do_shortcode($google_ads); ?>
                </div>
            </div>
        </div>
    <?php }
 } ?>
<?php } ?>
<?php function jw_tmpl_blog__blog(){ ?>
<?php
global $jaw_data, $post;
jaw_template_inc_counter('pagination');
$query = jaw_template_get_data();
$type = jaw_template_get_var('type', 'classical');
$pagination = jaw_template_get_var('blog_pagination', 'number');
// preset for content
$first = true;
if (!$query->have_posts()) {
        echo jaw_get_template_part('no_posts','blog');
}
if (jaw_template_get_var('bar_type', 'bar_type_1') != 'bar_type_big_left' && jaw_template_get_var('bar_type', 'bar_type_1') != 'bar_type_big_center' && jaw_template_get_var('bar_type', 'bar_type_1') != 'bar_type_big_right' && jaw_template_get_var('bar_show_categories', '0') && !empty($query->query_vars['category__in'])) {
    ?> <div class="list_of_categories <?php echo esc_attr(jaw_template_get_var('bar_type', 'bar_type_1')); ?>"> <?php
    if (sizeof($query->query_vars['category__in']) == 1) {
        $category = $query->query_vars['category__in'][0];
        echo '<a href="' . get_category_link($category) . '" title="' . get_cat_name($category) . '">' . esc_html__('see all', "gdn-theme") . '<i class="jaw-icon-arrow-right3"></i>' . '</a>';
    } else {
        foreach ($query->query_vars['category__in'] as $category) {
            echo '<a href="' . get_category_link($category) . '" title="' . get_cat_name($category) . '">' . get_cat_name($category) . '</a>';
        }
    }
    ?> </div> <?php 
}

$top_blog_image = jaw_template_get_var("url");
$top_blog_image_id = jaw_template_get_var("top_image_id");
$top_blog_image_link = jaw_template_get_var("blog_top_image_link", "");
if (isset($top_blog_image_id) && $top_blog_image_id != '') {
    ?>
    <div class="row blog-top-image">
        <div class="col-12 col-sm-12 col-lg-12">
            <?php echo jwMedia::getAttachment($top_blog_image_id, array('full'), $top_blog_image_link); ?> 
        </div>
    </div>
<?php } else if (isset($top_blog_image) && $top_blog_image != '') { ?>
    <div class="row blog-top-image">
        <div class="col-12 col-sm-12 col-lg-12">
            <?php if (strlen($top_blog_image_link) > 0) { ?>
                <img src="<?php echo esc_url($top_blog_image); ?>">
            <?php } else { ?>
                <img src="<?php echo esc_url($top_blog_image); ?>">
            <?php } ?>
        </div>
    </div>
<?php } ?>
<?php
$blog_classes = array();
$blog_classes[] = "jaw_paginated_" . jaw_template_get_counter('pagination');
$blog_classes[] = "blog_" . $type;
if (jaw_template_get_var('use_isotope', '1') == '1') {
    $blog_classes[] = 'jaw-isotope';
}
//jaw_template_set_var("clickable_image",1); // 16/11/2016 - Na vsech blozich byl natvrdo link v obrazku navzdory vsem nastavenim. 
?> 
<div class="row">
    <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?> jaw-blog-wraper">
        <div class="row jaw_blog <?php echo esc_attr(implode(" ", $blog_classes)); ?>" data-columns="<?php echo esc_attr(round(12 / jaw_template_get_var("columns", 4))); ?>" itemscope itemtype="http://schema.org/Blog">
            <?php do_action('jaw_before_blog'); ?>
            <?php    
            while ($query->have_posts()) {
                $query->the_post();
                if (get_post_meta(get_the_ID(), 'fw_rating_position', true) == '1') {
                    $format = 'review';
                } else {
                    $format = get_post_format();
                }
                $format = apply_filters( 'jaw_post_format', $format );
                if ($type == 'mix') {
                    if ($first) {
                        echo jaw_get_template_part('content-vertical', 'content', $format);
                        $first = false;
                    } else {
                        echo jaw_get_template_part('content-simple', 'content', $format);
                    }
                } else {
                    echo jaw_get_template_part('content-' . $type, 'content', $format);
                }
            }
            ?>
            <?php do_action('jaw_after_blog'); ?>
        </div>
    </div>
</div>
<?php echo jwRender::pagination(jaw_template_get_var('pagination', $pagination), $query); ?>
<?php
wp_reset_query();
?>
<?php } ?>
<?php function jw_tmpl_blog__category_header(){ ?>
<?php
if (is_category()) {
    $termid = get_query_var( "cat", 0 );
    ?>
    <div class="builder-section <?php echo esc_attr(jwLayout::col_class(12)); ?> ">
        <div class="jaw-preset-tax-header <?php echo 'jaw-preset-tax-header-' . esc_attr($termid); ?>">
            <h1 class="jw-page-title"><?php echo esc_attr(single_cat_title('', false)); ?></h1>
            <?php
            $cat_desc = category_description();
            if (strlen($cat_desc) > 0) {
            ?>
                <?php echo do_shortcode($cat_desc); ?>
            <?php } ?>
        </div>  
    </div>
    <?php
}?>
<?php } ?>
<?php function jw_tmpl_blog__featured_comentator(){ ?>
<?php if (is_user_logged_in() && jwOpt::get_option('use_my_news', '1')) { ?>
    <?php
    $f_post = '';
    $class = '';
    $user = get_user_by('email', get_comment_author_email());
    if ($user) {
        $featured_post = get_user_meta(get_current_user_id(), 'jaw_interest_comments', true);
        if (!empty($featured_post['authors']) && in_array($user->ID, $featured_post['authors'])) {
            $f_post = 'checked="checked"';
            $class = 'interested';
        }
        ?>
        <div class="jaw-featured-comentator jaw-featured <?php echo esc_attr($class); ?>">
            <label for="comentator_featured_<?php echo esc_attr($user->ID); ?>" title="<?php esc_html_e('Mark this commentator as featured', "gdn-theme"); ?>" >
                <span class="jaw-featured-added"><i class="jaw-icon-star3"></i><?php esc_html_e('Featured commentator', "gdn-theme"); ?></span>
                <span class="jaw-featured-wait"><i class="jaw-icon-busy2"></i><?php esc_html_e('Featured commentator', "gdn-theme"); ?></span>
                <span class="jaw-featured-add"><i class="jaw-featured-add jaw-icon-plus"></i><?php esc_html_e('Add to Featured', "gdn-theme"); ?></span>
            </label>
            <input id="comentator_featured_<?php echo esc_attr($user->ID); ?>" class="jwjs_interest_comentator jaw-featured-input comentator_featured_<?php echo esc_attr($user->ID); ?>" data-interest="<?php echo esc_attr($user->ID); ?>" type="checkbox" name="comentator_featured" value="<?php echo esc_attr($user->ID); ?>" <?php echo esc_attr($f_post); ?> />
        </div>
        <?php
    }
}?>
<?php } ?>
<?php function jw_tmpl_blog__featured_discussion(){ ?>
<?php if (is_user_logged_in() && jwOpt::get_option('use_my_news', '1')) { ?>
    <?php
    $f_post = '';
    $class = '';
    $featured_post = get_user_meta(get_current_user_id(), 'jaw_interest_comments', true);
    if (!empty($featured_post['posts']) && in_array(get_the_ID(), $featured_post['posts'])) {
        $f_post = 'checked="checked"';
        $class = 'interested';
    }
    ?>
    <div class="jaw-featured-discussion jaw-featured <?php echo esc_attr($class); ?>">
        <label for="discussion_featured_<?php echo get_the_ID(); ?>" title="<?php esc_html_e('Mark this discussion as featured', "gdn-theme"); ?>" >
            <span class="jaw-featured-added"><i class="jaw-icon-star3"></i><?php esc_html_e('Featured discussion', "gdn-theme"); ?></span>
            <span class="jaw-featured-wait"><i class="jaw-icon-busy2"></i><?php esc_html_e('Featured discussion', "gdn-theme"); ?></span>
            <span class="jaw-featured-add"><i class="jaw-featured-add jaw-icon-plus"></i><?php esc_html_e('Add Discussion to Featured', "gdn-theme"); ?></span>
        </label>
        <input id="discussion_featured_<?php echo esc_attr(get_the_ID()); ?>" class="jwjs_interest_comments jaw-featured-input" data-interest="<?php echo esc_attr(get_the_ID()); ?>" type="checkbox" name="discussion_featured" value="<?php echo esc_attr(get_the_ID()); ?>" <?php echo esc_attr($f_post); ?> />
    </div>
    <?php
}?>
<?php } ?>
<?php function jw_tmpl_blog__featured_post(){ ?>
<?php if (is_user_logged_in() && jwOpt::get_option('use_my_news', '1')) { ?>
    <?php
    $f_post = '';
    $class = '';
    $featured_post = get_user_meta(get_current_user_id(), 'jaw_featured_posts', true);
    if (!empty($featured_post) && in_array(get_the_ID(), $featured_post)) {
        $f_post = 'checked="checked"';
        $class = 'interested';
    }
    ?>
    <div class="jaw-featured-post jaw-featured <?php echo esc_attr($class); ?>">
        <label for="post_featured_<?php echo get_the_ID(); ?>" title="<?php esc_html_e('Add to Reading List', "gdn-theme"); ?>" >
            <span class="jaw-featured-added"><i class="jaw-icon-bookmarks"></i><?php esc_html_e('Added to Reading List', "gdn-theme"); ?></span>
            <span class="jaw-featured-wait"><i class="jaw-icon-busy2"></i><?php esc_html_e('Added to Reading List', "gdn-theme"); ?></span>
            <span class="jaw-featured-add"><i class="jaw-featured-add jaw-icon-bookmarks"></i><?php esc_html_e('Add to Reading List', "gdn-theme"); ?></span>
        </label>
        <input id="post_featured_<?php echo get_the_ID(); ?>" class="jwjs_featured_post jaw-featured-input" data-interest="<?php echo get_the_ID(); ?>" type="checkbox" name="post_featured" value="<?php echo get_the_ID(); ?>" <?php echo esc_attr($f_post); ?> />
    </div>
    <?php
}?>
<?php } ?>
<?php function jw_tmpl_blog__no_posts(){ ?>
<?php do_action("jaw_before_no_posts"); ?>
<div class="notice">
<p class="bottom"><?php esc_html_e('We are sorry, no results were found. You can try to find some related posts using the search function.', "gdn-theme"); ?></p>
</div>
<?php get_search_form(); 
do_action("jaw_after_no_posts");?>
<?php } ?>
<?php function jw_tmpl_blog__post_title(){ ?>
<header>
    <?php if (get_post_format() == 'link') { ?>
        <div class="image link">
            <i class="jaw-icon-new-tab"></i>
        </div>
        <h1 class="entry-title" itemprop="headline">
            <a href="<?php echo get_post_meta(get_the_ID(), 'jaw_post_link', true); ?>">
                <?php apply_filters( "jaw_single_title", the_title()); ?>
            </a>
        </h1>
    <?php } else if (get_post_format() == 'quote') { ?>
        <div class="image quote">
            <i class="jaw-icon-quotes-right"></i>
        </div>
        <h1 class="entry-title" itemprop="headline">
            <?php apply_filters( "jaw_single_title", the_title()); ?>
        </h1>
        <div class="clear"></div>
        <div class="quote-author">
            <?php echo get_post_meta(get_the_ID(), 'jaw_post_quote_author', true); ?>
        </div>
    <?php } else { ?>
        <h1 class="entry-title" itemprop="headline">
            <?php apply_filters( "jaw_single_title", the_title()); ?>
        </h1>
    <?php } ?>
</header>
<?php } ?>
<?php function jw_tmpl_blog__rating(){ ?>
<?php
$post_id = jaw_template_get_var('post_id', '0');
if($post_id === '0' || $post_id === ''){
    $post_id = get_the_ID();
}
$ratingManager = ratingManager::getInstance();
$ratings = $ratingManager->getRatings($post_id);
$totalrat = $ratingManager->getRatingsScore($ratings);
$total = $totalrat;
if (jaw_template_get_var('title', '') == '0') {
    $ratingTitle = $ratingManager->getRatignsTitle($post_id);
}else{
    $ratingTitle = jaw_template_get_var('title', '');
}
$ratingsCount = 0;
$ratingtype=jwOpt::get_option('rating_maximal_value');
$ratingmaxvalue=jwOpt::get_option('rating_maximal_value_show');
?>
<?php if ($ratingManager->getShowRatigns($post_id)) { ?>

    <?php    
    if (!is_null($ratingTitle) && strlen($ratingTitle) > 0) {
        ?>
        <?php
        jaw_template_set_var('box_title', $ratingTitle);
        echo jaw_get_template_part('section_bar', 'simple-shortcodes');
        ?>
        <?php
    }
    ?>
    <div class="clear"></div>
    <div class="jw-rating-box">
        <?php foreach ($ratings as $oneRating) { ?>
            <?php if ($oneRating->useredit != "1") { ?>
                <?php $ratingsCount++;
        $one_round="";
        switch($ratingtype) {
            case "100" :
                    $one_round = esc_attr(round($oneRating->finalScore, 0)).'<span>%</span>';
            break;
            default:
                    $one_round = esc_attr(round($oneRating->finalScore, 1));

            break;
        }
                ?>
                <div class="jaw-one-rating-row">
                    <div class="jaw-one-rating-name"><?php echo esc_attr($oneRating->name); ?></div>
                    <div class="jaw-one-rating-number"><?php echo $one_round; ?></div> 
                    <div class="jaw-one-rating-graphic-wrapper">
                        <div class="jaw-one-rating-graphic" style="width:<?php echo esc_attr($oneRating->score); ?>%" ></div>
                    </div>
                </div>
            <?php } ?>
        <?php } ?>

        <div class="jaw-rating-cont">
            <?php if (strlen($ratingManager->getRatignsPositives($post_id)) > 0) { ?>
                <div class="jaw-rating-positives jaw-one-rating-row">
                    <div class="jaw-rating-text-title"><i class="jaw-icon-thumbs-up2"></i><?php esc_html_e('Positives', "gdn-theme"); ?></div>
                    <p><?php echo esc_attr($ratingManager->getRatignsPositives($post_id)); ?></p>
                </div>
            <?php } ?>
            <?php if (strlen($ratingManager->getRatignsNegatives($post_id)) > 0) { ?>
                <div class="jaw-rating-negatives jaw-one-rating-row">
                    <div class="jaw-rating-text-title"><i class="jaw-icon-thumbs-down2"></i><?php esc_html_e('Negatives', "gdn-theme"); ?></div>
                    <p><?php echo esc_attr($ratingManager->getRatignsNegatives($post_id)); ?></p>
                </div>
            <?php } ?>
        </div>
        <div class="clear"></div>
        <?php if (strlen($ratingManager->getRatignsConclusion($post_id)) > 0) { ?>
            <div class="jaw-rating-conclusion jaw-one-rating-row" >
                <p><?php echo esc_attr($ratingManager->getRatignsConclusion($post_id)); ?></p>
            </div>
        <?php } ?>    



        <div class="jaw-total-rating-row ">  
            <span itemprop="itemreviewed" style="display:none"> <?php echo esc_attr($oneRating->name); ?></span>
            <span itemprop="datePublished" style="display:none"> <?php echo get_the_date(); ?></span>

            <?php if ($ratingsCount > 0) { ?>
                <?php
                    $final_round="";
                switch($ratingtype) {
                    case "100" :
                            $final_round = round($totalrat['final'], 0).'<span>%</span>';
                    break;
                    default:
                        if($ratingmaxvalue) {
                            $final_round = round($totalrat['final'], 1).'<span>/'.$ratingtype.'</span>';
                        } else {
                            $final_round = round($totalrat['final'], 1);
                        }
                    break;
                }
                 ?>
                <div class="jw-rating-row-overall jaw-one-rating-row"  itemprop="reviewRating" itemscope itemtype="http://schema.org/Rating">  
                    <div class="jaw-one-rating-name"><?php esc_html_e('Total Rating', "gdn-theme"); ?></div>
                    <div class="jaw-one-rating-number" itemprop="ratingValue"><?php echo $final_round; ?></div>
                    <div class="jaw-one-rating-graphic-wrapper">
                        <div class="jaw-one-rating-graphic" style="width:<?php echo esc_attr($total['score']); ?>%" ></div>
                    </div>
                    <meta itemprop="worstRating" content = "0"/>
                    <meta itemprop="bestRating" content = "<?php echo esc_attr(jwOpt::get_option('rating_maximal_value', 10)); ?>"/>
                </div>
            <?php } ?>
            <div class="clear"></div>
        </div>

        <!-- END TOTAL RATING -->


        <!-- USER RATING -->
        <?php if ($ratingManager->getRatignsShowUserRating($post_id)) { ?>
            <div class="jaw-one-rating-row jaw-user-rating">                  
                <?php
                $userRating = $ratingManager->getOneRating($post_id, 'UsersRatings');
                if (isset($userRating->finalScore)) {
                    $userScore = round($userRating->finalScore, 2);
                } else {
                    $userScore = jwOpt::get_option('rating_maximal_value', 10);
                }
                if (isset($userRating->voted)) {
                    $voted = $userRating->voted;
                } else {
                    $voted = 0;
                }
                ?>
                <div class="jaw-one-rating-name"><?php echo esc_html__('Users rating', "gdn-theme") . ' (<span class="jaw-one-rating-weight">' . esc_attr($voted) . '</span>)'; ?></div>
                <div class="jaw-one-rating-number"><?php echo esc_attr($userScore); ?></div>
                <div class="jaw-one-rating-graphic-wrapper">                    
                    <div class="jaw-one-rating-graphic user_editable" style="width:<?php echo esc_attr($userRating->score); ?>%">
                        <input type="hidden" class="jw_rating_name" name="jw_rating_name" value="<?php echo esc_attr($userRating->name); ?>">
                        <input type="hidden" class="jw_rating_id" name="jw_rating_id" value="<?php echo esc_attr($userRating->id); ?>">
                        <input type="hidden" class="jw_rating_value" name="jw_rating_value" value="<?php echo esc_attr($userRating->score); ?>">
                        <input type="hidden" class="jw_rating_final_value" name="jw_rating_final_value" value="<?php echo esc_attr($userScore); ?>">
                        <input type="hidden" class="jw_rating_maximal_value" name="jw_rating_maximal_value" value="<?php echo esc_attr($userRating->maximalValue); ?>">
                        <input type="hidden" class="jw_rating_post_id" name="jw_rating_post_id" value="<?php echo esc_attr($post_id); ?>">
                        <input type="hidden" class="jw_rating_user_value" name="jw_rating_user_value" value="0">
                    </div>
                </div>
            </div>


            <!-- END USER RATING -->
        <?php } ?>
    </div>

<?php } ?>

<?php } ?>
<?php function jw_tmpl_blog__related_post(){ ?>
<?php
global $wp_query,$post;
$single_preset = jaw_template_get_var('single_preset');
list($primary, $secondary) = jwRender::get_related_post(get_the_ID(), jwOpt::getPresetValue('post_bottom_number_of_relatedpost', '4', 'single', $single_preset));
wp_reset_query();
$wp_query = new WP_Query($primary);
if (!(have_posts())) {
    wp_reset_query();
    $wp_query = new WP_Query($secondary);
}
$blog_classes[] = "blog_vertical-small";
$blog_classes[] = 'jaw-isotope';
jaw_template_set_var("columns", 3);
jaw_template_set_var('letter_excerpt', 0);
jaw_template_set_var('title_h', 3);
jaw_template_set_var('letter_excerpt_title', -1);
jaw_template_set_var("clickable_image",1);
if (have_posts()) {
    
    $col_class = jwLayout::col_class(12);
    $blog_classes = implode(" ", $blog_classes);
    $columns = round(12 / jwOpt::getPresetValue('post_bottom_number_of_relatedpost', '4', 'single', $single_preset));
    jaw_template_set_var("columns",array($columns,$columns,6,12));
    ?>
    <div class="row">
        <div class="<?php echo esc_attr($col_class); ?> jaw-blog-wraper">
                <?php
                jaw_template_set_var('box_title', esc_html__('Related Posts', "gdn-theme"));
                echo jaw_get_template_part('section_bar', 'simple-shortcodes');
                ?>
                <div class="row jaw_blog <?php echo esc_attr($blog_classes); ?>" data-columns="<?php echo esc_attr($columns); ?>">
                    <?php while (have_posts()) : the_post(); ?>
                        <?php
                            if (get_post_meta(get_the_ID(), 'fw_rating_position', true) == '1') {
                                $format = 'review';
                            } else {
                                $format = get_post_format();
                            }
                            $format = apply_filters( 'jaw_post_format', $format );
                            echo jaw_get_template_part('content-vertical-small', 'content', $format);
                            ?>
                    <?php endwhile; ?>
                </div>
                <div class="clear"></div>
        </div>
    </div>
    <div class="meta_divider"></div>
    <?php
}
wp_reset_query();


?>
<?php } ?>
<?php function jw_tmpl_blog__related_post_box(){ ?>
<?php
$single_preset = jaw_template_get_var('single_preset');
list($primary, $secondary) = jwRender::get_related_post(get_the_ID(), jwOpt::getPresetValue('perex_number_of_related_posts', '3', 'single', $single_preset));
$query = new WP_Query($primary);
if (!($query->have_posts())) {
    wp_reset_query();
    $query = new WP_Query($secondary);
}
$blog_classes[] = "blog_vertical-small";
jaw_template_set_var("columns", 12);
jaw_template_set_var('title_h', 3);
jaw_template_set_var('letter_excerpt', 0);
jaw_template_set_var('letter_excerpt_title', -1);
jaw_template_set_var("clickable_image",1);
if ($query->have_posts()) {
    
    $col_class = jwLayout::col_class(12);
    $columns = round(12 / jaw_template_get_var("columns", 4));
    $blog_classes = implode(" ", $blog_classes);
    jaw_template_set_var("columns",array(12,12,4,12));
    ?>
    <div class="row">
        <div class="<?php echo esc_attr($col_class); ?> jaw-blog-wraper">
            
                <?php
                jaw_template_set_var('box_title', esc_html__('Related Posts', "gdn-theme"));
                echo jaw_get_template_part('section_bar', 'simple-shortcodes');
                ?>
                <div class="row jaw_blog <?php echo esc_attr($blog_classes); ?>" data-columns="<?php echo esc_attr($columns); ?>">
                    <?php
                    while ($query->have_posts()) : $query->the_post();
                   
                            if (get_post_meta(get_the_ID(), 'fw_rating_position', true) == '1') {
                                $format = 'review';
                            } else {
                                $format = get_post_format();
                            }
                            $format = apply_filters( 'jaw_post_format', $format );
                            echo jaw_get_template_part('content-vertical-small', 'content', $format);
                            
                    endwhile;
                    ?></div>
                <div class="clear"></div>
            </div>
    </div>
    <?php 
}
wp_reset_query();

?>
<?php } ?>
<?php function jw_tmpl_blog__related_post_showup(){ ?>
 <?php
global $wp_query,$post;
list($primary, $secondary) = jwRender::get_related_post(get_the_ID(), 1);
wp_reset_query();
$wp_query = new WP_Query($primary);
if (!(have_posts())) {
    wp_reset_query();
    $wp_query = new WP_Query($secondary);
}

$blog_classes[] = "blog_vertical";
jaw_template_set_var("columns", 3);
jaw_template_set_var('letter_excerpt', 0);
jaw_template_set_var('title_h', 3);
jaw_template_set_var('letter_excerpt_title', -1);
jaw_template_set_var("clickable_image",1);
jaw_template_set_var("columns", 12);
if (have_posts()) {
    
    $blog_classes = implode(" ", $blog_classes);
    $col_class = jwLayout::col_class(2);
    $columns = round(12 / jaw_template_get_var("columns", 4));
    
    ?>
    <div class="row">
        <div class="<?php echo esc_attr($col_class); ?> jaw-blog-wraper jaw-showup">
                <?php
                jaw_template_set_var('box_title', esc_html__('Do not miss', "gdn-theme"));
                echo jaw_get_template_part('section_bar', 'simple-shortcodes');
                ?>
                <i class="jaw-icon-close"></i>
                <div class="row jaw_blog <?php echo esc_attr($blog_classes); ?>" data-columns="<?php echo esc_attr($columns); ?>">
                    <?php while (have_posts()) : the_post(); ?>
                        <?php
                            if (get_post_meta(get_the_ID(), 'fw_rating_position', true) == '1') {
                                $format = 'review';
                            } else {
                                $format = get_post_format();
                            }
                            $format = apply_filters( 'jaw_post_format', $format );
                            echo jaw_get_template_part('content-vertical', 'content', $format);

                            break; //show only 1 post
                        ?>
                    <?php endwhile; ?>
                </div>
                <div class="clear"></div>
        </div>
    </div>
    <?php
}
wp_reset_postdata();
wp_reset_query(); ?>
<?php } ?>
<?php function jw_tmpl_blog__shareit_advanced(){ ?>
<?php
// SHARE IT BOX
global $post;
?>
<div class="row">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="share_post" role="main">
            <?php
            jaw_template_set_var('box_title', esc_html__('Share this', "gdn-theme"));
            echo jaw_get_template_part('section_bar', 'simple-shortcodes');
            ?>
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <?php echo do_shortcode("[mashshare shares='false']"); ?>
                    <div class="clear"></div>
                </div>
            </div>

        </div>
    </div>
</div>
    <?php
// END SHARE IT?>
<?php } ?>
<?php function jw_tmpl_blog__shareit_advanced_bottom(){ ?>
<?php
// SHARE IT BOX
?>
<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
    <div class="share_post share_bottom" role="main">
        <?php
        jaw_template_set_var('box_title', esc_html__('Share this', "gdn-theme"));
        echo jaw_get_template_part('section_bar', 'simple-shortcodes');
        ?>
        <?php echo do_shortcode("[mashshare]"); ?>
        <div class="clear"></div>
    </div>
</div>
<?php
// END SHARE IT?>
<?php } ?>
<?php function jw_tmpl_blog__shareit(){ ?>
<?php
// SHARE IT BOX
global $post;
?>
<div class="row">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="share_post" role="main">
            <?php
            jaw_template_set_var('box_title', esc_html__('Share this', "gdn-theme"));
            echo jaw_get_template_part('section_bar', 'simple-shortcodes');
            ?>
            <?php
            $title = htmlentities(urlencode(get_the_title()));
            $link = urlencode(get_permalink());
            $media = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'large-size');
            $media = urlencode($media[0]);
            $desc = urlencode($post->post_excerpt);
            
            if ((jwOpt::get_option('post_share_fb','1') != '1')
                && (jwOpt::get_option('post_share_tw','1') != '1')
                && (jwOpt::get_option('post_share_g','1') != '1')
                && (jwOpt::get_option('post_share_pi','1') != '1')
                && (jwOpt::get_option('post_share_re','1') != '1')
                && (jwOpt::get_option('post_share_mail','1') != '1')){
                    echo '<div class="jaw_msg jaw_msg_type_warning">';
                    sprintf(esc_html__('You have disabled all social sites in %s Theme Options -> Single Post -> Sharing Options %s','gdn-theme'),'<a href="'.admin_url("themes.php?page=optionsframework").'">','</a>');
                    echo '</div>';
                }
            ?>
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <ul class="socialshare-icon">
                            <?php if (jwOpt::get_option('post_share_fb','1') == '1') { ?>
                                <li>
                                    <a class="link-facebook" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode($link); ?>&t=<?php echo urlencode($title); ?>">
                                        <span class="jaw-icon-facebook4"></span>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if (jwOpt::get_option('post_share_tw','1') == '1') { ?>
                                <li>
                                    <a class="link-twitter" target="_blank" href="https://twitter.com/intent/tweet?original_referer=<?php echo urlencode($link); ?>&text=<?php echo urlencode($title); ?>&url=<?php echo urlencode($link); ?>">
                                        <span class="jaw-icon-twitter3"></span>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if (jwOpt::get_option('post_share_g','1') == '1') { ?>
                                <li>
                                    <a class="link-google" target="_blank" href="https://plus.google.com/share?url=<?php echo urlencode($link); ?>">
                                        <span class="jaw-icon-google-plus4"></span>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if (jwOpt::get_option('post_share_pi','1') == '1') { ?>
                                <li>
                                    <a class="link-pinterest" target="_blank" href="http://www.pinterest.com/pin/create/button/?url=<?php echo urlencode($link); ?>&media=<?php echo urlencode($media) ?>&description=<?php echo urlencode($desc); ?>">
                                        <span class="jaw-icon-pinterest"></span>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if (jwOpt::get_option('post_share_re','1') == '1') { ?>
                                <li>
                                    <a class="link-reddit" target="_blank" href="//www.reddit.com/submit" onclick="window.location = '//www.reddit.com/submit?url=' + + encodeURIComponent(window.location); return false">
                                        <span class="jaw-icon-reddit3"></span>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if (jwOpt::get_option('post_share_mail','1') == '1') { ?>
                                <li>
                                    <a class="link-email" target="_blank" href="mailto:<?php echo jwOpt::get_option('post_share_mail_content', 'youremail@addresshere.com'); ?>?subject=<?php echo urlencode($title); ?>&body=<?php echo urldecode($desc) . ' ' . urlencode($link); ?>">
                                        <span class="jaw-icon-mail4 "></span>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    <div class="clear"></div>
                </div>
            </div>

        </div>
    </div>
</div>
    <?php
// END SHARE IT?>
<?php } ?>
<?php function jw_tmpl_blog__shareit_bottom(){ ?>
<?php
global $post;
// SHARE IT BOX
    ?>
    
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="share_post share_bottom" role="main">
                <?php
                jaw_template_set_var('box_title', esc_html__('Share this', "gdn-theme"));
                echo jaw_get_template_part('section_bar', 'simple-shortcodes');
                ?>
                <?php
                $title = htmlentities(urlencode(get_the_title()));
                $link = urlencode(get_permalink());
                $media = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'large-size');
                $media = urlencode($media[0]);
                $desc = urlencode($post->post_excerpt);
                if ((jwOpt::get_option('post_share_fb','1') != '1')
                && (jwOpt::get_option('post_share_tw','1') != '1')
                && (jwOpt::get_option('post_share_g','1') != '1')
                && (jwOpt::get_option('post_share_pi','1') != '1')
                && (jwOpt::get_option('post_share_re','1') != '1')
                && (jwOpt::get_option('post_share_mail','1') != '1')){
                    echo '<div class="jaw_msg jaw_msg_type_warning">';
                    sprintf(esc_html__('You have disabled all social sites in %s Theme Options -> Single Post -> Sharing Options %s','gdn-theme'),'<a href="'.admin_url("themes.php?page=optionsframework").'">','</a>');
                    echo '</div>';
                }
                ?>
                        <ul class="socialshare-icon">
                            <?php if (jwOpt::get_option('post_share_fb','1') == '1') { ?>
                                <li>
                                    <a class="link-facebook" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode($link); ?>&t=<?php echo urlencode($title); ?>">
                                        <span class="jaw-icon-facebook4"></span>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if (jwOpt::get_option('post_share_tw','1') == '1') { ?>
                                <li>
                                    <a class="link-twitter" target="_blank" href="https://twitter.com/intent/tweet?original_referer=<?php echo urlencode($link); ?>&text=<?php echo urlencode($title); ?>&url=<?php echo urlencode($link); ?>">
                                        <span class="jaw-icon-twitter3"></span>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if (jwOpt::get_option('post_share_g','1') == '1') { ?>
                                <li>
                                    <a class="link-google" target="_blank" href="https://plus.google.com/share?url=<?php echo urlencode($link); ?>">
                                        <span class="jaw-icon-google-plus4"></span>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if (jwOpt::get_option('post_share_pi','1') == '1') { ?>
                                <li>
                                    <a class="link-pinterest" target="_blank" href="http://www.pinterest.com/pin/create/button/?url=<?php echo urlencode($link); ?>&media=<?php echo urlencode($media) ?>&description=<?php echo urlencode($desc); ?>">
                                        <span class="jaw-icon-pinterest"></span>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if (jwOpt::get_option('post_share_re','1') == '1') { ?>
                                <li>
                                    <a class="link-reddit" target="_blank" href="//www.reddit.com/submit" onclick="window.location = '//www.reddit.com/submit?url=' + + encodeURIComponent(window.location); return false">
                                        <span class="jaw-icon-reddit3"></span>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if (jwOpt::get_option('post_share_mail','1') == '1') { ?>
                                <li>
                                    <a class="link-email" target="_blank" href="mailto:<?php echo jwOpt::get_option('post_share_mail_content', 'youremail@addresshere.com'); ?>?subject=<?php echo urlencode($title); ?>&body=<?php echo urldecode($desc) . ' ' . urlencode($link); ?>">
                                        <span class="jaw-icon-mail4 "></span>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                        <div class="clear"></div>
            </div>
        </div>
    <?php
// END SHARE IT?>
<?php } ?>
<?php function jw_tmpl_blog__single_post_featured_img(){ ?>
<?php
// Featured image/gallery/video in SINGLE post

$single_preset = jaw_template_get_var('single_preset');
$featured_img = jwOpt::getPresetValue('post_use_featured', '1', 'single', $single_preset);
$attachment = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
$itemprop="";
if($attachment) {
$itemprop = 'itemprop="image" itemscope itemtype="https://schema.org/ImageObject"';
}
// Should I show FEATURED IMAGE
if ($featured_img === '1') {
    $post_meta = get_post_meta(get_the_id(), ''); // tohle bylo vyvanyšované
    $col_class = jwLayout::col_class(12);
    
    ?>
    <!-- Image / video / gallery -->
    <div class="jaw_single_img row " <?php echo $itemprop; ?>>
        <div class="<?php echo esc_attr($col_class); ?> "  >
            <?php
            switch (get_post_format()) {
                case 'video':
                    if (isset($post_meta['jaw_post_video_link'][0])) {
                        echo jwMedia::getVideoPlayer($post_meta['jaw_post_video_link'][0], 720);
                    }
                    break;
                case 'gallery':
                    if (isset($post_meta['jaw_post_gallery'][0])) {
                        //TADY BUDE JINA GALEIRE
                        $gallery = $post_meta['jaw_post_gallery'][0];
                        $ids = jwMedia::parseJson($gallery);
                        if(!empty($ids)){
                            echo do_shortcode('[jaw_gallery gallery="' . esc_attr( implode(',', $ids) ) . '" ]');
                        }else if(has_post_thumbnail()){
                            echo jwMedia::getPostThumbnail(get_the_ID(), array('large','full') );
                        } 
                    }
                    break;
                default:
                    echo jwMedia::getPostThumbnail(get_the_ID(), array('large','full') );
                    if(jwOpt::get_option('featured_image_caption')) {
                        $thumb_id = get_post(get_post_thumbnail_id());
                        $featured_img_caption = $thumb_id->post_excerpt;
                        if(!empty($featured_img_caption)) {
                            echo '<p class="featured_img_caption">'.$featured_img_caption.'</p>'; 
                        }
                    }
            }
            if(!empty($attachment)){
                ?>
                <meta itemprop="url" content="<?php echo esc_url(jwMedia::getPostThumbnailSrc(get_the_ID())); ?>">
                <meta itemprop="width" content="<?php echo esc_attr($attachment["width"]); ?>">
                <meta itemprop="height" content="<?php echo esc_attr($attachment["height"]); ?>">
            <?php } ?>
        </div>
    </div>
    <?php
}
?>
<?php } ?>
<?php function jw_tmpl_blog__single_post(){ ?>
<?php
global $wp_query, $post, $more;

// loop
while (have_posts()) : the_post();

//MODEL ============================================================================================

    // Classes for the content types
    $jaw_single_class = array();
    if (jwLayout::content_layout() == 'fullwidth_sidebar') {
        $jaw_single_class[] = 'fullwidth';
    } else {
        $jaw_single_class[] = 'sidebar';
    }
    $jaw_single_class[] = jwLayout::col_class(12);
    $jaw_single_class[] = 'content';
    $jaw_single_class[] = 'jaw-single';

    //get meta
    $post_meta = get_post_meta(get_the_id(), '');
    
    //get preset
    $jaw_gallery_id = "_defualt";
    $jaw_single_preset = jaw_template_get_var('single_preset');
    if(isset($post_meta['jaw_perex_gallery_box'][0])){
        $jaw_gallery_id = $post_meta['jaw_perex_gallery_box'][0];
    }
   
    // get category ID
    $jaw_terms = get_the_category();
    if (isset($jaw_terms[0]->term_id)) {
        $term_id = $jaw_terms[0]->term_id;
    } else {
        $term_id = 0;
    }
    
    // has this post review
    $review = false;
    $microdata = "";
    $rating_title="";
    if (isset($post_meta['fw_rating_position']) && implode($post_meta['fw_rating_position']) == '1') {
        $review = true;
        $microdata = ' itemscope itemtype="http://schema.org/Review" ';
    } else {
        $review = false;
        $microdata = ' itemscope itemtype="http://schema.org/Article" ';
    }
    if(isset($post_meta['fw_rating_title'][0]) && !empty($post_meta['fw_rating_title'][0])) {
        $rating_title = $post_meta['fw_rating_title'][0];
    }
    
    // with perex
    $with_perex = false;
    if (strpos(get_the_content(), 'id="more-')) {
        $with_perex = true;
    }
    
    // image caption
    $jaw_single_class[] = 'image_caption_toggle-' . jwOpt::get_option('image_caption_toggle');
    
    
    // META
    $jaw_meta_date = jwOpt::getPresetValue('meta_date', '1', 'single', $jaw_single_preset);
    $jaw_meta_comments_count = jwOpt::getPresetValue('meta_comments_count', '1', 'single', $jaw_single_preset);
    $jaw_meta_author = jwOpt::getPresetValue('meta_author', '1', 'single', $jaw_single_preset);
    $jaw_meta_category = jwOpt::getPresetValue('meta_category', '1', 'single', $jaw_single_preset);
    $jaw_meta_likes = jwOpt::getPresetValue('meta_likes', '1', 'single', $jaw_single_preset);
    $jaw_meta_ratings = jwOpt::getPresetValue('meta_ratings', '1', 'single', $jaw_single_preset);
    $jaw_meta_featured = jwOpt::getPresetValue('meta_featured', '1', 'single', $jaw_single_preset);
    $jaw_meta_print = jwOpt::getPresetValue('meta_print', '1', 'single', $jaw_single_preset);
    $jaw_meta_font_resize = jwOpt::getPresetValue('meta_font_resize', '1', 'single', $jaw_single_preset);
    
                    
    //Side Box
    
    $col_content = 12;
    
    $show_after_perex_box = false;
    $side_box_position = jwOpt::getPresetValue('perex_box', 'left', 'single', $jaw_single_preset);
    $side_box_visibility = jwOpt::getPresetValue('perex_box_visibility', 'tablet', 'single', $jaw_single_preset);
    $perex_next_to_content_shares = jwOpt::getPresetValue('perex_next_to_content_shares', '0', 'single', $jaw_single_preset);
    if ($side_box_visibility != '0') {
        jaw_template_set_var('bar_type', jwOpt::getPresetValue('post_layout_style', 'bar_type_1', 'single', $jaw_single_preset));
        jaw_template_set_var('single_preset', $jaw_single_preset);

        $gallery_show = jwOpt::getPresetValue('perex_gallery', '4', 'single', $jaw_single_preset);
        $perex_gallery_content = jwMedia::getGallery("vertical",$gallery_show);
        $perex_featured = jwOpt::getPresetValue('perex_featured', '1', 'single', $jaw_single_preset);
        $perex_shares = jwOpt::getPresetValue('perex_shares', '0', 'single', $jaw_single_preset);
        $perex_related_posts = jwOpt::getPresetValue('perex_related_posts', '1', 'single', $jaw_single_preset);
        $perex_tags = jwOpt::getPresetValue('perex_tags', '0', 'single', $jaw_single_preset);
        $perex_rating = jwOpt::getPresetValue('perex_rating', '1', 'single', $jaw_single_preset);
        $perex_banner = jwOpt::getPresetValue('perex_banner', '1', 'single', $jaw_single_preset);
        if($perex_gallery_content || $perex_featured || $perex_shares || $perex_related_posts || ($perex_rating && $review) || $perex_banner || $perex_tags) {
            $show_after_perex_box = true;
            $col_content = 9;
            
            $after_perex_box_class = array();
            $after_perex_box_class[] = jwLayout::col_class(3);
            $after_perex_box_class[] = 'show-on-'.$side_box_visibility;
            $after_perex_box_inner_class = array();
            $after_perex_box_inner_class[] = 'fixed_'.jwOpt::getPresetValue('perex_box_fixed', '0', 'single', $jaw_single_preset);
                            
        }
    }
    
    $main_content_class = array();
    $main_content_class[] = 'jaw-after-perex';
    $main_content_class[] = 'jaw-sidebox-position-'.$side_box_position;
    $main_content_class[] = jwLayout::col_class($col_content);

    // microdata
    $template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
    
    
    
    //VIEW ======================================================================================
    ?>
    <article  <?php post_class($jaw_single_class); ?> id="post-<?php the_ID(); ?>"  <?php echo $microdata; ?> >
        <meta itemscope itemprop="mainEntityOfPage"  itemType="https://schema.org/WebPage" itemid="<?php echo get_permalink(); ?>"/>
        <span itemprop="publisher" itemscope itemtype="https://schema.org/Organization">
            <meta itemprop="name" content="<?php echo get_bloginfo(); ?>"/>    
            <meta itemprop="url" content="<?php echo get_permalink(); ?>"/>
            <span itemprop="logo" itemscope itemtype="http://schema.org/ImageObject">
                <meta itemprop="url" content="<?php echo esc_url($template_logo); ?>" />
            </span>    
        </span>
        <div class="entry-content" >
            <?php
            if (jwOpt::getPresetValue('post_title_placement', 'under_image', 'single', $jaw_single_preset) == 'under_image') {
                echo jaw_get_template_part('single-post-featured-img', 'blog');
            }
            ?>
            <?php
            if ($with_perex) {
                $more = 0; //WP global
                ?>
                <div class="perex">
                    <?php echo jaw_get_template_part('post_title', 'blog'); ?>
                    <div class="row">
                        <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?> jaw-perex-content">
                            <?php do_action('jaw_before_single_perex'); ?>
                            <?php the_content('', true); ?>
                            <?php do_action('jaw_after_single_perex'); ?>
                        </div>
                    </div>

                <?php } else { ?>
                    <div  class="perex ">   
                        <?php echo jaw_get_template_part('post_title', 'blog'); ?>
                    <?php } ?>
                    <?php
                    
                    // META
                    if (($jaw_meta_date == '1') ||
                        ($jaw_meta_comments_count == '1') ||
                        ($jaw_meta_author == '1') ||
                        ($jaw_meta_category == '1') ||
                        ($jaw_meta_likes == '1') ||
                        ($jaw_meta_ratings == '1') ||
                        ($jaw_meta_featured == '1') ||
                        ($jaw_meta_print == '1') ||
                        ($jaw_meta_font_resize == '1')) {
                        ?>
                        <div class="row">
                            <ul class="<?php echo esc_attr(jwLayout::col_class(12)); ?> blog-meta-info-top blog-meta-info">
                                <?php if ($jaw_meta_date == '1') { ?>
                                    <li class="post-meta-date">
                                        <span class="date">
                                            <?php echo jwRender::get_meta_date(); ?>
                                        </span>
                                    </li>
                                <?php } ?>
                                <?php if ($jaw_meta_comments_count == '1') { ?>  
                                    <li class="post-meta-comments">
                                        <?php echo jwRender::get_meta_comments(); ?>
                                    </li>    
                                <?php } ?>
                                <?php if ($jaw_meta_author == '1') { ?>
                                    <li class="post-meta-author">
                                        <?php echo jwRender::get_meta_author(); ?>
                                    </li>
                                <?php } ?>
                                <?php if ($jaw_meta_category == '1') { ?>
                                    <li class="post-meta-catagory">
                                        <span><?php esc_html_e('Posted in ', "gdn-theme"); ?></span>
                                        <?php echo jwRender::get_meta_category(); ?>
                                    </li>
                                <?php } ?>
                            <?php //  ?>
                                <?php if ($jaw_meta_likes == '1') { ?>
                                    <?php echo jwRender::get_likes(); ?>
                                <?php } ?>
                                <?php if ($jaw_meta_ratings == '1') { ?>    
                                    <?php echo jwRender::metaRating(); ?>  <!-- RATING -->
                                <?php } ?>
                                <?php if ($jaw_meta_featured == '1' && jwOpt::get_option('use_my_news', '1') && is_user_logged_in()) { ?>
                                    <li class="post-meta-featured">
                                        <?php echo jaw_get_template_part('featured_post', 'blog'); ?>  
                                    </li>
                                <?php } ?>
                                <?php if ($jaw_meta_print == '1') { ?>
                                    <li class="post-meta-print">
                                        <a href="#"><i class="jaw-icon-print"></i></a> 
                                    </li>
                                <?php } ?>
                                <?php if ($jaw_meta_font_resize == '1') { ?>
                                <li class="post-meta-font-resizer">
                                    <ul class="blog-meta-info-top">
                                        <li class="post-meta-font-resize normal">
                                            <a href="#"><i class="jaw-icon-a-letter"></i></a> 
                                        </li>
                                        <li class="post-meta-font-resize bigger">
                                            <a href="#"><i class="jaw-icon-a-letter"></i></a> 
                                        </li>
                                        <li class="post-meta-font-resize biggest">
                                            <a href="#"><i class="jaw-icon-a-letter"></i></a> 
                                        </li>
                                    </ul>
                                </li>
                                <?php } ?>
                            <?php //  ?>
                                <?php edit_post_link( '<i class="jaw-icon-pen"></i> '. esc_html__( 'Edit', "gdn-theme" ), '<li class="post-meta-edit">', '</li>' ); ?>
                                <?php do_action('jaw_after_single_meta'); ?>
                            </ul>
                        </div>
                    <?php } // END META
                    ?>
                </div>
                <?php
                if (jwOpt::getPresetValue('post_title_placement', 'under_image', 'single', $jaw_single_preset) == 'above_image') {
                    echo jaw_get_template_part('single-post-featured-img', 'blog');
                }
                ?>
                <div  class="more-text">
                    <?php
                    if ($with_perex) {
                        $more = 1; //WP global
                    }
                    
                    // ========================== CONTENT =================================
                    ?>
                    <div class="row jw-fixed-sidebar-box">
                        <div class="<?php echo esc_attr(implode(' ', $main_content_class)); ?> jaw-after-perex">
                            <div class="row">
                                <?php do_action('jaw_before_single_content'); ?>
                                <?php 
                                if(jwOpt::getPresetValue('post_top_banner', '1', 'single', $jaw_single_preset) == '1'){  
                                    jwRender::get_banner('posttop'); 
                                }
                                ?>
                                <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
                                    <?php
                                    if (class_exists('mashshare') && $perex_next_to_content_shares) {
                                        echo do_shortcode("[mashshare]");
                                    }
                                    ?>
                                    <?php the_content('', true); ?>
                                </div>
                                <?php if(jwOpt::getPresetValue('post_bottom_banner', '1', 'single', $jaw_single_preset) == '1'){  
                                    jwRender::get_banner('postbottom'); 
                                } ?>
                                <?php do_action('jaw_after_single_content'); ?>
                                 <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
                                 <?php 
                                    wp_link_pages(array('before' => '<div id="page-nav">', 'after' => '</div>', 'link_before' => '<span class="post_page">', 'link_after' => '</span>'));
                                ?>
                                </div>
                            </div>
                        </div>
                        <?php
                        
                        
                        
                        // ========================================== BOX AFTER PEREX ===================================================
                        jaw_template_set_var('single_preset', $jaw_single_preset);
                        jaw_template_set_var('bar_type', jwOpt::getPresetValue('post_layout_style', 'bar_type_1', 'single', $jaw_single_preset));
                        
                        if ($show_after_perex_box) { // perex on
                            $count = 0;
                            ?>
                            <div class="<?php echo esc_attr(implode( ' ',$after_perex_box_class)); ?> jaw-box perex-box jw-rating-slim">
                             <div class="<?php echo esc_attr(implode( ' ',$after_perex_box_inner_class)); ?> perex-box-inner">
                                <?php do_action('jaw_before_perex_box'); ?>
                                <!-- Featured post area -->
                                <?php
                        // 
                                /*                                 * ****************** GALLERY PEREX BOX ******************* */
                                if($perex_gallery_content) { 
                                    echo $perex_gallery_content; 
                                    echo '<div class="meta_divider"></div>';
                                }
                                /*                                 * ****************** Featured post ******************* */
                                if ($perex_featured) {
                                    echo jaw_get_template_part('featured_post', 'blog');
                                    $count++;
                                }
                        // 
                                /*                                 * ****************** Share post ******************* */
                                if ($perex_shares) {
                                    if (class_exists('mashshare')) { // mashare plugin
                                        echo jaw_get_template_part('shareit-advanced', 'blog');
                                    } else {
                                        echo jaw_get_template_part('shareit', 'blog');
                                    }
                                    $count++;
                                }
                                /*                                 * ****************** Related posts ******************* */
                                if ($perex_related_posts) {
                                    echo jaw_get_template_part('related-post_box', 'blog');
                                    $count++;
                                }
                        // 
                                /*                                 * ****************** Rate post ******************* */
                                if ($perex_rating && $review) {
                                    jaw_template_set_var('title', $rating_title);
                                    echo jaw_get_template_part('rating', 'blog');
                                    $count++;
                                }
                        // 
                                /*                                 * ****************** TAGS  ******************* */
                               
                                if (has_tag() && $perex_tags) { 
                                    echo jaw_get_template_part('tags', 'blog');
                                    $count++;
                                }

                                /*                                 * ****************** banner ******************* */
                                if ($perex_banner) {
                                    ?>
                                    <div class="row"> 
                                        <?php
                                        jwRender::get_banner('postside');
                                        ?>
                                    </div>
                                    <?php
                                    $count++;
                                }
                                ?>
                                <?php if($count > 0){ ?>
                                    <div class="meta_divider"></div>
                                <?php } ?>
                                <?php do_action('jaw_after_side_box'); ?>
                            </div>
                            </div>
                        <?php } // CONTENT Side Box ?>
                    </div>
                </div>
                <div class="clear"></div>
                
                <?php // PAGINATION ?>
                <?php echo jaw_get_template_part('pagination', 'pagination'); ?>
                <?php // END PAGINATION ?>
                
                <?php
        // 
                // GALLERY BOTTOM
                $gallery_bottom_count = jwOpt::getPresetValue('post_gallery_bottom', '4', 'single', $jaw_single_preset);
                if($jaw_gallery_id != "_default" && $gallery_bottom_count) {
                    echo jwMedia::getGallery("horizontal",$gallery_bottom_count,$jaw_gallery_id);
                    echo '<div class="meta_divider"></div>';
                }
                // END GALLERY BOTTOM
        // 
                ?>
                
                <?php // BOTTOM SHARE POST ?>
                <?php if (jwOpt::getPresetValue('post_bottom_share', '1', 'single', $jaw_single_preset) == '1') { ?>
                    <div class="share-single-bottom">
                        <div class="row">
                            <?php
                                if (class_exists('mashshare')) { // mashare plugin
                                    echo jaw_get_template_part('shareit-advanced_bottom', 'blog'); 
                                } else {
                                    echo jaw_get_template_part('shareit_bottom', 'blog');
                                }
                            ?>
                        </div>
                    </div>
                    <div class="meta_divider"></div>
                <?php } ?>
                <?php // END BOTTOM SHARE POST ?>
                
                <?php // BOTTOM ABOUT AUTHOR ?>
                <?php if (jwOpt::getPresetValue('post_bottom_author', '1', 'single', $jaw_single_preset) == '1') { ?>
                    <?php
                    jaw_template_set_var('box_title', esc_html__('About author', "gdn-theme"));
                    echo jaw_get_template_part('section_bar', 'simple-shortcodes');
                    jaw_template_set_var('id', get_the_author_meta('ID'));
                    jaw_template_set_var('nicename', get_the_author());
                    echo jaw_get_template_part('author-bottom', 'blog');
                    ?>
                    <div class="meta_divider"></div>
                <?php } ?>
                <div class="clear"></div>
                <?php // BOTTOM ABOUT AUTHOR ?>
                
                <?php /* BOTTOM Related posts */ ?>
                <?php if (jwOpt::getPresetValue('post_bottom_relatedpost', '1', 'single', $jaw_single_preset) == '1') { ?>
                    <div class="related_bottom">
                        <?php echo jaw_get_template_part('related-post', 'blog'); ?>
                    </div>
                <?php } ?>
                <?php /* BOTTOM tags */ ?>
                <?php if (has_tag() && jwOpt::getPresetValue('post_tags_bottom', '1', 'single', $jaw_single_preset) == '1') { ?>
                    <?php echo jaw_get_template_part('tags', 'blog'); ?>
                    <div class="meta_divider"></div>
                <?php } ?>
    <?php //  ?>
                <?php /* BOTTOM Rating */ ?>
                <?php if ($review && jwOpt::getPresetValue('post_rating_bottom', '1', 'single', $jaw_single_preset) == '1') { ?>
                    <div class="jw-rating-bottom">
                    <?php
                    jaw_template_set_var('title', $rating_title);
                     echo jaw_get_template_part('rating', 'blog'); ?>
                    </div>
                    <div class="meta_divider"></div>
                <?php } ?>
    <?php  ?>
                <?php do_action('jaw_after_single'); ?>
                <?php /* BOTTOM Comments */ ?>
                <?php
                if (jwOpt::getPresetValue('show_comments', '1', 'single', $jaw_single_preset) == '1') {
                    comments_template();
                }
                ?>
                <?php
                // SHOW UP POST
                if(jwOpt::get_option("showup_post", 0)) {
                    echo jaw_get_template_part('related-post_showup', 'blog');
                }
                ?>
                <meta itemprop="name" content="<?php echo get_the_author(); ?>"/>
                <meta itemprop="datePublished" content="<?php echo get_the_date(); ?>"/>
                <meta itemprop="mainEntityOfPage" content="<?php echo get_the_permalink(); ?>"/>
                <span itemprop="author" itemscope itemtype="https://schema.org/Person">
                    <meta itemprop="name" content="<?php  echo get_the_author(); ?>"/>  
                </span>
                <meta itemprop="dateModified" content="<?php echo get_the_modified_date(); ?>"/>
                <input type="hidden" class="jw_readers_post_id" value="<?php  echo get_the_ID(); ?>" />
                </article>
                <?php
            endwhile;?>
<?php } ?>
<?php function jw_tmpl_blog__tags(){ ?>
 <div class="post-tags row">
    <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
        <?php
        jaw_template_set_var('box_title', esc_html__('Tags', "gdn-theme"));
        echo jaw_get_template_part('section_bar', 'simple-shortcodes');
        ?>
        <?php the_tags('<ul class="tag-list"><li>', '</li><li>', '</li></ul>'); ?>
    </div>
</div>
<?php } ?>
<?php function jw_tmpl_custom_posts__single_gallery(){ ?>
<?php
global $jaw_data, $wp_query;
$gal_actual_id = get_the_ID();
// Images 
$first = 'active';
$_gallery_items = get_post_meta(get_the_ID(), 'jaw_gallery_items', true);
$_gallery_items_parsed = json_decode($_gallery_items, true);
$_gallery_pagination_style = get_post_meta(get_the_ID(), 'jaw_gallery_pag_style', true);
$_gallery_show_share = get_post_meta(get_the_ID(), 'jaw_gallery_show_share', true);
$_gallery_gallery_image_description = get_post_meta(get_the_ID(), 'jaw_gallery_image_description', true);
$_gallery_image_position = get_post_meta(get_the_ID(), 'jaw_gallery_image_position', true);
$_gallery_show_animation = get_post_meta(get_the_ID(), 'jaw_gallery_show_animation', true);
$_gallery_image_interval_animation = get_post_meta(get_the_ID(), 'jaw_gallery_image_interval_animation', true);
$_gallery_get_excerpt = jwOpt::get_option('jaw_gallery_description_excerpt', '275');
$_gallery_image_description = get_post_meta(get_the_ID(),'jaw_gallery_image_description', 'On');
// Default
$_gallery_embed_pic_url = "";
$gallery_item_count = 0;
$video_link_width = 960; // default width of videos
$_gallery_show_post_title = "On";
$_gallery_show_gallery_title = "On";
// Banners
$gallery_banner = "";
$gallery_banner_class="";
$gallery_banner_position_type = "";
if (jwOpt::get_option('banner_gallery_show', '0')) {
    $gallery_banner = jaw_get_template_part('banner_gallery', 'blog');
}
if (jwOpt::get_option('banner_gallery_fixed', '0') == '1') {
    $gallery_banner_position_type = "jaw-gallery-banner-post-fixed";
}
$gallery_conteiner_col="";
if(empty($gallery_banner)) {
    $gallery_container_col = 12;
    $gallery_banner_class="jaw-gallery-banner-hide";
}  else {
    $gallery_container_col = 9;
    $gallery_banner_class="jaw-gallery-banner-show";
}
// Gallery pagination
$gallery_style = "";
$col_gallery_style = "";
switch ($_gallery_pagination_style) {
    case "Three" :
        $gallery_style = 2; // pagination 2
        $col_gallery_style = 6;
        break;
    case "Full" :
        $gallery_style = 4; // pagination 4
        $col_gallery_style = 12;
        break;
    default:
        $gallery_style = 4; // pagination 4
        $col_gallery_style = 12;
}
// Actual post ID and its excerpt
$actual_post_id = "";
$actual_post_desc = "";
$actual_cropp = -1;
$idurl=true;
if(isset($_GET["poid"])) {
    if(is_numeric($_GET["poid"]) && !isset($_GET["poid_sc"]) && !isset($_GET["iscat"])) {
        $actual_post_id = $_GET["poid"];
        $args = array(
            'post__in' => array(
                $actual_post_id
            ),
            'posts_per_page'      => 1,
            'ignore_sticky_posts' => 1,
            'post_excerpt' => $_gallery_get_excerpt
        );
        $wp_query = new WP_Query($args);
        while (have_posts()) : the_post();
            $actual_post_desc = get_the_excerpt();
        endwhile;
        wp_reset_query();
    }
} else {
    $idurl = false;
}

// redirecting functionality
$outstuff="";
$assigned_posts="";
$ids = get_the_ID();
$jaw_prev_url = jwUtils::jaw_get_previous_url(); // history refferer
$query = new WP_Query( array( 'meta_value' => $ids, 'posts_per_page' => 1 ) );
while ($query->have_posts()) : $query->the_post();
    $assigned_posts = get_the_ID();
endwhile;
$outstuff = get_the_title($assigned_posts);
if(!empty($assigned_posts)) { // redirect - pokud je galerie prirazena k postu(m)
    $redirect_back = get_post_permalink($assigned_posts); // vratis se do nejnovejsiho postu (pokud je galerie prirazena ve vice postech)
} else { // pokud neni prirazena
    $redirect_back = $jaw_prev_url;
}
if(empty($jaw_prev_url)) { // pokud nekdo nasdilel odkaz
    if(empty($assigned_posts)) {
        $redirect_back = jwUtils::jaw_get_previous_url();
    }
    $jaw_prev_url = get_home_url();
}

// Custom image position via admin
$max_gallery_items = sizeof($_gallery_items_parsed);
$custom_image_position="";
if($_gallery_image_position <= $max_gallery_items && $_gallery_image_position != null && is_numeric($_gallery_image_position)) {
    $custom_image_position = $_gallery_image_position;
} else {
    $custom_image_position = 1; // the first default image / item
}
// Custom image animation interval via admin
$gallery_image_interval_animation = 0;
if($_gallery_image_interval_animation != null && is_numeric($_gallery_image_interval_animation)) {
    $gallery_image_interval_animation = 0; // transfer to ms
}
// Turn off the image animation
$gallery_animation="jaw-gallery-anime-0";
if($_gallery_show_animation == "On") {
    $gallery_animation = "jaw-gallery-anime-1";
}
if (isset($_gallery_items_parsed)) {
    foreach ((array) $_gallery_items_parsed as $k => $i) {
        $image_id['image_id'][$k] = $i['id'];
    }
}
// Show / Hide image description
$gallery_image_description=0;
if(!empty($_gallery_image_description)) {
    switch($_gallery_image_description) {
        case "On" :
            $gallery_image_description=1;
            break;
        default:
            break;
    }
    $gallery_image_description="jaw-showhide-img-desc-".$gallery_image_description;
}
$gal = jwMedia::parseJson($_gallery_items);

if (isset($gal)) {
    $img_count=0;
    $hide_desc="";
    $urls = json_decode($_gallery_items);
    $post_desc="";
    $width="";
    $height="";
    foreach ((array) $gal as $k => $i) {
        $width=wp_get_attachment_metadata($image_id['image_id'][$k]);
        $width = isset($width["width"]) ? $width["width"] : "";
        $height=wp_get_attachment_metadata($image_id['image_id'][$k]);
        $height = isset($height["height"]) ? $height["height"] : "";
        $thumbnail_image = get_posts(array('p' => $image_id['image_id'][$img_count], 'post_type' => 'attachment')); 
        // hide empty img desc
        if(empty($thumbnail_image[0]->post_excerpt)) {
            $hide_desc = "jaw-hide-desc-empty";
            $post_desc="";
        } else {
            $hide_desc=""; 
            $post_desc = $thumbnail_image[0]->post_excerpt;
        }
        $urlpars=wp_get_attachment_image_src($urls[$k]->id,"full"); // $urlpars[0] means url
        $carousel['gallery'][$k] = '<div itemprop="associatedMedia" itemscope itemtype="http://schema.org/ImageObject" class=" '.$hide_desc.' item-wrapper" id="' . $image_id['image_id'][$k] . '"><a href="'.$urlpars[0].'" rel="prettyPhoto" itemprop="contentUrl">
        '.apply_filters('jaw_gallery_filter_expand_icon', '<i class="jaw-icon-expand"></i>').
        '</a><meta itemprop="width" content="'.$width.'"><meta itemprop="height" content="'.$height.'">
        '.apply_filters('jaw_gallery_filter_description_up_icon', '<i class="jaw-icon-square-up-right"></i>').
        '<div id="'.$gallery_animation.'" class="gallery-loader"></div>';
        $carousel['gallery'][$k] .= jwMedia::getAttachment($i,array('large','full'));
        $carousel['gallery'][$k] .= '<div id="jaw-gallery-single-image-' . $img_count . '" class="jaw-gallery-description active '.$gallery_image_description.'"><div class="jaw-shadow"><p itemprop="caption description">' . $post_desc . '</p>
        '.apply_filters('jaw_gallery_filter_description_down_icon', '<i class="jaw-icon-square-down-left"></i>').
        '</div></div>';
        $carousel['gallery'][$k] .= '</div>';
        $img_count++;
    }
}
if (isset($gal)) {
    $img_count=0;
    foreach ((array) $gal as $k => $i) {
        $temp = wp_get_attachment_metadata($image_id['image_id'][$img_count]);
            $carousel['gallery_list'][$k] = '<div class="item-wrapper" id="' . $image_id['image_id'][$k] . '"><div class="item-wrapper-main-border"><div class="item-wrapper-main-border-item simply-image-pic-lst">';
            $carousel['gallery_list'][$k] .= jwMedia::getAttachment($i,array('thumbnail'));
            $carousel['gallery_list'][$k] .= '<div id="jaw-gallery-single-image-' . $img_count . '"></div>';
            $carousel['gallery_list'][$k] .= '</div></div></div>';
            $img_count++;
    }
}
// Embed stuff
$_embed_items = get_post_meta(get_the_ID(), 'jaw_gallery_embed_link', true);
$_embed_items_parsed = json_decode($_embed_items, true);
$_gallery_embed_pic = jwOpt::get_option('gallery_embed_pic', 'def');
// Custom embed icon for embed stuff in gallery
if (!empty($_gallery_embed_pic)) {
    $parse_custom_img = (json_decode($_gallery_embed_pic, true));
    $_gallery_embed_pic_url = jwMedia::getAttachment($parse_custom_img[0]['id'], array('thumbnail'));
} else {
    $_gallery_embed_pic_url = apply_filters('jaw_default_embed_icon', '<i class="jaw-icon-embed3"></i>'); // default img
}
if (isset($_embed_items_parsed) && !empty($_embed_items_parsed)) {
    $carousel['embed_link'] = array();
    $carousel['embed_link_pic'] = array();
    foreach ((array) $_embed_items_parsed as $k => $i) {
        if(!empty($_embed_items_parsed[$k])) {
            if (!is_null($i['jaw_gallery_embed_link']) && !empty($i['jaw_gallery_embed_link'])) {
                $carousel['embed_link'][$k] = '<div class="item-wrapper embed_link its-width-'.$video_link_width.'">';
                $carousel['embed_link'][$k] .= $i['jaw_gallery_embed_link'];
                $carousel['embed_link'][$k] .= '</div>';
                $carousel['embed_link_pic'][$k] = '<div class="item-wrapper embed_link_pic"><div class="item-wrapper-main-border"><div class="item-wrapper-main-border-item">';
                $carousel['embed_link_pic'][$k] .= $_gallery_embed_pic_url;
                $carousel['embed_link_pic'][$k] .= '</div></div></div>';
            }
        }
    }
}
// video url
$_url_items = get_post_meta($gal_actual_id, 'jaw_gallery_video_link', true);
$_url_items_parsed = json_decode($_url_items, true);
if (isset($_url_items_parsed) && !empty($_url_items_parsed)) {
    $carousel['video_link'] = array();
    $carousel['video_link_pic'] = array();
    foreach ((array) $_url_items_parsed as $k => $i) {
        if(!empty($_url_items_parsed[$k])) {
            if (!is_null($i['jaw_gallery_video_link']) && !empty($i['jaw_gallery_video_link'])) {
                $video_thumb = jwMedia::getVideoInfo($_url_items_parsed[$k]['jaw_gallery_video_link']);
                $carousel['video_link'][$k] = '<div class="item-wrapper video_link its-width-'.$video_link_width.'">';
                $carousel['video_link'][$k] .= jwMedia::getVideoPlayer($i['jaw_gallery_video_link'], $video_link_width);
                $carousel['video_link'][$k] .= '</div>';
                $carousel['video_link_pic'][$k] = '<div class="item-wrapper video_link_pic"><div class="item-wrapper-main-border"><div class="item-wrapper-main-border-item">';
                $carousel['video_link_pic'][$k] .= '<div class="jaw-video-icon">'.apply_filters('jaw_default_video_icon', '<i class="jaw-icon-play4"></i>').
                '</div>';
                if(isset($video_thumb->thumbnails['thumbnail_medium'])){
                    $carousel['video_link_pic'][$k] .= '<img src="' . $video_thumb->thumbnails['thumbnail_medium'] . '"  alt="' . '" / >';
                }
                $carousel['video_link_pic'][$k] .= '</div></div></div>';
            }
        }
    }
}
// types position
$gallery_types = array(
    0 => "gallery_list",
    1 => "gallery", // 0
    2 => "video_link", // 1
    3 => "embed_link", // 2
    4 => "video_link_pic",
    5 => "embed_link_pic"
);
$gallery_types_items = array(
    0 => "item_list",
    1 => "item", // 0
    2 => "item video_link", // 1
    3 => "item embed_link", // 2
    4 => "item_pic video_link_pic",
    5 => "item_pic embed_link_pic"
);
foreach($gallery_types as $gtypes) {
    if (empty($carousel[''.$gtypes.''])) {
        $carousel[''.$gtypes.''] = array();
    }
}
jaw_template_inc_counter('gallery');
?>
    <div style="display:none;" class="jaw-media-gallery <?php echo esc_attr($gallery_banner_class).' jaw-gallery-preset-'.jwOpt::checkDefaultPreset(array(jwOpt::get_option('media_gallery_color', '_default'), jwOpt::get_option('main_color')),'color'); ?>">
        <?php
        if($_gallery_show_gallery_title == "On") { ?>
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <?php do_action('jaw_gallery_before_title'); ?>
                    <h1 class="jaw-gallery-main-title"><a href="<?php echo esc_url($redirect_back); ?>" target="_self">
                    <?php echo apply_filters('jaw_gallery_filter_undo_icon', '<i class="jaw-icon-undo2"></i>'); ?>
                    <span class="main_title"><?php echo esc_attr($outstuff); ?></span></a></h1>
                    <a href="<?php echo esc_url($jaw_prev_url); ?>" target="_self"><span class="jaw-gallery-close-icon close-button"><span class="close-text"><?php echo esc_html__('close','gdn-theme'); ?></span>
                    <?php echo apply_filters('jaw_gallery_filter_close_icon', '<i class="jaw-icon-close"></i>'); ?>
                    </span></a>
                    <?php do_action('jaw_gallery_after_title'); ?>
                </div> 
            </div>
        <?php } else { ?>
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <a href="<?php echo esc_url($jaw_prev_url); ?>" target="_self"><span class="jaw-gallery-close-icon close-button"><span class="close-text"><?php echo esc_html__('close','gdn-theme'); ?></span>
                    <?php echo apply_filters('jaw_gallery_filter_close_icon', '<i class="jaw-icon-close"></i>'); ?>
                    </span></a>
                </div> 
        </div> <?php } ?>
        <div class="row">
            <div class="col-lg-<?php echo esc_attr($gallery_container_col); ?> col-md-12 col-sm-12 col-xs-12 left-side-gallery-container <?php if(empty($gallery_banner)){echo "hide_border_banner";} ?>">
                <div class="row jaw-gallery-controls">
                    <?php 
                    // Share icons
                    if ($_gallery_show_share == "On") {
                        if (class_exists('mashshare')) { // mashare plugin
                            ?><div class="jaw-gallery-image-pagination3"></div>
                            <div class="mashShareIcon jaw-icon-share2"></div>
                            <?php echo do_shortcode("[mashshare shares='false' url='".$_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']."']"); ?>
                            <?php
                        } else {
                            ?><div class="jaw-gallery-share-area"><?php
                                echo jaw_get_template_part('shareit', 'blog');
                            ?></div><div class="jaw-gallery-image-pagination3"></div><?php
                        }
                        ?>
                    <?php } ?>
                    
                        </div>
                <div id="jaw-gallery-<?php echo esc_attr(jaw_template_get_counter('gallery')); ?>" class="row jaw-gallery">
                    <?php do_action('jaw_gallery_before_main_photo'); ?>
                    <div id="jaw-gallery-def-pos-<?php echo esc_attr($custom_image_position - 1); ?>" class="jaw-gallery-single-img-container"><a class="jaw-mobilegalleryarrow-left">
                        <?php echo apply_filters('jaw_gallery_filter_arrow_left_icon', '<i class="jaw-icon-sipka-gallery-left"></i>'); ?>
                        </a><a class="jaw-mobilegalleryarrow-right">
                            <?php echo apply_filters('jaw_gallery_filter_arrow_right_icon', '<i class="jaw-icon-sipka-gallery-right"></i>'); ?>
                        </a>
                        <div id="jaw-gallery-int-animation-<?php echo esc_attr($gallery_image_interval_animation); ?>" class="ic-with-custom-int inner-container">
                            <?php
                            for($a=0; $a < count($carousel);$a++) {
                                foreach ((array) $carousel[''.$gallery_types[$a].''] as $car) {
                                    foreach ((array) $car as $c) {
                                        echo '<div class="'.esc_attr($gallery_types_items[$a]).' ' . esc_attr($first) . '">';
                                            echo $c;
                                        echo '</div>';
                                        $first = '';
                                    }
                                }
                            }
                            ?>
                        </div>
                    </div>
                    <?php do_action('jaw_gallery_after_main_photo'); ?>
                </div>
                <div class="row jaw-gallery-after-img-area">
                    <?php do_action('jaw_gallery_before_list_photos'); ?>
                    <div class="col-lg-<?php echo esc_attr($col_gallery_style); ?> col-md-12 col-sm-12 col-xs-12 jaw-gallery-image-pagination<?php echo esc_attr($gallery_style); ?>"></div>
                    <?php do_action('jaw_gallery_after_list_photos'); ?>
                </div>
            </div>
            <!-- Banner -->
                    <?php if ($gallery_banner) { ?>
                <div class="col-lg-3 col-md-12 col-sm-12 col-xs-12">
                    <div class="jaw-gallery-banners <?php if ($gallery_banner_position_type) {
                        echo esc_attr($gallery_banner_position_type);
                    } ?>" aria-label="<?php esc_html_e('Here is a Banner','gdn-theme'); ?>">
            <?php
            if ($gallery_banner != null) {
                echo $gallery_banner;
            }
            ?>
                    </div>
                </div><?php } ?>
        </div>
<?php ?>
    </div>
<?php } ?>
<?php function jw_tmpl_featured_area__featured_area(){ ?>
<?php
$preset = jwOpt::checkDefaultPreset(array(jwOpt::get_option('header_color', '_default'), jwOpt::get_option('main_color')),'color');
echo jwUtils::customizer_preview_preset("Featured area", $preset);
$class_head = array();
$class_head[] = 'post-preset-' . $preset;	
$content = jwOpt::get_option('featured_area_builder_shortcodes',array());
if(isset($content['2_content'])){
	?>
	<div class="jaw-featured-area <?php echo esc_attr(implode(' ',$class_head)); ?>">
		<div class="row jaw-featured-area-row">
			<?php 
				echo do_shortcode($content['2_content']);
			?>
		</div>
	</div>
	<?php
}?>
<?php } ?>
<?php function jw_tmpl_content__content_classical_gallery(){ ?>
<?php
global $post, $wp_query, $jaw_data;
$col_count = jaw_template_get_var("columns", 4);
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-classical';
$single_class[] = 'jaw-post-box';
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">        
        <?php
            $link = false;
            $pp = false;
            switch (jaw_template_get_var('clickable_image', '0')) {
                case '1': $link = get_permalink();
                    break;
                case '2': $link = jwMedia::getPostThumbnailSrc(get_the_ID());
                    $pp = true;
                    break;
            }
            $gallery = get_post_meta(get_the_ID(), 'jaw_post_gallery', true);
            $ids = jwMedia::parseJson($gallery);
            if(!empty($ids)){
                ?>
                <div class="image gallery">
                <?php
                foreach ((array)$ids as $key => $id) {
                    echo jwMedia::getAttachment($id, array('jaw_blog-16_9-small', 'jaw_blog-16_9-middle', 'jaw_blog-16_9','jaw_blog-16_9-big',  'large'), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
                    if($key == 3){
                        break;
                    }
                }
            }else{
                ?>
                <div class="image">
                <?php
                echo jwMedia::getPostThumbnail(get_the_ID(), array('large','full'));
            }
            ?>
            <div class="post-comments-labes">
                <?php
                if (jaw_template_get_var('blog_comments_inimage', '1') == '1') {
                    echo jwRender::get_meta_comments();
                }
                ?>
            </div>
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_classical', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
        <div class="clear"></div>
    </div>
</article>


<?php } ?>
<?php function jw_tmpl_content__content_classical_link(){ ?>
<?php
global $post, $wp_query, $jaw_data;

$col_count = jaw_template_get_var("columns", 4);
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-classical';
$single_class[] = 'jaw-post-box';
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">        
        <div class="image link">
            <i class="jaw-icon-new-tab"></i>
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_classical', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
        <div class="clear"></div>
    </div>
</article>


<?php } ?>
<?php function jw_tmpl_content__content_classical_quote(){ ?>
<?php
global $post, $wp_query, $jaw_data;

$col_count = jaw_template_get_var("columns", 4);
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-classical';
$single_class[] = 'jaw-post-box';
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">        
        <div class="image quote">
            <i class="jaw-icon-quotes-right"></i>
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_classical', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
        <div class="clear"></div>
    </div>
    <div class="clear"></div>
</article>


<?php } ?>
<?php function jw_tmpl_content__content_classical_review(){ ?>
<?php
global $post, $wp_query, $jaw_data;
$post_meta = get_post_meta(get_the_ID(), 'fw_rating_position', true);
$totalrat = array('final' => "");
if(class_exists('ratingManager')){
    $ratingManager = ratingManager::getInstance();
    $ratings = $ratingManager->getRatings(get_the_ID());
    $totalrat = $ratingManager->getRatingsScore($ratings);
}
$ratingtype=jwOpt::get_option('rating_maximal_value');
$ratingmaxvalue=jwOpt::get_option('rating_maximal_value_show');
$col_count = jaw_template_get_var("columns", 4);
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-classical';
$single_class[] = 'format-review';
$single_class[] = 'jaw-post-box';
$attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">        
        <div class="image">
            <?php
            $link = false;
            $pp = false;
            switch (jaw_template_get_var('clickable_image', '0')) {
                case '1': $link = get_permalink();
                echo "<a href=".$link.">";
                    break;
                case '2': $link = jwMedia::getPostThumbnailSrc(get_the_ID());
                echo "<a href=".$link." rel='prettyPhoto[".jaw_template_get_counter('pagination')."]'>";
                $pp = true;
                break;
            }
            echo "<span class='jaw-fadein'></span>";
            echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-16_9-small', 'jaw_blog-16_9-middle', 'jaw_blog-16_9'));
            echo '<span class="post-categories-labels">';
                if ($post_meta == '1') { ?>
                    <span class="post-review-total">
                        <?php
                        switch($ratingtype) {
                            case "100" :
                                    echo esc_attr(round($totalrat['final'], 0)).'<span>%</span>';
                            break;
                            default:
                                if($ratingmaxvalue) {
                                    echo esc_attr(round($totalrat['final'], 1)).'<span>/'.esc_attr($ratingtype).'</span>';
                                } else {
                                    echo esc_attr(round($totalrat['final'], 1));
                                }
                            break;
                        }
                         ?>
                    </span>
                <?php }
            echo '</span>';
            if(has_post_thumbnail()){
                if(isset($attachement["width"]) && isset($attachement["height"])){
                    $width = $attachement["width"];
                    $height = $attachement["height"];
                }
            }?>
            <?php 
            if(jaw_template_get_var('clickable_image', '0')) {
                echo "</a>";
            }
            ?>
            <div class="post-comments-labes">
                <?php
                if (jaw_template_get_var('blog_comments_inimage', '1') == '1') {
                    echo jwRender::get_meta_comments();
                }
                ?>
            </div>
            <div class="post-categories-labels">
                <?php
                if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                    echo jwRender::get_meta_category();
                }
                ?>
            </div>
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_classical', 'review' ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
        <div class="clear"></div>
    </div>
</article>


<?php } ?>
<?php function jw_tmpl_content__content_classical_video(){ ?>
<?php
global $post, $wp_query, $jaw_data, $content_width;
$col_count = jaw_template_get_var("columns", 4);
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-classical';
$single_class[] = 'jaw-post-box';
$attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box">        
        <div class="image video">
            <?php
            $video = get_post_meta(get_the_ID(), 'jaw_post_video_link', true);
            $link = false;
            $pp = false;
            $rel = '';
            switch (jaw_template_get_var('clickable_image', '0')) {
                case '1': $link = get_permalink();
                    $rel = ''; 
                    break;
                case '2': $link = $video;
                    $pp = true;
                    $rel = 'prettyPhoto[]';
                    break;
            }
            if (has_post_thumbnail()) {
                echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-16_9-small', 'jaw_blog-16_9-middle', 'jaw_blog-16_9'), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
                if(isset($attachement["width"]) && isset($attachement["height"])){
                    $width = $attachement["width"];
                    $height = $attachement["height"];
                }
            } else {
                echo jwMedia::getVideoThumbnail($video, $link, array($pp, 'full', jaw_template_get_counter('pagination')));
            }
            if($link){
                echo '<a href="'.$link.'" rel="'.$rel.'" >';
            }
            echo '<span class="jaw-video-icon">'.apply_filters('jaw_default_video_icon', '<i class="jaw-icon-play4"></i>').'</span>';
             if($link){
                echo '</a>';
            }
            ?>
            <div class="post-comments-labes">
                <?php
                if (jaw_template_get_var('blog_comments_inimage', '1') == '1') {
                    echo jwRender::get_meta_comments();
                }
                ?>
            </div>
            <div class="post-categories-labels">
                <?php
                if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                    echo jwRender::get_meta_category();
                }
                ?>
            </div>
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_classical', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
        <div class="clear"></div>
    </div>
</article>


<?php } ?>
<?php function jw_tmpl_content__content_classical(){ ?>
<?php
global $post, $wp_query, $jaw_data, $content_width;
$col_count = jaw_template_get_var("columns", 4);
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-classical';
$single_class[] = 'jaw-post-box';
$attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">        
        <div class="image">
            <?php
            $link = false;
            $pp = false;
            switch (jaw_template_get_var('clickable_image', '0')) {
                case '1': $link = get_permalink();
                    break;
                case '2': $link = jwMedia::getPostThumbnailSrc(get_the_ID());
                    $pp = true;
                    break;
            }
            echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-16_9-small', 'jaw_blog-16_9-middle', 'jaw_blog-16_9', 'jaw_blog-16_9-big', 'large'), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
            if(has_post_thumbnail()){
                    if(isset($attachement["width"]) && isset($attachement["height"])){
                        $width = $attachement["width"];
                        $height = $attachement["height"];
                    }
                }?>
            <div class="post-comments-labes">
                <?php
                if (jaw_template_get_var('blog_comments_inimage', '1') == '1') {
                    echo jwRender::get_meta_comments();
                }
                ?>
            </div>
            <div class="post-categories-labels">
                <?php
                if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                    echo jwRender::get_meta_category();
                }
                ?>
            </div>
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_classical', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
        <div class="clear"></div>
    </div>
</article>


<?php } ?>
<?php function jw_tmpl_content__content_full_gallery(){ ?>
<?php
global $content_width, $wp_query, $post;


$terms = get_the_category();
$post_meta = get_post_meta(get_the_id(), '');

if (isset($terms[0]->term_id)) {
    $term_id = $terms[0]->term_id;
} else {
    $term_id = 0;
}
if (isset($terms[0]->term_id)) {
    $term_id = $terms[0]->term_id;
} else {
    $term_id = 0;
}
$single_preset = jwOpt::checkDefaultPreset(array(jwOpt::get_option('single_preset', jwOpt::get_option('single_preset'), 'category', $term_id), jwOpt::get_option('single_preset')),'single');
jaw_template_set_var('single_preset',$single_preset);

if (jwLayout::content_layout() == 'fullwidth_sidebar') {
    $layout = 'fullwidth';
} else {
    $layout = 'sidebar';
}
// with perex
$with_perex = false;
if (strpos(get_the_content(), 'more')) {
    $with_perex = true;
}
// image caption
$image_caption_toggle = 'image_caption_toggle-' . jwOpt::get_option('image_caption_toggle');
$columns = jaw_template_get_var("columns", 4);
//clases
$single_class = array();
$single_class[] = jwLayout::col_class($columns);
$single_class[] = 'content-full';
$single_class[] = 'jaw-post-box';
$single_class[] = 'jaw-single';
$single_class[] = 'bar_type_1';
$single_class[] = $layout;
$single_class[] = 'post-preset-' . jwOpt::checkDefaultPreset(array(jwOpt::get_option('content_color', '_default', 'category', $term_id), jwOpt::get_option('main_color')), 'color');
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');

//review
$review = false;
if (isset($post_meta['fw_rating_position']) && implode($post_meta['fw_rating_position']) == '1') {
    $review = true;
} else {
    $review = false;
}


// META
$meta_date = jwOpt::getPresetValue('meta_date', '1', 'single', $single_preset);
$meta_comments_count = jwOpt::getPresetValue('meta_comments_count', '1', 'single', $single_preset);
$meta_author = jwOpt::getPresetValue('meta_author', '1', 'single', $single_preset);
$meta_category = jwOpt::getPresetValue('meta_category', '1', 'single', $single_preset);
$meta_likes = jwOpt::getPresetValue('meta_likes', '1', 'single', $single_preset);
$meta_ratings = jwOpt::getPresetValue('meta_ratings', '1', 'single', $single_preset);
$meta_featured = jwOpt::getPresetValue('meta_featured', '1', 'single', $single_preset);
$meta_print = jwOpt::getPresetValue('meta_print', '1', 'single', $single_preset);
$meta_font_resize = jwOpt::getPresetValue('meta_font_resize', '1', 'single', $single_preset);
    
                
//Side Box

$col_content = 12;

$show_after_perex_box = false;
$side_box_position = jwOpt::getPresetValue('perex_box', 'left', 'single', $single_preset);
$side_box_visibility = jwOpt::getPresetValue('perex_box_visibility', 'tablet', 'single', $single_preset);
if ($side_box_visibility != '0') {
    jaw_template_set_var('bar_type', jwOpt::getPresetValue('post_layout_style', 'bar_type_1', 'single', $single_preset));
    jaw_template_set_var('single_preset', $single_preset);

    $gallery_show = jwOpt::getPresetValue('perex_gallery', '4', 'single', $single_preset);
    $perex_gallery_content = jwMedia::getGallery("vertical",$gallery_show);
    $perex_featured = jwOpt::getPresetValue('perex_featured', '1', 'single', $single_preset);
    $perex_shares = jwOpt::getPresetValue('perex_shares', '0', 'single', $single_preset);
    $perex_related_posts = jwOpt::getPresetValue('perex_related_posts', '1', 'single', $single_preset);
    $perex_tags = jwOpt::getPresetValue('perex_tags', '0', 'single', $single_preset);
    $perex_rating = jwOpt::getPresetValue('perex_rating', '1', 'single', $single_preset);
    $perex_banner = jwOpt::getPresetValue('perex_banner', '1', 'single', $single_preset);
    if($perex_gallery_content || $perex_featured || $perex_shares || $perex_related_posts || ($perex_rating && $review) || $perex_banner || $perex_tags) {
        $show_after_perex_box = true;
        $col_content = 9;
        
        $after_perex_box_class = array();
        $after_perex_box_class[] = jwLayout::col_class(3);
        $after_perex_box_class[] = 'show-on-'.$side_box_visibility;
        $after_perex_box_class[] = 'fixed_'.jwOpt::getPresetValue('perex_box_fixed', '0', 'single', $single_preset);
                        
    }
}

$main_content_class = array();
$main_content_class[] = 'jaw-after-perex';
$main_content_class[] = 'jaw-sidebox-position-'.$side_box_position;
$main_content_class[] = jwLayout::col_class($col_content);
    
    
?>
<article  <?php post_class($single_class); ?> id="post-<?php the_ID(); ?>">
    <div class="entry-content <?php echo esc_attr($image_caption_toggle); ?>" >
        <h3 class="entry-title perex">
            <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
            <?php the_title(); ?>
            </a>
        </h3>
  
       <?php
            $link = false;
            $pp = false;
            switch (jaw_template_get_var('clickable_image', '0')) {
                case '1': $link = get_permalink();
                    break;
                case '2': $link = jwMedia::getPostThumbnailSrc(get_the_ID());
                    $pp = true;
                    break;
            }
            $gallery = get_post_meta(get_the_ID(), 'jaw_post_gallery', true);
            $ids = jwMedia::parseJson($gallery);
            if(!empty($ids)){
                ?>
                <div class="image gallery">
                <?php
                foreach ((array)$ids as $key => $id) {
                    echo jwMedia::getAttachment($id, array('jaw_blog-16_9-big', 'jaw_blog-16_9-small', 'jaw_blog-16_9-middle', 'jaw_blog-16_9',  'large'), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
                    if($key == 3){
                        break;
                    }
                }
            }else{
                ?>
                <div class="image">
                <?php
                echo jwMedia::getPostThumbnail(get_the_ID(), array('large','full'));
            }
            ?>
            <div class="post-comments-labes">
                <?php
                if (jaw_template_get_var('blog_comments_inimage', '1') == '1') {
                    echo jwRender::get_meta_comments();
                }
                ?>
            </div>
            <div class="post-categories-labels">
                <?php
                if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                    echo jwRender::get_meta_category();
                }
                ?>
            </div>
        </div>
        <?php
        if ($with_perex) {
            global $more;
            $more = 0;
            ?>
            <div class="perex">   
                <div class="row">
                    <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?> jaw-perex-content">
                        <?php the_content('', true); ?>
                    </div>
                </div>

            <?php } else { ?>
                <div  class="perex ">   
                <?php } ?>
                <?php
                // META
                echo jaw_get_template_part('meta', 'meta') 
                // END META
                ?>
            </div>
            <div  class="more-text">
                <?php
                if ($with_perex) {
                    $more = 1;
                }
                // ========================== CONTENT =================================
            ?>
                <div class="row">
                    <div class="<?php echo esc_attr(implode(' ', $main_content_class)); ?> jaw-after-perex">
                        <div class="row">
                            <?php jwRender::get_banner('posttop'); ?>
                            <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
                                <?php the_content('', true); ?>
                            </div>
                            <?php jwRender::get_banner('postbottom'); ?>
                             <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
                             <?php 
                                 //multipages
                               wp_link_pages(array('before' => '<div id="page-nav">', 'after' => '</div>', 'link_before' => '<span class="post_page">', 'link_after' => '</span>'));
                             ?>
                            </div>
                        </div>
                    </div>
                    <?php
                    
                        
                    // ========================================== BOX AFTER PEREX ===================================================
                    jaw_template_set_var('single_preset', $single_preset);
                    jaw_template_set_var('bar_type', jwOpt::getPresetValue('post_layout_style', 'bar_type_1', 'single', $single_preset));
                    
                    if ($show_after_perex_box) { // perex on
                        $count = 0;
                        ?>
                        <div class="<?php echo esc_attr(implode( ' ',$after_perex_box_class)); ?> jaw-box perex-box jw-rating-slim">
                            <?php do_action('jaw_before_perex_box'); ?>
                            <!-- Featured post area -->
                            <?php
                            /*                                 * ****************** GALLERY PEREX BOX ******************* */
                            if($perex_gallery_content) {
                                echo $perex_gallery_content;
                                echo '<div class="meta_divider"></div>';
                            }
                            /*                                 * ****************** Featured post ******************* */
                            if ($perex_featured) {
                                echo jaw_get_template_part('featured_post', 'blog');
                                $count++;
                            }
                            /*                                 * ****************** Share post ******************* */
                            if ($perex_shares) {
                                echo jaw_get_template_part('shareit', 'blog');
                                $count++;
                            }
                            /*                                 * ****************** Related posts ******************* */
                            if ($perex_related_posts) {
                                echo jaw_get_template_part('related-post_box', 'blog');
                                $count++;
                            }
                            /*                                 * ****************** Rate post ******************* */
                            if ($perex_rating && $review) {
                                echo jaw_get_template_part('rating', 'blog');
                                $count++;
                            }
                            /*                                 * ****************** TAGS  ******************* */
                               
                                if (has_tag() && $perex_tags) { 
                                    echo jaw_get_template_part('tags', 'blog');
                                    $count++;
                                }
                            /*                                 * ****************** banner ******************* */
                            if ($perex_banner) {
                                ?>
                                <div class="row"> 
                                    <?php
                                    jwRender::get_banner('postside');
                                    ?>
                                </div>
                                <?php
                                $count++;
                            }
                            ?>
                            <?php if($count > 0){ ?>
                                <div class="meta_divider"></div>
                            <?php } ?>
                            <?php do_action('jaw_after_side_box'); ?>
                        </div>
                    <?php } // CONTENT Side Box
                    jaw_template_set_var("columns", $columns);
                    ?>
                </div>

            </div>
            <div class="clear"></div>
            <!-- Pagination -->
            </article>
            <?php

        ?>
<?php } ?>
<?php function jw_tmpl_content__content_full_link(){ ?>
<?php
global $post, $wp_query, $jaw_data;

if (jwLayout::content_layout() == 'fullwidth_sidebar') {
    $layout = 'fullwidth';
} else {
    $layout = 'sidebar';
}

$col_count = jaw_template_get_var("columns", 4);
//clases
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-full';
$single_class[] = 'jaw-post-box';
$single_class[] = 'bar_type_1';
$single_class[] = 'jaw-single';
$single_class[] = $layout;
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article  <?php post_class($single_class); ?> id="post-<?php the_ID(); ?>">
    <div class="box ">        
        <div class="image link">
            <i class="jaw-icon-new-tab"></i>
        </div>
        <div class="content-box">
            <header>
                <h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?> class="jw-title">
                    <a href="<?php echo esc_url(get_post_meta(get_the_ID(), 'jaw_post_link', true)); ?>" class="post_name"><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></a>
                </h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?>>
            </header>
            <?php
            echo jaw_get_template_part('meta', 'meta');
            ?>
        </div>
        <div class="clear"></div>
    </div>
</article>


<?php } ?>
<?php function jw_tmpl_content__content_full_quote(){ ?>
<?php
global $post, $wp_query, $jaw_data;

if (jwLayout::content_layout() == 'fullwidth_sidebar') {
    $layout = 'fullwidth';
} else {
    $layout = 'sidebar';
}

$col_count = jaw_template_get_var("columns", 4);
//clases
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-full';
$single_class[] = 'jaw-post-box';
$single_class[] = 'jaw-single';
$single_class[] = 'bar_type_1';
$single_class[] = $layout;
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article  <?php post_class($single_class); ?> id="post-<?php the_ID(); ?>">
    <div class="box ">        
        <div class="image quote">
            <i class="jaw-icon-quotes-right"></i>
        </div>
        <div class="content-box">
            <header>
                <h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?> class="jw-title">
                    <a href="<?php the_permalink(); ?>" class="post_name">
                    <?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?>
                    </a>
                </h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?>>
            </header>
            <div class="quote-author">
                <?php echo get_post_meta(get_the_ID(), 'jaw_post_quote_author', true); ?>
            </div>
            <?php
            echo jaw_get_template_part('meta', 'meta');
            ?>
        </div>
        <div class="clear"></div>
    </div>
    <div class="clear"></div>
</article>
<?php } ?>
<?php function jw_tmpl_content__content_full_review(){ ?>
<?php
global $content_width, $wp_query, $post;


$terms = get_the_category();
$post_meta = get_post_meta(get_the_id(), '');

$totalrat = array('final' => "");
if(class_exists('ratingManager')){
    $ratingManager = ratingManager::getInstance();
    $ratings = $ratingManager->getRatings(get_the_ID());
    $totalrat = $ratingManager->getRatingsScore($ratings);
}
$ratingtype=jwOpt::get_option('rating_maximal_value');
$ratingmaxvalue=jwOpt::get_option('rating_maximal_value_show');

if (isset($terms[0]->term_id)) {
    $term_id = $terms[0]->term_id;
} else {
    $term_id = 0;
}
$single_preset = jwOpt::checkDefaultPreset(array(jwOpt::get_option('single_preset', jwOpt::get_option('single_preset'), 'category', $term_id), jwOpt::get_option('single_preset')),'single');
jaw_template_set_var('single_preset',$single_preset);

if (jwLayout::content_layout() == 'fullwidth_sidebar') {
    $layout = 'fullwidth';
} else {
    $layout = 'sidebar';
}
// with perex
$with_perex = false;
if (strpos(get_the_content(), 'more')) {
    $with_perex = true;
}
// image caption
$image_caption_toggle = 'image_caption_toggle-' . jwOpt::get_option('image_caption_toggle');
$columns = jaw_template_get_var("columns", 4);
//clases
$single_class = array();
$single_class[] = jwLayout::col_class($columns);
$single_class[] = 'content-full';
$single_class[] = 'jaw-post-box';
$single_class[] = 'bar_type_1';
$single_class[] = 'jaw-single';
$single_class[] = 'format-review';
$single_class[] = $layout;
$single_class[] = 'post-preset-' . jwOpt::checkDefaultPreset(array(jwOpt::get_option('content_color', '_default', 'category', $term_id), jwOpt::get_option('main_color')),'color');
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');

//review
$review = false;
if (isset($post_meta['fw_rating_position']) && implode($post_meta['fw_rating_position']) == '1') {
    $review = true;
} else {
    $review = false;
}

// META
$meta_date = jwOpt::getPresetValue('meta_date', '1', 'single', $single_preset);
$meta_comments_count = jwOpt::getPresetValue('meta_comments_count', '1', 'single', $single_preset);
$meta_author = jwOpt::getPresetValue('meta_author', '1', 'single', $single_preset);
$meta_category = jwOpt::getPresetValue('meta_category', '1', 'single', $single_preset);
$meta_likes = jwOpt::getPresetValue('meta_likes', '1', 'single', $single_preset);
$meta_ratings = jwOpt::getPresetValue('meta_ratings', '1', 'single', $single_preset);
$meta_featured = jwOpt::getPresetValue('meta_featured', '1', 'single', $single_preset);
$meta_print = jwOpt::getPresetValue('meta_print', '1', 'single', $single_preset);
$meta_font_resize = jwOpt::getPresetValue('meta_font_resize', '1', 'single', $single_preset);
    
                
//Side Box

$col_content = 12;

$show_after_perex_box = false;
$side_box_position = jwOpt::getPresetValue('perex_box', 'left', 'single', $single_preset);
$side_box_visibility = jwOpt::getPresetValue('perex_box_visibility', 'tablet', 'single', $single_preset);
if ($side_box_visibility != '0') {
    jaw_template_set_var('bar_type', jwOpt::getPresetValue('post_layout_style', 'bar_type_1', 'single', $single_preset));
    jaw_template_set_var('single_preset', $single_preset);

    $gallery_show = jwOpt::getPresetValue('perex_gallery', '4', 'single', $single_preset);
    $perex_gallery_content = jwMedia::getGallery("vertical",$gallery_show);
    $perex_featured = jwOpt::getPresetValue('perex_featured', '1', 'single', $single_preset);
    $perex_shares = jwOpt::getPresetValue('perex_shares', '0', 'single', $single_preset);
    $perex_related_posts = jwOpt::getPresetValue('perex_related_posts', '1', 'single', $single_preset);
    $perex_tags = jwOpt::getPresetValue('perex_tags', '0', 'single', $jaw_single_preset);
    $perex_rating = jwOpt::getPresetValue('perex_rating', '1', 'single', $single_preset);
    $perex_banner = jwOpt::getPresetValue('perex_banner', '1', 'single', $single_preset);
    if($perex_gallery_content || $perex_featured || $perex_shares || $perex_related_posts || ($perex_rating && $review) || $perex_banner || $perex_tags) {
        $show_after_perex_box = true;
        $col_content = 9;
        
        $after_perex_box_class = array();
        $after_perex_box_class[] = jwLayout::col_class(3);
        $after_perex_box_class[] = 'show-on-'.$side_box_visibility;
        $after_perex_box_class[] = 'fixed_'.jwOpt::getPresetValue('perex_box_fixed', '0', 'single', $single_preset);
                        
    }
}

$main_content_class = array();
$main_content_class[] = 'jaw-after-perex';
$main_content_class[] = 'jaw-sidebox-position-'.$side_box_position;
$main_content_class[] = jwLayout::col_class($col_content);
$attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
?>
<article  <?php post_class($single_class); ?> id="post-<?php the_ID(); ?>">
    <div class="entry-content <?php echo esc_attr($image_caption_toggle); ?>" >
        <h3 class="entry-title perex" >
            <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
            <?php the_title(); ?>
            </a>
        </h3>
                <div class="image">
            <?php
            $link = false;
            $pp = false;
            switch (jaw_template_get_var('clickable_image', '0')) {
                case '1': $link = get_permalink();
                    break;
                case '2': $link = jwMedia::getPostThumbnailSrc(get_the_ID());
                    $pp = true;
                    break;
            }
            ?><span class="jaw-fadein"></span><?php 
            echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-16_9-big','jaw_blog-16_9-small', 'jaw_blog-16_9-middle', 'jaw_blog-16_9',  'large'), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
            if(has_post_thumbnail()){
                if(isset($attachement["width"]) && isset($attachement["height"])){
                    $width = $attachement["width"];
                    $height = $attachement["height"];
                }
            }?>
            <div class="post-comments-labes">
                <?php
                if (jaw_template_get_var('blog_comments_inimage', '1') == '1') {
                    echo jwRender::get_meta_comments();
                }
                ?>
            </div>
            <div class="post-categories-labels">
                <?php if (isset($post_meta['fw_rating_position'][0]) && $post_meta['fw_rating_position'][0] == '1') {
                    ?>
                    <div class="post-review-total">
                        <?php
                        switch($ratingtype) {
                            case "100" :
                                    echo esc_attr(round($totalrat['final'], 0)).'<span>%</span>';
                            break;
                            default:
                                if($ratingmaxvalue) {
                                    echo esc_attr(round($totalrat['final'], 1)).'<span>/'.esc_attr($ratingtype).'</span>';
                                } else {
                                    echo esc_attr(round($totalrat['final'], 1));
                                }
                            break;
                        }
                         ?>
                    </div>
                <?php } ?>
                <?php
                if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                    echo jwRender::get_meta_category();
                }
                ?>
            </div>
        </div>
        <?php
        if ($with_perex) {
            global $more;
            $more = 0;
            ?>
            <div class="perex">   
                <div class="row">
                    <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?> jaw-perex-content">
                        <?php the_content('', true); ?>
                    </div>
                </div>

            <?php } else { ?>
                <div  class="perex ">   
                <?php } ?>
                <?php
                // META
                echo jaw_get_template_part('meta', 'meta') 
                // END META
                ?>
            </div>
            <div  class="more-text">
                <?php
                if ($with_perex) {
                    $more = 1;
                }
                // ========================== CONTENT =================================
            ?>
                <div class="row">
                    <div class="<?php echo esc_attr(implode(' ', $main_content_class)); ?> jaw-after-perex">
                        <div class="row">
                            <?php jwRender::get_banner('posttop'); ?>
                            <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
                                <?php the_content('', true); ?>
                            </div>
                            <?php jwRender::get_banner('postbottom'); ?>
                             <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
                             <?php 
                                 //multipages
                               wp_link_pages(array('before' => '<div id="page-nav">', 'after' => '</div>', 'link_before' => '<span class="post_page">', 'link_after' => '</span>'));
                             ?>
                            </div>
                        </div>
                    </div>
                    <?php
                    
                        
                    // ========================================== BOX AFTER PEREX ===================================================
                    jaw_template_set_var('single_preset', $single_preset);
                    jaw_template_set_var('bar_type', jwOpt::getPresetValue('post_layout_style', 'bar_type_1', 'single', $single_preset));
                    
                    if ($show_after_perex_box) { // perex on
                        $count = 0;
                        ?>
                        <div class="<?php echo esc_attr(implode( ' ',$after_perex_box_class)); ?> jaw-box perex-box jw-rating-slim">
                            <?php do_action('jaw_before_perex_box'); ?>
                            <!-- Featured post area -->
                            <?php
                            /*                                 * ****************** GALLERY PEREX BOX ******************* */
                            if($perex_gallery_content) {
                                echo $perex_gallery_content;
                                echo '<div class="meta_divider"></div>';
                            }
                            /*                                 * ****************** Featured post ******************* */
                            if ($perex_featured) {
                                echo jaw_get_template_part('featured_post', 'blog');
                                $count++;
                            }
                            /*                                 * ****************** Share post ******************* */
                            if ($perex_shares) {
                                echo jaw_get_template_part('shareit', 'blog');
                                $count++;
                            }
                            /*                                 * ****************** Related posts ******************* */
                            if ($perex_related_posts) {
                                echo jaw_get_template_part('related-post_box', 'blog');
                                $count++;
                            }
                            /*                                 * ****************** Rate post ******************* */
                            if ($perex_rating && $review) {
                                echo jaw_get_template_part('rating', 'blog');
                                $count++;
                            }
                            /*                                 * ****************** TAGS  ******************* */
                               
                                if (has_tag() && $perex_tags) { 
                                    echo jaw_get_template_part('tags', 'blog');
                                    $count++;
                                }
                            /*                                 * ****************** banner ******************* */
                            if ($perex_banner) {
                                ?>
                                <div class="row"> 
                                    <?php
                                    jwRender::get_banner('postside');
                                    ?>
                                </div>
                                <?php
                                $count++;
                            }
                            ?>
                            <?php if($count > 0){ ?>
                                <div class="meta_divider"></div>
                            <?php } ?>
                            <?php do_action('jaw_after_side_box'); ?>
                        </div>
                    <?php } // CONTENT Side Box
                    jaw_template_set_var("columns", $columns);
                    ?>
                </div>

            </div>
            <div class="clear"></div>
            <!-- Pagination -->
            </article>
            <?php

        ?>
<?php } ?>
<?php function jw_tmpl_content__content_full_video(){ ?>
<?php
global $content_width, $wp_query, $post;


$terms = get_the_category();
$post_meta = get_post_meta(get_the_id(), '');

if (isset($terms[0]->term_id)) {
    $term_id = $terms[0]->term_id;
} else {
    $term_id = 0;
}
if (isset($terms[0]->term_id)) {
    $term_id = $terms[0]->term_id;
} else {
    $term_id = 0;
}
$single_preset = jwOpt::checkDefaultPreset(array(jwOpt::get_option('single_preset', jwOpt::get_option('single_preset'), 'category', $term_id), jwOpt::get_option('single_preset')),'single');
jaw_template_set_var('single_preset',$single_preset);
if (jwLayout::content_layout() == 'fullwidth_sidebar') {
    $layout = 'fullwidth';
} else {
    $layout = 'sidebar';
}
// with perex
$with_perex = false;
if (strpos(get_the_content(), 'more')) {
    $with_perex = true;
}
// image caption
$image_caption_toggle = 'image_caption_toggle-' . jwOpt::get_option('image_caption_toggle');
$columns = jaw_template_get_var("columns", 4);
//clases
$single_class = array();
$single_class[] = jwLayout::col_class($columns);
$single_class[] = 'content-full';
$single_class[] = 'jaw-post-box';
$single_class[] = 'jaw-single';
$single_class[] = 'bar_type_1';
$single_class[] = $layout;
$single_class[] = 'post-preset-' . jwOpt::checkDefaultPreset(array(jwOpt::get_option('content_color', '_default', 'category', $term_id), jwOpt::get_option('main_color')),'color');
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');

//review
$review = false;
if (isset($post_meta['fw_rating_position']) && implode($post_meta['fw_rating_position']) == '1') {
    $review = true;
} else {
    $review = false;
}

// META
$meta_date = jwOpt::getPresetValue('meta_date', '1', 'single', $single_preset);
$meta_comments_count = jwOpt::getPresetValue('meta_comments_count', '1', 'single', $single_preset);
$meta_author = jwOpt::getPresetValue('meta_author', '1', 'single', $single_preset);
$meta_category = jwOpt::getPresetValue('meta_category', '1', 'single', $single_preset);
$meta_likes = jwOpt::getPresetValue('meta_likes', '1', 'single', $single_preset);
$meta_ratings = jwOpt::getPresetValue('meta_ratings', '1', 'single', $single_preset);
$meta_featured = jwOpt::getPresetValue('meta_featured', '1', 'single', $single_preset);
$meta_print = jwOpt::getPresetValue('meta_print', '1', 'single', $single_preset);
$meta_font_resize = jwOpt::getPresetValue('meta_font_resize', '1', 'single', $single_preset);
    
                
//Side Box

$col_content = 12;

$show_after_perex_box = false;
$side_box_position = jwOpt::getPresetValue('perex_box', 'left', 'single', $single_preset);
$side_box_visibility = jwOpt::getPresetValue('perex_box_visibility', 'tablet', 'single', $single_preset);
if ($side_box_visibility != '0') {
    jaw_template_set_var('bar_type', jwOpt::getPresetValue('post_layout_style', 'bar_type_1', 'single', $single_preset));
    jaw_template_set_var('single_preset', $single_preset);

    $gallery_show = jwOpt::getPresetValue('perex_gallery', '4', 'single', $single_preset);
    $perex_gallery_content = jwMedia::getGallery("vertical",$gallery_show);
    $perex_featured = jwOpt::getPresetValue('perex_featured', '1', 'single', $single_preset);
    $perex_shares = jwOpt::getPresetValue('perex_shares', '0', 'single', $single_preset);
    $perex_related_posts = jwOpt::getPresetValue('perex_related_posts', '1', 'single', $single_preset);
    $perex_tags = jwOpt::getPresetValue('perex_tags', '0', 'single', $single_preset);
    $perex_rating = jwOpt::getPresetValue('perex_rating', '1', 'single', $single_preset);
    $perex_banner = jwOpt::getPresetValue('perex_banner', '1', 'single', $single_preset);
    if($perex_gallery_content || $perex_featured || $perex_shares || $perex_related_posts || ($perex_rating && $review) || $perex_banner || $perex_tags) {
        $show_after_perex_box = true;
        $col_content = 9;
        
        $after_perex_box_class = array();
        $after_perex_box_class[] = jwLayout::col_class(3);
        $after_perex_box_class[] = 'show-on-'.$side_box_visibility;
        $after_perex_box_class[] = 'fixed_'.jwOpt::getPresetValue('perex_box_fixed', '0', 'single', $single_preset);
                        
    }
}

$main_content_class = array();
$main_content_class[] = 'jaw-after-perex';
$main_content_class[] = 'jaw-sidebox-position-'.$side_box_position;
$main_content_class[] = jwLayout::col_class($col_content);
    
    
?>
<article  <?php post_class($single_class); ?>  id="post-<?php the_ID(); ?>">
    <div class="entry-content <?php echo esc_attr($image_caption_toggle); ?>" >
        <h3 class="entry-title perex">
            <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
            <?php the_title(); ?>
            </a>
        </h3>
        <div class=" image video">
            <?php
            $video = get_post_meta(get_the_ID(), 'jaw_post_video_link', true);
            if (isset($video)) {
                echo jwMedia::getVideoPlayer($video, 720);
            }
            ?>
        </div>
        <?php
        if ($with_perex) {
            global $more;
            $more = 0;
            ?>
            <div class="perex">   
                <div class="row">
                    <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?> jaw-perex-content">
                        <?php the_content('', true); ?>
                    </div>
                </div>

            <?php } else { ?>
                <div  class="perex ">   
                <?php } ?>
                <?php
                // META
                echo jaw_get_template_part('meta', 'meta') 
                // END META
                ?>
            </div>
            <div  class="more-text">
                <?php
                if ($with_perex) {
                    $more = 1;
                }
                // ========================== CONTENT =================================
            ?>
                <div class="row">
                    <div class="<?php echo esc_attr(implode(' ', $main_content_class)); ?> jaw-after-perex">
                        <div class="row">
                            <?php jwRender::get_banner('posttop'); ?>
                            <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
                                <?php the_content('', true); ?>
                            </div>
                            <?php jwRender::get_banner('postbottom'); ?>
                             <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
                             <?php 
                                 //multipages
                               wp_link_pages(array('before' => '<div id="page-nav">', 'after' => '</div>', 'link_before' => '<span class="post_page">', 'link_after' => '</span>'));
                             ?>
                            </div>
                        </div>
                    </div>
                    <?php
                    
                        
                    // ========================================== BOX AFTER PEREX ===================================================
                    jaw_template_set_var('single_preset', $single_preset);
                    jaw_template_set_var('bar_type', jwOpt::getPresetValue('post_layout_style', 'bar_type_1', 'single', $single_preset));
                    
                    if ($show_after_perex_box) { // perex on
                        $count = 0;
                        ?>
                        <div class="<?php echo esc_attr(implode( ' ',$after_perex_box_class)); ?> jaw-box perex-box jw-rating-slim">
                            <?php do_action('jaw_before_perex_box'); ?>
                            <!-- Featured post area -->
                            <?php
                            /*                                 * ****************** GALLERY PEREX BOX ******************* */
                            if($perex_gallery_content) {
                                echo $perex_gallery_content;
                                echo '<div class="meta_divider"></div>';
                            }
                            /*                                 * ****************** Featured post ******************* */
                            if ($perex_featured) {
                                echo jaw_get_template_part('featured_post', 'blog');
                                $count++;
                            }
                            /*                                 * ****************** Share post ******************* */
                            if ($perex_shares) {
                                echo jaw_get_template_part('shareit', 'blog');
                                $count++;
                            }
                            /*                                 * ****************** Related posts ******************* */
                            if ($perex_related_posts) {
                                echo jaw_get_template_part('related-post_box', 'blog');
                                $count++;
                            }
                            /*                                 * ****************** Rate post ******************* */
                            if ($perex_rating && $review) {
                                echo jaw_get_template_part('rating', 'blog');
                                $count++;
                            }
                            /*                                 * ****************** TAGS  ******************* */
                               
                                if (has_tag() && $perex_tags) { 
                                    echo jaw_get_template_part('tags', 'blog');
                                    $count++;
                                }
                            /*                                 * ****************** banner ******************* */
                            if ($perex_banner) {
                                ?>
                                <div class="row"> 
                                    <?php
                                    jwRender::get_banner('postside');
                                    ?>
                                </div>
                                <?php
                                $count++;
                            }
                            ?>
                            <?php if($count > 0){ ?>
                                <div class="meta_divider"></div>
                            <?php } ?>
                            <?php do_action('jaw_after_side_box'); ?>
                        </div>
                    <?php } // CONTENT Side Box
                    jaw_template_set_var("columns", $columns);
                    ?>
                </div>

            </div>
            <div class="clear"></div>
            <!-- Pagination -->
            </article>
            <?php

        ?>
<?php } ?>
<?php function jw_tmpl_content__content_full(){ ?>
<?php
global $content_width, $wp_query, $post;


$terms = get_the_category();
$post_meta = get_post_meta(get_the_id(), '');

if (isset($terms[0]->term_id)) {
    $term_id = $terms[0]->term_id;
} else {
    $term_id = 0;
}
$single_preset = jwOpt::checkDefaultPreset(array(jwOpt::get_option('single_preset', jwOpt::get_option('single_preset'), 'category', $term_id), jwOpt::get_option('single_preset')),'single');
jaw_template_set_var('single_preset',$single_preset);
jaw_template_set_var('bar_type', 'bar_type_1');

if (jwLayout::content_layout() == 'fullwidth_sidebar') {
    $layout = 'fullwidth';
} else {
    $layout = 'sidebar';
}
// with perex
$with_perex = false;
if (strpos(get_the_content(), 'more')) {
    $with_perex = true;
}
// image caption
$image_caption_toggle = 'image_caption_toggle-' . jwOpt::get_option('image_caption_toggle');
$columns = jaw_template_get_var("columns", 4);
//clases
$single_class = array();
$single_class[] = jwLayout::col_class($columns);
$single_class[] = 'content-full';
$single_class[] = 'jaw-post-box';
$single_class[] = 'bar_type_1';
$single_class[] = 'jaw-single';
$single_class[] = $layout;
$single_class[] = 'post-preset-' . jwOpt::checkDefaultPreset(array(jwOpt::get_option('content_color', '_default', 'category', $term_id), jwOpt::get_option('main_color')),'color');
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');

//review
$review = false;
if (isset($post_meta['fw_rating_position']) && implode($post_meta['fw_rating_position']) == '1') {
    $review = true;
} else {
    $review = false;
}

// META
$meta_date = jwOpt::getPresetValue('meta_date', '1', 'single', $single_preset);
$meta_comments_count = jwOpt::getPresetValue('meta_comments_count', '1', 'single', $single_preset);
$meta_author = jwOpt::getPresetValue('meta_author', '1', 'single', $single_preset);
$meta_category = jwOpt::getPresetValue('meta_category', '1', 'single', $single_preset);
$meta_likes = jwOpt::getPresetValue('meta_likes', '1', 'single', $single_preset);
$meta_ratings = jwOpt::getPresetValue('meta_ratings', '1', 'single', $single_preset);
$meta_featured = jwOpt::getPresetValue('meta_featured', '1', 'single', $single_preset);
$meta_print = jwOpt::getPresetValue('meta_print', '1', 'single', $single_preset);
$meta_font_resize = jwOpt::getPresetValue('meta_font_resize', '1', 'single', $single_preset);
    
                
//Side Box

$col_content = 12;

$show_after_perex_box = false;
$side_box_position = jwOpt::getPresetValue('perex_box', 'left', 'single', $single_preset);
$side_box_visibility = jwOpt::getPresetValue('perex_box_visibility', 'tablet', 'single', $single_preset);
if ($side_box_visibility != '0') {
    jaw_template_set_var('bar_type', jwOpt::getPresetValue('post_layout_style', 'bar_type_1', 'single', $single_preset));
    jaw_template_set_var('single_preset', $single_preset);

    $gallery_show = jwOpt::getPresetValue('perex_gallery', '4', 'single', $single_preset);
    $perex_gallery_content = jwMedia::getGallery("vertical",$gallery_show);
    $perex_featured = jwOpt::getPresetValue('perex_featured', '1', 'single', $single_preset);
    $perex_shares = jwOpt::getPresetValue('perex_shares', '0', 'single', $single_preset);
    $perex_related_posts = jwOpt::getPresetValue('perex_related_posts', '1', 'single', $single_preset);
    $perex_tags = jwOpt::getPresetValue('perex_tags', '0', 'single', $single_preset);
    $perex_rating = jwOpt::getPresetValue('perex_rating', '1', 'single', $single_preset);
    $perex_banner = jwOpt::getPresetValue('perex_banner', '1', 'single', $single_preset);
    if($perex_gallery_content || $perex_featured || $perex_shares || $perex_related_posts || ($perex_rating && $review) || $perex_banner || $perex_tags) {
        $show_after_perex_box = true;
        $col_content = 9;
        
        $after_perex_box_class = array();
        $after_perex_box_class[] = jwLayout::col_class(3);
        $after_perex_box_class[] = 'show-on-'.$side_box_visibility;
        $after_perex_box_class[] = 'fixed_'.jwOpt::getPresetValue('perex_box_fixed', '0', 'single', $single_preset);
                        
    }
}

$main_content_class = array();
$main_content_class[] = 'jaw-after-perex';
$main_content_class[] = 'jaw-sidebox-position-'.$side_box_position;
$main_content_class[] = jwLayout::col_class($col_content);
$attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));  
    
?>
<article  <?php post_class($single_class); ?> id="post-<?php the_ID(); ?>">
    <div class="entry-content <?php echo esc_attr($image_caption_toggle); ?>" >
        <h3 class="entry-title perex">
            <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
            <?php the_title(); ?>
            </a>
        </h3>
        <div class="image" >
            <?php
            $link = false;
            $pp = false;
            switch (jaw_template_get_var('clickable_image', '0')) {
                case '1': $link = get_permalink();
                    break;
                case '2': $link = jwMedia::getPostThumbnailSrc(get_the_ID());
                    $pp = true;
                    break;
            }
            echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-16_9-big', 'jaw_blog-16_9-small', 'jaw_blog-16_9-middle', 'jaw_blog-16_9', 'large'), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
            if(has_post_thumbnail()){
                if(isset($attachement["width"]) && isset($attachement["height"])){
                    $width = $attachement["width"];
                    $height = $attachement["height"];
                }
            }?>
            <div class="post-comments-labes">
                <?php
                if (jaw_template_get_var('blog_comments_inimage', '1') == '1') {
                    echo jwRender::get_meta_comments();
                }
                ?>
            </div>
            <div class="post-categories-labels">
                <?php
                if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                    echo jwRender::get_meta_category();
                }
                ?>
            </div>
        </div>
        <?php
        if ($with_perex) {
            global $more;
            $more = 0;
            ?>
            <div class="perex">   
                <div class="row">
                    <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?> jaw-perex-content">
                        <?php the_content('', true); ?>
                    </div>
                </div>

            <?php } else { ?>
                <div  class="perex ">   
                <?php } ?>
                <?php
                // META
                echo jaw_get_template_part('meta', 'meta') 
                // END META
                ?>
            </div>
            <div  class="more-text">
                <?php
                if ($with_perex) {
                    $more = 1;
                }
                 // ========================== CONTENT =================================
            ?>
                <div class="row">
                    <div class="<?php echo esc_attr(implode(' ', $main_content_class)); ?> jaw-after-perex">
                        <div class="row">
                            <?php jwRender::get_banner('posttop'); ?>
                            <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
                                <?php the_content('', true); ?>
                            </div>
                            <?php jwRender::get_banner('postbottom'); ?>
                             <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
                             <?php 
                                 //multipages
                               wp_link_pages(array('before' => '<div id="page-nav">', 'after' => '</div>', 'link_before' => '<span class="post_page">', 'link_after' => '</span>'));
                             ?>
                            </div>
                        </div>
                    </div>
                    <?php
                    
                        
                    // ========================================== BOX AFTER PEREX ===================================================
                    jaw_template_set_var('single_preset', $single_preset);
                    jaw_template_set_var('bar_type', jwOpt::getPresetValue('post_layout_style', 'bar_type_1', 'single', $single_preset));
                    
                    if ($show_after_perex_box) { // perex on
                        $count = 0;
                        ?>
                        <div class="<?php echo esc_attr(implode( ' ',$after_perex_box_class)); ?> jaw-box perex-box jw-rating-slim">
                            <?php do_action('jaw_before_perex_box'); ?>
                            <!-- Featured post area -->
                            <?php
                            /*                                 * ****************** GALLERY PEREX BOX ******************* */
                            if($perex_gallery_content) {
                                echo $perex_gallery_content;
                                echo '<div class="meta_divider"></div>';
                            }
                            /*                                 * ****************** Featured post ******************* */
                            if ($perex_featured) {
                                echo jaw_get_template_part('featured_post', 'blog');
                                $count++;
                            }
                            /*                                 * ****************** Share post ******************* */
                            if ($perex_shares) {
                                echo jaw_get_template_part('shareit', 'blog');
                                $count++;
                            }
                            /*                                 * ****************** Related posts ******************* */
                            if ($perex_related_posts) {
                                echo jaw_get_template_part('related-post_box', 'blog');
                                $count++;
                            }
                            /*                                 * ****************** Rate post ******************* */
                            if ($perex_rating && $review) {
                                echo jaw_get_template_part('rating', 'blog');
                                $count++;
                            }
                            /*                                 * ****************** TAGS  ******************* */
                               
                                if (has_tag() && $perex_tags) { 
                                    echo jaw_get_template_part('tags', 'blog');
                                    $count++;
                                }
                            /*                                 * ****************** banner ******************* */
                            if ($perex_banner) {
                                ?>
                                <div class="row"> 
                                    <?php
                                    jwRender::get_banner('postside');
                                    ?>
                                </div>
                                <?php
                                $count++;
                            }
                            ?>
                            <?php if($count > 0){ ?>
                                <div class="meta_divider"></div>
                            <?php } ?>
                            <?php do_action('jaw_after_side_box'); ?>
                        </div>
                    <?php } // CONTENT Side Box
                    jaw_template_set_var("columns", $columns);
                    ?>
                </div>

            </div>
            <div class="clear"></div>
            </article>
            <?php

        ?>
<?php } ?>
<?php function jw_tmpl_content__content_simple_gallery(){ ?>
<?php
global $post, $wp_query, $jaw_data, $content_width;
$col_count = jaw_template_get_var("columns", 12);
$number_image = 'number-image-'.jaw_template_get_var('number_insead_of_image', '0');
if(jaw_template_get_var("simple_numbers_widget_check_glob_var") > 1 ){
	jaw_template_set_var('number_insead_of_image'.jaw_template_get_var("simple_numbers_widget_check_glob_var"), '1');
}
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-simple';
$single_class[] = 'jaw-post-box';
$single_class[] = $number_image;
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">       
        <?php
        if(jaw_template_get_var('number_insead_of_image', '0')){?>
            <div class="image number-image">
                <?php echo jaw_template_inc_counter('number_insead_of_image'.jaw_template_get_var("simple_numbers_widget_check_glob_var"))+1; ?>
            </div>
        <?php
        } else { 
            ?>
            <?php
            $link = false;
            $pp = false;
            switch (jaw_template_get_var('clickable_image', '0')) {
                case '1': $link = get_permalink();
                    break;
                case '2': $link = jwMedia::getPostThumbnailSrc(get_the_ID());
                    $pp = true;
                    break;
            }
            $gallery = get_post_meta(get_the_ID(), 'jaw_post_gallery', true);
            $ids = jwMedia::parseJson($gallery);
            if(!empty($ids)){
                ?>
                <div class="image gallery">
                <?php
                foreach ((array)$ids as $key => $id) {
                    echo jwMedia::getAttachment($id, array('jaw_blog-mini'), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
                    if($key == 3){
                        break;
                    }
                }
            }else{
                ?>
                <div class="image">
                <?php
                echo jwMedia::getPostThumbnail(get_the_ID(), array('large','full'));
            }
            ?>
        </div>
        <?php } ?>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_simple', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
        <div class="clear"></div>
    </div>
</article>
<?php } ?>
<?php function jw_tmpl_content__content_simple_link(){ ?>
<?php
global $post, $wp_query, $jaw_data, $content_width;

$col_count = jaw_template_get_var("columns", 12);
$number_image = 'number-image-'.jaw_template_get_var('number_insead_of_image', '0');
if(jaw_template_get_var("simple_numbers_widget_check_glob_var") > 1 ){
	jaw_template_set_var('number_insead_of_image'.jaw_template_get_var("simple_numbers_widget_check_glob_var"), '1');
}
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-simple';
$single_class[] = 'jaw-post-box';
$single_class[] = $number_image;
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">  
         <?php
        if(jaw_template_get_var('number_insead_of_image', '0')){?>
            <div class="image number-image">
                <?php echo jaw_template_inc_counter('number_insead_of_image'.jaw_template_get_var("simple_numbers_widget_check_glob_var"))+1; ?>
            </div>
        <?php
        } else { 
            ?>      
        <div class="image link">
            <i class="jaw-icon-new-tab"></i>
        </div>
        <?php
        }
        ?>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_simple', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
        <div class="clear"></div>
    </div>
</article>
<?php } ?>
<?php function jw_tmpl_content__content_simple_quote(){ ?>
<?php
global $post, $wp_query, $jaw_data, $content_width;

$col_count = jaw_template_get_var("columns", 12);
$number_image = 'number-image-'.jaw_template_get_var('number_insead_of_image', '0');
if(jaw_template_get_var("simple_numbers_widget_check_glob_var") > 1 ){
	jaw_template_set_var('number_insead_of_image'.jaw_template_get_var("simple_numbers_widget_check_glob_var"), '1');
}
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-simple';
$single_class[] = 'jaw-post-box';
$single_class[] = $number_image;
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">  
         <?php
        if(jaw_template_get_var('number_insead_of_image', '0')){?>
            <div class="image number-image">
                <?php echo jaw_template_inc_counter('number_insead_of_image'.jaw_template_get_var("simple_numbers_widget_check_glob_var"))+1; ?>
            </div>
        <?php
        } else { 
            ?>
        <div class="image quote">
             <i class="jaw-icon-quotes-right"></i>
        </div>
        <?php
        }
        ?>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_simple', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
        <div class="clear"></div>
    </div>
</article>
<?php } ?>
<?php function jw_tmpl_content__content_simple_video(){ ?>
<?php
global $post, $wp_query, $jaw_data, $content_width;

$col_count = jaw_template_get_var("columns", 12);
$number_image = 'number-image-'.jaw_template_get_var('number_insead_of_image', '0');
if(jaw_template_get_var("simple_numbers_widget_check_glob_var") > 1 ){
	jaw_template_set_var('number_insead_of_image'.jaw_template_get_var("simple_numbers_widget_check_glob_var"), '1');
}
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-simple';
$single_class[] = 'jaw-post-box';
$single_class[] = $number_image;
$attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">     
         <?php
        if(jaw_template_get_var('number_insead_of_image', '0')){?>
            <div class="image number-image">
                <?php echo jaw_template_inc_counter('number_insead_of_image'.jaw_template_get_var("simple_numbers_widget_check_glob_var"))+1; ?>
            </div>
        <?php
        } else { 
            ?>   
        <div class=" image video">
            <?php
            $video = get_post_meta(get_the_ID(), 'jaw_post_video_link', true);
            $link = false;
            $pp = false;
            $rel = '';
            switch (jaw_template_get_var('clickable_image', '0')) {
                case '1': $link = get_permalink();
                    $rel = ''; 
                    break;
                case '2': $link = $video;
                    $pp = true;
                    $rel = 'prettyPhoto[]';
                    break;
            }
            if (has_post_thumbnail()) {
                echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-mini'), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
                if(isset($attachement["width"]) && isset($attachement["height"])){
                    $width = $attachement["width"];
                    $height = $attachement["height"];
                }
            } else {
                $video = get_post_meta(get_the_ID(), 'jaw_post_video_link', true);
                echo jwMedia::getVideoThumbnail($video, $link, array($pp, 'full', jaw_template_get_counter('pagination')));
            }
            if($link){
                echo '<a href="'.$link.'" rel="'.$rel.'" >';
            }
            echo '<span class="jaw-video-icon small">'.apply_filters('jaw_default_video_icon', '<i class="jaw-icon-play4"></i>').'</span>';
             if($link){
                echo '</a>';
            }
            ?>
        </div>
        <?php
        }
        ?>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_simple', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
        <div class="clear"></div>
    </div>
</article>
<?php } ?>
<?php function jw_tmpl_content__content_simple(){ ?>
<?php
global $post, $wp_query, $jaw_data, $content_width;
$col_count = jaw_template_get_var("columns", 6);
$number_image = 'number-image-'.jaw_template_get_var('number_insead_of_image', '0');
if(jaw_template_get_var("simple_numbers_widget_check_glob_var") > 1 ){
	jaw_template_set_var('number_insead_of_image'.jaw_template_get_var("simple_numbers_widget_check_glob_var"), '1');
}
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-simple';
$single_class[] = 'jaw-post-box';
$single_class[] = $number_image;
$attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">        
        <?php
        if(jaw_template_get_var('number_insead_of_image', '0')){?> 
            <div class="image number-image">
                <?php echo jaw_template_inc_counter('number_insead_of_image'.jaw_template_get_var("simple_numbers_widget_check_glob_var"))+1;?>
            </div>
        <?php
        } else {
            ?>
            <div class="image">
                <?php
                $link = false;
                $pp = false;
                switch (jaw_template_get_var('clickable_image', '0')) {
                    case '1': $link = get_permalink();
                        break;
                    case '2': $link = jwMedia::getPostThumbnailSrc(get_the_ID());
                        $pp = true;
                        break;
                }
                echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-mini'), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
                if(has_post_thumbnail()){
                    
                    if(isset($attachement["width"]) && isset($attachement["height"])){
                        $width = $attachement["width"];
                        $height = $attachement["height"];
                    }
            }?>
            </div>
            <?php
        }
        ?>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_simple', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
        <div class="clear"></div>
    </div>
</article>

<?php } ?>
<?php function jw_tmpl_content__content_special_big_review(){ ?>
<?php
global $post, $wp_query, $jaw_data, $content_width;
$post_meta = get_post_meta(get_the_ID(), 'fw_rating_position', true);
$totalrat = array('final' => "");
if(class_exists('ratingManager')){
    $ratingManager = ratingManager::getInstance();
    $ratings = $ratingManager->getRatings(get_the_ID());
    $totalrat = $ratingManager->getRatingsScore($ratings);
}
$ratingtype = jwOpt::get_option('rating_maximal_value');
$ratingmaxvalue = jwOpt::get_option('rating_maximal_value_show');
$col_count = jaw_template_get_var("columns", 12);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-special-big';
$single_class[] = 'jaw-post-box';
$single_class[] = 'format-review';
$attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box">
        <div class="content-box">
            <div class="image">
                <?php
                $link = false;
                $pp = false;
                switch (jaw_template_get_var('clickable_image', '0')) {
                case '1': $link = get_permalink();
                echo "<a href=".$link.">";
                    break;
                case '2': $link = jwMedia::getPostThumbnailSrc(get_the_ID());
                    echo "<a href=".$link." rel='prettyPhoto[".jaw_template_get_counter('pagination')."]'>";
                    $pp = true; 
                break;
                }
                echo "<span class='jaw-fadein'></span>";
                echo jwMedia::getPostThumbnail(get_the_ID(), array('large','full'));
                if ($post_meta == '1') { ?>
                    <div class="post-review-total">
                        <?php
                        switch ($ratingtype) {
                            case "100" :
                                echo esc_attr(round($totalrat['final'], 0)) . '<span>%</span>';
                                break;
                            default:
                                if ($ratingmaxvalue) {
                                    echo esc_attr(round($totalrat['final'], 1)) . '<span>/' . esc_attr($ratingtype) . '</span>';
                                } else {
                                    echo esc_attr(round($totalrat['final'], 1));
                                }
                                break;
                        }
                        ?>
                    </div>
                <?php }
                if(has_post_thumbnail()){
                    if(isset($attachement["width"]) && isset($attachement["height"])){
                        $width = $attachement["width"];
                        $height = $attachement["height"];
                    }
                }?>
                <?php 
                if(jaw_template_get_var('clickable_image', '0')) {
                    echo "</a>";
                }
                ?>
            </div>
            <div class="jw-container">
                <div class="categories-special-big">
                    <div class="post-categories-labels">
                        <div class="post-categories-links">
                        <?php
                        if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                            echo jwRender::get_meta_category();
                        }
                        ?>
                        </div>
                    </div>
                </div>
                <div class="content-border-wrapper">
                    
                    
                    <div class="title-special">
                        <h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?> class="jw-title">
                            <a href="<?php the_permalink(); ?>" class="post_name"><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></a>
                        </h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?>>
                    </div>
                    <?php do_action( 'jaw_postbox_special_big_after_title', 'review' ); ?>
                    <div class="content-box">
                        <p> 
                            <?php
                            echo jwUtils::crop_length(get_the_excerpt(), jaw_template_get_var('letter_excerpt', 275));
                            ?>
                        </p>
                    </div>
                    <div class="meta-special">
                        <?php
                        echo jaw_get_template_part('meta', 'meta');
                        ?>
                    </div>
                </div>
            </div>
            <?php do_action('jaw_after_postbox_content'); ?>
        </div>
    </div>
</article>
<?php } ?>
<?php function jw_tmpl_content__content_special_big_video(){ ?>
<?php
global $post, $wp_query, $jaw_data, $content_width;
$col_count = jaw_template_get_var("columns", 12);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-special-big';
$single_class[] = 'jaw-post-box';
$attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box">
        <div class="content-box">
            
            <div class="image video">
                <?php
                $video = get_post_meta(get_the_ID(), 'jaw_post_video_link', true);
                $link = false;
                $pp = false;
                $rel = '';
                switch (jaw_template_get_var('clickable_image', '0')) {
                    case '1': $link = get_permalink();
                        $rel = ''; 
                        break;
                    case '2': $link = $video;
                        $pp = true;
                        $rel = 'prettyPhoto[]';
                        break;
                }
                if (has_post_thumbnail()) {
                    echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-16_9-small', 'jaw_blog-16_9-middle', 'jaw_blog-16_9', 'large','full'), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
                    if(isset($attachement["width"]) && isset($attachement["height"])){
                        $width = $attachement["width"];
                        $height = $attachement["height"];
                    }
                } else {
                    echo jwMedia::getVideoThumbnail($video, $link, array($pp, 'full', jaw_template_get_counter('pagination')));
                }
                if($link){
                    echo '<a href="'.$link.'" rel="'.$rel.'" >';
                }
                echo '<span class="jaw-video-icon">'.apply_filters('jaw_default_video_icon', '<i class="jaw-icon-play4"></i>').'</span>';
                if($link){
                    echo '</a>';
                }
                ?>
            </div>
            <div class="jw-container">
                <div class="categories-special-big">
                    <div class="post-categories-labels">
                        <div class="post-categories-links">
                        <?php
                        if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                            echo jwRender::get_meta_category();
                        }
                        ?>
                        </div>
                    </div>
                </div>
                <div class="content-border-wrapper">
                    <div class="title-special">
                        <h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?> class="jw-title">
                            <a href="<?php the_permalink(); ?>" class="post_name"><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></a>
                        </h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?>>
                    </div>
                    <?php do_action( 'jaw_postbox_special_big_after_title', get_post_format() ); ?>
                    <div class="content-box">
                        <p> 
                            <?php
                            echo jwUtils::crop_length(get_the_excerpt(), jaw_template_get_var('letter_excerpt', 275));
                            ?>
                        </p>
                    </div>
                    <div class="meta-special">
                        <?php
                        echo jaw_get_template_part('meta', 'meta');
                        ?>
                    </div>
                </div>
            </div>
            <?php do_action('jaw_after_postbox_content'); ?>
        </div>
    </div>
</article>
<?php } ?>
<?php function jw_tmpl_content__content_special_big(){ ?>
<?php
global $post, $wp_query, $jaw_data, $content_width;
$col_count = jaw_template_get_var("columns", 12);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-special-big';
$single_class[] = 'jaw-post-box';
$attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box">
        <div class="content-box">
            
            <div class="image">
                <?php
                $link = false;
                $pp = false;
                switch (jaw_template_get_var('clickable_image', '0')) {
                    case '1': $link = get_permalink();
                        break;
                    case '2': $link = jwMedia::getPostThumbnailSrc(get_the_ID());
                        $pp = true;
                        break;
                }
                if(get_post_format() == "video") {
                    echo '<span class="jaw-video-icon">'.apply_filters('jaw_default_video_icon', '<i class="jaw-icon-play4"></i>').'</span>';
                }
                echo jwMedia::getPostThumbnail(get_the_ID(), array('large','full'), $link, array($pp, 'jaw_blog-mini'));
                if(has_post_thumbnail()){
                    if(isset($attachement["width"]) && isset($attachement["height"])){
                        $width = $attachement["width"];
                        $height = $attachement["height"];
                    }
            }?>
            </div>
            <div class="jw-container">
                <div class="categories-special-big">
                    <div class="post-categories-labels">
                        <div class="post-categories-links">
                        <?php
                        if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                            echo jwRender::get_meta_category();
                        }
                        ?>
                        </div>
                    </div>
                </div>
                <div class="content-border-wrapper">
                    <div class="title-special">
                        <h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?> class="jw-title">
                            <a href="<?php the_permalink(); ?>" class="post_name"><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></a>
                        </h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?>>
                    </div>
                    <?php do_action( 'jaw_postbox_special_big_after_title', get_post_format() ); ?>
                    <div class="content-box">
                        <p> 
                            <?php
                            echo jwUtils::crop_length(get_the_excerpt(), jaw_template_get_var('letter_excerpt', 275));
                            ?>
                        </p>
                    </div>
                    <div class="meta-special">
                        <?php
                        echo jaw_get_template_part('meta', 'meta');
                        ?>
                    </div>
                </div>
            </div>
            <?php do_action('jaw_after_postbox_content'); ?>
        </div>
    </div>
    
    
    
          

    
    
         
        
                  

</article>
<?php } ?>
<?php function jw_tmpl_content__content_special_gallery_video(){ ?>
<?php
global $post, $wp_query, $jaw_data;
$col_count = jaw_template_get_var("columns", 12);
$post_meta = get_post_meta(get_the_id(), '');

//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-special-gallery';
$single_class[] = 'jaw-post-box';
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box">
        <div class="content-box">
            
            <div class="image">
                <?php
                $video = get_post_meta(get_the_ID(), 'jaw_post_video_link', true);
                $link = false;
                $pp = false;
                $rel = '';
                switch (jaw_template_get_var('clickable_image', '0')) {
                    case '1': $link = get_permalink();
                        $rel = ''; 
                        break;
                    case '2': $link = $video;
                        $pp = true;
                        $rel = 'prettyPhoto[]';
                        break;
                }
                if (has_post_thumbnail()) {
                    echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-special'), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
                    $attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
                    if(isset($attachement["width"]) && isset($attachement["height"])){
                        $width = $attachement["width"];
                        $height = $attachement["height"];
                    }
                } else {
                    echo jwMedia::getVideoThumbnail($video, $link, array($pp, 'full', jaw_template_get_counter('pagination')));
                }
                if($link){
                    echo '<a href="'.$link.'" rel="'.$rel.'" >';
                }
                echo '<span class="jaw-video-icon">'.apply_filters('jaw_default_video_icon', '<i class="jaw-icon-play4"></i>').'</span>';
                if($link){
                    echo '</a>';
                }
                ?>
            </div>
            <div class="jw-container">
                <?php
                if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                    ?><div class="categories-special">
                        <div class="post-categories-labels"><?php
                            echo jwRender::get_meta_category();
                        ?></div>
                    </div><?php
                }
                ?>
                <div class="title-special">
                    <h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?> class="jw-title">
                        <a href="<?php the_permalink(); ?>" class="post_name"><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></a>
                    </h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?>>
                </div>
                <?php do_action( 'jaw_postbox_special_gallery_after_title', get_post_format() ); ?>
                <div class="meta-special">
                    <?php
                    echo jaw_get_template_part('meta', 'meta');
                    ?>
                </div>
                <?php echo jwMedia::getGallery("special"); ?>
            </div>
            <?php do_action('jaw_after_postbox_content'); ?>
        </div>
    </div>
    
    
    
          

    
    
         
        
                  

</article>

<?php } ?>
<?php function jw_tmpl_content__content_special_gallery(){ ?>
<?php
global $post, $wp_query, $jaw_data;
$col_count = jaw_template_get_var("columns", 12);
$post_meta = get_post_meta(get_the_id(), '');

//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-special-gallery';
$single_class[] = 'jaw-post-box';
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box">
        <div class="content-box">
            
            <div class="image">
                <?php
                $link = false;
                $pp = false;
                switch (jaw_template_get_var('clickable_image', '0')) {
                    case '1': $link = get_permalink();
                        break;
                    case '2': $link = jwMedia::getPostThumbnailSrc(get_the_ID());
                        $pp = true;
                        break;
                }
                echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-special'), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
                ?>
            </div>
            <div class="jw-container">
                <?php
                if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                    ?><div class="categories-special">
                        <div class="post-categories-labels"><?php
                            echo jwRender::get_meta_category();
                        ?></div>
                    </div><?php
                }
                ?>
                <div class="title-special">
                    <h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?> class="jw-title">
                        <a href="<?php the_permalink(); ?>" class="post_name"><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></a>
                    </h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?>>
                </div>
                <?php do_action( 'jaw_postbox_special_gallery_after_title', get_post_format() ); ?>
                <div class="meta-special">
                    <?php
                    echo jaw_get_template_part('meta', 'meta');
                    ?>
                </div>
                <?php echo jwMedia::getGallery("special"); ?>
            </div>
            <?php do_action('jaw_after_postbox_content'); ?>
        </div>
    </div>    
</article>

<?php } ?>
<?php function jw_tmpl_content__content_special_video(){ ?>
<?php
global $post, $wp_query, $jaw_data;
$col_count = jaw_template_get_var("columns", 12);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-special';
$single_class[] = 'jaw-post-box';
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box">
        <div class="content-box">
            
            <div class="image">
                <?php
                $video = get_post_meta(get_the_ID(), 'jaw_post_video_link', true);
                $link = false;
                $pp = false;
                $rel = '';
                switch (jaw_template_get_var('clickable_image', '0')) {
                    case '1': $link = get_permalink();
                        $rel = ''; 
                        break;
                    case '2': $link = $video;
                        $pp = true;
                        $rel = 'prettyPhoto[]';
                        break;
                }
                if (has_post_thumbnail()) {
                    echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-special'), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
                   $attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
                    if(isset($attachement["width"]) && isset($attachement["height"])){
                        $width = $attachement["width"];
                        $height = $attachement["height"];
                        
                    }
                } else {
                    echo jwMedia::getVideoThumbnail($video, $link, array($pp, 'full', jaw_template_get_counter('pagination')));
                }
                if($link){
                    echo '<a href="'.$link.'" rel="'.$rel.'" >';
                }
                echo '<span class="jaw-video-icon">'.apply_filters('jaw_default_video_icon', '<i class="jaw-icon-play4"></i>').'</span>';
                if($link){
                    echo '</a>';
                }
                ?>
            </div>
            <div class="jw-container">
                <?php
                if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                    ?><div class="categories-special">
                        <div class="post-categories-labels"><?php
                            echo jwRender::get_meta_category();
                        ?></div>
                    </div><?php
                }
                ?>
                <div class="title-special">
                    <h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?> class="jw-title">
                        <a href="<?php the_permalink(); ?>" class="post_name"><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></a>
                    </h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?>>
                </div>
                <?php do_action( 'jaw_postbox_special_after_title', get_post_format() ); ?>
                <div class="meta-special">
                    <?php
                    echo jaw_get_template_part('meta', 'meta');
                    ?>
                </div>
            </div>
            <?php do_action('jaw_after_postbox_content'); ?>
        </div>
    </div>
    
    
    
          

    
    
         
        
                  

</article>

<?php } ?>
<?php function jw_tmpl_content__content_special(){ ?>
<?php
global $post, $wp_query, $jaw_data;
$col_count = jaw_template_get_var("columns", 12);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-special';
$single_class[] = 'jaw-post-box';
$attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box">
        <div class="content-box">
            <div class="image">
                <?php
                $link = false;
                $pp = false;
                switch (jaw_template_get_var('clickable_image', '0')) {
                    case '1': $link = get_permalink();
                        break;
                    case '2': $link = jwMedia::getPostThumbnailSrc(get_the_ID());
                        $pp = true;
                        break;
                }
                echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-special'), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
                if(has_post_thumbnail()){
                    if(isset($attachement["width"]) && isset($attachement["height"])){
                        $width = $attachement["width"];
                        $height = $attachement["height"];
                    }
                }
                ?>
            </div>
            <div class="jw-container">
                <?php
                if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                    ?><div class="categories-special">
                        <div class="post-categories-labels"><?php
                            echo jwRender::get_meta_category();
                        ?></div>
                    </div><?php
                }
                ?>
                <div class="title-special">
                    <h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?> class="jw-title" >
                        <a href="<?php the_permalink(); ?>" class="post_name"><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></a>
                    </h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?>>
                </div>
                <?php do_action( 'jaw_postbox_special_after_title', get_post_format() ); ?>
                <div class="meta-special">
                    <?php
                    echo jaw_get_template_part('meta', 'meta');
                    ?>
                </div>
            </div>
            <?php do_action('jaw_after_postbox_content'); ?>
        </div>
    </div>
</article>

<?php } ?>
<?php function jw_tmpl_content__content_vertical_big_gallery(){ ?>
<?php
global $post, $wp_query, $jaw_data, $content_width;
$col_count = jaw_template_get_var("columns", 12);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-vertical-big';
$single_class[] = 'jaw-post-box';
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box "> 
        <?php
            $link = false;
            $pp = false;
            switch (jaw_template_get_var('clickable_image', '0')) {
                case '1': $link = get_permalink();
                    break;
                case '2': $link = jwMedia::getPostThumbnailSrc(get_the_ID());
                    $pp = true;
                    break;
            }
            $gallery = get_post_meta(get_the_ID(), 'jaw_post_gallery', true);
            $ids = jwMedia::parseJson($gallery);
            if(!empty($ids)){
                ?>
                <div class="image gallery">
                <?php
                foreach ((array)$ids as $key => $id) {
                    echo jwMedia::getAttachment($id, array('jaw_blog-16_9-small', 'jaw_blog-16_9-middle', 'jaw_blog-16_9','jaw_blog-16_9-big'), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
                    if($key == 3){
                        break;
                    }
                }
            }else{
                ?>
                <div class="image">
                <?php
                echo jwMedia::getPostThumbnail(get_the_ID(), array('large','full'));
            }
            ?>       
            <div class="post-comments-labes">
                <?php
                if (jaw_template_get_var('blog_comments_inimage', '1') == '1') {
                    echo jwRender::get_meta_comments();
                }
                ?>
            </div>
            <div class="post-categories-labels">
                <?php
                if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                    echo jwRender::get_meta_category();
                }
                ?>
            </div>
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_vertical_big', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
        <div class="clear"></div>
    </div>
</article>
<?php } ?>
<?php function jw_tmpl_content__content_vertical_big_link(){ ?>
<?php
global $post, $wp_query, $jaw_data, $content_widt;
$col_count = jaw_template_get_var("columns", 12);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-vertical-big';
$single_class[] = 'jaw-post-box';
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">        
        <div class="image link">
            <i class="jaw-icon-new-tab"></i>
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_vertical_big', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
        <div class="clear"></div>
    </div>
    
    
    
          

    
    
         
        
                  

</article>
<?php } ?>
<?php function jw_tmpl_content__content_vertical_big_quote(){ ?>
<?php
global $post, $wp_query, $jaw_data, $content_widt;
$col_count = jaw_template_get_var("columns", 12);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-vertical-big';
$single_class[] = 'jaw-post-box';
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">        
        <div class="image quote">
             <i class="jaw-icon-quotes-right"></i>
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_vertical_big', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
        <div class="clear"></div>
    </div>
</article>
<?php } ?>
<?php function jw_tmpl_content__content_vertical_big_review(){ ?>
<?php
global $post, $wp_query, $jaw_data;
$post_meta = get_post_meta(get_the_ID(), 'fw_rating_position', true);
$totalrat = array('final' => "");
if(class_exists('ratingManager')){
    $ratingManager = ratingManager::getInstance();
    $ratings = $ratingManager->getRatings(get_the_ID());
    $totalrat = $ratingManager->getRatingsScore($ratings);
}
$ratingtype=jwOpt::get_option('rating_maximal_value');
$ratingmaxvalue=jwOpt::get_option('rating_maximal_value_show');
$col_count = jaw_template_get_var("columns", 12);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-vertical-big';
$single_class[] = 'jaw-post-box';
$single_class[] = 'format-review';
$attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">        
        <div class="image">
            <?php
            $link = false;
            $pp = false;
            switch (jaw_template_get_var('clickable_image', '0')) {
                case '1': $link = get_permalink();
                echo "<a href=".$link.">";
                    break;
                case '2': $link = jwMedia::getPostThumbnailSrc(get_the_ID());
                echo "<a href=".$link." rel='prettyPhoto[".jaw_template_get_counter('pagination')."]'>";
                $pp = true;
                break;
            }
            echo "<span class='jaw-fadein'></span>";
            echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-16_9-small', 'jaw_blog-16_9-middle', 'jaw_blog-16_9'));
            echo '<span class="post-categories-labels">';
                if ($post_meta == '1') { ?>
                    <span class="post-review-total">
                        <?php
                        switch($ratingtype) {
                            case "100" :
                                    echo esc_attr(round($totalrat['final'], 0)).'<span>%</span>';
                            break;
                            default:
                                if($ratingmaxvalue) {
                                    echo esc_attr(round($totalrat['final'], 1)).'<span>/'.esc_attr($ratingtype).'</span>';
                                } else {
                                    echo esc_attr(round($totalrat['final'], 1));
                                }
                            break;
                        }
                         ?>
                    </span>
                <?php }
            echo '</span>';
            if(has_post_thumbnail()){
                if(isset($attachement["width"]) && isset($attachement["height"])){
                    $width = $attachement["width"];
                    $height = $attachement["height"];
                }
            }?>
            <?php 
            if(jaw_template_get_var('clickable_image', '0')) {
                echo "</a>";
            }
            ?>
            <div class="post-comments-labes">
                <?php
                if (jaw_template_get_var('blog_comments_inimage', '1') == '1') {
                    echo jwRender::get_meta_comments();
                }
                ?>
            </div>
            <div class="post-categories-labels">
                <?php
                if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                    echo jwRender::get_meta_category();
                }
                ?>
            </div>
            
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_vertical_big', 'review' ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
        <div class="clear"></div>
    </div>
</article>
<?php } ?>
<?php function jw_tmpl_content__content_vertical_big_video(){ ?>
<?php
global $post, $wp_query, $jaw_data, $content_width;
$col_count = jaw_template_get_var("columns", 12);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-vertical-big';
$single_class[] = 'jaw-post-box';
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">        
        <div class=" image video">
            <?php
            $video = get_post_meta(get_the_ID(), 'jaw_post_video_link', true);
            if (isset($video)) {
                echo jwMedia::getVideoPlayer($video, 720);
            }
            ?>
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_vertical_big', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
        <div class="clear"></div>
    </div>
</article>
<?php } ?>
<?php function jw_tmpl_content__content_vertical_big(){ ?>
<?php
global $post, $wp_query, $jaw_data, $content_widt;
$col_count = jaw_template_get_var("columns", 12);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-vertical-big';
$single_class[] = 'jaw-post-box';
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">        
        <div class="image">
            <?php
            $link = false;
            $pp = false;
            switch (jaw_template_get_var('clickable_image', '0')) {
                case '1': $link = get_permalink();
                    break;
                case '2': $link = jwMedia::getPostThumbnailSrc(get_the_ID());
                    $pp = true;
                    break;
            }
            echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-16_9-small', 'jaw_blog-16_9-middle', 'jaw_blog-16_9','jaw_blog-16_9-big'), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
            if(has_post_thumbnail()){
                $attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
                if(isset($attachement["width"]) && isset($attachement["height"])){
                    $width = $attachement["width"];
                    $height = $attachement["height"];
                }
            }?>
            <div class="post-comments-labes">
                <?php
                if (jaw_template_get_var('blog_comments_inimage', '1') == '1') {
                    echo jwRender::get_meta_comments();
                }
                ?>
            </div>
            <div class="post-categories-labels">
                <?php
                if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                    echo jwRender::get_meta_category();
                }
                ?>
            </div>
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_vertical_big', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
        <div class="clear"></div>
    </div>
</article>
<?php } ?>
<?php function jw_tmpl_content__content_vertical_gallery(){ ?>
<?php
global $post, $wp_query, $jaw_data;
$col_count = jaw_template_get_var("columns", 4);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-vertical';
$single_class[] = 'jaw-post-box';
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">
            <?php
            $link = false;
            $pp = false;
            switch (jaw_template_get_var('clickable_image', '0')) {
                case '1': $link = get_permalink();
                    break;
                case '2': $link = jwMedia::getPostThumbnailSrc(get_the_ID());
                    $pp = true;
                    break;
            }
            $gallery = get_post_meta(get_the_ID(), 'jaw_post_gallery', true);
            $ids = jwMedia::parseJson($gallery);
            if(!empty($ids)){
                ?>
                <div class="image gallery">
                <?php
                foreach ((array)$ids as $key => $id) {
                    echo jwMedia::getAttachment($id, array('jaw_blog-16_9-small', 'jaw_blog-16_9-middle', 'jaw_blog-16_9','jaw_blog-16_9-big'), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
                    if($key == 3){
                        break;
                    }
                }
            }else{
                ?>
                <div class="image">
                <?php
                echo jwMedia::getPostThumbnail(get_the_ID(), array('large','full'));
            }
            ?>
            <div class="post-comments-labes">
                <?php
                if (jaw_template_get_var('blog_comments_inimage', '1') == '1') {
                    echo jwRender::get_meta_comments();
                }
                ?>
            </div>
            <div class="post-categories-labels">
                <?php
                if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                    echo jwRender::get_meta_category();
                }
                ?>
            </div>
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_vertical', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
    </div>
</article>

<?php } ?>
<?php function jw_tmpl_content__content_vertical_link(){ ?>
<?php
global $post, $wp_query, $jaw_data;
$col_count = jaw_template_get_var("columns", 4);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-vertical';
$single_class[] = 'jaw-post-box';
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">
        <div class="image link">
             <i class="jaw-icon-new-tab"></i>
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_vertical', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
    </div>
</article>

<?php } ?>
<?php function jw_tmpl_content__content_vertical_quote(){ ?>
<?php
global $post, $wp_query, $jaw_data;
$col_count = jaw_template_get_var("columns", 4);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-vertical';
$single_class[] = 'jaw-post-box';
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">
        <div class="image quote">
            <i class="jaw-icon-quotes-right"></i>
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_vertical', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
    </div>
    
    
    
          

    
    
         
        
                  

    
</article>

<?php } ?>
<?php function jw_tmpl_content__content_vertical_review(){ ?>
<?php
global $post, $wp_query, $jaw_data;
$post_meta = get_post_meta(get_the_ID(), 'fw_rating_position', true);
$totalrat = array('final' => "");
if(class_exists('ratingManager')){
    $ratingManager = ratingManager::getInstance();
    $ratings = $ratingManager->getRatings(get_the_ID());
    $totalrat = $ratingManager->getRatingsScore($ratings);
}
$ratingtype=jwOpt::get_option('rating_maximal_value');
$ratingmaxvalue=jwOpt::get_option('rating_maximal_value_show');
$col_count = jaw_template_get_var("columns", 4);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-vertical';
$single_class[] = 'jaw-post-box';
$single_class[] = 'format-review';
$attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?> >
    <div class="box ">
        <div class="image ">
            <?php
            $link = false;
            $pp = false;
            switch (jaw_template_get_var('clickable_image', '0')) {
                case '1': $link = get_permalink();
                echo "<a href=".$link.">";
                    break;
                case '2': $link = jwMedia::getPostThumbnailSrc(get_the_ID());
                echo "<a href=".$link." rel='prettyPhoto[".jaw_template_get_counter('pagination')."]'>";
                $pp = true;
                break;
            }
            echo "<span class='jaw-fadein'></span>";
            echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-16_9-small', 'jaw_blog-16_9-middle', 'jaw_blog-16_9', 'jaw_blog-16_9-big'));
            echo '<span class="post-categories-labels">';
                if ($post_meta == '1') { ?>
                    <span class="post-review-total">
                        <?php
                        switch($ratingtype) {
                            case "100" :
                                    echo esc_attr(round($totalrat['final'], 0)).'<span>%</span>';
                            break;
                            default:
                                if($ratingmaxvalue) {
                                    echo esc_attr(round($totalrat['final'], 1)).'<span>/'.esc_attr($ratingtype).'</span>';
                                } else {
                                    echo esc_attr(round($totalrat['final'], 1));
                                }
                            break;
                        }
                         ?>
                    </span>
                <?php }
            echo '</span>';
            if(has_post_thumbnail()){
                if(isset($attachement["width"]) && isset($attachement["height"])){
                    $width = $attachement["width"];
                    $height = $attachement["height"];
                }
            }?>
            <?php 
            if(jaw_template_get_var('clickable_image', '0')) {
                echo "</a>";
            }
            ?>
            <div class="post-comments-labes">
                <?php
                if (jaw_template_get_var('blog_comments_inimage', '1') == '1') {
                    echo jwRender::get_meta_comments();
                }
                ?>
            </div>
            <div class="post-categories-labels">
                <?php
                if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                    echo jwRender::get_meta_category();
                }
                ?>
            </div>
            
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_vertical', 'review' ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
    </div>
</article>

<?php } ?>
<?php function jw_tmpl_content__content_vertical_small_gallery(){ ?>
<?php
global $post, $wp_query, $jaw_data;
$col_count = jaw_template_get_var("columns", 12);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-vertical-small';
$single_class[] = 'jaw-post-box';
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">
        <?php
            $link = false;
            $pp = false;
            switch (jaw_template_get_var('clickable_image', '0')) {
                case '1': $link = get_permalink();
                    break;
                case '2': $link = jwMedia::getPostThumbnailSrc(get_the_ID());
                    $pp = true;
                    break;
            }
            $gallery = get_post_meta(get_the_ID(), 'jaw_post_gallery', true);
            $ids = jwMedia::parseJson($gallery);
            if(!empty($ids)){
                ?>
                <div class="image gallery">
                <?php
                foreach ((array)$ids as $key => $id) {
                    echo jwMedia::getAttachment($id, array('jaw_blog-16_9-small', 'jaw_blog-16_9-middle', 'jaw_blog-16_9','jaw_blog-16_9-big',  'large'), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
                    if($key == 3){
                        break;
                    }
                }
            }else{
                ?>
                <div class="image">
                <?php
                echo jwMedia::getPostThumbnail(get_the_ID(), array('large','full'));
            }
            ?>
            <div class="post-comments-labes">
                <?php
                if (jaw_template_get_var('blog_comments_inimage', '1') == '1') {
                    echo jwRender::get_meta_comments();
                }
                ?>
            </div>
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_vertical_small', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
    </div>
    
    
    
          

    
    
         
        
                  

</article>
<?php } ?>
<?php function jw_tmpl_content__content_vertical_small_link(){ ?>
<?php
global $post, $wp_query, $jaw_data;
$col_count = jaw_template_get_var("columns", 12);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-vertical-small';
$single_class[] = 'jaw-post-box';
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">
        <div class="image link">
            <i class="jaw-icon-new-tab"></i>
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_vertical_small', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
    </div>
    
    
    
          

    
    
         
        
                  

</article>
<?php } ?>
<?php function jw_tmpl_content__content_vertical_small_quote(){ ?>
<?php
global $post, $wp_query, $jaw_data;
$col_count = jaw_template_get_var("columns", 12);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-vertical-small';
$single_class[] = 'jaw-post-box';
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">
        <div class="image quote">
            <i class="jaw-icon-quotes-right"></i>
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_vertical_small', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
    </div>
    
    
    
          

    
    
         
        
                  

</article>
<?php } ?>
<?php function jw_tmpl_content__content_vertical_small_review(){ ?>
<?php
global $post, $wp_query, $jaw_data;
$post_meta = get_post_meta(get_the_ID(), 'fw_rating_position', true);
$totalrat = array('final' => "");
if(class_exists('ratingManager')){
    $ratingManager = ratingManager::getInstance();
    $ratings = $ratingManager->getRatings(get_the_ID());
    $totalrat = $ratingManager->getRatingsScore($ratings);
}
$ratingtype=jwOpt::get_option('rating_maximal_value');
$ratingmaxvalue=jwOpt::get_option('rating_maximal_value_show');
$col_count = jaw_template_get_var("columns", 12);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-vertical-small';
$single_class[] = 'jaw-post-box';
$single_class[] = 'format-review';
$attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">
        <div class="image">
            <?php
            $link = false;
            $pp = false;
            switch (jaw_template_get_var('clickable_image', '0')) {
                case '1': $link = get_permalink();
                echo "<a href=".$link.">";
                    break;
                case '2': $link = jwMedia::getPostThumbnailSrc(get_the_ID());
                echo "<a href=".$link." rel='prettyPhoto[".jaw_template_get_counter('pagination')."]'>";
                $pp = true;
                break;
            }
            echo "<span class='jaw-fadein'></span>";
            echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-16_9-small', 'jaw_blog-16_9-middle', 'jaw_blog-16_9'));
            echo '<span class="post-categories-labels">';
                if ($post_meta == '1') { ?>
                    <span class="post-review-total">
                        <?php
                        switch($ratingtype) {
                            case "100" :
                                    echo esc_attr(round($totalrat['final'], 0)).'<span>%</span>';
                            break;
                            default:
                                if($ratingmaxvalue) {
                                    echo esc_attr(round($totalrat['final'], 1)).'<span>/'.esc_attr($ratingtype).'</span>';
                                } else {
                                    echo esc_attr(round($totalrat['final'], 1));
                                }
                            break;
                        }
                         ?>
                    </span>
                <?php }
            echo '</span>';
            if(has_post_thumbnail()){
                if(isset($attachement["width"]) && isset($attachement["height"])){
                    $width = $attachement["width"];
                    $height = $attachement["height"];
                     }
            }
            if(jaw_template_get_var('clickable_image', '0')) {
                echo "</a>";
            }
            ?>
            <div class="post-comments-labes">
                <?php
                if (jaw_template_get_var('blog_comments_inimage', '1') == '1') {
                    echo jwRender::get_meta_comments();
                }
                ?>
            </div>
            <div class="post-categories-labels">
                <?php
                if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                    echo jwRender::get_meta_category();
                }
                ?>
            </div>
           
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_vertical_small','review' ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
    </div>
    </article>
<?php } ?>
<?php function jw_tmpl_content__content_vertical_small_video(){ ?>
<?php
global $post, $wp_query, $jaw_data;
$col_count = jaw_template_get_var("columns", 12);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-vertical-small';
$single_class[] = 'jaw-post-box';
$single_class[] = 'format-review';
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">
        <div class=" image video">
            <?php
            $video = get_post_meta(get_the_ID(), 'jaw_post_video_link', true);
            $link = false;
            $pp = false;
            $rel = '';
            switch (jaw_template_get_var('clickable_image', '0')) {
                case '1': $link = get_permalink();
                    $rel = ''; 
                    break;
                case '2': $link = $video;
                    $pp = true;
                    $rel = 'prettyPhoto[]';
                    break;
            }
            if (has_post_thumbnail()) {
                echo jwMedia::getPostThumbnail(get_the_ID(), array( 'jaw_blog-16_9-small', 'jaw_blog-16_9-middle', 'jaw_blog-16_9'), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
                $attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
                if(isset($attachement["width"]) && isset($attachement["height"])){
                    $width = $attachement["width"];
                    $height = $attachement["height"];
                }
            } else {
                $video = get_post_meta(get_the_ID(), 'jaw_post_video_link', true);
                echo jwMedia::getVideoThumbnail($video, $link, array($pp, 'full', jaw_template_get_counter('pagination')));
            }
            if($link){
                echo '<a href="'.$link.'" rel="'.$rel.'" >';
            }
            echo '<span class="jaw-video-icon">'.apply_filters('jaw_default_video_icon', '<i class="jaw-icon-play4"></i>').'</span>';
            if($link){
                echo '</a>';
            }
            ?>
            <div class="post-comments-labes">
                <?php
                if (jaw_template_get_var('blog_comments_inimage', '1') == '1') {
                    echo jwRender::get_meta_comments();
                }
                ?>
            </div>
            <div class="post-categories-labels">
                <?php
                if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                    echo jwRender::get_meta_category();
                }
                ?>
            </div>
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_vertical_small', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
    </div>
</article>
<?php } ?>
<?php function jw_tmpl_content__content_vertical_small(){ ?>
<?php
global $post, $wp_query, $jaw_data;
$col_count = jaw_template_get_var("columns", 12);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-vertical-small';
$single_class[] = 'jaw-post-box';
$attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">
        <div class="image">
            <?php
            $link = false;
            $pp = false;
            switch (jaw_template_get_var('clickable_image', '0')) {
                case '1': $link = get_permalink();
                    break;
                case '2': $link = jwMedia::getPostThumbnailSrc(get_the_ID());
                    $pp = true;
                    break;
            }
            echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-16_9-small', 'jaw_blog-16_9-middle', 'jaw_blog-16_9'), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
            if(has_post_thumbnail()){
                if(isset($attachement["width"]) && isset($attachement["height"])){
                    $width = $attachement["width"];
                    $height = $attachement["height"];
                }
            }?>
            <div class="post-comments-labes">
                <?php
                if (jaw_template_get_var('blog_comments_inimage', '1') == '1') {
                    echo jwRender::get_meta_comments();
                }
                ?>
            </div>
            <div class="post-categories-labels">
                <?php
                if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                    echo jwRender::get_meta_category();
                }
                ?>
            </div>
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_vertical_small', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
    </div>
</article>
<?php } ?>
<?php function jw_tmpl_content__content_vertical_video(){ ?>
<?php
global $post, $wp_query, $jaw_data;
$col_count = jaw_template_get_var("columns", 4);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-vertical';
$single_class[] = 'jaw-post-box';
$single_class[] = 'format-review';
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box">
        <div class=" image video">
            <?php
            $video = get_post_meta(get_the_ID(), 'jaw_post_video_link', true);
            $link = false;
            $pp = false;
            $rel = '';
            switch (jaw_template_get_var('clickable_image', '0')) {
                case '1': $link = get_permalink();
                    $rel = ''; 
                    break;
                case '2': $link = $video;
                    $pp = true;
                    $rel = 'prettyPhoto[]';
                    break;
            }
            if (has_post_thumbnail()) {
                echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-16_9-small', 'jaw_blog-16_9-middle', 'jaw_blog-16_9', 'jaw_blog-16_9-big', 'large'), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
                $attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
                if(isset($attachement["width"]) && isset($attachement["height"])){
                    $width = $attachement["width"];
                    $height = $attachement["height"];
                }
            } else {
                echo jwMedia::getVideoThumbnail($video, $link, array($pp, 'full', jaw_template_get_counter('pagination')));
            }
            if($link){
                echo '<a href="'.$link.'" rel="'.$rel.'" >';
            }
            echo '<span class="jaw-video-icon">'.apply_filters('jaw_default_video_icon', '<i class="jaw-icon-play4"></i>').'</span>';
            if($link){
                echo '</a>';
            }
            ?>
            <div class="post-comments-labes">
                <?php
                if (jaw_template_get_var('blog_comments_inimage', '1') == '1') {
                    echo jwRender::get_meta_comments();
                }
                ?>
            </div>
            <div class="post-categories-labels">
                <?php
                if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                    echo jwRender::get_meta_category();
                }
                ?>
            </div>
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_vertical', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
    </div>
</article>

<?php } ?>
<?php function jw_tmpl_content__content_vertical(){ ?>
<?php
global $post, $wp_query, $jaw_data;
$col_count = jaw_template_get_var("columns", 6);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-vertical';
$single_class[] = 'jaw-post-box';
$attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box ">
        <div class="image">
            <?php
            $link = false;
            $pp = false;
            switch (jaw_template_get_var('clickable_image', '0')) {
                case '1': $link = get_permalink();
                    break;
                case '2': $link = jwMedia::getPostThumbnailSrc(get_the_ID());
                    $pp = true;
                    break;
            }
            echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-16_9-small', 'jaw_blog-16_9-middle', 'jaw_blog-16_9', "jaw_blog-16_9-big"), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
            if(has_post_thumbnail()){
                if(isset($attachement["width"]) && isset($attachement["height"])){
                    $width = $attachement["width"];
                    $height = $attachement["height"];
                }
            }?>
            <div class="post-comments-labes">
                <?php
                if (jaw_template_get_var('blog_comments_inimage', '1') == '1') {
                    echo jwRender::get_meta_comments();
                }
                ?>
            </div>
            <div class="post-categories-labels">
                <?php
                if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                    echo jwRender::get_meta_category();
                }
                ?>
            </div>
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_vertical', get_post_format() ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
    </div>
</article>
<?php } ?>
<?php function jw_tmpl_footer__footer_12(){ ?>
<?php
$class = array();

$class[] = 'sidebars-preset-' . jwOpt::checkDefaultPreset(array(jwOpt::get_option('footer_color', '_default'), jwOpt::get_option('main_color')),'color');
$class[] = jwOpt::checkDefault(array(jwOpt::get_option('footer_bar_type', '_default'), jwOpt::get_option('global_header_style')));
$class[] = jwLayout::col_class(12);

echo jwUtils::customizer_preview_preset("Footer", jwOpt::checkDefaultPreset(array(jwOpt::get_option('footer_color', '_default'), jwOpt::get_option('main_color')),'color'), array('image' => 'footer_colors.jpg', 'position'=> 'top'));

$footer_class = array();
$footer_class[] = 'jw-fullwidth-' . jwOpt::get_option('footer_fullwidth', 'off');  
?>
<div class="row jaw-footer-sidebars <?php echo esc_attr(implode(' ', $footer_class)); ?>">
    <div class="sidebar footer-sidebar <?php echo esc_attr(implode(' ', $class)); ?>">
        <?php dynamic_sidebar('footer1'); ?>
    </div>
    <?php do_action('jaw_after_footer_widgets'); ?>
</div>
<?php } ?>
<?php function jw_tmpl_footer__footer_3_3_3_3(){ ?>
<?php
$class = array();

$class[] = 'sidebars-preset-' . jwOpt::checkDefaultPreset(array(jwOpt::get_option('footer_color', '_default'), jwOpt::get_option('main_color')),'color');
$class[] = jwOpt::checkDefault(array(jwOpt::get_option('footer_bar_type', '_default'), jwOpt::get_option('global_header_style')));
$class[] = jwLayout::col_class(array(3,3,6,12));

echo jwUtils::customizer_preview_preset("Footer", jwOpt::checkDefaultPreset(array(jwOpt::get_option('footer_color', '_default'), jwOpt::get_option('main_color')),'color'), array('image' => 'footer_colors.jpg', 'position'=> 'top'));

$footer_class = array();
$footer_class[] = 'jw-fullwidth-' . jwOpt::get_option('footer_fullwidth', 'off');  
?>
<div class="row jaw-footer-sidebars <?php echo esc_attr(implode(' ', $footer_class)); ?>">
    <div class="sidebar footer-sidebar <?php echo esc_attr(implode(' ', $class)); ?>">
        <div class="sidebar-box">
            <?php dynamic_sidebar('footer1'); ?>
        </div>
    </div>
    <div class="sidebar footer-sidebar <?php echo esc_attr(implode(' ', $class)); ?>">
        <div class="sidebar-box">
            <?php dynamic_sidebar('footer2'); ?>
        </div>
    </div>
    <div class="sidebar footer-sidebar <?php echo esc_attr(implode(' ', $class)); ?>">
        <div class="sidebar-box">
            <?php dynamic_sidebar('footer3'); ?>
        </div>
    </div>
    <div class="sidebar footer-sidebar <?php echo esc_attr(implode(' ', $class)); ?>">
        <div class="sidebar-box">
            <?php dynamic_sidebar('footer4'); ?>
        </div>
    </div>
    <?php do_action('jaw_after_footer_widgets'); ?>
</div>
<?php } ?>
<?php function jw_tmpl_footer__footer_4_4_4(){ ?>
<?php
$class = array();

$class[] = 'sidebars-preset-' . jwOpt::checkDefaultPreset(array(jwOpt::get_option('footer_color', '_default'), jwOpt::get_option('main_color')),'color');
$class[] = jwOpt::checkDefault(array(jwOpt::get_option('footer_bar_type', '_default'), jwOpt::get_option('global_header_style')));
$class[] = jwLayout::col_class(array(4,4,6,12));

echo jwUtils::customizer_preview_preset("Footer", jwOpt::checkDefaultPreset(array(jwOpt::get_option('footer_color', '_default'), jwOpt::get_option('main_color')),'color'), array('image' => 'footer_colors.jpg', 'position'=> 'top') );

$footer_class = array();
$footer_class[] = 'jw-fullwidth-' . jwOpt::get_option('footer_fullwidth', 'off');   
?>
<div class="row jaw-footer-sidebars <?php echo esc_attr(implode(' ', $footer_class)); ?>">
    <div class="sidebar footer-sidebar <?php echo esc_attr(implode(' ', $class)); ?>">
        <div class="sidebar-box">
            <?php dynamic_sidebar('footer1'); ?>
        </div>
    </div>
    <div class="sidebar footer-sidebar <?php echo esc_attr(implode(' ', $class)); ?>">
        <div class="sidebar-box">
            <?php dynamic_sidebar('footer2'); ?>
        </div>
    </div>
    <div class="sidebar footer-sidebar <?php echo esc_attr(implode(' ', $class)); ?>">
        <div class="sidebar-box">
            <?php dynamic_sidebar('footer3'); ?>
        </div>
    </div>
    <?php do_action('jaw_after_footer_widgets'); ?>
</div>
<?php } ?>
<?php function jw_tmpl_footer__footer_4_8(){ ?>
<?php
$class = array();

$class[] = 'sidebars-preset-' . jwOpt::checkDefaultPreset(array(jwOpt::get_option('footer_color', '_default'), jwOpt::get_option('main_color')),'color');
$class[] = jwOpt::checkDefault(array(jwOpt::get_option('footer_bar_type', '_default'), jwOpt::get_option('global_header_style')));

echo jwUtils::customizer_preview_preset("Footer", jwOpt::checkDefaultPreset(array(jwOpt::get_option('footer_color', '_default'), jwOpt::get_option('main_color')),'color'), array('image' => 'footer_colors.jpg', 'position'=> 'top'));

$footer_class = array();
$footer_class[] = 'jw-fullwidth-' . jwOpt::get_option('footer_fullwidth', 'off');  
?>
<div class="row jaw-footer-sidebars <?php echo esc_attr(implode(' ', $footer_class)); ?>">
    <div class="sidebar footer-sidebar <?php echo esc_attr(implode(' ', $class) . ' ' . jwLayout::col_class(array(4,4,5,12))); ?>">
        <div class="sidebar-box">
            <?php dynamic_sidebar('footer1'); ?>
        </div>
    </div>
    <div class="sidebar footer-sidebar <?php echo esc_attr(implode(' ', $class) . ' ' . jwLayout::col_class(array(8,8,7,12))); ?>">
        <div class="sidebar-box">
            <?php dynamic_sidebar('footer2'); ?>
        </div>
    </div>
    <?php do_action('jaw_after_footer_widgets'); ?>  
</div>
<?php } ?>
<?php function jw_tmpl_footer__footer_6_6(){ ?>
<?php
$class = array();

$class[] = 'sidebars-preset-' . jwOpt::checkDefaultPreset(array(jwOpt::get_option('footer_color', '_default'), jwOpt::get_option('main_color')),'color');
$class[] = jwOpt::checkDefault(array(jwOpt::get_option('footer_bar_type', '_default'), jwOpt::get_option('global_header_style')));
$class[] = jwLayout::col_class(array(6,6,6,12));

echo jwUtils::customizer_preview_preset("Footer", jwOpt::checkDefaultPreset(array(jwOpt::get_option('footer_color', '_default'), jwOpt::get_option('main_color')),'color'), array('image' => 'footer_colors.jpg', 'position'=> 'top'));

$footer_class = array();
$footer_class[] = 'jw-fullwidth-' . jwOpt::get_option('footer_fullwidth', 'off');  
?>
<div class="row jaw-footer-sidebars <?php echo esc_attr(implode(' ', $footer_class)); ?>">
    <div class="sidebar footer-sidebar <?php echo esc_attr(implode(' ', $class)); ?>">
        <div class="sidebar-box">
            <?php dynamic_sidebar('footer1'); ?>
        </div>
    </div>
    <div class="sidebar footer-sidebar <?php echo esc_attr(implode(' ', $class)); ?>">
        <div class="sidebar-box">
            <?php dynamic_sidebar('footer2'); ?>
        </div>
    </div>
    <?php do_action('jaw_after_footer_widgets'); ?>
</div>
<?php } ?>
<?php function jw_tmpl_footer__footer(){ ?>
<footer id="footer" class="jaw-footer row">
  <?php
$footer_class = array();
$footer_class[] = jwLayout::col_class(12);
$footer_class[] = 'copyright-preset-' . jwOpt::get_option('main_color');
$footer_class[] = 'jw-center-elements-' . jwOpt::get_option('show_centered_elements', 'off');

$left_part_class = array();
$show_menu = jwOpt::get_option('show_footer_menu', '0');
if($show_menu == '1'){
    $left_part_class[] = jwLayout::col_class(6);
}else{
    $left_part_class[] = jwLayout::col_class(12);
}
?>
    <div class="<?php echo esc_attr(implode(' ', $footer_class)); ?>">
      <?php
if(jwOpt::get_option('footer_style', 'footer-12') != "footer-off"){
    echo jaw_get_template_part(jwOpt::get_option('footer_style', 'footer-12'), 'footer');
}else{
    do_action('jaw_after_footer_widgets');
}
?>
        <?php if (jwOpt::get_option('show_copyright', 'on') == 'on') {

    $copyright_class = array();
    $copyright_class[] = 'jw-fullwidth-' . jwOpt::get_option('footer_fullwidth', 'off');
    ?>
          <div id="copyright" class="footer-copyright row <?php echo esc_attr(implode(' ', $copyright_class)); ?>">
            <div class="<?php echo esc_attr(implode(' ',$left_part_class)); ?>">
              <?php echo '<span>'.do_shortcode(jwOpt::get_option('footer_text', 'Copyright &copy; 2016 Design by <a href="http://www.jawtemplates.com/wordpress-themes/gday-news-magazine/">Jawtemplates.com</a>.')).'</span>'; ?>
                <?php
    if (jwOpt::get_option('show_responsive', '1')) {

        $responsive = esc_attr(jwOpt::get_option('responsive', '1'));
        echo '<a href="' . esc_url(add_query_arg(array('jaw_responsive' => $responsive), '//' . $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"])) . '" class="jw-responsive">';
        if ($responsive == '1') {
            esc_html_e('Disable responsivity','gdn-theme');
        } else {
            esc_html_e('Allow responsivity','gdn-theme');
        }
        echo '</a>';
    }
    ?>
            </div>
            <?php if($show_menu == '1'){  ?>
            <!-- footer menu -->
            <div class="<?php echo esc_attr(jwLayout::col_class(6)); ?>">
              <nav class="footer-menu" role="navigation">
                <section>
                  <?php
                  if(has_nav_menu( 'footer_navigation' )){
                    wp_nav_menu(
                        array(
                        'theme_location' => 'footer_navigation',
                        )
                    );
                  } else {
                    echo jwUtils::jaw_msg(
                        sprintf(esc_html__('You have not set Footer Navigation in Menu Settings. Please %sclick here%s for setting it up.','gdn-theme'),'<a href="'.admin_url( 'nav-menus.php').'">','</a>'),"warning");
                  }
                    ?>
                    <div class="clear"></div>
                </section>
              </nav>
            </div>
            <!-- end footer menu -->
            <?php } ?>
          </div>
          <?php } ?>
    </div>
</footer>
</div>
<!-- End the template box -->
</div>
<!-- Container End -->
<!-- Custom Script in Footer -->
<script>
  <?php echo jwOpt::get_option('custom_js'); ?>
</script>

    </div>
    <?php
if (jwOpt::get_option('background_banner_show', '0')) {
    // linky
    echo jaw_get_template_part('banner_background', 'banners');
}
?>

<?php } ?>
<?php function jw_tmpl_header__header(){ ?>
<?php //  ?>
<?php if (jwOpt::get_option('top_bar_show', '0') == '1') { ?>
  <?php
    $class_top = array();
    $class_top[] = 'top_bar-preset-' . jwOpt::checkDefaultPreset(array(jwOpt::get_option('top_bar_color', '_default'), jwOpt::get_option('main_color')),'color');
    $class_top[] = 'jw-fullwidth-' . jwOpt::get_option('top_bar_fullwidth', 'off');
    switch (jwOpt::get_option('top_bar_fix', '0')) {
        case '1': $class_top[] = 'jaw-fixed-bar';
                $class_top[] = 'jaw-mobile-fixed-bar';
            break;
        case '2': $class_top[] = 'jaw-fixed-bar';
                $class_top[] = 'jaw-mobile-fixed-bar';
                $class_top[] = 'jaw-fixed-bar-smart';
            break;
    }
    ?>
    <div class="jaw-top-bar <?php echo esc_attr(implode(' ', $class_top)); ?>">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 jaw-topbar-col">
        <?php echo jwUtils::customizer_preview_preset("Top bar", jwOpt::checkDefaultPreset(array(jwOpt::get_option('top_bar_color', '_default'), jwOpt::get_option('main_color')),'color'),array(
        'image' => 'topbar_colors.jpg',
        'title' => 'Top Bar colors'
        ));?>
          <?php echo jaw_get_template_part('top-bar', 'header'); ?>
      </div>
      <div class="clear"></div>
    </div>
    <?php } ?>

      <?php if ((is_front_page() && jwOpt::get_option('header_featured_show', 'off') == 'home') || jwOpt::get_option('header_featured_show', 'off') == 'all_web')  { ?>
        <?php echo jaw_get_template_part('header_featured_area', 'header'); ?>
          <?php } ?>
<?php //  ?>
<?php do_action('jaw_under_topbar'); ?>
            <?php
//LOGO area
if(in_array(jwOpt::get_option('header_style','l-center'), array('l-left', 'l-right', 'l-center', 'l-a', 'a-l', '4-l-4', 'l-4-4', '4-4-l'))){
    echo jaw_get_template_part('header-logo-area',array('header','logo_area'));
} ?>
<?php do_action('jaw_before_menuwrapper'); ?>
              <?php // MENU ?>
                <?php
$class = array();

$class[] = 'jw-menu-align-' . jwOpt::get_option('menu_align', 'left');

switch (jwOpt::get_option('menu_bar_fix', '0')) {
    case '1': $class[] = 'jaw-fixed-bar';
        break;
    case '2': $class[] = 'jaw-fixed-bar';
        $class[] = 'jaw-fixed-bar-smart';
        break;
}
if(jwOpt::get_option('logo_in_menu_bar_fix', '0') && jwOpt::get_option('menu_bar_fix','1')){
    $class[] = 'jw-fixed-menu-logo';
}

$class[] = 'jw-header-style-' . jwOpt::get_option('header_style', 'l-center');

$class[] = 'jw-use-user-panel-' . jwOpt::get_option('use_user_panel', '1');

$class[] = 'jw-menu-style-' . jwOpt::get_option('menu_style_type', 'classic');

$class[] = 'menu-preset-' . jwOpt::checkDefaultPreset(array(jwOpt::get_option('menu_color', '_default'), jwOpt::get_option('main_color')),'color');

$class[] = 'sub-menu-preset-' . jwOpt::checkDefaultPreset(array(jwOpt::get_option('submenu_color', '_default'), jwOpt::get_option('menu_color', '_default'), jwOpt::get_option('main_color')),'color');
    
$class[] = 'menu-left-preset-' . jwOpt::checkDefaultPreset(array(jwOpt::get_option('menu_left_color', '_default'), jwOpt::get_option('menu_color'), jwOpt::get_option('main_color')), 'color');

$class[] = 'jw-fullwidth-' . jwOpt::get_option('menu_fullwidth', 'off');

$class[] =  'user-panel-search-'.jwOpt::get_option('user-panel-search', '0');

$class[] =  'user-panel-submit-message-'.jwOpt::get_option('user-panel-submit-message', '0');
        
        ?>
                  <div class="row main-menu <?php echo esc_attr(implode(' ', $class)); ?>">
                    <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?> jaw-menu-col">
                      <div class="jw-menu-wrapper">
                        <?php
        if ( has_nav_menu( 'primary_navigation' ) ) {
            
            echo jwUtils::customizer_preview_preset("Menu - Left Area", jwOpt::checkDefaultPreset(array(jwOpt::get_option('menu_left_color', '_default'), jwOpt::get_option('main_color')), 'color'), array(
                'image' => 'mynews_colors.jpg',
                'title' => 'Menu Left Area colors'
                ),  'right');
                
                
                //search
                if (jwOpt::get_option('user-panel-search', '1') != '0') {
                    echo '<div class="jaw-user-panel-search jaw-popup-serarch show-on-' . jwOpt::get_option('user-panel-search', '0') . '">';
                    get_search_form();
                    echo '</div>';
            }
            
            //submit message button
            if (jwOpt::get_option('user-panel-submit-message', '0') != '0') {
                echo '<div class="jaw-user-panel-submit-message show-on-' . esc_attr(jwOpt::get_option('user-panel-message', '0')) . '">';
                echo '<div class="jaw-user-panel-submit-message-wrapper">';
                echo '<div class="jaw-user-button jaw_button jaw-user-logout btn">';
                echo '<a href="#" class="popmake-'.esc_attr(jwOpt::get_option('user-panel-submit-message-modal_id','1')).'" >';
                echo jwOpt::get_option('user-panel-submit-message-style','');
                echo '</a>';
                echo '</div>';
                echo '</div>';
                echo '</div>';
            }
// 
            //My News
            if (jwOpt::get_option('use_user_panel', '0') != '0') {
                echo jaw_get_template_part('user_panel_controll', array('header', 'user_panel'));
            }
// 
            
            echo jwUtils::customizer_preview_preset("Menu", jwOpt::checkDefaultPreset(array(jwOpt::get_option('menu_color', '_default'), jwOpt::get_option('main_color')),'color'), array(
                'image' => 'menu_colors.jpg',
                'title' => 'Menu colors'
                ), 'left');
                
                // LOGO in menu
                if(jwOpt::get_option('header_style','l-center') == 'in-menu'){
                    echo jaw_get_template_part('in-menu',array('header','logo_area'));
            }
            //LOGO in fixed menu
            if(jwOpt::get_option('logo_in_menu_bar_fix','1') && jwOpt::get_option('menu_bar_fix','1')){
                echo jaw_get_template_part('in-fixed-menu',array('header','logo_area'));
            }
            
            //menu
            echo jaw_get_template_part(jwOpt::get_option('menu_style_type', 'classic'), array('header', 'menu'));
            
        } else {
            return jwUtils::jaw_msg(sprintf(esc_html__('You have not set Primary Navigation in Menu Settings. Please %sclick here%s for setting it up.','gdn-theme'),'<a href="'.admin_url( 'nav-menus.php').'"','</a>'),"warning");
            }
        ?>
        <?php do_action("jaw_after_menu_wrapper"); ?>
                        </div><!-- END jw-menu-wrapper -->
                        </div>
                    </div>

                    <?php // MOBILE menu ?>
                        <?php
        $mobile_class = array();
        $mobile_class[] = 'mobile-menu-preset-' .  jwOpt::checkDefaultPreset(array(jwOpt::get_option('mobile_menu_color', '_default'), jwOpt::get_option('menu_color', '_default'), jwOpt::get_option('main_color')),'color');
            ?>
                        <div class="row mobile-main-menu-bar <?php echo esc_attr(implode(' ', $mobile_class)); ?>">
                            <?php
            
            // logo in menu (mobile)
            if(jwOpt::get_option('header_style','l-center') == 'in-menu'){
                echo jaw_get_template_part('in-mobile-menu',array('header','logo_area'));
        }
        
        $mobile_class = array();
        if(jwOpt::get_option('mobile_menu_bar_fix', '1')){
            $mobile_class[] = 'jaw-mobile-fixed-bar';
        }
        ?>
                            <div class="jw-mobile-menu-wrapper">
                                <div class="jw-mobile-menu-bar <?php echo esc_attr(implode(' ',$mobile_class)); ?>">
                                <div class="jw-open-mobile-menu jw-mobile-close">
                                    <i class="jaw-icon-menu2"></i>
                                </div>
                                <?php do_action("jaw_mobile_menu_wrapper"); ?>
                                <?php if(jwOpt::get_option('mobile_menu_show_login', '1')) { ?>
                                    <div class="jw-open-login jw-mobile-close">
                                        <i class="jaw-icon-user"></i>
                                    </div>
                                <?php } ?>
                                <?php   if (jwOpt::get_option('mobile_menu_show_search', '1')) {  ?>
                                    <div class="jw-mobile-search closed">
                                        <div class="open-search-button">
                                        <i class="jaw-icon-search3"></i>
                                        </div>
                                        <?php get_search_form(); ?>
                                    </div>
                                <?php } ?>
                                </div>
                            </div>
                        </div>


                        <?php
        //LOGO area
        if(jwOpt::get_option('header_style','l-center') == 'under-menu'){
            echo jaw_get_template_part('header-logo-area',array('header','logo_area'));
        } ?>


                            <?php // MYnews ?>
                            <?php
        if (is_user_logged_in() && (jwOpt::get_option('use_user_panel', '1') || jwOpt::get_option('top_bar_user_content', '1'))) {
            $class = array();
            $class[] = 'post-preset-'.jwOpt::checkDefaultPreset(array(jwOpt::get_option('my_news_color','_default'), jwOpt::get_option('main_color')),'color');
                $class[] = 'user-content-preset-'.jwOpt::checkDefaultPreset(array(jwOpt::get_option('my_news_color','_default'), jwOpt::get_option('main_color')),'color');
                    $class[] = 'jw-menu-fixed-'.jwOpt::get_option('menu_fullwidth', 'off');
                    ?>
                                <div class="jaw-user-panel-content <?php echo esc_attr(implode(' ',$class)); ?> ">
                                <div class="jaw-user-item jaw-user-loader">
                                    <div class="jaw-user-content row"><i class="jaw-icon-spinner2 jaw-spinit"></i></div>
                                </div>
                                </div>
                                <?php
            }?>
<?php } ?>
<?php function jw_tmpl_header__header_featured_area(){ ?>
<?php
$preset = jwOpt::checkDefaultPreset(array(jwOpt::get_option('header_color', '_default'), jwOpt::get_option('main_color')),'color');
$class_head = array();
$class_head[] = 'jw-fullwidth-' . jwOpt::get_option('header_fullwidth', 'off');
$class_head[] = 'head-preset-' . $preset;	
$class_head[] = 'post-preset-' . $preset;	

?>

<div class="jaw-header-featured-area <?php echo esc_attr(implode(' ', $class_head)); ?>">
	<?php echo jwUtils::customizer_preview_preset("Featured area", jwOpt::checkDefaultPreset(array(jwOpt::get_option('header_color', '_default'), jwOpt::get_option('main_color')),'color'));?>
	<div class="row jaw-header-featured-area-row">
		<?php $content = jwOpt::get_option('header_featured_area_builder_shortcodes','');
		if(isset($content['2_content'])){
			echo do_shortcode($content['2_content']);
		}
		?>
	</div>
</div>
<?php } ?>
<?php function jw_tmpl_header__modal(){ ?>
<?php
global $post;
$post = get_page(jaw_template_get_var('page_id'));
if(isset($post->ID)){
?>
<div class="modal col-lg-8 fade" id="jaw_modal">
    <div class="modal-header col-lg-8">
        <a class="close" data-dismiss="modal"><i class="jaw-icon-cancel-circle"></i></a>
        <h3><?php echo esc_attr($post->post_title); ?></h3>
    </div>
    <div class="modal-body col-lg-8">
        <p><?php echo apply_filters('the_content', $post->post_content); ?></p>
    </div>
    <div class="clear"></div>
</div>
<?php } ?>
<?php } ?>
<?php function jw_tmpl_header__page_title(){ ?>
<?php
global $post;
$class = array();
$bread = '0';
switch (jwOpt::get_option('breadcrumb_bar_fix', '0')) {
    case '1': $class[] = 'jaw-fixed-bar';
        break;
    case '2': $class[] = 'jaw-fixed-bar';
        $class[] = 'jaw-fixed-bar-smart';
        break;
}
if (is_page()) {
    $bread = get_post_meta(get_the_ID(), 'jaw_page_breadcrumbs', true);
    if($bread == '_default' || $bread == ""){
        $bread = esc_attr(jwOpt::get_option('page_breadcrumbs', '0'));
    }
} else {
    $bread = esc_attr(jwOpt::get_option('blog_breadcrumb', '1'));
}
if ($bread == '1' && (!is_home() || !is_front_page())) {
    ?>
    <div class="row-fullwidth jaw-bread <?php echo esc_attr(implode(' ', $class)); ?>">
        <div class="breadcrumbs-wrap">
            <div class="fullwidth-block row">
                <div class="col-lg-12 row-breadcrumbs">            
                    <?php
                    echo jaw_get_template_part('breadcrumbs', 'simple-shortcodes');
                    ?>
                </div>
            </div>    
        </div>                          
    </div>
    <?php
} else if ($bread == '0' || (is_home() && $bread == '1')) {
    ?>
    <div class="without-breadcrumb"></div>
    <?php
}?>
<?php } ?>
<?php function jw_tmpl_header__skyscrapper_left(){ ?>
<?php if ( jwOpt::get_option('banner_skyscrapper_left_show', '0') == 'image' && strlen(jwOpt::get_option('banner_skyscrapper_left_image', '')) > 0 ) { ?>
    <div id="skyscrapper-left" class="skyscrapper">
        <?php 
            $banner_link = jwOpt::get_option('banner_skyscrapper_left_link', '#');
        ?>
        <?php if ( strlen($banner_link) <= 0 || $banner_link == 'http://' || $banner_link == 'https://' ) { ?>
        <a href="#">
            <img src="<?php echo esc_url(jwOpt::get_option('banner_skyscrapper_left_image', '')); ?>">
        </a>
        <?php } else { ?>
        <a href="<?php echo esc_url($banner_link); ?>"   target="<?php echo esc_url(jwOpt::get_option('banner_skyscrapper_left_link_target', '_blank')); ?>"   >
            <img src="<?php echo esc_url(jwOpt::get_option('banner_skyscrapper_left_image', '')); ?>">
        </a>
        <?php } ?>
    </div>
<?php } else if(jwOpt::get_option('banner_skyscrapper_left_show', '0') == 'google'){ ?>
    <?php if ( strlen(jwOpt::get_option('banner_skyscrapper_left_google', '')) > 0 ) { ?>
        <div id="skyscrapper-left" class="skyscrapper">
            <div class="google_ads">
                <?php echo do_shortcode(jwOpt::get_option('banner_skyscrapper_left_google', '')); ?>
            </div>
        </div>
    <?php } ?>
<?php } ?>

<?php } ?>
<?php function jw_tmpl_header__skyscrapper_right(){ ?>
<?php 
if ( jwOpt::get_option('banner_skyscrapper_right_show', '0') == 'image' && strlen(jwOpt::get_option('banner_skyscrapper_right_image', '')) > 0 ) { ?>
    <div id="skyscrapper-right" class="skyscrapper">
        <?php 
            $banner_link = jwOpt::get_option('banner_skyscrapper_right_link', '#');
        ?>
        <?php if ( strlen($banner_link) <= 0 || $banner_link == 'http://' || $banner_link == 'https://' ) { ?>
        <a href="#">
            <img src="<?php echo esc_url(jwOpt::get_option('banner_skyscrapper_right_image', '')); ?>">
        </a>
        <?php } else { ?>
        <a href="<?php echo esc_url($banner_link); ?>"   target="<?php echo esc_url(jwOpt::get_option('banner_skyscrapper_right_link_target', '_blank')); ?>"   >
            <img src="<?php echo esc_url(jwOpt::get_option('banner_skyscrapper_right_image', '')); ?>">
        </a>
        <?php } ?>
    </div>
<?php } else if(jwOpt::get_option('banner_skyscrapper_right_show', '0') == 'google'){ ?>
    <?php if ( strlen(jwOpt::get_option('banner_skyscrapper_right_google', '')) > 0 ) { ?>
        <div id="skyscrapper-right" class="skyscrapper">
            <div class="google_ads">
                <?php echo do_shortcode(jwOpt::get_option('banner_skyscrapper_right_google', '')); ?>
            </div>
        </div>
    <?php } ?>
<?php } ?>

<?php } ?>
<?php function jw_tmpl_header__to_top(){ ?>
<div class="totop-button" id="totop" >
    <i class="jaw-icon-arrow-slide-up"></i>
</div>
<?php } ?>
<?php function jw_tmpl_header__top_bar(){ ?>
<div class="jaw-top-bar-content">
    <?php
    /**     * ********************* LEFT SIDE ****************************** */
    if (jwOpt::get_option('top_bar_date', '0') != '0') {
        echo '<div class="jaw-top-bar-item-left jaw-top-bar-date show-on-' . esc_attr(jwOpt::get_option('top_bar_date', '0')) . '">';
        echo current_time(jwOpt::get_option('top_bar_date_format', 'F j, Y'));
        echo '</div>';
    }
    if (jwOpt::get_option('top_bar_text', '0') != '0') {
        echo '<div class="jaw-top-bar-item-left jaw-top-bar-text show-on-' . esc_attr(jwOpt::get_option('top_bar_text', '0')) . '">';
        echo do_shortcode(jwOpt::get_option('top_bar_text_content', ''));
        echo '</div>';
    }
    if (jwOpt::get_option('top_bar_menu', '0') != '0') {
        echo '<div class="jaw-top-bar-item-left jaw-top-bar-menu show-on-' . esc_attr(jwOpt::get_option('top_bar_menu', '0')) . '">';
        echo '<nav class="top-bar top-bar-jw menu-in-top-bar" role="navigation">';
        echo '<section>';
        if(has_nav_menu( 'top_bar_navigation' )){
            wp_nav_menu(
                array(
                'theme_location' => 'top_bar_navigation',
                )
            );
        } else {
            echo jwUtils::jaw_msg(sprintf(esc_html__('You have not set TopBar Navigation in Menu Settings. Please %sclick here%s for setting it up.','gdn-theme'),'<a href="'.admin_url( 'nav-menus.php').'"','</a>'),"warning");
        }
        echo '<div class="clear"></div>';
        echo '</section>';
        echo '</nav>';
        echo '</div>';
    }

    //MENU
    /**     * ********************* RIGHT SIDE ****************************** */
    if (jwOpt::get_option('top_bar_search', '0') != '0') {
        echo '<div class="jaw-top-bar-item-right jaw-top-bar-search jaw-popup-serarch show-on-' . esc_attr(jwOpt::get_option('top_bar_search', '0')) . '">';
        get_search_form();
        echo '</div>';
    }
// 
    if (jwOpt::get_option('top_bar_user_content', '0') != '0') {
        echo '<div class="jaw-top-bar-item-right jaw-top-bar-user-content show-on-' . esc_attr(jwOpt::get_option('top_bar_user_content', '0')) . '">';
        echo jaw_get_template_part('user_panel_controll', array('header', 'user_panel'));
        echo '</div>';
    }
// 
    
    if (jwOpt::get_option('top_bar_social', '0') != '0') {
        jaw_template_set_data(array(
            'social' => array(
                'facebook' => jwOpt::get_option('top_bar_social_facebook', ''),
                'twitter' => jwOpt::get_option('top_bar_social_twitter', ''),
                'google' => jwOpt::get_option('top_bar_social_google', ''),
                'youtube' => jwOpt::get_option('top_bar_social_youtube', ''),
                'vimeo' => jwOpt::get_option('top_bar_social_vimeo', ''),
                'flickr' => jwOpt::get_option('top_bar_social_flickr', ''),
                'linkedin' => jwOpt::get_option('top_bar_social_linkedin', ''),
                'pinterest' => jwOpt::get_option('top_bar_social_pinterest', ''),
                'instagram' => jwOpt::get_option('top_bar_social_instagram', '')
            ),
            'color' => 'inherit',
            'target' => '_blank'));
        echo '<div class="jaw-top-bar-item-right jaw-top-bar-social show-on-' . esc_attr(jwOpt::get_option('top_bar_social', '0')) . '">';
        echo jaw_get_template_part('social_icons', 'simple-shortcodes');
        echo '</div>';
    }
    ?>
    <div class="clear"></div>
</div>
<?php } ?>
<?php function jw_tmpl_meta__meta(){ ?>
<?php
if (
        (jaw_template_get_var('blog_meta_author', '0') == '1') ||
        (jaw_template_get_var('blog_comments_count', '0') == '1') ||
        (jaw_template_get_var('blog_metadate', '0') == '1') ||
        (jaw_template_get_var('blog_meta_category', '0') == '1') ||
        (jaw_template_get_var('blog_meta_like', '0') == '1') ||
        (jaw_template_get_var('blog_ratings', '0') == '1') ||
        (jaw_template_get_var('blog_readers', '0') == '1') ||
        (jaw_template_get_var('blog_last_comment_date', '0') == '1') || 
        (jaw_template_get_var('blog_featured_post', '0') == '1')
) {
    ?>
    <div class="blog-meta-info">
        <ul class="blog-meta-info-content">  
            <?php if (jaw_template_get_var('blog_metadate', '0') == '1') { ?>
                <li class="post-meta-author-date">
                    <?php
                    $date = jwRender::get_meta_date();
                    echo $date;
                    ?>
                </li>
            <?php } ?>
            <?php if (jaw_template_get_var('blog_meta_author', '0') == '1') { ?>
                <li class="post-meta-author-date" itemprop="author" itemscope itemtype="https://schema.org/Person">                        
                    <?php
                    $author = jwRender::get_meta_author();
                    echo $author;
                    ?>                          
                </li>
            <?php } ?>     

            <?php if (jaw_template_get_var('blog_comments_count', '0') == '1') { ?>
                <li class="post-meta-comments">
                    <?php echo jwRender::get_meta_comments(); ?>
                </li>
            <?php } ?>

            <?php if (jaw_template_get_var('blog_meta_category', '0') == '1') { ?>
                <li class="post-meta-catagory">
                    <span><?php esc_html_e('Posted in ', "gdn-theme"); ?></span>
                    <?php echo jwRender::get_meta_category(); ?>
                </li>
            <?php } ?>
<?php //  ?>
            <?php if (jaw_template_get_var('blog_meta_like', '0') == '1') { ?>
                <?php echo jwRender::get_likes(); ?>
            <?php } ?>
            <?php if (jaw_template_get_var('blog_ratings', '0') == '1') { ?>
                <?php // li se renderuje az v jwrenderu - kdyz neni rating tak aby tam nebyla mezera?>
                <?php echo jwRender::metaRating(); ?>  <!-- RATING -->

            <?php } ?>
            <?php if (jaw_template_get_var('blog_readers', '0') == '1') { ?>
                <li class="post-meta-readers">
                    <?php echo jwRender::metaReaders(); ?>  <!-- readers -->
                </li>
            <?php } ?>
            <?php if (jaw_template_get_var('blog_last_comment_date', '0') == '1') { ?>
                <li class="post-meta-last-comment">
                    <?php echo jwRender::metaLastComment(); ?>  <!-- comments -->
                </li>
            <?php } ?>
<?php //  ?>
            <?php if (jaw_template_get_var('blog_featured_post', '0') == '1' && is_sticky()) { ?>
                <li class="post-meta-featured-post">
                    <?php echo esc_html_e("Featured post", "gdn-theme"); ?>  <!-- comments -->
                </li>
            <?php } ?>
        </ul>                
    </div>
    <?php
}?>
<?php } ?>
<?php function jw_tmpl_pagination__pagination(){ ?>
<?php 
global $post;
wp_reset_postdata();

// PREV/NEXT posts navigation
$prevnextnav_allowed = jwOpt::get_option("prevnextnav_show", "true");
if($prevnextnav_allowed == "true") {
	$prevnextnav_excerpt_title = jwOpt::get_option("prevnextnav_excerpt_title", 60);
	$prevnextnav_thumbs = 'prevnextnav_thumbs-'.jwOpt::get_option("prevnextnav_thumbs", 1);
	$prevnextnav_meta = 'prevnextnav_meta-'.jwOpt::get_option("prevnextnav_meta", 1);
	$previous_post = get_adjacent_post(false, "", true); 
	$next_post = get_adjacent_post(false, "", false);
	$post_types="";
	$post_types_cls = "";
	$clear="";
	$link = "";
	$print_content="";
	$gallery="";
	$ids="";
	// Meta
	$single_preset = jaw_template_get_var('single_preset');
	$meta_date = jwOpt::getPresetValue('meta_date', '1', 'single', $single_preset);
	$meta_comments_count = jwOpt::getPresetValue('meta_comments_count', '1', 'single', $single_preset);
	?>
	<nav id="nav-single" class="row <?php echo esc_attr($prevnextnav_thumbs.' '.$prevnextnav_meta);?>">
		<div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
			<?php if (!empty($previous_post)) { ?>
				<div class="nav-previous-container navi-next-prev">
					<span class="nav-prev-icon"><?php previous_post_link('%link', '<i class="jaw-icon-next-post-left"></i> '); ?></span>
					<div class="nav-previous">
						<div class="box">
							<?php 
							$post_types = get_post_format($previous_post->ID);
							switch($post_types) {
								case "quote" :
									$post_types_cls="jaw-icon-quotes-right";
									$link="";
									$print_content="";
									break;
								case "link" :
									$post_types_cls="jaw-icon-new-tab";
									$link="";
									$print_content="";
									break;
								case "gallery" :
									$post_types_cls="";
									$link="";
									$gallery = get_post_meta($previous_post->ID, 'jaw_post_gallery', true);
									if(empty($gallery)) {
										$clear="nocont";
									}
									$ids = jwMedia::parseJson($gallery);
									foreach ($ids as $key => $id) {
										$print_content.=jwMedia::getAttachment($id, array('jaw_blog-mini'), false, array(false, 'full', jaw_template_get_counter('pagination')));
										if($key == 0) {
											break;
										}
									}
									break;
								case "video":
									$link = get_post_meta($previous_post->ID, 'jaw_post_video_link', true);
									$print_content = jwMedia::getVideoThumbnail($link);
									break;
								default:
									$post_types_cls="";
									$link="";
									$print_content="";
									break;
							}
							?>
							<div class="image <?php echo esc_attr($post_types_cls.' '.$post_types); ?>">
								<?php
								if (has_post_thumbnail($previous_post->ID)) {
									if(get_post_format($previous_post->ID) == 'video') {
										echo '<a href="'.get_permalink($previous_post->ID).'">'.jwMedia::getPostThumbnail($previous_post->ID, array('jaw_blog-mini'), false, array(false, 'full', jaw_template_get_counter('pagination'))).'<span class="jaw-video-icon small">
										'.apply_filters('jaw_default_video_icon', '<i class="jaw-icon-play4"></i>').'
										</span></a>';
									} else {
										echo '<a href="'.get_permalink($previous_post->ID).'">'.jwMedia::getPostThumbnail($previous_post->ID, array('jaw_blog-mini'), false, array(false, 'full', jaw_template_get_counter('pagination'))).'</a>';
									}
								} else {
									echo $print_content; 
									if(!$post_types) {
										$clear="nocont";
									}
								}
								?>
							</div>
							<div class="content-box <?php echo esc_attr($clear); ?> <?php echo esc_attr($post_types); ?>">
								<header>
									<h4>
										<?php previous_post_link("%link", jwUtils::crop_length(get_the_title($previous_post->ID), $prevnextnav_excerpt_title)); ?>
									</h4>
								</header>
								<ul class="blog-meta-info-top">
									<?php if ($meta_date == '1') { ?>
										<li class="post-meta-date">
											<span class="date">
												<?php echo jwRender::get_meta_date($previous_post->ID); ?>
											</span>
										</li>
									<?php } ?>
									<?php if ($meta_comments_count == '1') { ?>  
										<li class="post-meta-comments">
											<?php echo jwRender::get_meta_comments($previous_post->ID); ?>
										</li>    
									<?php } ?>
								</ul>
							</div>
						</div>
					</div>
				</div>
			<?php } ?>
			<?php if (!empty($next_post)) { ?>
				<div class="nav-next-container navi-next-prev">
					<span class="nav-next-icon"><?php next_post_link('%link', '<i class="jaw-icon-next-post-right"></i> '); ?></span>
					<div class="nav-next">
						<div class="box">
							<?php 
							$post_types = get_post_format($next_post->ID);
							switch($post_types) {
								case "quote" :
									$post_types_cls="jaw-icon-quotes-right";
									$link="";
									$print_content="";
									break;
								case "link" :
									$post_types_cls="jaw-icon-new-tab";
									$link="";
									$print_content="";
									break;
								case "gallery" :
									$post_types_cls="";
									$link="";
									$gallery = get_post_meta($next_post->ID, 'jaw_post_gallery', true);
									if(empty($gallery)) {
										$clear="nocont";
									}
									$ids = jwMedia::parseJson($gallery);
									foreach ($ids as $key => $id) {
										$print_content.=jwMedia::getAttachment($id, array('jaw_blog-mini'), false, array(false, 'full', jaw_template_get_counter('pagination')));
										if($key == 0) {
											break;
										}
									}
									break; 
								case "video":
									$link = get_post_meta($next_post->ID, 'jaw_post_video_link', true);
									$print_content = jwMedia::getVideoThumbnail($link);
									break;
								default:
									$post_types_cls="";
									$link="";
									$print_content="";
									break;
							}
							?>
							<div class="image <?php echo esc_attr($post_types_cls . ' ' . $post_types); ?>">
								<?php
								if (has_post_thumbnail($next_post->ID)) {
									if(get_post_format($next_post->ID) == 'video') {
										echo '<a href="'.get_permalink($next_post->ID).'">'.jwMedia::getPostThumbnail($next_post->ID, array('jaw_blog-mini'), false, array(false, 'full', jaw_template_get_counter('pagination'))).'<span class="jaw-video-icon small">
										'.apply_filters('jaw_default_video_icon', '<i class="jaw-icon-play4"></i>').'
										</span></a>';
									} else {
										echo '<a href="'.get_permalink($next_post->ID).'">'.jwMedia::getPostThumbnail($next_post->ID, array('jaw_blog-mini'), false, array(false, 'full', jaw_template_get_counter('pagination'))).'</a>';
									}
								} else {
									echo $print_content;
									if(!$post_types) {
										$clear="nocont";
									}
								}
								?>
							</div>
							<div class="content-box <?php echo esc_attr($clear); ?> <?php echo esc_attr($post_types); ?>">
								<header>
									<h4>
										<?php next_post_link("%link", jwUtils::crop_length(get_the_title($next_post->ID), $prevnextnav_excerpt_title)); ?>
									</h4>
								</header>
								<ul class="blog-meta-info-top">
									<?php if ($meta_date == '1') { ?>
										<li class="post-meta-date">
											<span class="date">
												<?php echo jwRender::get_meta_date($next_post->ID); ?>
											</span>
										</li>
									<?php } ?>
									<?php if ($meta_comments_count == '1') { ?>  
										<li class="post-meta-comments">
											<?php echo jwRender::get_meta_comments($next_post->ID); ?>
										</li>    
									<?php } ?>
								</ul>
							</div>
						</div>
					</div>
				</div>
			<?php } ?>
		</div>
	</nav>
<?php
}?>
<?php } ?>
<?php function jw_tmpl_sidebar__sidebar(){ ?>
<?php
 echo jwSidebars::render(jaw_template_get_var('sidebar_name')); ?>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__accordion(){ ?>
<?php global $jaw_data; ?>
<div class="row">
    <div class="col-lg-<?php echo esc_attr(jaw_template_get_var('box_size')); ?>">
        <div class="panel-group accordion">
            <?php
            echo do_shortcode(jaw_template_get_var('content'));
            ?>
        </div>
    </div>
</div>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__accordion_item(){ ?>
<?php global $jaw_data; ?>
<?php jaw_template_inc_counter('accordion'); ?>
<?php
$handle_class = 'collapsed';
if (jaw_template_get_var('class') == 'collapse in') {
    $handle_class = '';
}
?>
<div class="jaw-accordion-shortcode">
    <div class="panel-acc panel-default">
        <div class="panel-heading">
            <h4 class="panel-title">
                <a class="accordion-toggle <?php echo esc_attr($handle_class); ?>" data-toggle="collapse" data-parent="#accordion" href="#collapse<?php echo esc_attr(jaw_template_get_counter('accordion')); ?>">
                    <span class="open"></span>
                    <span class="colapse"></span>
                    <?php echo jaw_template_get_var('title'); ?>
                </a>
            </h4>
        </div>
        <div id="collapse<?php echo esc_attr(jaw_template_get_counter('accordion')); ?>" class="panel-collapse <?php echo esc_attr(jaw_template_get_var('class')); ?>"><div class="panel-body"><?php echo jaw_template_get_var('content'); ?></div></div>
    </div>
</div>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__author(){ ?>
<?php
$has_soc_icons = (get_the_author_meta('facebook', jaw_template_get_var('id')) ||
                    get_the_author_meta('twitter', jaw_template_get_var('id')) ||
                    get_the_author_meta('google', jaw_template_get_var('id')) ||
                    get_the_author_meta('youtube', jaw_template_get_var('id')) ||
                    get_the_author_meta('linkedin', jaw_template_get_var('id')) ||
                    get_the_author_meta('vimeo', jaw_template_get_var('id')) ||
                    get_the_author_meta('flickr', jaw_template_get_var('id')));
?>
<div class="row jaw-author-shortcode">
    <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
        <div class="admin_info" role="main" itemtype="http://schema.org/Person" itemscope itemprop="author">
            <div class="author_info">
                <div class="author_desc">
                    <div class="author_image">
                        <div class="author_image_wrap <?php echo esc_attr(($has_soc_icons) ? 'has-social-icons' : 'no-social-icons'); ?>">
                            <a href="<?php echo get_author_posts_url(jaw_template_get_var('id')); ?>"><?php echo get_avatar(jaw_template_get_var('id')); ?></a>
                            <div class="author_social">
                                <?php
                                if ($has_soc_icons) { 
                                    ?>
                                    <ul class="socialshare-icon">
                                        <?php if (get_the_author_meta('facebook', jaw_template_get_var('id'))) { ?>
                                            <li>
                                                <a class="link-facebook" target="_blank" href="<?php echo esc_url(get_the_author_meta('facebook', jaw_template_get_var('id'))) ?>">
                                                    <span class="jaw-icon-facebook4"></span>
                                                </a>
                                            </li>
                                        <?php } ?>
                                        <?php if (get_the_author_meta('twitter', jaw_template_get_var('id'))) { ?>
                                            <li>
                                                <a class="link-twitter" target="_blank" href="<?php echo esc_url(get_the_author_meta('twitter', jaw_template_get_var('id'))) ?>">
                                                    <span class="jaw-icon-twitter3"></span>
                                                </a>
                                            </li>
                                        <?php } ?>                            
                                        <?php if (get_the_author_meta('google', jaw_template_get_var('id'))) { ?>
                                            <li>
                                                <a class="link-google" target="_blank" href="<?php echo esc_url(get_the_author_meta('google', jaw_template_get_var('id'))) ?>">
                                                    <span class="jaw-icon-google-plus4"></span>
                                                </a>
                                            </li>
                                        <?php } ?>

                                        <?php if (get_the_author_meta('youtube', jaw_template_get_var('id'))) { ?>
                                            <li>
                                                <a class="link-youtube" target="_blank" href="<?php echo esc_url(get_the_author_meta('youtube', jaw_template_get_var('id'))) ?>">
                                                    <span class="jaw-icon-youtube"></span>
                                                </a>
                                            </li>
                                        <?php } ?>

                                        <?php if (get_the_author_meta('linkedin', jaw_template_get_var('id'))) { ?>
                                            <li>
                                                <a class="link-linkedin" target="_blank" href="<?php echo esc_url(get_the_author_meta('linkedin', jaw_template_get_var('id'))) ?>">
                                                    <span class="jaw-icon-linkedin"></span>
                                                </a>
                                            </li>
                                        <?php } ?> 

                                        <?php if (get_the_author_meta('vimeo', jaw_template_get_var('id'))) { ?>
                                            <li>
                                                <a class="link-vimeo" target="_blank" href="<?php echo esc_url(get_the_author_meta('vimeo', jaw_template_get_var('id'))) ?>">
                                                    <span class="jaw-icon-vimeo3"></span>
                                                </a>
                                            </li>
                                        <?php } ?>  

                                        <?php if (get_the_author_meta('flickr', jaw_template_get_var('id'))) { ?>
                                            <li>
                                                <a class="link-flickr" target="_blank" href="<?php echo esc_url(get_the_author_meta('flickr', jaw_template_get_var('id'))) ?>">
                                                    <span class="jaw-icon-flickr4"></span>
                                                </a>
                                            </li>
                                        <?php } ?>  

                                        <?php if (get_the_author_meta('pinterest', jaw_template_get_var('id'))) { ?>
                                            <li>
                                                <a class="link-pinterest" target="_blank" href="<?php echo esc_url(get_the_author_meta('pinterest', jaw_template_get_var('id'))) ?>">
                                                    <span class="jaw-icon-pinterest"></span>
                                                </a>
                                            </li>
                                        <?php } ?>  
                                        <?php if (get_the_author_meta('instagram', jaw_template_get_var('id'))) { ?>
                                            <li>
                                                <a class="link-instagram" target="_blank" href="<?php echo esc_url(get_the_author_meta('instagram', jaw_template_get_var('id'))) ?>">
                                                    <span class="jaw-icon-instagram"></span>
                                                </a>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <div class="author-details">
                        <div class="author_name"  itemprop="name"><a href="<?php echo esc_url(get_author_posts_url(jaw_template_get_var('id'))); ?>"  ><?php echo jaw_template_get_var('name'); ?></a></div>
                        <?php if (get_the_author_meta('profession', jaw_template_get_var('id'))) { ?>
                            <div class="author_proff"><?php echo get_the_author_meta('profession', jaw_template_get_var('id')); ?></div>
                        <?php } ?> 
                        <div class="author_description"><p><?php echo get_the_author_meta("description", jaw_template_get_var('id')); ?></p></div>
                        <div class="clear"></div>
                    </div>

                    <div class="clear"></div>
                </div>
            </div>
            <div class="clear"></div>
        </div><!-- End Content row -->

    </div>
</div>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__authors(){ ?>
<?php
$clases = '';
if (jaw_template_get_var('use_isotope', '1') == '1') {
    $clases = 'jaw-isotope';
}
?>
<div class="row jaw-authors <?php echo esc_attr($clases); ?>">
    <?php
    $authors = jaw_template_get_var('authors');
    foreach ((array) $authors as $author) {
        ?>
        <div class="one-author <?php echo esc_attr(jwLayout::col_class(jaw_template_get_var('columns', '12'))); ?> element">
            <?php
            $user = get_userdata($author);
            jaw_template_set_var('id', $author);
            if (isset($user->display_name)) {
                jaw_template_set_var('name', $user->display_name);
            }
            echo jaw_get_template_part('author', 'simple-shortcodes');
            ?>
        </div>
        <?php
    }
    ?>
</div>

<?php } ?>
<?php function jw_tmpl_simple_shortcodes__banner(){ ?>
<div class="row">
<?php  jaw_get_template_part('jaw_banner_widget', 'widgets'); ?>
</div>


<?php } ?>
<?php function jw_tmpl_simple_shortcodes__blog_carousel(){ ?>
<?php
global $jaw_data, $post;
$first = 'active';
$first_post = true;
$type = jaw_template_get_var('type', 'classical');
$post_in_slide = jaw_template_get_var('post_in_slide', 3);
$query = jaw_template_get_data();
$col_count = jaw_template_get_var("columns", 12);
jaw_template_inc_counter('carousel');

?>
<div class="row">
    <div id="jaw-blog-carousel-<?php echo esc_attr(jaw_template_get_counter('carousel')); ?>" class="jaw_blog jaw-carousel jaw-blog-carousel <?php echo esc_attr($type); ?> carousel horizontal slide navigation-<?php echo esc_attr(jaw_template_get_var('carousel_style', 'bar')); echo esc_attr(' autoslide-'.jaw_template_get_var('automatic_slide', '0')); echo esc_attr(jwLayout::col_class(12)); echo esc_attr(' clickable_image-'.jaw_template_get_var('clickable_image', '1')); ?>">
        <div class="carousel-inner">
        <?php
        $count = 0;
        $konec = true;
        while ($query->have_posts()) {
            $query->the_post();
            if(has_post_thumbnail()) {
                    if (get_post_meta(get_the_ID(), 'fw_rating_position', true) == '1') {
                        $format = 'review';
                    } else {
                        $format = get_post_format();
                    }
                    $format = apply_filters( 'jaw_post_format', $format );
                if ($count % $post_in_slide == 0) {
                    $konec = false;
                    ?>
                    <div class="item <?php echo esc_attr($first); ?>">
                        <div class="row">
                        <?php
                        $first = '';
                        if($type == "mix") {
                            echo jaw_get_template_part('content-vertical', 'content', $format);
                        } else {
                            echo jaw_get_template_part('content-' . $type, 'content', $format);
                        }
                    } else {
                        $first = '';
                        if($type == "mix") {
                        echo jaw_get_template_part('content-simple', 'content', $format);
                        } else {
                            echo jaw_get_template_part('content-' . $type, 'content', $format);
                        }
                    }
                    $count++;
                    if ($count % $post_in_slide == 0) {
                      ?>
                    </div>
                </div>
                    <?php $first_post = true; ?>
                    <?php $konec = true; ?>
                <?php } ?>            
        <?php }
        } ?>   
        <?php if ($konec) { ?>
        </div>
    <?php } else { ?>           
    </div></div></div>
<?php } ?>
    <ol class="carousel-indicators">
        <?php
            $count_items = $count/$post_in_slide;
        $first_item = "active";
        for($i=0;$i<$count_items;$i++) {
            ?><li data-target="#jaw-blog-carousel-<?php echo esc_attr(jaw_template_get_counter('carousel'));?>" data-slide-to="<?php echo esc_attr($i); ?>" class="<?php echo esc_attr($first_item); ?>"></li><?php
            $first_item="";
        }
        ?>
    </ol>
</div>
<script>
    jQuery(document).ready(function($) {
        jQuery("#jaw-blog-carousel-<?php echo esc_attr(jaw_template_get_counter('carousel')); ?>").carousel({
            interval: <?php echo esc_attr(jaw_template_get_var("slider_interval",5000)); ?>
        });
    });
</script>
</div>
<div class="clear"></div>

<?php
wp_reset_query();
?>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__blog_carousel_vertical(){ ?>
<?php
global $jaw_data, $post;
$first = 'active';
$first_post = true;
$type = jaw_template_get_var('type', 'classical');
$post_in_slide = jaw_template_get_var('post_in_slide', 3);
$query = jaw_template_get_data();
$col_count = jaw_template_get_var("columns", 12);
jaw_template_inc_counter('carousel');
?>
<div class="row">
    <div id="jaw-blog-carousel-vertical-<?php echo esc_attr(jaw_template_get_counter('carousel')); ?>" class="jaw_blog jaw-carousel jaw-blog-carousel <?php echo esc_attr($type); ?> carousel vertically slide navigation-<?php echo esc_attr(jaw_template_get_var('carousel_style', 'bar')); echo esc_attr(' autoslide-'.jaw_template_get_var('automatic_slide', '0')); echo esc_attr(jwLayout::col_class(12)); echo esc_attr(' clickable_image-'.jaw_template_get_var('clickable_image', '1')); ?>">
        <div class="carousel-inner">
        <?php
        $count = 0;
        $konec = true;
        while ($query->have_posts()) {
            $query->the_post();
            if(has_post_thumbnail()) {
                if ($count % $post_in_slide == 0) {
                    $konec = false;
                    ?>
                    <div class="item <?php echo esc_attr($first); ?>">
                        <div class="row">
                        <?php
                        $first = '';
                        if($type == "mix") {
                            echo jaw_get_template_part('content-vertical', 'content');
                            } else {
                                echo jaw_get_template_part('content-' . $type, 'content');
                            }
                        } else {
                            $first = '';
                            if($type == "mix") {
                            echo jaw_get_template_part('content-simple', 'content');
                            } else {
                                echo jaw_get_template_part('content-' . $type, 'content');
                            }
                        }
                      $count++;
                      if ($count % $post_in_slide == 0) {
                          ?>
                        </div>
                    </div>
                    <?php $first_post = true; ?>
                    <?php $konec = true; ?>
                <?php } ?>            
        <?php }
        } ?>   
        <?php if ($konec) { ?>
        </div>
    <?php } else { ?>           
    </div></div></div>
<?php } ?>
    <ol class="carousel-indicators">
        <?php
            $count_items = $count/$post_in_slide;
        $first_item = "active";
        for($i=0;$i<$count_items;$i++) {
            ?><li data-target="#jaw-blog-carousel-vertical-<?php echo esc_attr(jaw_template_get_counter('carousel')); ?>" data-slide-to="<?php echo esc_attr($i); ?>" class="<?php echo esc_attr($first_item); ?>"></li><?php
            $first_item="";
        }
        ?>
    </ol>
</div>
<script>
    jQuery(document).ready(function($) {
        jQuery("#jaw-blog-carousel-vertical-<?php echo esc_attr(jaw_template_get_counter('carousel')); ?>").carousel({
            interval: <?php echo esc_attr(jaw_template_get_var("slider_interval",5000)); ?>
        });
    });
</script>
</div>
<div class="clear"></div>

<?php
wp_reset_query();
?>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__breadcrumbs(){ ?>
<?php

/*
  Name: Simple Breadcrumb Navigation
  Description: A simple and very lightweight breadcrumb navigation that covers nested pages and categories
  Version: 1
  Author: Christian "Kriesi" Budschedl
  Author URI: http://www.kriesi.at/
 */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//SUPPORT FOR YOAST SEO PLUGIN
if (function_exists('yoast_breadcrumb')) {
    $options = get_option('wpseo_internallinks');
}
if (isset($options['breadcrumbs-enable']) && $options['breadcrumbs-enable'] === true) {
    yoast_breadcrumb('<span id="breadcrumbs" class="breadcrumb">', '</span>');
} else {//CLASSICAL BREADCRUMBS
    global $post, $blog_page;

    $markup = '';
    
    do_action("jaw_before_breadcrumbs");

    echo '<span class="breadcrumb" itemtype="http://data-vocabulary.org/Breadcrumb">';

    if (jwOpt::get_option('breadcrumb_show_home', '1') == '1') {
        echo '<a href="' . home_url('/') . '" itemprop="url">';
        echo '<span itemprop="title">' . apply_filters('jaw_breadcrumbs_title' , esc_html__('Home', "gdn-theme")) . '</span>';
        echo "</a>";
    }

    if (!is_front_page()) {
        echo esc_attr($markup);
    }

    if (is_page()) {
        $link = '';
        if ($post->post_parent) {
            $anc = array_reverse(get_post_ancestors($post->ID));
            $title = get_the_title();
            foreach ($anc as $ancestor) {
                $link .= '<a itemprop="url" href="' . get_permalink($ancestor) . '" title="' . get_the_title($ancestor) . '"><span itemprop="title">' . apply_filters('jaw_breadcrumbs_text' , get_the_title($ancestor), "page_parents" ) . '</span></a>' . esc_attr($markup);
            }
            echo esc_url($link);
        }
    }

    if (is_tag()) {
        echo '<a href="#">' . apply_filters('jaw_breadcrumbs_text' , esc_html__('Tag:', "gdn-theme") . ' ' . single_tag_title('', FALSE), "tag") . '</a>';
    } else if (is_author()) {
        $curauth = get_user_by('id', get_query_var('author'));
        echo '<a href="#">' . apply_filters('jaw_breadcrumbs_text' , esc_html__('Author:', "gdn-theme") . ' ' . esc_attr($curauth->display_name) , "author" ) . '</a>';
    } else if (is_year()) {
        $k_year = get_the_time('Y');
        echo "<a href='" . get_year_link($k_year) . "'>" . apply_filters('jaw_breadcrumbs_text' , $k_year, "year") . "</a>";
    } else if (is_month()) {
        $k_year = get_the_time('Y');
        $k_month = get_the_time('F');
        echo "<a href='" . get_year_link($k_year) . "'>" . apply_filters('jaw_breadcrumbs_text' , $k_year, "year") . "</a>";
        echo "<a href='" . get_month_link($k_year, $k_year) . "'>" . apply_filters('jaw_breadcrumbs_text' ,$k_month, "month") . "</a>";
    } else if (is_day() || is_time()) {
        $k_year = get_the_time('Y');
        $k_month = get_the_time('F');
        $k_day = get_the_time('j');
        echo "<a href='" . get_year_link($k_year) . "'>" . apply_filters('jaw_breadcrumbs_text' , $k_year, "year") . "</a>";
        echo "<a href='" . get_month_link($k_year, $k_year) . "'>" . apply_filters('jaw_breadcrumbs_text' ,$k_month, "month") . "</a>";
        echo "<a href='" . get_day_link($k_year, $k_year, $k_day) . "'>" . apply_filters('jaw_breadcrumbs_text' ,$k_day, "day") . "</a>";
    } else if (is_404()) {
        echo '<a href="#">' . apply_filters('jaw_breadcrumbs_text' , esc_html__('File not found', "gdn-theme") , "404") . '</a>';
    } else if (is_search()) {
        echo '<a href="#">' . apply_filters('jaw_breadcrumbs_text' , esc_html__('Search:', "gdn-theme") . ' ' . get_search_query() , "search" ) . '</a>';
    } else if (is_category()) {
        //POST | CATEGORY
        global $wp_query;
        $cat_id = 0;
        if (isset($wp_query->query_vars['cat'])) {
            $cat_id = $wp_query->query_vars['cat'];
        }
        if ($cat_id > 0) { // pokud neni v kategorii post neyobrazi se breadcrumb
            $cats = get_category($cat_id);
            if (isset($cats->name)) {
                $category = $cats->name;
            }
            if (sizeof($category) > 0 && $category != '') {
                echo get_category_parents($cat_id, TRUE, $markup, FALSE);
            }
        }
    } else if (is_single()) {
        $cats = get_the_category();
        if (isset($cats[0])) { // pokud neni v kategorii post neyobrazi se breadcrumb
            //Post
            $category = $cats[0]->name;
            $cat_id = $cats[0]->term_id;

            if (sizeof($category) > 0 && $category != '') {

                echo get_category_parents($cat_id, TRUE, $markup, FALSE);
            }
        }
    }
    
    if (is_singular() && jwOpt::get_option('breadcrumb_show_article', '1') == '1') {
        echo '<a href="' . get_permalink() . '">' . apply_filters('jaw_breadcrumbs_text' , jwUtils::crop_length(strip_tags(get_the_title()), jwOpt::get_option('blog_cut_breadcrumb', '-1')), "single") . '</a>';
    }
    
    do_action("jaw_after_breadcrumbs");
}
?>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__button(){ ?>
<?php
global $jaw_data;

$size = jaw_template_get_var('button_size','default');
if ($size == "default") {
    $size = "";
}
$span_class = array();
$span_class[] = 'jw-align-'.jaw_template_get_var('align','none');

$style = array();

$rgba = jaw_template_get_var('button_bg_color');
$rgb = jwUtils::rgba2rgb($rgba);

if ($rgba == $rgb) {
    $style[] = 'background-color: ' . $rgba;
} else {
    $style[] = 'background-color: ' . $rgb;
    $style[] = 'background-color: ' . $rgba;
}
$style[] = 'color: ' . jaw_template_get_var('button_font_color');
?>
<span class="jaw_button <?php echo esc_attr(implode( ' ', $span_class)); ?>">
    <a type="button" class="btn <?php echo esc_attr($size); ?> jw-effect-ripple" href="<?php echo esc_url(jaw_template_get_var('link')); ?>" target="<?php echo esc_attr(jaw_template_get_var('target')); ?>" style="<?php echo esc_attr(implode(';', $style)); ?>">
        <?php echo jaw_template_get_var('label'); ?>
    </a>
</span>

<?php } ?>
<?php function jw_tmpl_simple_shortcodes__chart_item(){ ?>
<?php global $jaw_data; ?>
<li>
<span class="chart-legend-color" style="background: <?php echo jaw_template_get_var('color',''); ?>" ></span><?php echo jaw_template_get_var('title',''); ?>
</li>
<script>
    jQuery(document).ready(function(){
        data_<?php echo jaw_template_get_counter('chart');?>.push({
            value: <?php echo jaw_template_get_var('value',''); ?>,
            color:"<?php echo jaw_template_get_var('color',''); ?>"
        });
    });
</script>


<?php } ?>
<?php function jw_tmpl_simple_shortcodes__circle_chart(){ ?>
<?php global $jaw_data; 
jaw_template_inc_counter('chart');?>
<script>
    var data_<?php echo jaw_template_get_counter('chart');?> = new Array;
</script>

<div class="row">
    <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
        <div class="circle-progressbar">
            <?php
            $chart_type = jaw_template_get_var('chart_type', 'Pie');
            ?>
            <canvas id="chart-<?php echo esc_attr(jaw_template_get_counter('chart')); ?>" width="<?php echo jaw_template_get_var('size', '150'); ?>" height="<?php echo jaw_template_get_var('size', '150'); ?>"></canvas>
            <ul class="chart-legend"><?php echo do_shortcode(jaw_template_get_var('content', '')); ?></ul>
        </div>
    </div>
</div>

<script>
    jQuery(document).ready(function() {
        var ctx = jQuery("#chart-<?php echo jaw_template_get_counter('chart'); ?>").get(0).getContext("2d");
        new Chart(ctx).<?php echo esc_attr($chart_type); ?>(data_<?php echo jaw_template_get_counter('chart');?>);
    });
</script>

<?php } ?>
<?php function jw_tmpl_simple_shortcodes__clear(){ ?>
<div class="clear"></div>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__columns(){ ?>
<?php
$class = array();
$class[] = jaw_template_get_var('type', 'one-half');
if (jaw_template_get_var('last', '') == 'true') {
    $class[] = 'last';
}
?>
<div class="jaw-column <?php echo esc_attr(implode(" ", $class)); ?>">
    <?php echo do_shortcode(jaw_template_get_var('content', '')); ?>
</div>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__comments(){ ?>
<?php global $jaw_data;
$comments=(jaw_template_get_var('comments'));  
?>
<div class="row">
    <div class="col-lg-12">
        <div   class="comments-block">
            <?php
                
                 foreach ($comments as $comment) { ?>                    
                <div   class="one-comment">
                    <div class="comment-avatar">
                        <?php
                        $avatar_size = 68;
                        if ('0' != $comment->comment_parent)
                            $avatar_size = 68;
                        echo get_avatar($comment, $avatar_size);
                        ?>  
                    </div>
                    <div class="comment-info">
                        <div class="comment-content">
                            <a href="<?php echo get_comment_link($comment); ?>"><?php echo jwUtils::crop_length($comment->comment_content, jaw_template_get_var('letter_excerpt', 35)); ?></a>
                        </div>
                        <div class="comment-meta-data">
                            <div class="comment-date">
                                <?php echo jwRender::get_meta_date("M d. Y"); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
</div>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__contact(){ ?>
<?php global $jaw_data; ?>
<div class="jaw-contact-shortcode">
    <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12 contact-days-container contact-column">
        <?php if (jaw_template_get_var('title', '') != '') { ?>
            <div class = "contact-name">
                <h5><?php echo jaw_template_get_var('title'); ?></h5>
            </div>
        <?php } ?>
        <?php if (jaw_template_get_var('desc', '') != '') { ?>
            <div class="contact-desc">
                <p><?php echo jaw_template_get_var('desc');
            ?></p>
            </div>
        <?php } ?>
    </div>

    <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12 contact-address-container contact-column">
        <?php if (jaw_template_get_var('street', '') != '' || jaw_template_get_var('city', '') != '' || jaw_template_get_var('country', '') != '') { ?>
            <div class="contact-address">
                <?php
                $print = "";
                if (jaw_template_get_var('street', '') != '') {
                    ?>
                    <?php $print .= jaw_template_get_var('street') . '</br>';
                    ?>
                <?php } ?>
                <?php if (jaw_template_get_var('city', '') != '') { ?>
                    <?php $print .= jaw_template_get_var('city') . ', ';
                    ?>
                <?php } ?>
                <?php if (jaw_template_get_var('country', '') != '') { ?>
                    <?php $print.= jaw_template_get_var('country');
                    ?>
                <?php } ?>
                <?php if (jaw_template_get_var('show_titles', 'icon') == 'icon') { ?>
                    <i class="jaw-icon-home2"></i>
                <?php }
                ?> <p><?php echo $print; ?> </p>
            </div>
        <?php } ?>
        <div class="contact-other">
            <?php if (jaw_template_get_var('mail', '') != '') { ?>
                <div class="contact-mail">
                    <?php if (jaw_template_get_var('show_titles', 'icon') == 'icon') { ?>
                        <i class="jaw-icon-mail4"></i>
                    <?php } else { ?>
                        <span><?php echo esc_html__('E-mail:', "gdn-theme"); ?></span> 
                    <?php } ?>
                    <p><a href="mailto:<?php echo jaw_template_get_var('mail', ''); ?>"><?php echo ' ' . jaw_template_get_var('mail', ''); ?></a></p>
                </div>
            <?php } ?>

            <?php if (jaw_template_get_var('phone', '') != '') { ?>
                <div itemscope itemtype="http://schema.org/LocalBusiness" class="contact-phone">
                    <?php if (jaw_template_get_var('show_titles', 'icon') == 'icon') { ?>
                        <i class="jaw-icon-phone2"></i>
                    <?php } else { ?>
                        <span itemprop="name"><?php echo esc_html__('Phone:', "gdn-theme"); ?></span> 
                    <?php } ?>
                    <p itemprop="telephone"><a href="tel:<?php echo jaw_template_get_var('phone', ''); ?>"><?php echo ' ' . jaw_template_get_var('phone', ''); ?></a></p>
                </div>
            <?php } ?>

            <?php if (jaw_template_get_var('skype', '') != '') { ?>
                <div class="contact-skype">
                    <?php if (jaw_template_get_var('show_titles', 'icon') == 'icon') { ?>
                        <i class="jaw-icon-skype"></i>
                    <?php } else { ?>
                        <span><?php echo esc_html__('Skype:', "gdn-theme"); ?></span> 
                    <?php } ?>
                    <p><a href="callto:<?php echo str_replace(' ', '', jaw_template_get_var('skype', '')); ?>"><?php echo ' ' . jaw_template_get_var('skype', ''); ?></a></p>
                </div>
            <?php } ?>
        </div>
    </div>

    <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12 contact-days-container contact-column">
        <div class="contact-time">
            <div class="contact-open-hours"><h5><?php echo esc_html__('Opening hours', "gdn-theme"); ?></h5></div>
            <div class="contact-oh-items">
                <?php if (jaw_template_get_var('mo', '') != '') { ?>
                    <div class="row contact-time-mo">
                        <span class="col-lg-6"><?php echo esc_html__('Monday:', "gdn-theme") . '</span><span class="col-lg-6"> ' . jaw_template_get_var('mo'); ?></span>
                    </div>
                <?php } ?>

                <?php if (jaw_template_get_var('tu', '') != '') { ?>
                    <div class="row contact-time-mo">
                        <span class="col-lg-6"><?php echo esc_html__('Tuesday:', "gdn-theme") . '</span><span class="col-lg-6">' . jaw_template_get_var('tu'); ?></span>
                    </div>
                <?php } ?>
                <?php if (jaw_template_get_var('we', '') != '') { ?>
                    <div class="row contact-time-mo">
                        <span class="col-lg-6"><?php echo esc_html__('Wednesday:', "gdn-theme") . '</span><span class="col-lg-6"> ' . jaw_template_get_var('we'); ?></span>
                    </div>
                <?php } ?>
                <?php if (jaw_template_get_var('th', '') != '') { ?>
                    <div class="row contact-time-mo">
                        <span class="col-lg-6"><?php echo esc_html__('Thursday:', "gdn-theme") . '</span><span class="col-lg-6"> ' . jaw_template_get_var('th'); ?></span>
                    </div>
                <?php } ?>
                <?php if (jaw_template_get_var('fr', '') != '') { ?>
                    <div class="row contact-time-mo">
                        <span class="col-lg-6"><?php echo esc_html__('Friday:', "gdn-theme") . '</span><span class="col-lg-6"> ' . jaw_template_get_var('fr'); ?></span>
                    </div>
                <?php } ?>
                <?php if (jaw_template_get_var('sa', '') != '') { ?>
                    <div class="row contact-time-mo">
                        <span class="col-lg-6"><?php echo esc_html__('Saturday:', "gdn-theme") . '</span><span class="col-lg-6"> ' . jaw_template_get_var('sa'); ?></span>
                    </div>
                <?php } ?>
                <?php if (jaw_template_get_var('su', '') != '') { ?>
                    <div class="row contact-time-mo">
                        <span class="col-lg-6"><?php echo esc_html__('Sunday:', "gdn-theme") . '</span><span class="col-lg-6"> ' . jaw_template_get_var('su'); ?></span>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__container_background(){ ?>
<?php
$class = '';

$bg_image = jaw_template_get_var('bg_image', '');
$bg_video_mp4 = jaw_template_get_var('bg_video_mp4', '');
$bg_video_url = jaw_template_get_var('bg_video_url', '');

$bg_paralax = jaw_template_get_var('bg_paralax', 'none');

$class .= jaw_template_get_var('bg_pattern', '1');


?>
<div class="jaw-mediabg <?php echo esc_attr($class) . ' jw-paralax-' . esc_attr($bg_paralax); ?>">
    <div class="background-wrap" >
        <?php
        if ($bg_video_url != '') {
            $video = jwMedia::getVideoInfo($bg_video_url);
            $video_frame_id = jaw_template_inc_counter('bg_item');
            if ($video->domain == 'youtube') {
                ?>
                <div id="bg_item_<?php echo esc_attr($video_frame_id); ?>" class="video jaw-keep-ratio jaw-bg-item"></div>
                <script>
                    var tag = document.createElement('script');
                    tag.src = "http://www.youtube.com/player_api";
                    var firstScriptTag = document.getElementsByTagName('script')[0];
                    firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);

                    var player;
                    function onYouTubePlayerAPIReady() {
                        player = new YT.Player('bg_item_<?php echo esc_attr($video_frame_id); ?>', {
                            playerVars: {'autoplay': 1, 'controls': 0, 'loop': 1, 'playlist': '<?php echo esc_attr($video->id); ?>'},
                            videoId: '<?php echo esc_attr($video->id); ?>',
                            events: {
                                'onReady': onPlayerReady}
                        });
                    }
                    function onPlayerReady(event) {
                        event.target.mute();
                    }
                </script>
                <?php
            }
        } else if ($bg_video_mp4 != '') {

            $width = 1920;
            $height = 1080;

            $meta = wp_get_attachment_metadata($bg_video_mp4);
            if (isset($meta['width'])) {
                $width = $meta['width'];
            }
            if (isset($meta['height'])) {
                $height = $meta['height'];
            }
            $mp4 = wp_get_attachment_url($bg_video_mp4);

            ?>
            <video  class="jaw-bg-video jaw-bg-item" width="<?php echo esc_attr($width); ?>" height="<?php echo esc_attr($height); ?>"  preload="auto" loop="true" data-setup="{}"  autoplay="" >
                <source src="<?php echo esc_url($mp4); ?>" type="video/mp4">

            </video>
            <?php
            if ($bg_image != '') {
                echo jwMedia::getAttachment($bg_image, array('full'), false, array(), array("class" => "jaw-bg-item jaw-bg-video-image"));
            }
        } else if ($bg_image != '') {
            
            if($bg_paralax == 'static'){
                echo '<div class="jaw-bg-item jaw-bg-paralax-static" style="background-image:url(\''.esc_url(jwMedia::getAttachmentSrc($bg_image, 'full')).'\')"></div>';
            }else{
                echo jwMedia::getAttachment($bg_image, array('full'), false, array(), array("class" => "jaw-bg-item"));
            }
            
        }
        ?>


    </div>
</div>

<?php } ?>
<?php function jw_tmpl_simple_shortcodes__container(){ ?>
<?php global $jaw_data; ?>
<?php
    $class = array();
    $bg_image = jaw_template_get_var('bg_image', '');
    $bg_video_mp4 = jaw_template_get_var('bg_video_mp4', '');
    $bg_video_url = jaw_template_get_var('bg_video_url', '');
    if($bg_image != '' || $bg_video_mp4 != '' || $bg_video_url!= ''){
        $class[] = 'jaw-container-has-background';
    }
    $class[] = jwLayout::col_class(jaw_template_get_var('size', 12));
    $class[] = jaw_template_get_var('class');
    $class[] = 'fullwidth-'.jaw_template_get_var('fullwidth');
    $class[] = 'post-preset-' . jaw_template_get_var('color', jwOpt::get_option('main_color'));
    $class[] = jaw_template_get_var('space_after', 'space_after');
    $class[] = 'jaw-animate-'.jaw_template_get_var('animation', 'none');
    $class[] = 'show-on-'.jaw_template_get_var('show_on_devices');
    
?>
<div 
    <?php if(jaw_template_get_var('el_id', '') !== ''){ ?> 
        id="<?php echo jaw_template_get_var('el_id', ''); ?>"
        <?php $class[] = 'has-onepage-id';?>
    <?php } ?>
    class="builder-section jaw-container <?php echo esc_attr(implode(' ',$class)); ?>" >
    <?php echo jwUtils::customizer_preview_preset("Conteiner", jaw_template_get_var('color', jwOpt::get_option('main_color'))); ?>
    <div class="row jaw-container-content jw-fixed-sidebar-box">
        <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
            <?php echo jaw_get_template_part('container-background', 'simple-shortcodes'); ?>
            <?php
            $content = jaw_template_get_var('content');
            if (jaw_template_get_var('bar_type', '') != '') {
                echo jaw_get_template_part('section_bar', 'simple-shortcodes');
            }
            ?>
            <div class="row jw-fw-content" style="padding-top: <?php echo esc_attr(jaw_template_get_var('padding_top', '0')); ?>px;padding-bottom: <?php echo esc_attr(jaw_template_get_var('padding_bottom', '0')); ?>px;padding-left: <?php echo esc_attr(jaw_template_get_var('padding_left', '0')); ?>px;padding-right: <?php echo esc_attr(jaw_template_get_var('padding_right', '0')); ?>px;">
                <?php echo do_shortcode($content);
                ?>
            </div>
        </div>
    </div>
</div>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__countdown(){ ?>
<?php
global $jaw_data;
?>

<div class="row timeTo-countdown">
    <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
        <div class="timeTo-counter <?php echo esc_attr(jaw_template_get_var('hide_days', 'show-days')); ?> <?php echo esc_attr(jaw_template_get_var('hide_sec', 'show-sec')); ?>">
            <div id="counter<?php echo esc_attr(jaw_template_get_var('id')); ?>" style="color:<?php echo jaw_template_get_var('color'); ?>"></div>
        </div>
    </div>
</div>
<script>jQuery(document).ready(function() {
        var a = new Date;
        a.setYear(<?php echo esc_attr(jaw_template_get_var('years')); ?>), a.setMonth(<?php echo esc_attr(jaw_template_get_var('months')); ?>), a.setDate(<?php echo esc_attr(jaw_template_get_var('days')); ?>), a.setHours(<?php echo esc_attr(jaw_template_get_var('hours')); ?>), a.setMinutes(<?php echo esc_attr(jaw_template_get_var('minutes')); ?>), a.setSeconds(<?php echo esc_attr(jaw_template_get_var('seconds')); ?>)
<?php
echo "jQuery('#counter" . esc_attr(jaw_template_get_var('id')) . "').timeTo({timeTo:new Date(a), displayDays:true,titleDays:'" . esc_html__('days', "gdn-theme") . "',titleHours:'" . esc_html__('hrs', "gdn-theme") . "',titleMinutes:'" . esc_html__('mnts', "gdn-theme") . "',titleSeconds:'" . esc_html__('sec', "gdn-theme") . "'})";
?>
    });</script>  

<?php } ?>
<?php function jw_tmpl_simple_shortcodes__counter(){ ?>
<span class="jaw-counter" style="font-size:<?php echo esc_attr(jaw_template_get_var('size','48')); ?>px" data-from="0" data-to="<?php echo esc_attr(jaw_template_get_var('number','100')); ?>">0</span>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__cta(){ ?>
<?php
global $jaw_data;

$style = array();
$style[] = 'background: ' . jaw_template_get_var('color', '#434343');
$style[] = 'color: ' . jaw_template_get_var('text_color', '#ffffff');

$button_possition = jaw_template_get_var('cta_button_possition');
$button_size = jaw_template_get_var('cta_button_size');

$button_style_color = array();
$button_style_color[] = 'background-color: ' . jaw_template_get_var('cta_button_bg_color', '#434343');
$button_style_color[] = 'color: ' . jaw_template_get_var('cta_button_font_color', '#ffffff');

$link = jaw_template_get_var('link', "#");
?>

  <div class="row">
    <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">

      <?php if ($button_possition == 'right') { ?>
        <div class="ctv_section" style="<?php echo implode(';', $style); ?>;">
          <div class="cta-table right">
            <div class="cta-table-wrapper">
              <div class="cta-table-content">
                <div class="textarea fullwidht-textarea">
                  <?php echo do_shortcode(jaw_template_get_var('text')); ?>
                </div>
              </div>
              <?php
    ?>
                <div class="cta-table-button jaw_button">
                  <a href="<?php echo esc_attr($link); ?>" target="<?php echo esc_attr(jaw_template_get_var('target')); ?>">
                    <button type="button" class="btn jw-effect-ripple <?php echo esc_attr($button_size); ?>" style="<?php echo implode(';', $button_style_color); ?>"><?php echo jaw_template_get_var('button_text'); ?></button>
                    </a>
                </div>
                <div class="clear"></div>
            </div>
          </div>
        </div>
        <?php } ?>

          <?php if ($button_possition == 'left') { ?>
            <div class="ctv_section" style="<?php echo implode(';', $style); ?>;">
              <div class="cta-table left">
                <div class="cta-table-wrapper">
                  <div class="cta-table-button jaw_button">
                    <a href="<?php echo esc_url($link); ?>" target="<?php echo esc_attr(jaw_template_get_var('target')); ?>">
    <button type="button" class="btn jw-effect-ripple <?php echo esc_attr($button_size); ?>" style="<?php echo implode(';', $button_style_color); ?>"><?php echo jaw_template_get_var('button_text'); ?></button>
    </a>
                  </div>
                  <div class="cta-table-content">
                    <div class="textarea fullwidht-textarea">
                      <?php echo do_shortcode(jaw_template_get_var('text')); ?>
                    </div>
                  </div>
                  <div class="clear"></div>
                </div>
              </div>
            </div>
            <?php } ?>

              <?php if ($button_possition == 'top') { ?>
                <div class="ctv_section" style="<?php echo implode(';', $style); ?>;">
                  <div class="cta-table top">
                      <div class="cta-table-wrapper" >
                    <div class="jaw_button cta-table-button">
                      <a href="<?php echo esc_url($link); ?>" target="<?php echo esc_attr(jaw_template_get_var('target')); ?>">
    <button type="button" class="btn jw-effect-ripple <?php echo esc_attr($button_size); ?>" style="<?php echo implode(';', $button_style_color); ?>"><?php echo jaw_template_get_var('button_text'); ?></button>
    </a>
                    </div>
                    <div class="cta-table-content">
                      <div class="textarea fullwidht-textarea">
                        <?php echo do_shortcode(jaw_template_get_var('text')); ?>
                      </div>
                    </div>
                    <div class="clear"></div>
                  </div>
                  </div>
                </div>
                <?php } ?>

                  <?php if ($button_possition == 'bottom') { ?>
                    <div class="ctv_section" style="<?php echo implode(';', $style); ?>;">
                      <div class="cta-table bottom">
                          <div class="cta-table-wrapper" >
                        <div class="cta-table-content">
                          <div class="textarea fullwidht-textarea">
                            <?php echo do_shortcode(jaw_template_get_var('text')); ?>
                          </div>
                        </div>
                        <div class="jaw_button cta-table-button">
                          <a href="<?php echo esc_url($link); ?>" target="<?php echo esc_attr(jaw_template_get_var('target')); ?>">
    <button type="button" class="btn jw-effect-ripple <?php echo esc_attr($button_size); ?>" style="<?php echo implode(';', $button_style_color); ?>"><?php echo jaw_template_get_var('button_text'); ?></button>
    </a>
                        </div>
                        <div class="clear"></div>
                      </div>
                      </div>
                    </div>
                    <?php } ?>

    </div>
  </div>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__custom_code(){ ?>
<?php global $jaw_data; ?>

<?php echo do_shortcode(jaw_template_get_var('html_code')); ?>
<?php if (jaw_template_get_var('js_code', '') != '') { ?>
    <script>
        jQuery(document).ready(function() {
            <?php echo do_shortcode(jaw_template_get_var('js_code')); ?>
        })
    </script>
<?php } ?>

<?php } ?>
<?php function jw_tmpl_simple_shortcodes__custom_text(){ ?>
<?php global $jaw_data; 
$style = '';
if(jaw_template_get_var('use_bg','0') == '1'){
$style = 'style="background:url(\''.jaw_template_get_var('bg_image','').'\') 50% 0 '.jaw_template_get_var('bg_color','#000000').'; min-height:'.jaw_template_get_var('height','50').'px;padding-top:'.jaw_template_get_var('padding-top','0').'px;"';
}

?>

<div class="row">
    <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?> jw-custom-text">
        <div <?php echo esc_attr($style); ?>>
        <?php echo do_shortcode(jaw_template_get_var('custom_text')); ?>
        </div>
    </div>
</div>

<?php } ?>
<?php function jw_tmpl_simple_shortcodes__divider(){ ?>
<?php global $jaw_data;
$style="";
if(jaw_template_get_var('space_size', '0') >= 0){
    $style = 'padding-top:'. jaw_template_get_var('space_size', '0').'px';
}else{
    $style = 'margin-top:'. jaw_template_get_var('space_size', '0').'px';
}
if(jaw_template_get_var('space_after_size', '0') == 0){
    $style_after = '';
}else{
    $style_after = 'margin-bottom:'. jaw_template_get_var('space_after_size', '0').'px';
}
$class = array();
$class[] = jwLayout::col_class(jaw_template_get_var('size', 12));
$class[] = jaw_template_get_var('class');
$class[] = jaw_template_get_var('space_after', 'space_after');
$class[] = 'show-on-'.jaw_template_get_var('show_on_devices', 'phone');
?>
<div class="builder-section jaw-divider <?php echo esc_attr(implode(' ',$class)); ?>" >
        <div class="divider divider-<?php echo esc_attr(jaw_template_get_var('divider_style', 'none')); ?>  <?php echo esc_attr(jaw_template_get_var('clear', 'clear-off')); ?>" style="border-bottom-style:<?php echo jaw_template_get_var('divider_style', 'solid'); ?>; border-bottom-width:<?php echo jaw_template_get_var('width', '1'); ?>px;border-bottom-color:<?php echo jaw_template_get_var('color', '#000000'); ?>; <?php echo esc_attr($style).'; '.$style_after; ?>;">
            <?php if (jaw_template_get_var('divider_totop', '1') == '1') { ?>   
                <div class="to-top-<?php echo esc_attr(jaw_template_get_var('totop_align', 'right')); ?>"><a class="divider_to_top" href="#"><?php echo jaw_template_get_var('divider_title', ''); ?></a></div>
                <?php } ?>
        </div>
</div>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__dropcap(){ ?>
<?php
$main = jaw_template_get_var('content');
if(!empty($main)) {
	echo '<span class="jaw-dropcap">'.$main.'</span>';
}?>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__gallery(){ ?>
<?php
$gallery = jaw_template_get_var('gallery');
$pp = jaw_template_get_var('lightbox', '0');
jaw_template_inc_counter('gallery');
?>
<div class="jaw-gallery-shortcode">
    <div  class="gallery-slider slider">

        <?php
        foreach ($gallery as $key => $id) {

            $thumbnail_image = get_posts(array('p' => $id['id'], 'post_type' => 'attachment'));
            if (isset($thumbnail_image[0]->post_excerpt)) {
                $attachment_meta = $thumbnail_image[0]->post_excerpt;
            }
            echo '<div class="jaw-keep-ratio">';
            echo '<div class="jaw-slider-img">';
            echo '<div class="jaw-slider-wrap">';
            echo jwMedia::getAttachment($id['id'], array('large','full'), true, array($pp, 'full', jaw_template_get_counter('pagination')), array("class" => "jaw-sub-keep-ratio"));
            if ($attachment_meta != '') {
                echo '<span class="jaw-slider-caption">';
                echo '<span class="jaw-slider-caption-wrap">';
                echo esc_attr($attachment_meta);
                echo '</span>';
                echo '</span>';
            }
            echo '</div>';
            echo '</div>';
            echo '</div>';
        }
        ?>

    </div>
    <div  class="gallery-thumbnails slider">

        <?php
        foreach ($gallery as $key => $id) {
            echo '<div >';
            echo jwMedia::getAttachment($id['id'], array('jaw_blog-16_9'));
            echo '</div>';
        }
        ?>    

    </div> 
</div>
<div class="clear"></div>
<?php
jaw_template_set_data(array()); //mate to JaW Gallery pod postem?>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__google_map(){ ?>
<?php global $jaw_data; ?>

<?php
ob_start();
wp_register_script('g_maps', 'https://maps.googleapis.com/maps/api/js?key=AIzaSyDQawavpg46SmVMRFtdPl1YKzSDQc0UI6U&callback=JawGoogleMapLoaded', array('jquery'), false, true);
wp_enqueue_script('g_maps');
// origin and destination
echo '<div class="jaw-g-maps row">';
echo '<div class="col-lg-12">';
echo '
        <div id="google_map_' . esc_attr(jaw_template_get_var('id')) . '" class="google_map" style="' . jaw_template_get_var('width') . jaw_template_get_var('height') . '"></div>';
echo '</div>';
echo '</div>';


echo ' <script type="text/javascript">
jQuery("body").on("jaw_g_maps",function(){
    var location = new google.maps.LatLng(' . esc_attr(jaw_template_get_var('latitude')) . ', ' . esc_attr(jaw_template_get_var('longitude')) . ');
    var mapOptions = {
        center: location,
        zoom: ' . esc_attr(jaw_template_get_var('zoom')) . ',
        panControl: ' . esc_attr(jaw_template_get_var('controls')) . ',
        zoomControl: ' . esc_attr(jaw_template_get_var('controls')) . ',
        zoomControlOptions: {
            style: google.maps.ZoomControlStyle.SMALL,
            position: google.maps.ControlPosition.TOP_LEFT
        },
        mapTypeControl: ' . esc_attr(jaw_template_get_var('controls')) . ',
        mapTypeControlOptions: {
            style: google.maps.MapTypeControlStyle.DROPDOWN_MENU,
            position: google.maps.ControlPosition.TOP_RIGHT
        },
        scaleControl: false,
        streetViewControl: false,
        overviewMapControl: false,
        draggable: ' . esc_attr(jaw_template_get_var('dragable')) . ',
        disableDoubleClickZoom: ' . esc_attr(jaw_template_get_var('disabledoubleclickzoom')) . ',
        scrollwheel: ' . esc_attr(jaw_template_get_var('scrollwheel')) . ',
        mapTypeId: google.maps.MapTypeId.' . esc_attr(jaw_template_get_var('maptype')) . '
    };
    var map = new google.maps.Map(document.getElementById("google_map_' . esc_attr(jaw_template_get_var('id')) . '"), mapOptions);';
    
// default marker
if(jaw_template_get_var("marker","1") == "1") {
    echo '
        var contentString = ' . json_encode(jaw_template_get_var('description')) . ';
        var infowindow = new google.maps.InfoWindow({
            content: contentString
        });
        var marker = new google.maps.Marker({
            position: location,
            map: map
        });';
    if (jaw_template_get_var('description', '') != '') {
        if (jaw_template_get_var('description_open', 'start') == 'start') {
            echo 'infowindow.setContent(' . json_encode(jaw_template_get_var('description')) . ');';
            echo 'infowindow.open(map,marker);';
        }
        echo '
        google.maps.event.addListener(marker, "click", function() {
        infowindow.setContent(' . json_encode(jaw_template_get_var('description')) . ');
            infowindow.open(map,this);
        });';
    }
}

// origin and destination
if(jaw_template_get_var('waypoint', '1') == "1") {
    echo '
    var dirService = new google.maps.DirectionsService();
    var dirRenderer = new google.maps.DirectionsRenderer({suppressMarkers: true});
    dirRenderer.setMap(map);
    ';
    echo 'var request = {
    origin: "'.jaw_template_get_var("latitude_origins").','.jaw_template_get_var("longitude_origins").'",
    destination: "'.jaw_template_get_var("latitude_destination").','.jaw_template_get_var("longitude_destination").'",
    travelMode: google.maps.TravelMode.'.jaw_template_get_var("maptypetravel").'
    };';
}

// multiple markers
if (jaw_template_get_var('markers')) {
    // g multiple map markers
    echo do_shortcode(jaw_template_get_var('markers'));
}

// origin and destination
if(jaw_template_get_var('waypoint', '1') == "1") {
    echo 'dirService.route(request, function(result, status) {
        if (status == google.maps.DirectionsStatus.OK) {
            dirRenderer.setDirections(result);
        } else {
            console.log(result);
        }
    });';
}
echo '});
</script>';

echo ob_get_clean();



?>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__google_map_marker(){ ?>
<?php

global $jaw_data; 
    echo '
        var contentString = ' . (json_encode(jaw_template_get_var('description_marker'))) . ';
        var infowindow = new google.maps.InfoWindow({
            content: contentString
        });
        var marker = new google.maps.Marker({
        position: new google.maps.LatLng(' . ((jaw_template_get_var('latitude'))) .','. ((jaw_template_get_var('longitude'))).'),
        map: map
    });';
if (jaw_template_get_var('description_marker', '') != '') {
    if (jaw_template_get_var('descriptionopen', '1') == '1') {
        
        echo 'infowindow.setContent(' . (json_encode(jaw_template_get_var('description_marker'))) . ');';
        echo 'infowindow.open(map,marker);';
    }
    echo ' 
    google.maps.event.addListener(marker, "click", function() {
    infowindow.setContent(' . (json_encode(jaw_template_get_var('description_marker'))) . ');
        infowindow.open(map,this);
    });'; 
}?>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__google_map_waypoint(){ ?>
<?php 

echo 'request.waypoints = request.waypoints || [];'; // undefined
echo 'request.waypoints.push({location:"'.esc_attr(jaw_template_get_var("latitude")).','.esc_attr(jaw_template_get_var("longitude")).'"});';?>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__googlefonts(){ ?>
<?php
global $jaw_data;
?>
<link media="all" type="text/css" href="http://fonts.googleapis.com/css?family=<?php echo jaw_template_get_var('font_family');?>" rel="stylesheet">

<span class="jaw-google-fonts" style="font-family:<?php echo jaw_template_get_var('font_family'); ?>;font-size:<?php echo jaw_template_get_var('font_size'); ?>px;color:<?php echo jaw_template_get_var('color'); ?>;">
    <?php echo jaw_template_get_var('content'); ?>
</span>


<?php } ?>
<?php function jw_tmpl_simple_shortcodes__h(){ ?>
<<?php echo esc_attr(jaw_template_get_var('code')); ?>><?php echo jaw_template_get_var('content'); ?></<?php echo esc_attr(jaw_template_get_var('code')); ?>>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__highlight(){ ?>
<?php
$main = jaw_template_get_var('content');
if(!empty($main)) {
	echo '<span class="jaw-highlight">'.$main.'</span>';
}?>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__html_carousel(){ ?>
<?php
global $wp_query, $jaw_data;

jaw_template_inc_counter('carousel');

$items_in_slide = jaw_template_get_var('items_in_slide', 1);
$one_width = 12/$items_in_slide;
$content = jaw_template_get_var('content');
$first = 'active';

jaw_template_set_var('items_in_slide', $items_in_slide);
jaw_template_set_var('one_width', $one_width);
jaw_template_set_var('first', $first);
jaw_template_set_var('konec', 'true');
jaw_template_set_var('count', '0');


?>
<div class="row">
<div id="jaw-carousel-<?php echo esc_attr(jaw_template_get_counter('carousel')); ?>" class="carousel jaw-carousel horizontal slide navigation-<?php echo esc_attr(jaw_template_get_var('carousel_style', 'bar')). ' ' . esc_attr(jwLayout::col_class(12)); ?>">
    <!-- Wrapper for slides -->
    <div class="carousel-inner">
        <?php
            echo do_shortcode($content);
        ?>        
    <?php if (jaw_template_get_var('konec', 'true') == 'true') { ?>
        </div>
    <?php } else { ?>           
    </div></div></div>
    <?php } ?>

<ol class="carousel-indicators">
    <?php
    $count_items = jaw_template_get_var('count', '0')/jaw_template_get_var('items_in_slide', '1');
    $first_item = "active";
    for($i=0;$i<$count_items;$i++) {
        ?><li data-target="#jaw-carousel-<?php echo esc_attr(jaw_template_get_counter('carousel')); ?>" data-slide-to="<?php echo esc_attr($i); ?>" class="<?php echo esc_attr($first_item); ?>"></li><?php
        $first_item="";
    }
    ?>
</ol>

</div>
<script>
    jQuery(document).ready(function($) {
        jQuery("#jaw-carousel-<?php echo esc_attr(jaw_template_get_counter('carousel')); ?>").carousel({
            interval: <?php echo jaw_template_get_var("slider_interval",5000); ?>
        });
    });
</script>

<div class="clear"></div>

</div>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__html_carousel_one(){ ?>
<?php $count = jaw_template_get_var('count', '0'); ?>
<?php if ($count % jaw_template_get_var('items_in_slide', '1') == 0) {
    jaw_template_set_var('konec', 'false');
?>
<div class="item <?php echo esc_attr(jaw_template_get_var('first', '')); ?>">
    <div class="row">
<?php } ?>

        <div class="<?php echo esc_attr(jwLayout::col_class(jaw_template_get_var('one_width', '12'))); ?>">
        <?php echo do_shortcode(jaw_template_get_var('content','')); ?>
        </div>
<?php
    $count++;
    jaw_template_set_var('count', $count); 
    if ($count % jaw_template_get_var('items_in_slide', '1') == 0) {
        jaw_template_set_var('konec', 'true');
        ?>
            </div>
        </div>
        <?php 
    }

?>
<?php jaw_template_set_var('first', ''); ?>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__icon(){ ?>
<?php global $jaw_data; ?>
<?php $id = rand(0, 1000); ?>
<span id="icon-<?php echo esc_attr($id); ?>" class="<?php echo esc_attr(jaw_template_get_var('align', 'none')); ?> jw-el-icon">
    <span  class="<?php echo esc_attr(jaw_template_get_var('icon')); ?> icon"  style=" font-size: <?php echo esc_attr(jaw_template_get_var('size')); ?>px; color:<?php echo jaw_template_get_var('color'); ?>"></span>
</span>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__iframe(){ ?>
<?php global $jaw_data; ?>
<?php
$class= array();
if(jaw_template_get_var('keep_ratio', '0')){
    $class[] = "jaw-keep-ratio";
}
?>
<iframe class="iframe jaw-iframe <?php echo esc_attr(implode(' ' , $class)); ?>" src="<?php echo esc_url(jaw_template_get_var('src', '')); ?>" height="<?php echo esc_attr(jaw_template_get_var('height', '100')); ?>"></iframe>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__image(){ ?>
<?php global $jaw_data; ?>
<?php
$id = rand(0, 9999);
$class = array();

if (jaw_template_get_var('hover_url', '') != '') {
    $class[] = 'with-hover';
}
$class[] = jaw_template_get_var('class');

$url="";
$img_set=false;
if(jaw_template_get_var('url')) {
    $url = jaw_template_get_var('url');
    $img_set = true;
} else {
    $url = jwUtils::jaw_msg(esc_html__("You have not set the image",'gdn-theme'),"warning");
}
if($img_set) {
?>
<div class="row">

    <div class="col-lg-12 <?php echo esc_attr(implode(' ', $class)); ?> builder-img">
        <?php if (jaw_template_get_var('link', '') != '' && jaw_template_get_var('lightbox', '0') == '0') { ?>
            <a href="<?php echo esc_url(jaw_template_get_var('link', '')); ?>"  target="<?php echo esc_attr(jaw_template_get_var('target')); ?>">
            <?php } else if (jaw_template_get_var('lightbox', '0') == '1') { ?>
                <a href="<?php echo esc_url($url); ?>" rel="prettyPhoto[<?php echo esc_attr($id); ?>]" title="<?php echo esc_attr(jaw_template_get_var('caption')); ?>">
                <?php } ?>
                <span id="image-<?php echo esc_attr($id); ?>"  >   
                    <?php $img_size = jaw_template_get_var('url-size', array('height' => '100%', 'width'=>'100%')); ?>
                    <img class="builder-image" src="<?php echo esc_url($url); ?>" data-original="<?php echo esc_url($url); ?>" alt="<?php echo esc_attr(jaw_template_get_var('caption')); ?>" title="<?php echo esc_attr(jaw_template_get_var('caption')); ?>"/>  
                </span>
                <?php if (jaw_template_get_var('lightbox', '0') == '1') { ?>
                </a>
            <?php } ?>
            <?php if (jaw_template_get_var('hover_url', '') != '') { ?>
                <?php if (jaw_template_get_var('lightbox', '0') == '1') { ?>
                    <a href="<?php echo esc_url(jaw_template_get_var('hover_url')); ?>" rel="prettyPhoto[<?php echo esc_attr($id); ?>]" title="<?php echo esc_attr(jaw_template_get_var('hover_caption')); ?>">
                    <?php } ?>
                    <?php $img_size = jaw_template_get_var('hover_url-size',  array('height' => '100%', 'width'=>'100%')); ?>
                    <img class="builder-hover_image" src="<?php echo esc_url(jaw_template_get_var('hover_url-small')); ?>" data-original="<?php echo esc_url(jaw_template_get_var('hover_url')); ?>" alt="<?php echo esc_attr(jaw_template_get_var('hover_caption')); ?>" title="<?php echo esc_attr(jaw_template_get_var('hover_caption')); ?>" height="<?php echo esc_attr($img_size['height']); ?>" width="<?php echo esc_attr($img_size['width']); ?>"/>  
                    <?php if (jaw_template_get_var('lightbox', '0') == '1') { ?>
                    </a>
                <?php } ?>
            <?php } ?>

            <?php if (jaw_template_get_var('link', '') != '' && jaw_template_get_var('lightbox', '0') == '0') { ?>
            </a>
        <?php } ?>


    </div>
</div>
<?php }?>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__interested_content(){ ?>
<?php 
$userID = get_current_user_id();

echo 'jaw_interest_posts';
$interest_posts = get_user_meta($userID, 'jaw_interest_posts', true);

echo 'jaw_interest_comments';
$interest_comments = get_user_meta($userID, 'jaw_interest_comments', true);

echo 'jaw_featured_posts';
$featured_posts = get_user_meta($userID, 'jaw_featured_posts', true);


echo 'cool heh?';
?>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__list(){ ?>
<?php global $jaw_data; ?>

<h5><?php echo jaw_template_get_var('list_title'); ?></h5>
<ul class="jaw_list">
    <?php echo do_shortcode(jaw_template_get_var('content')); ?>
</ul>


<?php } ?>
<?php function jw_tmpl_simple_shortcodes__list_item(){ ?>
<li><i class="<?php echo esc_attr(jaw_template_get_var('icon','jaw-icon-circle-small')); ?>"></i><?php echo jaw_template_get_var('list',''); ?></li>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__login(){ ?>
<?php

$args = array(
    'echo' => true,
    'form_id' => 'loginform',
    'label_username' => esc_html__('Username','gdn-theme'),
    'label_password' => esc_html__('Password','gdn-theme'),
    'label_remember' => esc_html__('Remember Me','gdn-theme'),
    'label_log_in' => esc_html__('Log In','gdn-theme'),
    'id_username' => 'user_login',
    'id_password' => 'user_pass', 
    'id_remember' => 'rememberme',
    'id_submit' => 'wp-submit',
    'remember' => true,
    'value_remember' => false
);

if((int) jwOpt::get_option('user_bar_login_pageid', '') > 0){
    $args['redirect'] = get_permalink((int) jwOpt::get_option('user_bar_login_pageid', ''));
} 
?>
 
<div class="row">
    <div class="col-lg-12">
        <div class="jaw_login">
            <?php if (is_user_logged_in()) { ?>              
                <div class="login-content" >
                    <?php
                    $current_user = wp_get_current_user();
                    $user_id = $current_user->ID;
                    echo get_avatar($user_id, 60);
                    ?>
                    <p><?php echo esc_html__('Welcome, ', "gdn-theme"); ?></p><p class="user-name"><?php echo esc_attr($current_user->display_name) . '!'; ?></p>

                    <div class="clear"></div>
                    <p class="service-link jaw-user-logoutlink  btn"><a href="<?php echo wp_logout_url(); ?>"><?php esc_html_e('Log Out', "gdn-theme"); ?></a></p>
                    <p class="service-link jaw-user-settings  btn"><a href="<?php echo esc_url(get_permalink(jwOpt::get_option('user_account_pageid'))); ?>"><?php esc_html_e('Settings', "gdn-theme"); ?></a></p>
                    <?php jaw_template_inc_counter('login'); ?>
                </div>
            <?php } else { ?>
                <?php jaw_template_dec_counter('login'); ?>
                <div class="login-content" >
                    <div class="login">
                        <?php
                        wp_login_form($args);
                        ?>
                        <?php if (jaw_template_get_var('show_register', '1') == '1') { ?>
                            
                                <?php
                                $register_link = esc_url(wp_registration_url());
                                ?>
                                <?php echo apply_filters('register', sprintf('<a class="service-link regiter-button button-primary" href="%s">%s</a>', $register_link, esc_html__('Register', "gdn-theme"))); ?>
                            
                        <?php } ?>
                    </div>
                    <?php jaw_template_inc_counter('login'); ?>
                </div>
            <?php } ?>
        </div>
    </div>  
</div>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__media_gallery(){ ?>
<?php
// get jaw gallery
echo '<div class="row jaw-media-gallery-'.esc_attr(jaw_template_get_var("type_gallery")).'">';
    echo '<div class="'.esc_attr(jwLayout::col_class(12)).' jaw-box">';
        echo jwMedia::getGallery(jaw_template_get_var("type_gallery"),jaw_template_get_var("thumb_gallery","4"));
    echo '</div>';
echo '</div>';?>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__menu(){ ?>
<?php
global $jaw_data;

$menu = jaw_template_get_var('menu');
$type_menu = jaw_template_get_var('menu_type');
$nav_menu = wp_get_nav_menu_object($menu);
$col_count = 'col-count-' . jaw_template_get_var('menu_col_count');

?>

<div class="menu-shortcode <?php echo esc_attr($col_count) . " " . esc_attr($type_menu); ?>">

    <?php
    
    if ($type_menu == "jawmenu") {    
        $a = wp_nav_menu(
            array(
                'menu' => $nav_menu,
                'depth' => 0,
                'echo' => false,
                'walker' => new JawMenuFrontendWalker()
            )
        );
    } else {
        $a = wp_nav_menu(
            array(
                'menu' => $nav_menu,
                'depth' => 0,
                'echo' => false
            )
        );        
    }
    
    echo esc_attr($a);
    
    ?>
    <div class="clear"></div>
</div>



<?php } ?>
<?php function jw_tmpl_simple_shortcodes__message(){ ?>
<?php global $jaw_data; ?>
<div class="alert alert-warning alert-dismissible" role="alert">
    <div class="row">
        <div class="col-lg-<?php echo jaw_template_get_var('box_size','12'); ?>">
            <div class="panel-<?php echo jaw_template_get_var('message_style'); ?> fade in">
                <div class="panel-heading">
                    <?php if (jaw_template_get_var('show_icon', '1') == '1') { ?>
                        <?php if (jaw_template_get_var('message_style') == 'primary') { ?>
                            <i class="jaw-icon-info"></i>	
                        <?php } else if (jaw_template_get_var('message_style') == 'success') { ?>
                            <i class="jaw-icon-checkmark"></i>
                        <?php } else if (jaw_template_get_var('message_style') == 'info') { ?>
                            <i class="jaw-icon-info"></i>
                        <?php } else if (jaw_template_get_var('message_style') == 'warning') { ?>
                            <i class="jaw-icon-notification"></i>
                        <?php } else if (jaw_template_get_var('message_style') == 'danger') { ?>
                            <i class="jaw-icon-warning "></i>
                        <?php } ?>  
                    <?php } ?>    
                    <?php if (jaw_template_get_var('show_close', '1') == '1') { ?>
                        <a class="close" data-dismiss="alert" href="#" aria-hidden="true">&times;</a>
                    <?php } ?>
    
                    <?php echo do_shortcode(jaw_template_get_var('message_text')); ?>
    
                </div>
            </div>
        </div>
    </div>
</div>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__one_progressbar(){ ?>
<?php
$id = rand(0, 9999);
if (jaw_template_get_var('animate', '0') == '1') {
    $width = 0;
    ?>
    <script>
        jQuery(document).ready(function() {
            var checkStartAnimation = function() {
                var bottom_of_window = jQuery(window).scrollTop() + jQuery(window).height();
                var bottom_of_object = jQuery('#progress-<?php echo esc_attr($id); ?> .progress-bar').offset().top;
                if (bottom_of_window > bottom_of_object) {
                    return true;
                }
                ;
                return false;
            };

            var jawAnimationHandler = function() {
                if (checkStartAnimation()) {
                    jQuery('#progress-<?php echo esc_attr($id); ?> .progress-bar').css('width', '<?php echo esc_attr(jaw_template_get_var('value')); ?>%');
                }
            };
            jawAnimationHandler();
            jQuery(window).scroll(jawAnimationHandler);


        });
    </script>
    <?php
} else {
    $width = jaw_template_get_var('value');
}
?>
<div id="progress-<?php echo esc_attr($id); ?>" class="progress">   
    <div class="progress-bar" role="progressbar" aria-valuenow="<?php echo esc_attr(jaw_template_get_var('value')); ?>" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo esc_attr($width); ?>%; background:<?php echo jaw_template_get_var('color'); ?>">
        <span><?php echo jaw_template_get_var('title'); ?> </span><span class="progress-percents">(<?php echo jaw_template_get_var('value'); ?>%)</span>
    </div>
</div>


<?php } ?>
<?php function jw_tmpl_simple_shortcodes__page(){ ?>
<?php global $jaw_data; ?>
<?php
global $post;
if (jaw_template_get_var('id', '') != '') {
    $post = get_post((int) jaw_template_get_var('id'));
    ?>
    <div  style="background: url('<?php echo esc_url(jaw_template_get_var('image_src')); ?>');">
        <?php
        echo apply_filters('the_content',$post->post_content);
        ?> 
    </div>
<?php
}
wp_reset_query();
?>

<?php } ?>
<?php function jw_tmpl_simple_shortcodes__page_content(){ ?>
<?php global $jaw_data; ?>

<?php 

global $wp_query;
echo do_shortcode(get_the_content());
?>

<?php } ?>
<?php function jw_tmpl_simple_shortcodes__panel_box(){ ?>
<?php global $jaw_data; ?>

<div class="row">
    <div class="col-lg-<?php echo esc_attr(jaw_template_get_var('box_size','12')); ?>">
        <div class="panel panel-<?php echo esc_attr(jaw_template_get_var('message_style')); ?>">
            <?php if (strlen(jaw_template_get_var('panel_title')) > 0) { ?>
            <div class="panel-heading">
                <h3 class="panel-title"><?php echo do_shortcode(jaw_template_get_var('panel_title')); ?></h3>
            </div>
            <?php } ?>
            <div class="panel-body">
                <?php echo do_shortcode(jaw_template_get_var('text_content')); ?>
            </div>
        </div>
    </div>
</div>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__post_rating(){ ?>
<?php 
echo jaw_get_template_part('rating', 'blog');?>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__presentation_box(){ ?>
<?php
$class = array();
$imgClass = array();
$class[] = 'jw-style-'.jaw_template_get_var('style', 'nextto');
$class[] = 'jw-align-'.jaw_template_get_var('align', 'left');
$imageUrl = jaw_template_get_var('url', '');
$hoverImageUrl = jaw_template_get_var('hover_url', '');
if($hoverImageUrl != ''){
    $imgClass[] = 'jw-with-hover';
}
?>
  <div class="jw-presentation-box <?php echo esc_attr(implode(' ',$class)); ?>">
    <?php if($imageUrl !== ''){ ?>
      <div class="jw-present-image <?php echo esc_attr(implode(' ',$imgClass)); ?>">
        <img src="<?php echo esc_url($imageUrl); ?>" alt="<?php echo esc_attr(jaw_template_get_var('title', '')); ?>" class="jw-first-img"/>
        <?php if($hoverImageUrl != ''){ ?>
            <img src="<?php echo esc_url($hoverImageUrl); ?>" alt="<?php echo esc_attr(jaw_template_get_var('title', '')); ?>" class="jw-second-img"/>
        <?php } ?>
      </div>
      <?php } ?>
        <div class="jw-present-content">
          <div class="jw-present-title">
            <h4><?php echo jaw_template_get_var('title', ''); ?></h4>
          </div>
          <div class="jw-present-text">
            <?php echo do_shortcode(jaw_template_get_var('content', '')); ?>
          </div>
        </div>
  </div>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__progressbar(){ ?>
<?php global $jaw_data; ?>
<?php $id = rand(0, 1000); ?>
<div id="jaw_progress" >  
   <?php 
   echo do_shortcode(jaw_template_get_var('content'));?>
</div>

<?php } ?>
<?php function jw_tmpl_simple_shortcodes__qrcode(){ ?>
<?php global $jaw_data; ?>

<?php $class = rand(0, 1000); ?>
<div id="qrcode-<?php echo esc_attr($class); ?>">
    <div class="qr-symbol">
    </div>
    <div class="clear"></div>

    <script>
        jQuery(document).ready(function(){

            jQuery('#qrcode-<?php echo esc_attr($class); ?> .qr-symbol').qrcode({
                render: 'canvas',
                size: '960',
                text: '<?php echo do_shortcode(jaw_template_get_var('qrcode')); ?>'
            });
        });
    </script>
</div>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__quote(){ ?>
<?php global $jaw_data;?>
<div class="blockquote-container">
    <div class="quote-icon">
        <i class="jaw-icon-quotes-right"></i>
    </div>
    <blockquote>
        <?php if(jaw_template_get_var('custom_text', '') == null) {
            // shortocde
            echo do_shortcode(jaw_template_get_var('content', ''));
        } else {
            // builder
            echo do_shortcode(jaw_template_get_var('custom_text', ''));
        } ?>
    </blockquote>
    <div class="quote-author">
        <?php echo jaw_template_get_var('author', ''); ?>
    </div>
</div>
<div class="clear"></div>

<?php } ?>
<?php function jw_tmpl_simple_shortcodes__recent_comments(){ ?>
<?php
$comments = jaw_template_get_var('comments', array());
?>
<div class="jaw-recent-comments">
    <?php foreach ($comments as $key => $comment) { ?> 
         <?php $GLOBALS['comment'] = $comment; ?>
        <div class="tab-post-row">
            <div class="tab-post-widget-img">
                <a href="<?php echo get_comment_link($comment); ?>">
                    <?php echo get_avatar($comment->comment_author_email); ?>
                </a>
            </div>
            <div class="tab-post-widget-content">
                <?php 
                $commentID = get_comment_ID(); 
                $getComment = get_comment($commentID);
                ?>
                <div class="wrap">
                    <?php 
                    if(jaw_template_get_var('show_author', '1')) {
                    ?>
                    <span class="author">
                    <?php if($getComment->user_id > 0){ ?>
                        <a href="<?php echo get_author_posts_url($getComment->user_id); ?>" class='url'>
                    <?php } ?>
                        <?php echo get_comment_author_link(); ?>
                    <?php if($getComment->user_id > 0){ ?>
                        </a>
                    <?php } ?>
                        <span><?php esc_html_e("on:",'gdn-theme'); ?></span>
                    </span>
                    <?php } ?>
                    <span class="title">
                        <a href="<?php echo get_comment_link($comment); ?>"><?php echo get_the_title($getComment->comment_post_ID); ?></a>
                    </span>                                            
                    <span class="content">
                    <?php
                        echo jwUtils::crop_length($comment->comment_content,jaw_template_get_var('excerpt_length', '100')); 
                    ?>
                    </span>
                    <?php 
                    if(jaw_template_get_var('show_date', '1')) {
                    ?>
                    <div class="date">
                            <?php echo jwRender::get_meta_date("M d. Y"); ?>
                    </div>
                    <?php } ?>
                </div>
            </div>                          
            <div class="clear"></div>
        </div>
    <?php } ?>
</div>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__register(){ ?>
<?php if (!is_user_logged_in() && get_option('users_can_register')) { ?>

    <div class="row">
        <div class="col-lg-12">
            <div class="jaw_login">
                <div class="login-content registration-form-wrapper">
                    <?php
                    if (isset($_POST['svalue']) && $_POST['svalue'] != jaw_template_get_var('answer', '2')) {
                        echo do_shortcode('[jaw_message message_style="warning" show_close="0" message_text="' . esc_html__('Wrong answer', "gdn-theme") . '"]');
                    } else if (defined('REGISTRATION_ERROR')) {
                        foreach (unserialize(REGISTRATION_ERROR) as $error) {
                            echo do_shortcode('[jaw_message message_style="warning" show_close="0" message_text="<strong>' . esc_html__('Error: ', "gdn-theme") . '</strong>' . esc_attr($error) . '"]');
                        }
                    } elseif (defined('REGISTERED_A_USER')) {
                        echo do_shortcode('[jaw_message message_style="success" show_close="0" message_text="<strong>' . esc_html__('Congratulations you have been registered.', "gdn-theme") . '</strong><br>' . esc_html__('Please check your e-mail box: ', "gdn-theme") . REGISTERED_A_USER . '"]');
                    }
                    ?>

                    <form id="jaw-registration-form" method="post" action="<?php echo add_query_arg('do', 'register', get_permalink($post->ID)); ?>#jaw_login">
                        <p>
                            <label for="username">Username</label>
                            <input type="text" class="input" id="username" name="user" value=""/>
                        </p><p>
                            <label for="email">E-mail</label>
                            <input type="text" class="input" id="email" name="email" value="" />
                        </p><p>
                            <label for="svalue"><?php echo jaw_template_get_var('question', 'What is a result of 1+1?'); ?></label>
                            <input type="text"  class="input" name="svalue" value="" />
                        </p><p class="jw-margin-bottom">
                            <?php echo esc_html__('A password will be e-mailed to you.', "gdn-theme"); ?>
                        </p><p >
                            <input type="hidden" value="<?php echo esc_attr(jaw_template_get_var('answer', '2')); ?>" name="jaw-register" /> 
                            <?php wp_nonce_field('jaw_register', 'jaw_register_nonce'); ?>
                            <input type="submit" class="reg-submit service-link regiter-button btn" value="<?php echo esc_html__('Register', "gdn-theme"); ?>" />
                            <div class="clear"></div>
                        </p>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <?php
}?>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__row(){ ?>
<div class="row jaw-row" ><?php echo do_shortcode(jaw_template_get_var('content')); ?></div>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__search(){ ?>
<?php
global $jaw_data;

?>

<div class="shortcode-search-form">

    <?php 
        get_search_form(); 
    ?>

</div>



<?php } ?>
<?php function jw_tmpl_simple_shortcodes__section(){ ?>
<?php global $jaw_data; ?>
<?php
$fw_style = '';
if (jaw_template_get_var('fullwidth') == '1' && jaw_template_get_var('size') == 12) {
    $fullwidth = 'row-fullwidth';
} else if (jaw_template_get_var('fullwidth') == 'full-item' && jaw_template_get_var('size') == 12) {
    $fullwidth = 'row-fullwidth-item';
} else {
    $fullwidth = '';
}

//default pro bartypy
$bar_type = jwOpt::checkDefault(array(jaw_template_get_var('bar_type', ''), jwOpt::get_option('global_header_style','bar_type_1')));
jaw_template_set_var('bar_type', $bar_type);

if (jaw_template_get_var('full_back_color') != '') {
    $fw_style = 'background: ' . jaw_template_get_var('full_back_color') . '; ';
}
$class = array();
$class[] =  jwLayout::col_class(jaw_template_get_var('size'));
$class[] = jaw_template_get_var('class');
$class[] = 'show-on-'.jaw_template_get_var('show_on_devices');
$class[] = $fullwidth;
$class[] = jaw_template_get_var('space_after', 'space_after');

$id="";
if(jaw_template_get_var('el_id') != null) {
    $id = 'id='.esc_attr(jaw_template_get_var('el_id'));
    $class[] = "has-onepage-id";
}
// image caption
$class[] = 'image_caption_toggle-' . jwOpt::get_option('image_caption_toggle');

?>
<div <?php echo esc_attr($id); ?> class="builder-section <?php echo esc_attr(implode(' ',$class)); ?>" >

    <?php
    if ($fullwidth == 'row-fullwidth') {
        echo '<div class="fullwidth-block row" style="' . esc_attr($fw_style) . '">';
    }
    $content = jaw_template_get_var('content'); 
    if (jaw_template_get_var('bar_type', '') != '') {
        echo jaw_get_template_part('section_bar', 'simple-shortcodes');
    }
    ?>
    <?php
    echo do_shortcode($content);
    if ($fullwidth == 'row-fullwidth') {
        echo '</div>';
    }
    ?>

</div>
<?php 
unset($class);
unset($fw_style);
unset($bar_type);
unset($fullwidth);
?>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__section_bar(){ ?>
<?php
global $jaw_data;
$arrows_in_header = array('blog_carousel');
$title = "";
if((jaw_template_get_var('custom_link') == "")) {
    $title = apply_filters('jaw_section_title', jaw_template_get_var('box_title', ''));
} else {
    $title = '<a class="builder_custom_link" href="'.jaw_template_get_var('custom_link').'">'.apply_filters('jaw_section_title',jaw_template_get_var('box_title', '')).'</a>';
} 
?>

<div class="row section-header <?php echo esc_attr( jaw_template_get_var('bar_type', '')); ?>">
    <div class="col-lg-12 col-sm-12 col-md-12">
        <?php do_action('jaw_before_section_title'); ?>
        <?php
        switch (jaw_template_get_var('bar_type', 'bar_type_1')) {

            case 'off':
                ?>
                <div class="section_bar_off">
                    <h<?php echo esc_attr(jaw_template_get_var('bar_h', '3')); ?> class="section-name" >
                        &nbsp;
                    </h<?php echo esc_attr(jaw_template_get_var('bar_h', '3')); ?>>
                </div>
                <?php
                break;

            case 'space':
                ?>
                <div class="section_bar_space">
                    <h<?php echo esc_attr(jaw_template_get_var('bar_h', '3')); ?> class="section-name" >
                    </h<?php echo esc_attr(jaw_template_get_var('bar_h', '3')); ?>>
                </div>
                <?php
                break;
            case 'bar_type_big_left':
            case 'bar_type_big_center':
            case 'bar_type_big_right':
            case 'bar_type_4':
                ?>
                <div class="section_wrapper">
                    <div class="section_bar">
                        <h<?php echo esc_attr(jaw_template_get_var('bar_h', '3')); ?> class="section-name" >
                            <?php echo   $title ; ?>
                        </h<?php echo esc_attr(jaw_template_get_var('bar_h', '3')); ?>>
                    </div>
                </div>
                <?php
                break;

            case 'bar_type_1':
            case 'bar_type_2':
            case 'bar_type_3':
            default:
                ?>
                <div class="section_bar">
                    <h<?php echo esc_attr(jaw_template_get_var('bar_h', '3')); ?> class="section-name" >
                        <?php echo  $title ; ?>
                    </h<?php echo esc_attr(jaw_template_get_var('bar_h', '3')); ?>>
                </div>
                <?php
        }
        ?>
        <?php do_action('jaw_after_section_title'); ?>
    </div>
</div>

<?php } ?>
<?php function jw_tmpl_simple_shortcodes__sidebar(){ ?>
<?php global $jaw_data; ?>
<?php
$class = array();
$class[] = 'sidebars-preset-' . jwOpt::checkDefaultPreset(array(jaw_template_get_var('sidebar_color', '_default'), jwOpt::get_option('main_color')),'color');
$class[] =  jwOpt::checkDefault(array(jaw_template_get_var('bar_type_widgets', ''), jwOpt::get_option('sidebars_bar_type', 'bar_type_3'), jwOpt::get_option('global_header_style', '')));
$class[] = 'fixed_'.jaw_template_get_var('fixed', 'off');
echo jwUtils::customizer_preview_preset("Sidebar", jwOpt::checkDefaultPreset(array(jaw_template_get_var('sidebar_color', '_default'), jwOpt::get_option('main_color')),'color'));
?>
<div class="sidebar <?php echo esc_attr(implode(" ", $class)); ?>">
    <div class="sidebar-box">
        <?php
        dynamic_sidebar(jaw_template_get_var('build_sidebar', ''));
        ?>	 
    </div>
</div>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__social_icons(){ ?>
<?php global $jaw_data; ?>
<?php $id = rand(0, 1000); ?>
<?php

$socials = jaw_template_get_var('social');

$icons = array(
    'facebook' => 'jaw-icon-facebook4',
    'twitter' => 'jaw-icon-twitter3',
    'google' => 'jaw-icon-google-plus4',
    'youtube' => 'jaw-icon-youtube',
    'vimeo' => 'jaw-icon-vimeo3',
    'flickr' => 'jaw-icon-flickr4',
    'linkedin' => 'jaw-icon-linkedin',
    'pinterest' => 'jaw-icon-pinterest',
    'instagram' => 'jaw-icon-instagram'
); 

?>
<span  id="icon-<?php echo esc_attr($id); ?>" >
    <span  class="el-social-icons"  style="font-size: <?php echo esc_attr(jaw_template_get_var('size')); ?>px; color:<?php echo jaw_template_get_var('color', '#666666'); ?>;">
        <?php foreach ((array) $socials as $name => $link) { ?>
            <?php if ($link != '' && isset($icons[$name])) { ?>
                <a href="<?php echo esc_url($link); ?>" target="<?php echo esc_attr(jaw_template_get_var('target', '_blank')); ?>" class="<?php echo esc_attr($name); ?>" style="color: <?php echo jaw_template_get_var('color', '#666666'); ?>"><i class="<?php echo esc_attr($icons[$name]); ?>"></i></a>
                <?php } ?>
            <?php } ?>
    </span>
</span>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__spoiler(){ ?>
<?php
$main = jaw_template_get_var('content');
$bg_image = get_template_directory_uri() . '/images/spoiler/spoiler.png';
if(!empty($main)) {
	echo '<span class="jaw-spoiler" style="background-image: url('.$bg_image.');"><span class="restriction first"></span><span class="revealed">'.$main.'</span><span class="restriction last"></span></span>';
}?>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__submit_message(){ ?>
<?php       
    echo "<div class='jaw-submit-message'>";
        echo "<a href='#' class='popmake-".jaw_template_get_var('modal_id')."'>";
        echo "<span class='jaw-submit-icon'>";
        echo '<i class="' . jaw_template_get_var('icon') . '"></i>';
        echo "</span>";
        echo "<span class='jaw-submit-content'>";
        echo '<span class="submit-text">';
        echo jaw_template_get_var('style');
        echo '</span>';
        echo "</span>";
        echo '</a>';
    echo "</div>";
?>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__table_of_content(){ ?>
<?php
global $multipage, $numpages, $page;
if($multipage) { // has post links
	$title = jaw_template_get_var("table_of_content_title");
	$items = explode(",",jaw_template_get_var("table_of_content_list"));
    $icon = jaw_template_get_var("icon");
    $format = "";
	if(count($items) == $numpages) { // must be equal bruh
	?>
		<div class="jaw-table-of-content-wrapper">
			<div class="row">
				<div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
					<div class="title"><h3><?php echo esc_attr($title); ?></h3></div>
					<div class="items">
						<?php 
						foreach($items as $i => $item) {
                            if(!empty($icon)) {
                                $format = '<i class="'.$icon.'"></i>';
                            } else {
                                $format = ($i+1).'. ';
                            }
							if($page == ($i+1)) { // active current page
								echo '<div class="item active">'.esc_attr($format).esc_attr($item).'</div>';
							} else {
								echo '<div class="item"><a href="'.add_query_arg( 'page', $i + 1, get_the_permalink()).'">'.esc_attr($format).esc_attr($item).'</a></div>';
							}
						} ?>
					</div>
				</div>
			</div>
		</div>
	<?php
	} else {
		echo jwUtils::jaw_msg(sprintf(esc_html__('The items and the page links should be the equal. You have %s items and %s page links','gdn-theme'),esc_attr(count($items)),
		esc_attr($numpages)),"warning");
	}
}?>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__tabs(){ ?>
<?php global $jaw_data; 
jaw_template_inc_counter('accordion');
?>
<div class="jaw-tabs <?php echo esc_attr(jaw_template_get_var('style')); ?>">
<?php
echo do_shortcode(jaw_template_get_var('content'));
?>
</div>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__tabs_content(){ ?>
<?php global $jaw_data; ?>
<?php if (jaw_template_get_var('class') == 'active') { ?>
    <div class="tab-pane fade active in" id="tab_<?php echo esc_attr(jaw_template_get_counter('accordion')); ?>_<?php echo esc_attr(jaw_template_get_var('id')); ?>"><p><?php echo do_shortcode(jaw_template_get_var('content')); ?></p></div>
<?php } else { ?>
    <div class="tab-pane fade" id="tab_<?php echo esc_attr(jaw_template_get_counter('accordion')); ?>_<?php echo esc_attr(jaw_template_get_var('id')); ?>"><p><?php echo do_shortcode(jaw_template_get_var('content')); ?></p></div>
<?php } ?>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__tabs_contents(){ ?>
<?php global $jaw_data; ?>
<div class="tab-content" > <?php echo do_shortcode(jaw_template_get_var('content')); ?> </div>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__tabs_title(){ ?>
<?php global $jaw_data; ?>

<?php if (jaw_template_get_var('class') == 'active') { ?>
    <li class="active"><a data-toggle="tab" href="#tab_<?php echo esc_attr(jaw_template_get_counter('accordion')); ?>_<?php echo esc_attr(jaw_template_get_var('id')); ?>"><?php echo jaw_template_get_var('content'); ?></a></li>
<?php } else { ?>
    <li><a data-toggle="tab" href="#tab_<?php echo esc_attr(jaw_template_get_counter('accordion')); ?>_<?php echo esc_attr(jaw_template_get_var('id')); ?>"><?php echo jaw_template_get_var('content'); ?></a></li>
<?php } ?>

<?php } ?>
<?php function jw_tmpl_simple_shortcodes__tabs_titles(){ ?>
<?php global $jaw_data; ?>
<ul class="nav nav-tabs" > <?php echo do_shortcode(jaw_template_get_var('content')); ?> </ul>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__ticker(){ ?>
<?php
global $post, $wp_query, $jaw_data, $content_width;
$first = 'active';
$col_count = jaw_template_get_var("columns", 12);
$main_title = jaw_template_get_var('ticker_title', 'default');
$random = jaw_template_inc_counter("ticker");
$query = jaw_template_get_data();
$type = jaw_template_get_var('ticker_type', 'classic');
$direction = jaw_template_get_var('ticker_direction', 'horizontal');

echo jwUtils::customizer_preview_preset("Breaking news", jaw_template_get_var('ticker_preset_color', ''));
?>

<div class="row jaw-ticker <?php echo esc_attr('ticker-preset-' . jaw_template_get_var('ticker_preset_color','')); ?> <?php echo esc_attr($type); ?>">
    <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
        <div class="jaw-ticker-wrapper">
            <div class="main-title"><span><?php echo esc_attr($main_title); ?></span></div>
            <div class="ticker-carousel-wrapper">
                <div id="jaw-carousel-ticker-<?php echo esc_attr($random); ?>" class="carousel <?php echo esc_attr($direction); ?>  slide navigation-<?php echo jaw_template_get_var('carousel_style', 'bar'); echo ' autoslide-'.jaw_template_get_var('automatic_slide', '0') ?>">
                    <div class="carousel-inner">
                    <?php
                        while ($query->have_posts()) {
                            $query->the_post(); ?>
                        <div class="item <?php echo esc_attr($first); ?>">
                            <a href="<?php the_permalink(); ?>"><?php
                                $first = "";
                                echo jaw_get_template_part('ticker_item', 'simple-shortcodes');?>
                            </a>
                        </div>
                            <?php
                        } ?>
                    </div>
                </div>
                <?php if($type != "classic") { ?>
                <div class="ticker-switcher ticker-switcher-closed">
                    <i class="jaw-icon-menu2"></i>
                </div>
                <?php  } else { ?>
                <div class="ticker-arrows">
                    <a class="left" href="#jaw-carousel-ticker-<?php echo esc_attr($random); ?>" data-slide="prev">
                        <span class="jaw-icon-sipka-gallery-left"></span>
                    </a>
                    <a class="right" href="#jaw-carousel-ticker-<?php echo esc_attr($random); ?>" data-slide="next">
                        <span class="jaw-icon-sipka-gallery-right"></span>
                    </a>
                </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__ticker_item(){ ?>
<?php
global $post, $wp_query, $jaw_data, $content_width;
?>

<span class="ticker-item-title">
    <?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?>
</span>
<span class="ticker-item-content">
    <?php
        echo jwUtils::crop_length(get_the_excerpt(), jaw_template_get_var('letter_excerpt', 275));
    ?>
</span>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__title(){ ?>
<?php global $jaw_data; ?>
<div class="row element-title"> 
    <div class="col-lg-<?php echo esc_attr(jaw_template_get_var('box_size')); ?>">
        <?php jaw_template_set_var('box_title', jaw_template_get_var('title', '')); ?>
        <?php echo jaw_get_template_part('section_bar', 'simple-shortcodes'); ?>
        <?php if (jaw_template_get_var('description', '') != '') { ?>
            <span class="jaw-title-bar-descripton <?php echo jaw_template_get_var('bar_type', 'bar_type_1'); ?>">
                <?php echo jaw_template_get_var('description', ''); ?>
            </span>
        <?php } ?>  
    </div>
</div>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__typography(){ ?>
<?php

if (jaw_template_get_var('code') == 'code') { ?>
    <code><?php echo jaw_template_get_var('content'); ?></code>
<?php 
}
if (jaw_template_get_var('code') == 'pre') { ?>
    <pre><?php echo jaw_template_get_var('content'); ?></pre>
<?php 
}
if (jaw_template_get_var('code') == 'br') { ?>
    <br>
<?php 
}
?>
<?php } ?>
<?php function jw_tmpl_simple_shortcodes__v_video(){ ?>
<?php global $jaw_data; ?>
<div class='row vimeo_frame'>
    <div class='col-lg-<?php echo esc_attr(jaw_template_get_var('box_size')); ?>'>
        <iframe class='vimeo jaw-keep-ratio' style='height:<?php echo esc_attr(jaw_template_get_var('height')); ?>px;width:<?php echo esc_attr(jaw_template_get_var('width')); ?>' src='<?php echo esc_url(jaw_template_get_var('url')); ?>' width='$width' height='$height' frameborder='0'></iframe>
    </div>
</div>

<?php } ?>
<?php function jw_tmpl_simple_shortcodes__vine_video(){ ?>
<?php global $jaw_data; ?>
<div class='vine_frame row'>
    <div class='col-lg-<?php echo esc_attr(jaw_template_get_var('box_size')); ?>'>
        <iframe class="vine-embed" src="<?php echo esc_url(jaw_template_get_var('url')); ?>/embed/simple" height="<?php echo esc_attr(jaw_template_get_var('width')); ?>" width="<?php echo esc_attr(jaw_template_get_var('width')); ?>" frameborder="0" ></iframe>
    </div>
</div>

<?php } ?>
<?php function jw_tmpl_simple_shortcodes__y_video(){ ?>
<?php global $jaw_data; ?>
<div class='youtube_frame row'>
    <div class='col-lg-<?php echo esc_attr(jaw_template_get_var('box_size')); ?>'>
        <iframe class='youtube jaw-keep-ratio' style='height:<?php echo esc_attr(jaw_template_get_var('height')); ?>px;width:<?php echo esc_attr(jaw_template_get_var('width')); ?>' src='<?php echo esc_url(jaw_template_get_var('url')); ?>' height='<?php echo esc_attr(jaw_template_get_var('height')); ?>' frameborder='0'></iframe>
    </div>
</div>

<?php } ?>
<?php function jw_tmpl_simple_shortcodes__yop_poll(){ ?>
<?php
global $jaw_data;

$poll_id = jaw_template_get_var('poll_id');

?>

<div class="yop-poll-shortcode">

    <?php echo do_shortcode('[yop_poll id="'.$poll_id.'"]')?>

</div>



<?php } ?>
<?php function jw_tmpl_simple_shortcodes__youtube_feeds(){ ?>
<?php global $jaw_data; ?>
<div class="youtube_feeds row">
    <h2><a href="<?php echo esc_url(jaw_template_get_var('url')); ?>"><?php echo jaw_template_get_var('title'); ?></a></h2>
    <?php foreach ((array) jaw_template_get_var('videos') as $video) { ?>
        <div class="col-lg-6 ">
            <?php if (isset($video['title'])) { ?>
                <h3><?php echo esc_attr($video['title']); ?></h3> 
            <?php } ?>
            <?php if (isset($video['content'])) { ?>
                <p><?php echo esc_attr($video['content']); ?></p>
            <?php } ?>
            <?php if (isset($video['link']['href'])) { ?>
                <?php echo do_shortcode('[jaw_y_video clip_id="' . esc_url($video['link']['href']) . '" width="470px" title="' .esc_attr( $video['title'] ). '" autoplay="false" /]'); ?>
            <?php } ?>
        </div>
    <?php } ?> 
</div>
<?php } ?>
<?php function jw_tmpl_sliders__grid(){ ?>
<?php
global $wp_query,$post;
$wp_query = jaw_template_get_data();
$is_custom = false;
if($wp_query->query["post_type"] == "custom") {
    $is_custom = true;
}
$size = jaw_template_get_var('size',4);
$info_opacity = (1 - (jaw_template_get_var("info_opacity") / 100));
$title_color = jaw_template_get_var("title_color");
$bigone = 1;
if($size >= 3){
	$bigone = 2;
}
$subitem=0;
$width = array(1);
$count = 0;
$bigOne = 2;
$rowSize = 0;
$end = false;
$cols=1;
//konfigurace - jak jdou velky a maly dlazdice za sebou
switch($size){
	case 1: $width = array(4);
        $cols = 1;
		break;
	case 12: $width = array(4,1,1,1,1,4); // zmena smeru (411 a pak 114)
        $cols = 3;
		break;
	case 13: $width = array(4,2,1,1,1,1,2,4);
        $cols = 4;
		break;
	case 14: $width = array(4,1,1,1,1,1,1,1,1,4);
        $cols = 4;
		break;
	case 141: $width = array(4,1,1,1,1,4);
        $cols = 6;
		break;
	case 2: $width = array(1,1);
        $cols = 2;
		break;
	case 21: $width = array(1,1,4,4,1,1);
        $cols = 3;
		break;
	case 3: $width = array(1,1,1);
        $cols = 3;
		break;
	case 31: $width = array(1,1,2,4,4,2,1,1);
        $cols = 4;
		break;
	case 4: $width = array(1,1,1,1);
        $cols = 4;
		break;
	case 41: $width = array(1,1,1,1,4,4,1,1,1,1);
        $cols = 4;
		break;
	default: 'This size is not supported';
}
jaw_template_set_var("is_custom",$is_custom);
jaw_template_set_var("cols",$cols);
jaw_template_set_var("subitem",$subitem);
jaw_template_set_var("width",$width);
jaw_template_set_var("count", $count);
jaw_template_set_var("end",$end);
jaw_template_set_var("rowSize",$rowSize);
$mainClass = array();
$mainClass[] = 'slider-preset-'.jaw_template_get_var('slider_preset_color', '_default'); 
$mainClass[] = 'jaw-preset-helper'; 

echo jwUtils::customizer_preview_preset("Grid", jaw_template_get_var('slider_preset_color', ''));
?>
<div class="jw-grid row <?php echo esc_attr(implode(' ', $mainClass)); ?>"> 
<?php
if($is_custom) {
    echo do_shortcode(jaw_template_get_var("content"));
} else {
    if(!have_posts()){
        echo jwUtils::jaw_msg(esc_html__('Too few posts, please check your settings', "gdn-theme"),'warning');
    }else{
        while(have_posts()){
            the_post();
            if(has_post_thumbnail()){
                jaw_template_set_var("img",get_post_thumbnail_id(get_the_ID()));
                jaw_template_set_var("link",get_the_permalink());
                jaw_template_set_var("title",get_the_title());
                jaw_template_set_var("description","");
                
                echo jaw_get_template_part("grid_item","sliders");
            }
        }
    }
}
$end = jaw_template_get_var("end");
if($end) {  ?>
        </div>
</div>
<?php
}
?>
</div>
<?php
wp_reset_query();?>
<?php } ?>
<?php function jw_tmpl_sliders__grid_item(){ ?>
<?php
$is_custom = jaw_template_get_var('is_custom');
$img_id = jaw_template_get_var('img');
$link = jaw_template_get_var("link");
$title = jaw_template_get_var("title");
$desc = jaw_template_get_var("description");
$size = jaw_template_get_var('size',4);
$overlay_upper = jaw_template_get_var("overlay_upper");
$overlay_bottom = jaw_template_get_var("overlay_bottom");
$title_color = jaw_template_get_var("title_color");
$cols = jaw_template_get_var("cols",1);
$count = jaw_template_get_var("count");
//col-lg sirka zakladni (mensi) dlazdice
if($size == "12" ||$size == "13" || $size == "14" || $size == "141" ||$size == "21" ||$size == "31") {
    $size = 6;
}
$baseWidth = round(12/$cols);

//konfigurace - jak jdou velky a maly dlazdice za sebou
$subitem = jaw_template_get_var("subitem");
$width = jaw_template_get_var("width");
$rowSize = jaw_template_get_var("rowSize");
$bigOne = $width[$count%sizeof($width)];
$thisSize = $baseWidth*round($width[$count%sizeof($width)]/2); // ze 4 (width) se stane 2 a z 1 se stane 0.5 -> round na 1

$class = array();
$class[] = 'col-lg-'.$thisSize;
$class[] = 'col-md-'.$thisSize;
$class[] = 'col-sm-12';
$class[] = 'col-xs-12';
$count_size = $width[$count%sizeof($width)];
$class[] = 'size-'.$count_size;

$video_class = array();
if($count_size == 1){
    $video_class[] = "small";
}
$end = jaw_template_get_var("end");

if($bigOne == 2 || $bigOne == 4 || ($bigOne == 1 && $subitem%2 == 0) || $size < 5 || !$end) {
    $rowSize = $rowSize+$thisSize;
    $subitem = 0;
    $end = true;
?>
<div class="jw-grid-one <?php echo esc_attr(implode(' ', $class)); ?>">
    <div class="row">
        <?php } ?>
        <div class="jw-grid-one-wrapper <?php echo esc_attr(jwLayout::col_class(12)); ?>">
            <div class="jw-grid-one-inner">
                <div class="image">
                    <?php
                    if($is_custom) {
                        ?>
                        <a href="<?php echo esc_url($link); ?>">
                        <?php
                            $url = wp_get_attachment_image_src($img_id,"post-size-big");
                            echo '<img src="'.$url[0].'">';
                        ?>
                        <div class="jaw-fadein"></div>
                        </a>
                        <?php
                    } else {
                    ?>
                <?php if(jaw_template_get_var('clickable_image', '1')){  ?>
                        <a href="<?php the_permalink(); ?>">
                <?php }
                    echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-16_9-small', 'jaw_blog-16_9-middle', 'jaw_blog-16_9', "jaw_blog-16_9-big", 'large'),false);

                ?>

                    <div class="jaw-fadein"></div>
                    <?php if(get_post_format() == 'video'){
                     echo '<span class="jaw-video-icon ' . esc_attr(implode(' ', $video_class)) . '">'.apply_filters('jaw_default_video_icon', '<i class="jaw-icon-play4"></i>').'</span>';
                 } ?>
                    <?php if(jaw_template_get_var('clickable_image', '1')){ ?>
                        </a>
                        <?php }
                    }?>
                </div>
                <div class="jw-grid-one-content">
                    <?php
                    if($is_custom) {
                        ?>
                        <div class="content-wrapper">
                            <h4>
                                <a href="<?php echo esc_url($link); ?>" style="<?php echo "color:".$title_color; ?>">
                                    <?php echo jwUtils::crop_length($title, jaw_template_get_var('letter_excerpt_title', 60)); ?>
                                </a>
                            </h4>
                            <?php if(!empty($desc)) { ?>
                            <div class="gridline" style="<?php echo "border-color:".$title_color; ?>"></div>
                            <p class="desc" style="<?php echo "color:".$title_color; ?>"><?php echo esc_attr($desc); ?></p>
                            <?php } ?>
                        </div>
                        <?php
                    } else {
                        ?>
                        <div class="post-categories-labels">
                            <?php
                            if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                                echo jwRender::get_meta_category();
                            }
                            ?>
                        </div>
                        <h4>
                            <a href="<?php the_permalink(); ?>">
                            <?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?>
                            </a>
                        </h4>
                        <?php echo jaw_get_template_part('meta', 'meta');
                    } ?>
                </div>
            </div>
            <?php
        ?>
        </div>
<?php if($bigOne == 2 || $bigOne == 4 || ($bigOne == 1 && $subitem%2 == 1) || $size < 5) { ?>
    </div>
</div>
<?php
    $end = false;
    if($rowSize >= 12){
        ?>
        <div class="clear"></div>
        <?php
        $rowSize = 0;
    }
}
$subitem++;
$count++;
if($bigOne == 2) {
    $subitem = 0;
}
jaw_template_set_var("count", $count);
jaw_template_set_var("subitem",$subitem);
jaw_template_set_var("end",$end);
jaw_template_set_var("rowSize",$rowSize);
?>
<?php } ?>
<?php function jw_tmpl_sliders__slider_1(){ ?>
<?php
global $jaw_data, $post;
$first = 'active';
$first_post = true;
$post_in_slide = jaw_template_get_var('post_in_slide', 3);
$query = jaw_template_get_data();
$random = jaw_template_inc_counter("slider_1");

$class = array();
$class[] = jwLayout::col_class(12);
$class[] = 'autoslide-'.jaw_template_get_var('automatic_slide', '0');
$class[] = 'clickable_image-'.jaw_template_get_var('clickable_image', '1');
$class[] = 'navigation-'.jaw_template_get_var('carousel_style', 'bar');
$class[] = 'slider-preset-'.jaw_template_get_var('slider_preset_color', 'default'); 

echo jwUtils::customizer_preview_preset("Slider", jaw_template_get_var('slider_preset_color', ''));

$interval = 'false';
if(jaw_template_get_var('automatic_slide', 'false') == 'true'){
    $interval = jaw_template_get_var("slider_interval",5000);
}
?>
<div class="jaw-slider-1-wrapper">
    <div class="row">
        <div id="jaw-slider1-<?php echo esc_attr($random); ?>" class="jaw_blog jaw-blog-slider jaw-preset-helper special-big carousel horizontal slide <?php echo esc_attr(implode(' ', $class)); ?>" data-interval="<?php echo esc_attr($interval);?>">
            <div class="carousel-inner">
            <?php
            $count = 0;
            $konec = true;
            while ($query->have_posts()) {
                $query->the_post();
                if(has_post_thumbnail()) {
                    if (get_post_meta(get_the_ID(), 'fw_rating_position', true) == '1') {
                        $format = 'review';
                    } else {
                        $format = get_post_format();
                    }
                    $format = apply_filters( 'jaw_post_format', $format );
                    ?>
                    <div class="item <?php echo esc_attr($first); ?>">
                        <div class="row">
                            <?php
                            $first = '';
                            echo jaw_get_template_part('content-special-big', 'content', $format);?>
                        </div>
                    </div>
            <?php }
            } ?>   
        </div>
        <div class="blog-slider-arrows">
            <a class="left special-big" href="#jaw-slider1-<?php echo esc_attr($random); ?>" data-slide="prev">
                <span class="jaw-icon-sipka-gallery-left"></span>
            </a>
            <a class="right special-big" href="#jaw-slider1-<?php echo esc_attr($random); ?>" data-slide="next">
                <span class="jaw-icon-sipka-gallery-right"></span>
            </a>
        </div>
    </div>
    </div>
    <div class="clear"></div>
</div>
<?php
wp_reset_query();
?>
<?php } ?>
<?php function jw_tmpl_sliders__slider_2(){ ?>
<?php
global $jaw_data, $post, $wp_query;
$active = 'active';
$counter = 1;
$wp_query = jaw_template_get_data();
$post_in_cols = jaw_template_get_var('columns');
$approved=true;
$total_post = $wp_query->post_count;

$class = array();
$class[] = jwLayout::col_class(12);
$class[] = 'size-' . jaw_template_get_var('columns');
$class[] = 'clickable_image-'.jaw_template_get_var('clickable_image', '1');
$class[] = 'slider-preset-'.jaw_template_get_var('slider_preset_color', 'default'); 

echo jwUtils::customizer_preview_preset("Slider", jaw_template_get_var('slider_preset_color', ''));

if ($total_post < $post_in_cols+3) {
    echo jwUtils::jaw_msg(sprintf(esc_html__('Squares Slider - You should probably add more posts with featured images (%s at least).','gdn-theme'),$post_in_cols+3-$total_post));
    $approved = false;
}

if($approved) {
    
$interval = 'false';
if(jaw_template_get_var('automatic_slide', 'false') == 'true'){
    $interval = jaw_template_get_var("slider_interval",5000);
}
?>
<div class="row">
    <div id="jaw-slider_2-<?php echo esc_attr(jaw_template_inc_counter('jaw-slider_2')); ?>" class="jaw-slider_2 jaw-preset-helper <?php echo esc_attr(implode(' ',$class));?>">
        <div class="slider-wrapper jaw_blog">
            <div class="slider-row ">
                <?php
                $konec = true;
                while (have_posts()) {
                    the_post();
                    ?>
                    <div class="slider-item content-slider_2 shown <?php echo esc_attr($active); ?>">
                        <div class="slider-item-inner">
                            <?php 
                            $link = false;
                            if(jaw_template_get_var('clickable_image', '1')){
                                $link = get_the_permalink();
                                ?><a class="clickable" href="<?php echo esc_url($link); ?>"></a><?php
                            }
                            $active = '';
                            echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-special', 'jaw_slider-square'),$link);
                            $counter++;
                            ?>
                        </div>
                        <div class="slider-item-description <?php echo esc_attr($active); ?>">
                            <h3><a href="<?php the_permalink(); ?>"><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></a></h3>
                            <?php echo jaw_get_template_part('meta', 'meta'); ?>
                        </div>
                    </div>

                <?php 
                    }
                ?>   
            </div>
            <?php if($approved) { ?>
            <div class="jaw-slider_2-arrows">
                <span class="left jaw-slider_2-arrow" data-direction="right">
                    <i class="jaw-icon-sipka-gallery-left"></i>
                </span>
                <span class="right jaw-slider_2-arrow"  data-direction="left">
                    <i class="jaw-icon-sipka-gallery-right"></i>
                </span>
            </div>
            <?php  }?>
        </div>
 
    </div>
    <script>
    document.addEventListener("jaw-RunSliders", function(e) { 
        jQuery('#jaw-slider_2-<?php echo jaw_template_get_counter('jaw-slider_2'); ?>').slider({autoSlide:<?php echo jaw_template_get_var('automatic_slide','true'); ?>,interval:<?php echo jaw_template_get_var('slider_interval','5000'); ?>});
    });
    </script>
    
</div>
<div class="clear"></div>

<?php
}
wp_reset_query();
?>
<?php } ?>
<?php function jw_tmpl_sliders__slider_3(){ ?>
<?php
global $jaw_data, $post;
$query = jaw_template_get_data();
$counter = jaw_template_inc_counter("slider_3");
$link = false;
$disable_fadein = "";
if(jaw_template_get_var('disable_fadein', '1')) {
    $disable_fadein='jaw-fadein';
}

$class = array();
$class[] = jwLayout::col_class(12);
$class[] = 'autoslide-'.jaw_template_get_var('automatic_slide', '0');
$class[] = 'clickable_image-'.jaw_template_get_var('clickable_image', '1');
$class[] = 'navigation-'.jaw_template_get_var('carousel_style', 'bar');
$class[] = 'slider-preset-'.jaw_template_get_var('slider_preset_color', 'default'); 

echo jwUtils::customizer_preview_preset("Slider", jaw_template_get_var('slider_preset_color', ''));

$interval = 'false';
if(jaw_template_get_var('automatic_slide', 'false') == 'true'){
    $interval = jaw_template_get_var("slider_interval",5000);
}
?>
<div class="jaw-slider-3-wrapper">
    <div class="row jaw-main-slider">
        <div id="jaw-slider3-main-<?php echo esc_attr($counter); ?>" class="jaw_blog jaw-blog-slider slider_3 jaw-preset-helper slider_3_main carousel-sync carousel horizontal slide navigation-<?php echo esc_attr(implode(' ', $class));?>">
            <div class="carousel-inner row">
            <?php
            $first = 'active';
            $count_main = 0;
            while ($query->have_posts()) {
                $query->the_post();
                if(has_post_thumbnail()) {
                ?>
                <div class="item <?php echo esc_attr($first); ?>">
                    <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?> jaw-slider-img-item">
                        <div class="jaw-slider-img-list">
                            <?php
                            $first = '';
                            if(jaw_template_get_var('clickable_image', '1')){
                                $link = get_the_permalink(get_the_ID());
                                ?><a class="clickable" href="<?php echo esc_url($link); ?>"><?php
                                if(get_post_format() == "video") {
                                    echo '<span class="jaw-video-icon">'.apply_filters('jaw_default_video_icon', '<i class="jaw-icon-play4"></i>').'</span>';
                                }
                                ?></a><?php
                            }
                            echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-16_9-big','jaw_blog-16_9'));
                            ?>
                            <div class="<?php echo esc_attr($disable_fadein); ?>"></div>
                            <div class="jaw-slider-desc-container-main">
                                <div class="title">
                                    <span><a href="<?php echo get_permalink(); ?>"><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></a></span>
                                </div>
                                <div class="desc">
                                    <span><a href="<?php echo get_permalink(); ?>"><?php echo jwUtils::crop_length(get_the_excerpt(), jaw_template_get_var('letter_excerpt', 275)); ?></a></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php 
            $count_main++;
            }} ?>   
            </div>
            <script type="text/javascript">
                jQuery(document).ready(function() {
                    jQuery("#jaw-slider3-main-<?php echo esc_attr($counter); ?>").carousel({
                        interval: <?php echo jaw_template_get_var("slider_interval",5000); ?>
                    });
                });
            </script>
        </div>
    </div>
    <div class="row jaw-navigate-slider">
        <div id="jaw-slider3-slide-<?php echo esc_attr($counter); ?>" class="jaw_blog jaw-blog-slider slider_3 slider_3_slide carousel carousel-sync horizontal slide autoslide-0 navigation-<?php echo jaw_template_get_var('carousel_style', 'bar'); echo esc_attr(jwLayout::col_class(12)); ?>">
            <div class="carousel-inner row">
            <?php
            $query->posts=array_reverse($query->posts);
            $count = 0;
            while ($query->have_posts()) {
                $query->the_post();
                // second main img default
                if($count == 0) {
                    $first = "active";
                }
                if(has_post_thumbnail()) {
                ?>
                <div class="item <?php echo esc_attr($first); ?>">
                    <div class="col-xs-4 col-sm-4 col-md-4 col-lg-4 jaw-slider-img-item">
                        <div class="jaw-slider-img-list">
                            <?php
                            $first = '';
                            if(jaw_template_get_var('clickable_image', '1')){
                                $link = get_the_permalink(get_the_ID());
                                ?><a class="clickable" href="<?php echo esc_attr($link); ?>">
                                    <?php if(get_post_format() == "video") {
                                    echo '<span class="jaw-video-icon small">'.apply_filters('jaw_default_video_icon', '<i class="jaw-icon-play4"></i>').'</span>';
                                }?></a><?php
                            }
                            echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-special'));
                            ?>
                            <div class="<?php echo esc_attr($disable_fadein); ?>"></div>
                            <div class="jaw-slider-desc-container-main">
                                <div class="title">
                                    <span><a href="<?php echo get_permalink(); ?>"><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></a></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php 
            $count++;
            }} ?>
            </div>
            <div class="blog-slider-arrows">
                <a class="left slide_3_arr" href="#jaw-slider3-main-<?php echo esc_attr($counter); ?>" data-slide="prev">
                    <span class="jaw-icon-sipka-gallery-left"></span>
                </a>
                <a class="right slide_3_arr" href="#jaw-slider3-main-<?php echo esc_attr($counter); ?>" data-slide="next">
                    <span class="jaw-icon-sipka-gallery-right"></span>
                </a>
            </div>
        </div>
    </div>
    <div class="clear"></div>
</div>
<?php
wp_reset_query();
?>
<?php } ?>
<?php function jw_tmpl_sliders__slider_4(){ ?>
<?php
global $jaw_data, $post, $wp_query;
$active = 'active';
$counter = 1;
$wp_query = jaw_template_get_data();
$slider_arrows = jaw_template_get_var('slider_arrows');
$post_in_cols = jaw_template_get_var('columns');
$total_post = $wp_query->post_count;
$class = array();
$class[] = jwLayout::col_class(12);
$class[] = 'clickable_image-'.jaw_template_get_var('clickable_image', '1');
$class[] = 'slider-preset-'.jaw_template_get_var('slider_preset_color', 'default'); 
$class[] = 'size-' . jaw_template_get_var('columns');
$check_sum = $post_in_cols+3-$total_post;
echo jwUtils::customizer_preview_preset("Slider", jaw_template_get_var('slider_preset_color', ''));
$approved = true;

if ($total_post <= $post_in_cols+3 && $check_sum != 0) {
    echo jwUtils::jaw_msg(sprintf(esc_html__('Row Slider - You should probably add more posts with featured images (%s at least).','gdn-theme'),$check_sum));
    $approved = false;
}

if($approved) {

$interval = 'false';
if(jaw_template_get_var('automatic_slide', 'false') == 'true'){
    $interval = jaw_template_get_var("slider_interval",5000);
}
$video_class = array();
if($post_in_cols > 3){
    $video_class[] = 'small';
}
?>
<div class="row">
    <div id="jaw-slider_4-<?php echo esc_attr(jaw_template_inc_counter('jaw-slider_4')); ?>" class="jaw-slider_4 jaw-preset-helper <?php echo esc_attr(implode(' ', $class)); ?>">
        <div class="slider-wrapper jaw_blog">
            <div class="slider-row ">
                <?php
                $konec = true;
                while (have_posts()) {
                    the_post();
                    if(has_post_thumbnail() || get_post_format() == "video") {
                    ?>
                    <div class="slider-item content-slider_4 shown <?php echo esc_attr($active); ?>">
                        <div class="slider-item-inner">
                            <?php
                            $link = false;
            
                            if(jaw_template_get_var('clickable_image', '1')){
                                $link = get_the_permalink();
                                ?><a class="clickable" href="<?php echo esc_url($link); ?>"></a><?php
                            }
                            $active = ''; 
                            if(get_post_format() == "video") {
                                echo '<span class="jaw-video-icon '. esc_attr(implode(' ',$video_class)) .'">'.apply_filters('jaw_default_video_icon', '<i class="jaw-icon-play4"></i>').'</span>';
                            }
                            
                            if(has_post_thumbnail()){
                                echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-16_9-big','jaw_blog-16_9'),$link);
                            }else if(get_post_format() == "video"){
                                $video = get_post_meta(get_the_ID(), 'jaw_post_video_link', true);
                                echo jwMedia::getVideoThumbnail($video, $link);
                            }
                            
                            $counter++;
                            ?>
                        </div>
                        <div class="desc-wrapper">
                            <div class="categories-slider_4">
                                <div class="post-categories-labels">
                                    <?php
                                    if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                                        echo jwRender::get_meta_category();
                                    }
                                    ?>
                                </div>
                            </div>
                            <div class="slider-item-title">
                                <h3><a href="<?php the_permalink(); ?>"><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></a></h3>
                            </div>
                            <div class="slider-item-desc">
                                <div class="slider-item-description-excerpt"><?php echo jwUtils::crop_length(get_the_excerpt(), jaw_template_get_var('letter_excerpt', 150)); ?></div>
                            </div>
                        </div>
                    </div>
                <?php 
                }
                }
                 ?>   
            </div>
            <?php
                if($slider_arrows) {
            ?>
            <div class="jaw-slider_4-arrows">
                <span class="left jaw-slider_4-arrow" data-direction="right">
                    <i class="jaw-icon-sipka-gallery-left"></i>
                </span>
                <span class="right jaw-slider_4-arrow"  data-direction="left">
                    <i class="jaw-icon-sipka-gallery-right"></i>
                </span>
            </div>
            <?php } ?>
        </div>
    </div>
    <script> 
    document.addEventListener("jaw-RunSliders", function(e) {
        jQuery('#jaw-slider_4-<?php echo jaw_template_get_counter('jaw-slider_4'); ?>').slider({autoSlide:<?php echo jaw_template_get_var('automatic_slide','true'); ?>,interval:<?php echo jaw_template_get_var('slider_interval','5000'); ?>});
    });
    </script>
</div>
<div class="clear"></div>
<?php
}



wp_reset_query();
?>
<?php } ?>
<?php function jw_tmpl_sliders__slider_5(){ ?>
<?php
global $jaw_data, $post, $wp_query;
$wp_query = jaw_template_get_data();
$counter = jaw_template_inc_counter("slider_5");

$class = array();
$class[] = jwLayout::col_class(12);
$class[] = 'fullwidth-'.jaw_template_get_var('fullwidth', 'fw_color'); 

$class_slider = array();
$class_slider[] = 'slider-preset-'.jaw_template_get_var('slider_preset_color', 'default'); 

echo jwUtils::customizer_preview_preset("Slider", jaw_template_get_var('slider_preset_color', ''));

$interval = 'false';
if(jaw_template_get_var('automatic_slide', 'false') == 'true'){
    $interval = jaw_template_get_var("slider_interval",5000);
}
?>
<div class="jaw-slider-5-wrapper jaw-preset-helper <?php echo esc_attr(implode(' ', $class_slider));?>">
    <div class="row jaw-main-slider">
        <div id="jaw-slider5-main-<?php echo esc_attr($counter); ?>" class="jaw_blog jaw-blog-slider slider_5_main carousel-sync carousel fade slide <?php echo esc_attr(implode(' ', $class));?>" data-interval="<?php echo esc_attr($interval);?>">
            <div class="carousel-inner row">
            <?php
            $first = 'active';
            $count_main = 0;
            while (have_posts()) {
                the_post();
                if(has_post_thumbnail()) {
                ?>
                <div class="item <?php echo esc_attr($first); ?>">
                    <?php 
                    $first = '';
                    ?>
                    <div class="jaw-slider-img jaw-mediabg">
                        <?php
                        echo jwMedia::getPostThumbnail(get_the_ID(), array('full'), null, null, array('class' => 'jaw-bg-item'));
                        ?>
                    </div>
                    <div class="jaw-slider-desc-container-main">
                        <div class="post-categories-labels">
                            <?php
                            if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                                echo jwRender::get_meta_category();
                            }
                            ?>
                        </div>
                        <div class="title">
                            <a href="<?php echo get_permalink(); ?>"><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></a>
                        </div>
                        <div class="meta">
                            <?php echo jaw_get_template_part('meta', 'meta'); ?>
                        </div>
                    </div>
                </div>
                <?php 
                    $count_main++;
                    if($count_main == 3){
                        break;
                    }
                }
            }  ?>  
            </div>        

        <div class="slider_5_navigate carousel-indicators">
            <?php
            $count = 0;
            //@todo celkem prasacky - chtelo by to udelat jinak
            $wp_query = new WP_Query($wp_query->query);
            while (have_posts()) {
                the_post();
                if(has_post_thumbnail()) {
                ?>
                <a href="<?php echo get_permalink(); ?>" class="jaw-slider-item" data-target="#jaw-slider5-main-<?php echo esc_attr($counter); ?>" data-slide-to="<?php echo esc_attr($count); ?>">
                    <div class="jaw-slider-desc-container-main">
                        <div class="title">
                            <span><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></span>
                        </div>
                    </div>
                </a>
            <?php 
            $count++;
            if($count == 3){
                break;
            }
            }
            } ?>

        </div>
        <div class="blog-slider-arrows">
            <a class="left slide_5_arr" href="#jaw-slider5-main-<?php echo esc_attr($counter); ?>" data-slide="prev">
                <span class="jaw-icon-sipka-gallery-left"></span>
            </a>
            <a class="right slide_5_arr" href="#jaw-slider5-main-<?php echo esc_attr($counter); ?>" data-slide="next">
                <span class="jaw-icon-sipka-gallery-right"></span>
            </a>
        </div>
    </div>
    </div>
    <div class="clear"></div>
</div>
<?php
wp_reset_query();
?>
<?php } ?>
<?php function jw_tmpl_widgets__jaw_about_author(){ ?>
<?php
wp_reset_query();
$instance = jaw_template_get_var('instance');
if (isset($instance['about_author'])) {
    if ($instance['about_author'] == 'auto' && is_single()) {
        $id = get_the_author_meta('ID');
    } else {
        $id = $instance['about_author'];
    }
    if ($id != 'auto') {
        jaw_template_set_var('id', $id);
        $user = get_userdata($id);
        if (isset($user->display_name)) {
            jaw_template_set_var('name', $user->display_name);
        }
        ?>
        <article class="w_about_author clear widget">
            <?php
            echo jaw_get_template_part('author', 'simple-shortcodes');
            ?>
        </article>
        <?php
    }
}
?>
<?php } ?>
<?php function jw_tmpl_widgets__jaw_banner_widget(){ ?>
<?php
$args = jaw_template_get_var('args', array());
$instance = jaw_template_get_var('instance');
if(isset($instance['custom_banner'])){
    echo '<article class="widget jaw_banner_widget">';
        jwRender::get_banner('custom_'.$instance['custom_banner']);
    echo '</article>';
}?>
<?php } ?>
<?php function jw_tmpl_widgets__jaw_default_widget(){ ?>
<?php

/**
 * frameworkWidget
 *
 * This class extends default WP_Widget class and add an automaticall widget settings form
 * !!! extended class has to have $options variable
 *
 * @author freshface
 */
class Jaw_Default_Widget extends WP_Widget {

    /**
     * this function is updating values, called by wordpress
     */
    function update($new_instance, $old_instance) {
        //save the widget
        foreach ($this->options as $one_option) {
            $key = $one_option['id'];
            if ($one_option['type'] == 'text') {
                $instance[$key] = strip_tags($new_instance[$key]);
            } else if ($one_option['type'] == 'checkbox') {
                $instance[$key] = 0;
                if (!empty($new_instance[$key]))
                    $instance[$key] = 1;
            }
            else if ($one_option['type'] == 'select') {

                $instance[$key] = $new_instance[$key];
            }
        }
        return $instance;
    }

    /**
     * this function is printing wordpress widget forms, called by wordpress
     */
    function form($instance) {

        foreach ($this->options as $one_option) {
            if ($one_option['type'] == 'text') {
                $value = $one_option['default'];
                if (isset($instance[$one_option['id']]))
                    $value = $instance[$one_option['id']];
                echo '<p>';
                echo '<label for="' . esc_attr($this->get_field_id($one_option['id'])) . '">' . $one_option['description'] . '</label><br>';
                echo '<input id="' . esc_attr($this->get_field_id($one_option['id'])) . '" name="' . esc_attr($this->get_field_name($one_option['id'])) . '" type="text" value="' . $value . '">';
                echo '</p>';
            }

            else if ($one_option['type'] == 'checkbox') {
                $value = '';
                if ((!isset($instance[$one_option['id']]) && $one_option['default'] == 1 ) || $instance[$one_option['id']] == 1)
                    $value = 'checked="checked"';
                echo '<p>';
                echo '<label for="' . esc_attr($this->get_field_id($one_option['id'])) . '">' . $one_option['description'] . '</label>';
                echo '<input id="' . esc_attr($this->get_field_id($one_option['id'])) . '" name="' . esc_attr($this->get_field_name($one_option['id'])) . '" type="checkbox" ' . $value . '>';
                echo '</p>';
            }

            else if ($one_option['type'] == 'select') {
                $value = $one_option['default'];
                if (isset($instance[$one_option['id']]))
                    $value = $instance[$one_option['id']];

                echo '<p>';
                echo '<label for="' . esc_attr($this->get_field_id($one_option['id'])) . '">' . $one_option['description'] . '</label><br>';
                echo '<select id="' . esc_attr($this->get_field_id($one_option['id'])) . '" name="' . esc_attr($this->get_field_name($one_option['id'])) . '">';
                foreach ($one_option['values'] as $one_val) {
                    $selected = null;
                    if ($value == $one_val['value'])
                        $selected = 'selected="selected"';

                    $val = 'value="' . $one_val['value'] . '"';

                    echo "<option {$val} {$selected}>";
                    echo esc_attr($one_val['name']);
                    echo "</option>";
                }

                echo '</select>';
                echo '</p>';
            }
        }
    }

    public function getOptions() {
        return $this->options;
    }

}?>
<?php } ?>
<?php function jw_tmpl_widgets__jaw_icons_menu(){ ?>
<?php
$args = jaw_template_get_var('args', array());
$instance = jaw_template_get_var('instance');
extract($args);

$nav_menu = ! empty( $instance['nav_menu'] ) ? wp_get_nav_menu_object( $instance['nav_menu'] ) : false;
if ( !$nav_menu )
    return;


echo $before_widget;
$title = apply_filters('widget_title', empty($instance['title']) ? '' : $instance['title'], $instance, '');
if (!empty($title)) {
    echo $before_title . $title . $after_title;
}

if(!class_exists('JawMenuFrontendIconsMenu')) {
    echo do_shortcode('[jaw_message message_style="danger" show_icon="1" show_close="0"]Works ONLY with JaW Menu for GDayNews Plugin. Please install and activate it.[/jaw_message]');
}else{
        
    echo '<div class="jw-icons-menu" >';
    
    wp_nav_menu( array(
    'fallback_cb' => '',
    'menu'        => $nav_menu,
    'walker'      => new JawMenuFrontendIconsMenu()
    ));
    
    
    echo '</div>';
}
echo $after_widget;?>
<?php } ?>
<?php function jw_tmpl_widgets__jaw_instagram_widget(){ ?>
<?php
$args = jaw_template_get_var('args', array());
$instance = jaw_template_get_var('instance');
$decode = jaw_template_get_var('decode');
extract($args);
echo $before_widget;
$title = apply_filters('widget_title', empty($instance['widget_title']) ? '' : $instance['widget_title'], $instance, '');
if (!empty($title)) {
    echo $before_title . $title . $after_title;
}
if ($decode != false && isset($decode->data)) {
    $img_count = 0;
    $img_per_row = 0;
    $count = 0;
    $desc_text = "";
    $class = "";
    $target = "";
    $show_desc = "";
    $img_count = $instance["images_count"];
    $img_per_row = $instance["images_per_row"];
    $target = $instance["target"];
    $desc_text = $instance["description_text"];
    $show_desc = $instance["description"]; 
    $class = jwLayout::col_class(array($img_per_row,$img_per_row,4,4));
    ?>
    <div class="jaw-instagram-widget-wrapper">
        <div class="row">
            <?php foreach($decode->data as $image) { ?>
            <?php 
            $responsiveImgs = array();
            foreach($image->images as $size => $img){
                $responsiveImgs[$size] = array("file" => $img->url, "width" => $img->width);
            }
            ?>
            
                <?php if($count < $img_count) { ?>
                    <div class="<?php echo esc_attr($class); ?> image">
                            <a href="<?php echo esc_url($image->link); ?>" target="<?php echo esc_attr($target); ?>">
                                <?php echo jwMedia::getResponsiveImage($responsiveImgs["standard_resolution"]["file"], $responsiveImgs, array("alt"=>$desc_text) ); ?>
                            </a>
                            <?php if($show_desc) { ?>
                                <a class="checkit" href="<?php echo esc_url($image->link); ?>" target="<?php echo esc_attr($target); ?>"><i class="jaw-icon-instagram"></i><span class="desc-text">
                                <?php echo esc_attr($desc_text); ?></span></a>
                            <?php } ?>
                    </div>
                <?php } ?>
                <?php $count++; ?>
            <?php } ?>
        </div>
    </div>
    <?php
    echo "<div class='clear'></div>";
} else if (isset($decode->error_message)) {
    echo '<div class="jaw_msg jaw_msg_type_warning">'. esc_html__('Error: ','gdn-theme') . $decode->error_message.'</div>';
} else {
    echo '<div class="jaw_msg jaw_msg_type_warning">'.esc_html__('Please check your API in Theme Options->API Keys and also your username in widgets','gdn-theme').'</div>';
}
echo $after_widget;?>
<?php } ?>
<?php function jw_tmpl_widgets__jaw_jaw_gallery_widget(){ ?>
<?php

$args = jaw_template_get_var('args');
$instance = jaw_template_get_var('instance');
extract($args);
echo $before_widget;
    $title = apply_filters('widget_title', empty($instance['widget_title']) ? '' : $instance['widget_title'], $instance, '');
    if (!empty($title)) {
        echo $before_title . $title . $after_title;
    }
    // get jaw gallery
    echo '<div class="row jaw-media-gallery-'. esc_attr($instance["jaw_gallery_type"]) . '">';
        echo '<div class="'.esc_attr(jwLayout::col_class(12)).' jaw-box">';
            echo jwMedia::getGallery($instance["jaw_gallery_type"],$instance["jaw_gallery_thumbs"],$instance["jaw_gallery_id"]);
        echo '</div>';
    echo '</div>';
echo $after_widget;?>
<?php } ?>
<?php function jw_tmpl_widgets__jaw_posts_widget(){ ?>
<?php
global $post;
$args = jaw_template_get_var('args');
$instance = jaw_template_get_var('instance');
$feedData = jaw_template_get_var('feedData');
$tab = array(
    'popular' => jaw_template_inc_counter('tab-posts'),
    'recent_posts' => jaw_template_inc_counter('tab-posts')
);
$title = '';
$first = true;
$simple_numbers_widget_check_var = "";
if($instance['posts_type'] == "simple_numbers") {
	$simple_numbers_widget_check_var = jaw_template_inc_counter("simple_numbers_widget_check", 1)+1;
}
jaw_template_set_var("simple_numbers_widget_check_glob_var",$simple_numbers_widget_check_var);
$title = $instance["post_title"];

extract($args);
echo $before_widget;

$type = $instance['posts_type'];

$class = array();
$class[] = 'blog_'.$type;

?>
<div class="jaw-popular_posts">
    <?php
    if (!empty($title)) {
        echo $before_title . $title . $after_title;
    }
    ?>
    <div class="posts-content jaw_blog row <?php echo esc_attr(implode(' ',$class)); ?> " data-columns="<?php echo esc_attr(round(12 / jaw_template_get_var("columns", 4))); ?>">
        <?php if (isset($feedData->posts) && !is_null($feedData->posts)) { ?>  
                    <?php
                    foreach ($feedData->posts as $post) {
                        setup_postdata($post);
                            if (get_post_meta(get_the_ID(), 'fw_rating_position', true) == '1') {
                                $format = 'review';
                            } else { 
                                $format = get_post_format();
                            }
                            $format = apply_filters( 'jaw_post_format', $format );
                            if ($type == 'mix') {
                                if ($first) {
                                    echo jaw_get_template_part('content-vertical', 'content', $format);
                                    $first = false;
                                } else {
                                    echo jaw_get_template_part('content-simple', 'content', $format);
                                }
                            } else { 
                                if($type == 'simple_numbers'){
                                    jaw_template_set_var('number_insead_of_image', '1');
                                    $type = 'simple';
                                }
                                echo jaw_get_template_part('content-' . $type, 'content', $format);
                            }
                    }
                    ?>
        <?php } ?>
    </div>
</div>
<?php
wp_reset_postdata();
wp_reset_query();
echo $after_widget;
            ?>
<?php } ?>
<?php function jw_tmpl_widgets__jaw_rate_post_gdn_widget(){ ?>
<article class="widget jw-rating jw-rating-slim">
    <?php
    $data = jaw_template_get_data();
    if(isset($data['instance'])){
        $instance = $data['instance'];
        jaw_template_set_data($instance);
    }
    if(isset($data['args'])){
        $args = $data['args'];
    }
    if(isset($instance['ratings_title']) && $instance['ratings_title'] != '' && isset($args['before_title']) && isset($args['after_title'])){
        echo $args['before_title'] . $instance['ratings_title'] . $args['after_title'];
    }
    jaw_template_set_var('title', '');
    echo jaw_get_template_part('rating', 'blog');
    ?>
</article>
<?php } ?>
<?php function jw_tmpl_widgets__jaw_social_icons_widget(){ ?>
<article class="widget">
        <?php
        $data = jaw_template_get_data();
        if(isset($data['instance'])){
                $instance = $data['instance'];
                jaw_template_set_data($instance);
        }
        if(isset($data['args'])){
                $args = $data['args'];
        }
        if(isset($instance['box_title']) && $instance['box_title'] != '' && isset($args['before_title']) && isset($args['after_title'])){
                echo $args['before_title'] . $instance['box_title'] . $args['after_title'];
        }
        echo jaw_get_template_part('social_icons', 'simple-shortcodes');
        ?>
</article>
<?php } ?>
<?php function jw_tmpl_widgets__jaw_social_widget(){ ?>
<?php

$args = jaw_template_get_var('args');
$instance = jaw_template_get_var('instance');

if (!empty($instance)) {

    extract($args);

    echo $before_widget;

    $title = apply_filters('widget_title', empty($instance['widget_title']) ? '' : $instance['widget_title'], $instance, '');

    if (!empty($title)) {
        echo $before_title . $title . $after_title;
    }

    $social = array(
        "facebook" => array("var" => $instance['fb_username'],
            "type" => "user",
        ),
        "twitter" => array("var" => $instance['tw_username'],
            "type" => "user",
        ),
        "vimeo" => array("var" => $instance['vimeo_username'],
            "type" => "user",
        ),
        "instagram" => array("var" => $instance['i_username'],
            "type" => "user",
        ),
        "tumblr" => array("var" => $instance['tumblr_username'],
            "type" => "user",
        ),
        "youtube" => array("var" => $instance['youtube_username'],
            "type" => "user",
        ),
        "google" => array("var" => $instance['g_username'],
            "type" => "user",
        ),
        "rss" => array("var" => $instance['rss_link'],
            "type" => "link",
            "text" => esc_html__("Subscribe To", "gdn-theme"),
            "subtext" => esc_html__("RSS", "gdn-theme")
        ),
    );

    $social_active = array();
    foreach ($social as $service => $vars) {
        if (!empty($vars["var"])) {
            $social_active[$service] = $social[$service];
        }
    }
    
    if(!isset($instance['show_errors'])){
        $show_errors = '1';
    }else{
        $show_errors = $instance['show_errors'];
    }

    $row = 0;

    foreach ($social_active as $service => $vars) {

        if ($vars["type"] == 'user') {
            if (!empty($vars["var"])) {

                $username_hash = jwUtils::jaw_base64_enc($vars["var"]);
                $namespace = $service . '_' . $username_hash;

                $service_vars = unserialize(jaw_template_call('_getOption', array($namespace, '_vars')));
                $cache_time = jaw_template_call('_getOption', array($namespace, '_last_actualization'));

                if ((isset($service_vars->error) && $service_vars->error != '' ) || $cache_time == null || ( $cache_time + ( 60 * $instance['cache_time'] ) ) < time() || $service_vars == null) {
                    //nemam cache
                    $service_vars = jaw_template_call($service . '_followers_counter', array($vars["var"]));

                    jaw_template_call('_setOption', array($namespace, '_vars', serialize($service_vars)));
                    jaw_template_call('_setOption', array($namespace, '_last_actualization', time()));
                }
                if (isset($service_vars)) {
                    echo "<div class='social " . $service . "'>";
                    if (isset($service_vars->error) && $service_vars->error !== '' && $show_errors === '1') {
                        echo '<div class="jaw_msg jaw_msg_type_warning">'.esc_attr($service_vars->error).esc_html__(' Please check Theme Options -> Api keys','gdn-theme').'</div>';
                    } else {
                        echo "<a href='" . esc_url($service_vars->url) . "' class='" . esc_attr($vars["type"]) . "'>";
                        echo "<div class='jaw-social-icon-box'>";
                        echo "<div class='jaw-social-icon'>";
                        echo '<span class="jaw-icon-' . esc_attr($service) . '"></span>';
                        echo "</div>";
                        echo "<div class='jaw-social-content'>";
                        echo '<span class="social-text">';
                        switch ($service) {
                            case "google": esc_html_e("followers", "gdn-theme");
                                break;
                            case "twitter": esc_html_e("followers", "gdn-theme");
                                break;
                            case "facebook": esc_html_e("fans", "gdn-theme");
                                break;
                            case "instagram": esc_html_e("followers", "gdn-theme");
                                break;
                            case "flickr": esc_html_e("photos", "gdn-theme");
                                break;
                            case "youtube": esc_html_e("subscribers", "gdn-theme");
                                break;
                            case "tumblr": esc_html_e("followers", "gdn-theme");
                                break;
                            case "vimeo": esc_html_e("followers", "gdn-theme");
                                break;
                            default: esc_html_e("followers", "gdn-theme");
                        }
                        echo '</span>';
                        echo '<span class="jaw-counter" data-from="0" data-to="' . esc_attr($service_vars->followers) . '">0</span>';
                        echo "</div>";
                        echo "</div>"; 
                        echo '</a>';
                    }
                    echo "</div>";
                }
            }
        } else {
            if (!empty($vars["var"])) {
                echo "<div class='social " . esc_attr($service) . "'>";
                echo "<a href='" . esc_url($vars["var"]) . "' class='" . esc_attr($vars["type"]) . "'>";
                echo "<div class='jaw-social-icon-box'>";
                echo "<div class='jaw-social-icon'>";
                echo '<div class="jaw-icon-feed2"></div>';
                echo "</div>";
                echo "<div class='jaw-social-content'>";
                echo "<span class='social-subtext'>" . esc_attr($vars["subtext"]) . "</span>"."<span class='social-text'>" . $vars["text"] . "</span>";
                echo "</div>";
                echo "</div>";
                echo "</a>";
                echo "</div>";
            }
        }

        $row++;
    }
    echo "<div class='clear'></div>";

    echo $after_widget;
}?>
<?php } ?>
<?php function jw_tmpl_widgets__jaw_submit_message_widget(){ ?>
<article class="widget jw-submit-message-widget">
    <?php
    $data = jaw_template_get_data();
    if(isset($data['instance'])){
        $instance = $data['instance'];
        jaw_template_set_data($instance);
    }
    if(isset($data['args'])){
        $args = $data['args'];
    }
    if(isset($instance['box_title']) && $instance['box_title'] != '' && isset($args['before_title']) && isset($args['after_title'])){
        echo $args['before_title'] . $instance['box_title'] . $args['after_title'];
    }
    echo jaw_get_template_part('submit_message', 'simple-shortcodes');
    ?>  
</article>
<?php } ?>
<?php function jw_tmpl_widgets__jaw_twitter_widget(){ ?>
<?php 
$args = jaw_template_get_var('args');
$instance = jaw_template_get_var('instance');
$tweets = jaw_template_get_var('tweets');
extract($args);
echo $before_widget;
?>
    <?php 
    $title = apply_filters('widget_title', empty($instance['widget_title']) ? '' : $instance['widget_title'], $instance, '');

    if (!empty($title)) {
        echo $before_title . $title . $after_title;
    }
    ?>
    <ul class="jw-tweets-widgets-tweets">
        <?php foreach ((array) $tweets as $key=>$tweet) { ?>
        <li>
            <div class="jw-tweets-widgets-icon">
                <span class="jaw-icon-twitter3"></span><span class="tweet-name"><?php echo esc_attr($tweet->name); ?></span>
            </div>
            <div class="tweetie"><?php echo esc_attr($tweet->tweet); ?></div>
            <?php
                if($tweet->dateUnparsed != null) {
                    
                $parsed_time = date_parse($tweet->dateUnparsed);
                ?><div class="blog-meta-info"><?php echo date("F", mktime(0, 0, 0, $parsed_time['month'], 10)) . '</span>'.' '.$parsed_time['day'].', '.$parsed_time['year']; ?></div>
                <?php
                }
            ?>
        </li>
        <?php } ?>
    </ul>
<?php
echo $after_widget;?>
<?php } ?>
<?php function jw_tmpl_content__parts__excerpt(){ ?>
<p> 
    <?php
    echo apply_filters('jaw_excerpt', get_the_excerpt(), jaw_template_get_var('letter_excerpt', 300)); 
    ?>
</p>
<?php } ?>
<?php function jw_tmpl_content__parts__quote_author(){ ?>
<div class="quote-author">
    <?php echo get_post_meta(get_the_ID(), 'jaw_post_quote_author', true); ?>
</div>
<?php } ?>
<?php function jw_tmpl_content__parts__title_link(){ ?>
<header>
    <h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?> class="jw-title">
        <a href="<?php echo esc_url(get_post_meta(get_the_ID(), 'jaw_post_link', true)); ?>" class="post_name"><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></a>
    </h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?>>
</header>
<?php } ?>
<?php function jw_tmpl_content__parts__title(){ ?>
<header>
    <h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?> class="jw-title">
        <a href="<?php the_permalink(); ?>" class="post_name"><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></a>
    </h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?>>
</header>
<?php } ?>
<?php function jw_tmpl_header__logo_area__4_4_l(){ ?>
<?php 
$header_widget_class = array();
$header_widget_class[] = 'sidebar';
$header_widget_class[] = jwLayout::col_class(4);
$header_widget_class[] = 'sidebars-preset-' . jwOpt::checkDefaultPreset(array(jwOpt::get_option('header_color', '_default'), jwOpt::get_option('main_color')),'color');
$header_widget_class[] = jwOpt::checkDefault(array(jwOpt::get_option('header_bar_type', '_default'), jwOpt::get_option('global_header_style', 'bar_type_1')));
?>
<div class="jaw-header-widget <?php echo esc_attr(implode(' ',$header_widget_class)); ?>">
    <div class="sidebar-box">
        <?php dynamic_sidebar('headerwidgetarea1'); ?>
    </div>
</div>
<div class="jaw-header-widget <?php echo esc_attr(implode(' ',$header_widget_class)); ?>">
    <div class="sidebar-box">
        <?php dynamic_sidebar('headerwidgetarea2'); ?>
    </div>
</div>
<div class="<?php echo esc_attr(jwLayout::col_class(4)); ?> header-logo jaw-header-l-center">
    <?php echo jaw_get_template_part('logo', array('header', 'logo_area'));?>
</div>
<div class="clear"></div>
<?php } ?>
<?php function jw_tmpl_header__logo_area__4_l_4(){ ?>
<?php 
$header_widget_class = array();
$header_widget_class[] = 'sidebar';
$header_widget_class[] = jwLayout::col_class(4);
$header_widget_class[] = 'sidebars-preset-' . jwOpt::checkDefaultPreset(array(jwOpt::get_option('header_color', '_default'), jwOpt::get_option('main_color')),'color');
$header_widget_class[] = jwOpt::checkDefault(array(jwOpt::get_option('header_bar_type', '_default'), jwOpt::get_option('global_header_style', 'bar_type_1'))); 
?>
<div class="jaw-header-widget <?php echo esc_attr(implode(' ',$header_widget_class)); ?>">
    <div class="sidebar-box">
        <?php dynamic_sidebar('headerwidgetarea1'); ?>
    </div>
</div>
<div class="<?php echo esc_attr(jwLayout::col_class(4)); ?> header-logo jaw-header-l-center">
     <?php echo jaw_get_template_part('logo', array('header', 'logo_area'));?>
</div>
<div class="jaw-header-widget <?php echo esc_attr(implode(' ',$header_widget_class)); ?>">
    <div class="sidebar-box">
        <?php dynamic_sidebar('headerwidgetarea2'); ?>
    </div>
</div>

<div class="clear"></div>
<?php } ?>
<?php function jw_tmpl_header__logo_area__a_l(){ ?>
<div class="jaw-in_header_banner-wrapper">
        <?php jwRender::get_banner('in_header', 12); ?>
</div>
<div class="header-logo jaw-header-a-l">
     <?php echo jaw_get_template_part('logo', array('header', 'logo_area'));?>
</div>


<div class="clear"></div>
<?php } ?>
<?php function jw_tmpl_header__logo_area__header_logo_area(){ ?>
<?php
$class_head = array();
$class_head[] = 'jw-fullwidth-' . jwOpt::get_option('header_fullwidth', 'off');
$class_head[] = 'head-preset-' . jwOpt::checkDefaultPreset(array(jwOpt::get_option('header_color', '_default'), jwOpt::get_option('main_color')),'color');
$class_head[] = 'head-style-' . jwOpt::get_option('header_style','l-center');
?>
<div class="row jw-header-content <?php echo esc_attr(implode(' ', $class_head)); ?>">

<?php echo jwUtils::customizer_preview_preset("Header", jwOpt::checkDefaultPreset(array(jwOpt::get_option('header_color', '_default'), jwOpt::get_option('main_color')),'color')); ?>

<?php $img_src = get_header_image(); ?>
<?php if (isset($img_src) && $img_src != '') { ?>
<?php
$custom_image_class = array();
if(jwOpt::get_option('header_fullwidth', 'off') == 'on'){
    $custom_image_class[] = 'fullwidth-fw_edge';
}
?>
    <div class="custom_header_img-wrapper">
        <div class="col-lg-12 custom_header_img <?php echo esc_attr(implode(' ',$custom_image_class)); ?> ">
            <img src="<?php echo esc_url($img_src); ?>"  alt="Header Image" />
        </div>
    </div>
<?php } ?>

<?php // LOGO area ?>
<?php do_action('jaw_before_header'); ?>
<div class="jaw_header_wrapper">
<?php jwRender::get_banner('leader', 12); ?>
<?php echo jaw_get_template_part(jwOpt::get_option('header_style','l-center'),array('header','logo_area')); ?>
</div>
<?php do_action('jaw_after_header'); ?>
</div>
<?php } ?>
<?php function jw_tmpl_header__logo_area__in_fixed_menu(){ ?>
<?php 
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
$template_logo_fixed = jwOpt::get_option('custom_logo_fixed_menu', $template_logo);
if (strlen($template_logo_fixed) == 0) {
    $template_logo_fixed = $template_logo;
}
?>
<div class="jw-logo-in-menu">
    <?php if (jwOpt::get_option('use_jaw_seo_logo', '1') == '1') { ?>
    <h1>
    <?php } else { ?>
        <p>
        <?php } ?>
        <a href="<?php echo home_url('/'); ?>" title="<?php bloginfo('name'); ?>">
            <img class="template-logo-fixed" src="<?php echo esc_url($template_logo_fixed); ?>">
        </a>
        <?php if (jwOpt::get_option('use_jaw_seo_logo', '1') == '1') { ?>
    </h1>
<?php } else { ?>
    </p>
<?php } ?>
</div>
<?php } ?>
<?php function jw_tmpl_header__logo_area__in_menu(){ ?>
<?php 
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
if (strlen($template_logo) == 0) {
    $template_logo = JAW_THEME_URI . '/images/logo/logo.png';
}
?>
<div class="jw-logo-in-menu">
    <?php if (jwOpt::get_option('use_jaw_seo_logo', '1') == '1') { ?>
    <h1>
    <?php } else { ?>
        <p>
        <?php } ?>
        <a href="<?php echo home_url('/'); ?>" title="<?php bloginfo('name'); ?>">
            <img class="template-logo" src="<?php echo esc_url($template_logo); ?>">
        </a>
        <?php if (jwOpt::get_option('use_jaw_seo_logo', '1') == '1') { ?>
    </h1>
<?php } else { ?>
    </p>
<?php } ?>
</div>
<?php } ?>
<?php function jw_tmpl_header__logo_area__in_mobile_menu(){ ?>
<?php 
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
$template_logo_mobile = jwOpt::get_option('custom_mobile_logo', $template_logo);
if (strlen($template_logo) == 0) {
    $template_logo = JAW_THEME_URI . '/images/logo/logo.png';
}
if (strlen($template_logo_mobile) == 0) {
    $template_logo_mobile = $template_logo;
}
?>
<div class="jw-logo-in-menu">
    <?php if (jwOpt::get_option('use_jaw_seo_logo', '1') == '1') { ?>
    <h1>
    <?php } else { ?>
        <p>
        <?php } ?>
        <a href="<?php echo home_url('/'); ?>" title="<?php bloginfo('name'); ?>">
            <img class="template-logo-mobile" src="<?php echo esc_url($template_logo_mobile); ?>">
        </a>
        <?php if (jwOpt::get_option('use_jaw_seo_logo', '1') == '1') { ?>
    </h1>
<?php } else { ?>
    </p>
<?php } ?>
</div>
<?php } ?>
<?php function jw_tmpl_header__logo_area__l_4_4(){ ?>
<div class="<?php echo esc_attr(jwLayout::col_class(4)); ?> header-logo jaw-header-l-center">
     <?php echo jaw_get_template_part('logo', array('header', 'logo_area'));?>
</div>
<?php 
$header_widget_class = array();
$header_widget_class[] = 'sidebar';
$header_widget_class[] = jwLayout::col_class(4);
$header_widget_class[] = 'sidebars-preset-' . jwOpt::checkDefaultPreset(array(jwOpt::get_option('header_color', '_default'), jwOpt::get_option('main_color')),'color');
$header_widget_class[] = jwOpt::checkDefault(array(jwOpt::get_option('header_bar_type', '_default'), jwOpt::get_option('global_header_style', 'bar_type_1'))); 
?>

<div class="jaw-header-widget <?php echo esc_attr(implode(' ',$header_widget_class)); ?>">
    <div class="sidebar-box">
        <?php dynamic_sidebar('headerwidgetarea1'); ?>
    </div>
</div>
<div class="jaw-header-widget <?php echo esc_attr(implode(' ',$header_widget_class)); ?>">
    <div class="sidebar-box">
        <?php dynamic_sidebar('headerwidgetarea2'); ?>
    </div>
</div>

<div class="clear"></div>
<?php } ?>
<?php function jw_tmpl_header__logo_area__l_a(){ ?>
<div class="header-logo jaw-header-l-a">
     <?php echo jaw_get_template_part('logo', array('header', 'logo_area'));?>
</div>
<div class="jaw-in_header_banner-wrapper">
        <?php jwRender::get_banner('in_header', 12); ?>
</div>
<div class="clear"></div>
<?php } ?>
<?php function jw_tmpl_header__logo_area__l_center(){ ?>
<div class="<?php echo esc_attr(jwLayout::col_class(12)); ?> header-logo jaw-header-l-center">
     <?php echo jaw_get_template_part('logo', array('header', 'logo_area'));?>
</div>

<div class="clear"></div>
<?php } ?>
<?php function jw_tmpl_header__logo_area__l_left(){ ?>
<div class="<?php echo esc_attr(jwLayout::col_class(12)); ?> header-logo jaw-header-l-left">
     <?php echo jaw_get_template_part('logo', array('header', 'logo_area'));?>
</div>

<div class="clear"></div>
<?php } ?>
<?php function jw_tmpl_header__logo_area__l_right(){ ?>
<div class="<?php echo esc_attr(jwLayout::col_class(12)); ?> header-logo jaw-header-l-right">
     <?php echo jaw_get_template_part('logo', array('header', 'logo_area'));?>
</div>

<div class="clear"></div>
<?php } ?>
<?php function jw_tmpl_header__logo_area__logo(){ ?>
<?php
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
$template_logo_mobile = jwOpt::get_option('custom_mobile_logo', $template_logo);
if (strlen($template_logo) == 0) {
    $template_logo = JAW_THEME_URI . '/images/logo/logo.png';
}
if (strlen($template_logo_mobile) == 0) {
    $template_logo_mobile = $template_logo;
}
?>
<?php if (jwOpt::get_option('use_jaw_seo_logo', '1') == '1') { ?>
    <h1>
    <?php } else { ?>
        <p>
        <?php } ?>
        <a href="<?php echo home_url('/'); ?>" title="<?php bloginfo('name'); ?>">
            <img class="template-logo" src="<?php echo esc_url($template_logo); ?>">
            <img class="template-logo-mobile" src="<?php echo esc_url($template_logo_mobile); ?>">
        </a>
        <?php if (jwOpt::get_option('use_jaw_seo_logo', '1') == '1') { ?>
    </h1>
<?php } else { ?>
    </p>
<?php } ?>

<span itemprop="publisher" itemscope itemtype="https://schema.org/Organization">
    <meta itemprop="name" content="<?php echo get_bloginfo(); ?>"/>
            <span itemprop="logo" itemscope itemtype="http://schema.org/ImageObject">             <meta itemprop="url" content="<?php echo esc_url($template_logo); ?>" />         </span>    
    <meta itemprop="url" content="<?php echo home_url('/'); ?>"/>    
</span>
<?php } ?>
<?php function jw_tmpl_header__logo_area__under_menu(){ ?>
<div class="<?php echo esc_attr(jwLayout::col_class(12)); ?> header-logo jaw-header-l-center">
     <?php echo jaw_get_template_part('logo', array('header', 'logo_area'));?>
</div>

<div class="clear"></div>
<?php } ?>
<?php function jw_tmpl_header__menu__classic(){ ?>
<nav class="top-bar top-bar-jw jw-menu-bar" role="navigation">
            <section>
                <?php
                wp_nav_menu(
                        array(
                            'menu_class' => 'menu top-nav',
                            'theme_location' => 'primary_navigation',
                        )
                );
                ?>
                <div class="clear"></div>
            </section>
        </nav>
<?php } ?>
<?php function jw_tmpl_header__menu__colored(){ ?>
<nav class="top-bar top-bar-jw jw-menu-bar" role="navigation">
            <section>
                <?php
                wp_nav_menu(
                        array(
                            'menu_class' => 'menu top-nav',
                            'theme_location' => 'primary_navigation',
                        )
                );

                ?>
                <div class="clear"></div>
            </section>
        </nav>
<?php } ?>
<?php function jw_tmpl_header__menu__mobile_menu(){ ?>
<?php
$mobile_class = array();
$mobile_class[] = 'mobile-menu-preset-' . jwOpt::checkDefaultPreset(array(jwOpt::get_option('mobile_menu_color', '_default'), jwOpt::get_option('menu_color', '_default'), jwOpt::get_option('main_color')),'color');
?>
<div class="mobile-main-menu <?php echo esc_attr(implode(' ', $mobile_class)); ?>">
        <div class="jw-menu-wrapper">
                <div class="jw-mobile-menu-bar"  >
                        <div class="jw-open-mobile-menu jw-mobile-close">
                                <i class="jaw-icon-close"></i>
                        </div> 
                        <?php if (jwOpt::get_option('mobile_menu_show_search', '1')) { ?>
                        <div class="jw-mobile-search closed">
                                <div class="open-search-button">
                                <i class="jaw-icon-search3"></i>
                                </div>
                                <?php  get_search_form();  ?>
                        </div>
                        <?php } ?>
                </div>
                <nav class="jaw-mobile-menu-nav" role="navigation">
                <section> 
                        <?php
                        wp_nav_menu(
                                array(
                                'theme_location' => 'primary_mobile_navigation',
                                'mobile-menu' => 'true'
                                )
                        );
                        ?>
                        <div class="clear"></div>
                </section>
                </nav>
        </div>
        <div class="jw-close-mobile-menu">
        </div>
</div>
<?php } ?>
<?php function jw_tmpl_header__menu__mobile_userpanel(){ ?>
<?php
$mobile_class = array();
$mobile_class[] = 'mobile-menu-preset-' . jwOpt::checkDefaultPreset(array(jwOpt::get_option('mobile_menu_color', '_default'), jwOpt::get_option('menu_color', '_default'), jwOpt::get_option('main_color')),'color');
?>
<div class="mobile-main-menu mobile-user-content <?php echo esc_attr(implode(' ', $mobile_class)); ?>">
        <div class="jw-close-login">
        </div>
        <div class="jw-menu-wrapper">
                <div class="jw-mobile-menu-bar"  >
                        <div class="jw-close-login jw-mobile-close">
                                <i class="jaw-icon-close"></i>
                        </div>
                        <?php if (jwOpt::get_option('mobile_menu_show_search', '1')) { ?>
                        <div class="jw-mobile-search closed">
                                <div class="open-search-button">
                                <i class="jaw-icon-search3"></i>
                                </div>
                                <?php  get_search_form();  ?>
                        </div>
                        <?php } ?>
                </div>
                <?php
// 
                if (jwOpt::get_option('mobile_menu_show_login', '1')) {
                        jaw_template_set_var('settings_as_link', '1'); //settings use as link to settigs page
                        echo jaw_get_template_part('mobile_user_panel_controll', array('header', 'user_panel'));
                }
// 
                ?>
        </div>
</div>
<?php } ?>
<?php function jw_tmpl_header__menu__simple(){ ?>
<nav class="top-bar top-bar-jw jw-menu-bar" role="navigation">
            <section>
                <?php
                wp_nav_menu(
                        array(
                            'menu_class' => 'menu top-nav',
                            'theme_location' => 'primary_navigation',
                        )
                );
                ?>
                <div class="clear"></div>
            </section>
        </nav>
<?php } ?>
<?php function jw_tmpl_header__user_panel__banner(){ ?>
<?php
$banner = jwOpt::get_option('user_panel_banner', '');
if ($banner == '') {
    $banner = JAW_THEME_URI . '/images/default_user_banner.jpg';
}
if ($banner != '') {
    ?>
    <div class="user_panel_banner">
        <img src="<?php echo esc_url($banner); ?>" alt="User Panel Banner"/> 
    </div>
    <?php
}
?>
<?php } ?>
<?php function jw_tmpl_header__user_panel__featured_posts(){ ?>
<?php

$featured_posts = get_user_meta(get_current_user_id(), 'jaw_featured_posts', true);
if (!empty($featured_posts)) {
    global $wp_query, $jaw_data, $content_width;
    $old_query = $wp_query;
    $archive_preset = jwOpt::get_option('archive_preset', '_default');
    $qs = array();

    $qs['paged'] = (get_query_var('paged')) ? get_query_var('paged') : 1;

    $qs['post__in'] = $featured_posts;
    $qs['posts_per_page'] = jwOpt::get_option('user_reading_list_number_posts', 5);
    $qs['post_type'] = 'post';

    $blog_query = new WP_Query($qs);


    $blog_query->pagination = 'none';
    $blog_query->type = 'simple';
    $blog_query->columns = jaw_template_get_var('columns', '12');
    $blog_query->letter_excerpt = jwOpt::getPresetValue('letter_excerpt', '-1', 'category', $archive_preset);
    $blog_query->title_h = jwOpt::getPresetValue('title_h', '3', 'category', $archive_preset);
    $blog_query->letter_excerpt_title = jwOpt::getPresetValue('letter_excerpt_title', '-1', 'category', $archive_preset);
    $blog_query->blog_category_inimage = jwOpt::getPresetValue('blog_category_inimage', '1', 'category', $archive_preset);
    $blog_query->blog_comments_inimage = jwOpt::getPresetValue('blog_comments_inimage', '1', 'category', $archive_preset);
    $blog_query->blog_metadate = '1';
    $blog_query->blog_meta_author = '0';
    $blog_query->blog_comments_count = '0';   
    $blog_query->blog_meta_category = '0';
    $blog_query->blog_meta_like = '0';
    $blog_query->blog_ratings = '0';
    $blog_query->blog_readers = '1';  
    $blog_query->blog_featured_post = '1';  
    
    $blog_query->use_isotope = '1';
    $blog_query->blog_color = jwOpt::checkDefaultPreset(array(jwOpt::get_option('menu_color', '_default'), jwOpt::get_option('main_color')),'color');

    jaw_template_set_data($blog_query);  
    echo jaw_get_template_part('blog');
    
    if(jwOpt::get_option('user_bar_reading_list_page', '') !== '' || jwOpt::get_option('user_bar_reading_list_page', '') !== '_default' ){
        echo '<div class="jaw-mynews-show-all-reading">';
        echo '<a href="'.get_the_permalink(esc_attr(jwOpt::get_option('user_bar_reading_list_page', '')) ).'">';
        esc_html_e('show all posts', "gdn-theme"); 
        echo '<i class=" jaw-icon-arrow-right3"></i>';
        echo '</a>';
        echo '</div>';
    }

    wp_reset_query();
    $wp_query = $old_query;
}?>
<?php } ?>
<?php function jw_tmpl_header__user_panel__interested_comments_old(){ ?>
<?php
/* Nepouziva se */


$interest_coments = get_user_meta(get_current_user_id(), 'jaw_interest_comments', true);
$authors = array();
if (isset($interest_coments['authors'])) {
    $authors = $interest_coments['authors'];
}
$interested_posts = array();
if (isset($interest_coments['posts'])) {
    $interested_posts = $interest_coments['posts'];
}
$args = array(
    'author__in' => $authors,
    'post__in' => $interested_posts,
    'status' => 'approve',
    'number' => 3
);
// The Query
$comments_query = new WP_Comment_Query();
$comments = $comments_query->query($args);

// Comment Loop
if ($comments) {
    foreach ((array) $comments as $comment) {
        $url = get_comment_link($comment->comment_ID);
        echo '<div class="jaw-interest-one-comment">';
        echo '<div><span class="jaw-interest-one-comment-author"><i class="jaw-icon-user"></i><a href="' . $url . '">' . esc_attr($comment->comment_author) . '</a></span></div>';
        echo '<div><span class="jaw-interest-one-comment-title"><i class="jaw-icon-pencil"></i><a href="' . $url . '">' . esc_attr(get_the_title($comment->comment_post_ID)) . '</a></span></div>';
        echo '<div><span class="jaw-interest-one-comment-content">"' . esc_attr(substr($comment->comment_content, 0, 50)) . '..."</span></div>';
        echo '<div><span class="jaw-interest-one-comment-date">' . esc_attr(get_comment_date(get_option('date_format'), $comment->comment_ID)) . '</span></div>';
        echo '</div>';
    }
} else {
    echo 'No comments found.';
}
wp_reset_query();
?>
<?php } ?>
<?php function jw_tmpl_header__user_panel__interested_disscussions(){ ?>
<?php
$interest_coments = get_user_meta(get_current_user_id(), 'jaw_interest_comments', true);
$interested_posts = array();
if (isset($interest_coments['posts'])) {
    $interested_posts = $interest_coments['posts'];
}
if (!empty($interested_posts)) {
    global $wp_query, $jaw_data, $content_width;
    $old_query = $wp_query;
    $archive_preset = jwOpt::get_option('archive_preset', '_default');
    
    add_filter('posts_join', array('jwUtils','join_last_comment'));
    add_filter('posts_orderby', array('jwUtils', 'orderby_last_comment'));
    $qs = array();

    $qs['paged'] = (get_query_var('paged')) ? get_query_var('paged') : 1;
    $qs['post__in'] = $interested_posts;
    $qs['posts_per_page'] = jwOpt::get_option('user_comments_number_posts', 5);
    $qs['post_type'] = 'post';
 
    $qs['post_status'] = 'publish';
    $blog_query = new WP_Query($qs);
    
    remove_filter('posts_join', array('jwUtils','join_last_comment'));
    remove_filter('posts_orderby', array('jwUtils', 'orderby_last_comment'));

    $blog_query->pagination = 'none';
    $blog_query->type = 'simple';
    $blog_query->columns = jaw_template_get_var('columns', '12');
    $blog_query->letter_excerpt = jwOpt::getPresetValue('letter_excerpt', '-1', 'category', $archive_preset);
    $blog_query->title_h = jwOpt::getPresetValue('title_h', '3', 'category', $archive_preset);
    $blog_query->letter_excerpt_title = jwOpt::getPresetValue('letter_excerpt_title', '-1', 'category', $archive_preset);
    $blog_query->blog_category_inimage = '0';
    $blog_query->blog_comments_inimage = '0';
    $blog_query->blog_metadate = '0';
    $blog_query->blog_meta_author = '0';
    $blog_query->blog_comments_count = '0';   
    $blog_query->blog_meta_category = '0';
    $blog_query->blog_meta_like = '0';
    $blog_query->blog_ratings = '0';
    $blog_query->blog_readers = '0';   
    $blog_query->blog_last_comment_date = '1';   
    $blog_query->blog_featured_post = '0';   
    
    $blog_query->use_isotope = '1';
    $blog_query->blog_color = jwOpt::checkDefaultPreset(array(jwOpt::get_option('menu_color', '_default'), jwOpt::get_option('main_color')),'color');

    jaw_template_set_data($blog_query);  
    echo jaw_get_template_part('blog');
    wp_reset_query();
    $wp_query = $old_query;
}?>
<?php } ?>
<?php function jw_tmpl_header__user_panel__interested_posts(){ ?>
<?php

$interest_post = get_user_meta(get_current_user_id(), 'jaw_interest_posts', true);

global $wp_query, $jaw_data, $content_width;
$old_query = $wp_query;
$archive_preset = jwOpt::get_option('archive_preset', '_default');
$qs = array();

$qs['paged'] = (get_query_var('paged')) ? get_query_var('paged') : 1;
$qs['tax_query'] = array();
$qs['tax_query']['relation'] = 'OR';
if (!empty($interest_post['cat'])) {
    $qs['tax_query'][] = array(
        'taxonomy' => 'category',
        'field' => 'ID',
        'terms' => $interest_post['cat'],
        'include_children' => false 
    );
}
if (!empty($interest_post['tag'])) {
    $qs['tax_query'][] = array(
        'taxonomy' => 'post_tag',
        'field' => 'ID',
        'terms' => $interest_post['tag'],
        'include_children' => false 
    );
}
$qs['posts_per_page'] = esc_attr(jwOpt::get_option('user_interest_posts','4'));
$qs['post_type'] = 'post';
$qs['post_status'] = 'publish';
$blog_query = new WP_Query($qs);

$blog_query->pagination = 'none';
$blog_query->type = jwOpt::get_option('user_interest_boxes_type','vertical');
$blog_query->columns = 12/jwOpt::get_option('user_interest_columns','2');
$blog_query->letter_excerpt = jwOpt::get_option('user_interest_letter_excerpt','0');
$blog_query->title_h = jwOpt::get_option('user_interest_title_h','3');
$blog_query->letter_excerpt_title = jwOpt::get_option('user_interest_letter_excerpt_title','-1');
$blog_query->blog_category_inimage = jwOpt::getPresetValue('blog_category_inimage', '1', 'category', $archive_preset);
$blog_query->blog_comments_inimage = jwOpt::getPresetValue('blog_comments_inimage', '1', 'category', $archive_preset);
$blog_query->blog_metadate = '1';
$blog_query->blog_meta_author = '0';
$blog_query->blog_comments_count = '0';   
$blog_query->blog_meta_category = '0';
$blog_query->blog_meta_like = '0';
$blog_query->blog_ratings = '0';
$blog_query->blog_readers = '1';   
$blog_query->blog_featured_post = '1';   

$blog_query->use_isotope = '1';
$blog_query->blog_color = jwOpt::checkDefaultPreset(array(jwOpt::get_option('menu_color', '_default'), jwOpt::get_option('main_color')),'color');


jaw_template_set_data($blog_query);
echo jaw_get_template_part('blog');

wp_reset_query();
$wp_query = $old_query;
?>
<?php } ?>
<?php function jw_tmpl_header__user_panel__mobile_user_panel_controll(){ ?>
<div class="jaw-user-panel ">
    <?php
    if (is_user_logged_in()) {
        $class = 'user-loggedin';
    } else {
        $class = 'np-user-loggedin';
    }
    ?>
    <div class="jaw-user-buttons mobile-menu-item <?php echo esc_attr($class); ?>">
        <div class="jaw-user-login">
            <?php if (is_user_logged_in()) { ?>
                <div class="jaw-user-loggedin">
                    <div class="jaw-user-button jaw_button jaw-user-logout btn">
                        <a href="<?php echo wp_logout_url(get_permalink(esc_attr(jwOpt::get_option('user_bar_logout_pageid', '')))); ?>" title="login"><?php esc_html_e('Log Out', "gdn-theme"); ?></a>
                    </div>
                    <div class="jaw-user-name">
                        <div class="jaw-greetings">
                            <?php esc_html_e('Welcome,', "gdn-theme"); ?>
                        </div>
                        <div class="jaw-name" >
                            <?php $current_user = wp_get_current_user(); ?>
                            <?php echo esc_attr($current_user->display_name); ?>
                        </div>
                    </div>
                </div>
            <?php } else { ?>
                <div class="jaw-user-loggedout">
                    <?php if (get_option('users_can_register')) { ?>
                        <div class="jaw-user-item">
                            <div class="jaw-user-button jaw_button jaw-user-register-mobile btn">
                                <a href="#" title="register"><?php esc_html_e('Register', "gdn-theme"); ?></a>
                            </div>

                        </div>
                    <?php } ?>
                    <div class="jaw-user-item">
                        <div class="jaw-user-button jaw_button jaw-user-log-in-mobile btn">
                            <a href="#" title="login"><?php esc_html_e('Log In', "gdn-theme"); ?></a>
                        </div>
                       
                    </div>
                </div>
            <?php } ?>
        </div>
        <?php if (is_user_logged_in() && jwOpt::get_option('mobile_menu_show_login', '1') == '2') { ?>
            <ul class="sub-menu user-sub-menu  depth-0">

                <li class="menu-item menu-item-type-custom mobile-menu-item">

                    <div class="jaw-user-item" data-content=".jaw-user-favorites">
                        <?php if (jaw_template_get_var('settings_as_link', '0') == '1') { // link to settigs page ?>
                            <a href="#">
                                <i class="jaw-icon-star3"></i><?php esc_html_e("Favorites", "gdn-theme"); ?>
                            </a>                        
                        <?php } ?>
                    </div>
                </li>
                <li class="menu-item menu-item-type-custom mobile-menu-item">

                    <div class="jaw-user-item" data-content=".jaw-user-time">
                        <?php if (jaw_template_get_var('settings_as_link', '0') == '1') { // link to settigs page ?>
                            <a href="#">
                                <i class="jaw-icon-clock"></i><?php esc_html_e("History", "gdn-theme"); ?>
                            </a>                        
                        <?php } ?>
                    </div>
                </li>
                <li class="menu-item menu-item-type-custom mobile-menu-item">

                    <div class="jaw-user-item jaw-user-settings">
                        <?php if (jaw_template_get_var('settings_as_link', '0') == '1') { // link to settigs page ?>
                            <a href="<?php echo esc_url(get_permalink(jwOpt::get_option('user_account_pageid'))); ?>">
                                <i class="jaw-icon-settings-new"></i><?php esc_html_e("Settings", "gdn-theme"); ?>
                            </a>
                        <?php } ?>
                    </div>
                </li>
            </ul>

        <?php } else { ?>

            <ul class="sub-menu logged-out-menu depth-0">

                <li class="menu-item jaw-register-mobile-content menu-item-type-custom mobile-menu-item">

                    <div class="jaw-user-content-register jaw-user-content <?php echo (defined('REGISTERED_A_USER')) ? 'jaw-user-registered-now' : ''; ?>">
                        <?php
                        echo jaw_get_template_part('register', 'simple-shortcodes');
                        ?>
                    </div>
                </li>
                <li class="menu-item jaw-login-mobile-content menu-item-type-custom mobile-menu-item">

                     <div class="jaw-user-content-login jaw-user-content">
                            <?php
                            jaw_template_set_var('show_register', '0');
                            echo jaw_get_template_part('login', 'simple-shortcodes');
                            ?>
                        </div>
                </li>
            </ul>
        <?php } ?>

    </div>

</div>

<?php } ?>
<?php function jw_tmpl_header__user_panel__recent_posts(){ ?>
<?php
$recent_posts = get_user_meta(get_current_user_id(), 'jaw_visited_posts', true);

if (!empty($recent_posts)) {
    global $wp_query, $jaw_data, $content_width;
    $old_query = $wp_query;
    $archive_preset = jwOpt::get_option('archive_preset', '_default');
    $qs = array();

    $qs['paged'] =  1;
    $ids = array_reverse(array_keys($recent_posts));
    $qs['post__in'] = $ids;
    $qs['posts_per_page'] = jwOpt::get_option('user_history_posts','3');
    $qs['post_type'] = 'post';
    $qs['orderby'] = 'post__in';
    $qs['post_status'] = 'publish';

    $blog_query = new WP_Query($qs);
    $blog_query->pagination = 'none';
    $blog_query->type = jwOpt::get_option('user_history_boxes_type','simple');
    $blog_query->columns = 12/jwOpt::get_option('user_history_columns','3');
    $blog_query->letter_excerpt =  jwOpt::get_option('user_history_letter_excerpt','300');
    $blog_query->title_h = jwOpt::get_option('user_history_title_h','3');
    $blog_query->letter_excerpt_title = jwOpt::get_option('user_history_letter_excerpt_title','150');
    $blog_query->blog_category_inimage = jwOpt::getPresetValue('blog_category_inimage', '1', 'category', $archive_preset);
    $blog_query->blog_comments_inimage = jwOpt::getPresetValue('blog_comments_inimage', '1', 'category', $archive_preset);
    $blog_query->blog_metadate = '1';
    $blog_query->blog_meta_author = '0';
    $blog_query->blog_comments_count = '0';   
    $blog_query->blog_meta_category = '0';
    $blog_query->blog_meta_like = '0';
    $blog_query->blog_ratings = '0';
    $blog_query->blog_readers = '1';  
    $blog_query->blog_featured_post = '1';  
    
    $blog_query->use_isotope = '1';
    $blog_query->blog_color = jwOpt::checkDefaultPreset(array(jwOpt::get_option('menu_color', '_default'), jwOpt::get_option('main_color')),'color');

    jaw_template_set_data($blog_query);
    echo jaw_get_template_part('blog');

    wp_reset_query();
    $wp_query = $old_query;
}?>
<?php } ?>
<?php function jw_tmpl_header__user_panel__settings(){ ?>
<form id="jwjs_user_settings">
    <h3 class="jaw-user-settings-title"><i class="jaw-icon-star3"></i><?php esc_html_e("Choose what you're interested in:", "gdn-theme"); ?></h3>
    <?php
    $interest_post = get_user_meta(get_current_user_id(), 'jaw_interest_posts', true);
    $interest_coments = get_user_meta(get_current_user_id(), 'jaw_interest_comments', true); // jen pro prehled jiz odebiranych a odhlaseni odberu

    /* JAW_CATEGORIES************************************ */
    $args = array(
        'type' => 'post',
        'hide_empty' => 1,
        'taxonomy' => 'category'
    );
    $terms = get_categories($args);
    if (!empty($terms)) {
        ?>
        <div class="jaw-user-settings-item">
            <h4><?php esc_html_e("Categories:", "gdn-theme"); ?></h4>
            <?php
            foreach ((array) $terms as $term) {
                $check = "";
                $class = "";
                if (!empty($interest_post['cat']) && in_array($term->term_id, $interest_post['cat'])) {
                    $check = 'checked="checked"';
                    $class = "checked";
                }
                echo '<span class="jaw-settings-checkbox ' . esc_attr($class) . '">';
                echo '<input type="checkbox" id="cat-' . esc_attr($term->term_id) . '" ' . esc_attr($check) . ' name="cat[' . esc_attr($term->term_id) . ']" />';
                echo '<label for="cat-' . esc_attr($term->term_id) . '"><i class="jaw-icon-checkbox-unchecked2"></i><i class="jaw-user-checkmark jaw-icon-checkmark"></i>' . esc_attr($term->name) . '</label>';
                echo '<br>';
                echo '</span>';
            }
            ?>
        </div>
        <?php
    }

    /* TAGS************************************ */
    $args = array(
        'type' => 'post',
        'hide_empty' => 1,
        'taxonomy' => 'post_tag'
    );
    $terms = get_categories($args);
    if (!empty($terms)) {
        ?>
        <div class="jaw-user-settings-item">
            <h4><?php esc_html_e("Tags:", "gdn-theme"); ?></h4>
            <?php
            foreach ((array) $terms as $term) {
                $check = '';
                $class = "";
                if (!empty($interest_post['tag']) && in_array($term->term_id, $interest_post['tag'])) {
                    $check = 'checked="checked"';
                    $class = "checked";
                }
                echo '<span class="jaw-settings-checkbox ' . esc_attr($class) . '">';
                echo '<input type="checkbox" id="tag-' . esc_attr($term->term_id) . '" ' . esc_attr($check) . ' name="tag[' . esc_attr($term->term_id) . ']" />';
                echo '<label for="tag-' . esc_attr($term->term_id) . '"><i class="jaw-icon-checkbox-unchecked2"></i><i class="jaw-user-checkmark jaw-icon-checkmark"></i>' . esc_attr($term->name) . '</label>';
                echo '<br>';
                echo '</span>';
            }
            ?>
        </div>
        <?php
    }



    /* AUTHORS ************************************ */
    $args = array(
        'who' => 'authors'
    );
    $users = get_users($args);
    if (!empty($users)) {
        ?>
        <div class="jaw-user-settings-item">
            <h4><?php esc_html_e("Authors:", "gdn-theme"); ?></h4>
            <?php
            foreach ((array) $users as $usr) {
                $check = '';
                $class = "";
                if (!empty($interest_post['usr']) && in_array($usr->data->ID, $interest_post['usr'])) {
                    $check = 'checked="checked"';
                    $class = "checked";
                }
                echo '<span class="jaw-settings-checkbox ' . esc_attr($class) . '">';
                echo '<input type="checkbox" id="usr-' . esc_attr($usr->data->ID) . '" ' . esc_attr($check) . ' name="usr[' . esc_attr($usr->data->ID) . ']" />';
                echo '<label for="usr-' . esc_attr($usr->data->ID) . '"><i class="jaw-icon-checkbox-unchecked2"></i><i class="jaw-user-checkmark jaw-icon-checkmark"></i>' . esc_attr($usr->data->display_name) . '</label>';
                echo '<br>';
                echo '</span>';
            }
            ?>
        </div>
    <?php } ?>

    <?php
    /* POSTS ************************************ */
    if (empty($interest_coments['posts'])) {
        $interest_coments['posts'] = array();
    } else {
        ?>
        <div class="jaw-user-settings-item">
            <h4><?php esc_html_e("Comments:", "gdn-theme"); ?></h4>
            <?php
            foreach ((array) $interest_coments['posts'] as $post_id) {

                $check = 'checked="checked"';
                $class = "checked";
                echo '<span class="jaw-settings-checkbox ' . esc_attr($class) . '">';
                echo '<input type="checkbox" id="pst-' . esc_attr($post_id) . '" ' . esc_attr($check) . ' name="pst[' . esc_attr($post_id) . ']" />';
                echo '<label for="pst-' . esc_attr($post_id) . '"><i class="jaw-icon-checkbox-unchecked2"></i><i class="jaw-user-checkmark jaw-icon-checkmark"></i>' . get_the_title($post_id) . '</label>';
                echo '<br>';
                echo '</span>';
            }
            ?>
        </div>
    <?php } ?>


</form>
<?php } ?>
<?php function jw_tmpl_header__user_panel__user_panel_content(){ ?>
<?php
$featured_class = 6;
$comments_count = 3;
if (jwOpt::get_option('fbcomments_switch', '0') == '1' || (defined('DISQUS_DOMAIN') && get_option('disqus_active'))) {
    $featured_class = 9;
    $comments_count = 0;
}
?>

    <div class="jaw-user-item jaw-user-favorites">
        <div class="jaw-user-content row">
            <div class="<?php echo esc_attr(jwLayout::col_class($featured_class)); ?> jw-uc-interested-posts">
                <?php
                $atts = array(
                    'box_title' => esc_html__('Interested posts', "gdn-theme"),
                    'bar_type' => jwOpt::get_option('global_header_style', 'bar_type_1')
                );
                jaw_template_set_data($atts);
                echo jaw_get_template_part('section_bar', 'simple-shortcodes');
                if ($comments_count) {
                    jaw_template_set_var('columns', '6');
                } else {
                    jaw_template_set_var('columns', '4');
                }
                echo jaw_get_template_part('interested_posts', array('header', 'user_panel'));
                ?>
            </div>
            <?php if ($comments_count) { ?>
                <div class="<?php echo esc_attr(jwLayout::col_class($comments_count)); ?> jw-uc-interested-comments">
                    <?php
                    $atts = array(
                        'box_title' => esc_html__('Interested comments', "gdn-theme"),
                        'bar_type' => jwOpt::get_option('global_header_style', 'bar_type_1')
                    );
                    jaw_template_set_data($atts);
                    echo jaw_get_template_part('section_bar', 'simple-shortcodes');
                    echo jaw_get_template_part('interested_disscussions', array('header', 'user_panel'));
                    ?>
                </div>
            <?php } ?>
            <div class="<?php echo esc_attr(jwLayout::col_class(3)); ?> jw-uc-reading-list">
                <?php
                $atts = array(
                    'box_title' => esc_html__('Reading List', "gdn-theme"),
                    'bar_type' => jwOpt::get_option('global_header_style', 'bar_type_1')
                );
                jaw_template_set_data($atts);
                echo jaw_get_template_part('section_bar', 'simple-shortcodes');
                echo jaw_get_template_part('featured_posts', array('header', 'user_panel'));
                ?>
            </div>
        </div>
        <div class="clear"></div>
        <div class="jaw_user_hide"><span class="jaw_user_hide_button"><i class="jaw-icon-arrow-slide-up jaw-hide-first"></i><i class="jaw-icon-arrow-slide-up jaw-hide-second"></i><i class="jaw-icon-arrow-slide-up jaw-hide-third"></i></span></div>
    </div>

    <div class="jaw-user-item jaw-user-time">
        <div class="jaw-user-content row">
            <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
                <?php
                $atts = array(
                    'box_title' => esc_html__('History', "gdn-theme"),
                    'bar_type' => jwOpt::get_option('global_header_style', 'bar_type_1')
                );
                jaw_template_set_data($atts);
                echo jaw_get_template_part('section_bar', 'simple-shortcodes');
                echo jaw_get_template_part('recent_posts', array('header', 'user_panel'));
                ?>
                <div class="row jwjs-clear-history" >
                    <a class=" jaw_button " href="#" title="<?php esc_html_e('Delete history', "gdn-theme"); ?>"><i class="jaw-icon-remove"></i> Delete history</a>
                </div>
                <div class="clear"></div>
            </div>
            <div class="clear"></div>
        </div>
        <div class="clear"></div>
        <div class="jaw_user_hide"><span class="jaw_user_hide_button"><i class="jaw-icon-arrow-slide-up jaw-hide-first"></i><i class="jaw-icon-arrow-slide-up jaw-hide-second"></i><i class="jaw-icon-arrow-slide-up jaw-hide-third"></i></span></div>
    </div>

<?php } ?>
<?php function jw_tmpl_header__user_panel__user_panel_controll(){ ?>
<div class="jaw-user-panel <?php echo 'user-preset-' . jwOpt::get_option('my_news_color', jwOpt::get_option('main_color')); ?> ">
    <?php
    if (is_user_logged_in()) {
        $class = 'user-loggedin';
    } else {
        $class = 'np-user-loggedin';
    }
    ?>
    <div class="jaw-user-buttons <?php echo esc_attr($class); ?>">
        <div class="jaw-user-item jaw-user-item-favorites" data-content=".jaw-user-favorites">
            <?php  if (!is_user_logged_in()) { // link to settigs page ?>
                <a href="<?php echo esc_url(get_permalink(jwOpt::get_option('user_account_pageid'))); ?>">
                    <i class="jaw-icon-star3"></i>
                </a>
            <?php } else { ?>
                <i class="jaw-icon-star3"></i>
            <?php } ?>
        </div>

        <div class="jaw-user-item jaw-user-item-time" data-content=".jaw-user-time">
            <?php  if (!is_user_logged_in()) { // link to settigs page ?>
                <a href="<?php echo esc_url(get_permalink(jwOpt::get_option('user_account_pageid'))); ?>">
                    <i class="jaw-icon-clock"></i>
                </a>
            <?php } else { ?>
                <i class="jaw-icon-clock"></i>
            <?php } ?>
        </div>

        <div class="jaw-user-item jaw-user-settings">
                <a href="<?php echo esc_url(get_permalink(jwOpt::get_option('user_account_pageid'))); ?>">
                    <i class="jaw-icon-settings-new"></i>
                </a>
                    <?php if (!is_user_logged_in()) { ?>
                        <div class="jaw-user-content">
                        <?php echo jaw_get_template_part('banner', array('header', 'user_panel')); ?>
                        </div>
                    <?php } ?>
                
        </div>
    </div>
    <div class="jaw-user-login">
        <?php if (is_user_logged_in()) { ?>
            <div class="jaw-user-loggedin">
                <div class="jaw-user-button jaw_button jaw-user-logout btn">
                    <a href="<?php echo wp_logout_url(get_permalink(esc_attr(jwOpt::get_option('user_bar_logout_pageid', '')))); ?>" title="login"><?php esc_html_e('Log Out', "gdn-theme"); ?></a>
                </div>
                <div class="jaw-user-name">
                    <div class="jaw-greetings">
                        <?php esc_html_e('Welcome,', "gdn-theme"); ?>
                    </div>
                    <div class="jaw-name">
                        <?php $current_user = wp_get_current_user(); ?>
                        <?php echo esc_attr($current_user->display_name); ?>
                    </div>
                </div>
            </div>
        <?php } else { ?>
            <div class="jaw-user-loggedout">
            <?php
                do_action("jaw_before_register_button");
                if (get_option('users_can_register')) { ?>
                    <div class="jaw-user-item">
                        <div class="jaw-user-button jaw_button jaw-user-register btn">
                            <a href="#" title="register"><?php esc_html_e('Register', "gdn-theme"); ?></a>
                        </div>
                        <div class="jaw-user-content-register jaw-user-content <?php echo (defined('REGISTERED_A_USER')) ? 'jaw-user-registered-now' : ''; ?>">
                            <?php
                            echo jaw_get_template_part('register', 'simple-shortcodes');
                            ?>
                        </div>
                    </div>
                <?php } 
                ?>
                <div class="jaw-user-item">
                    <div class="jaw-user-button jaw_button jaw-user-log-in btn">
                        <a href="#" title="login"><?php esc_html_e('Log In', "gdn-theme"); ?></a>
                    </div>
                    <div class="jaw-user-content-login jaw-user-content">
                        <?php
                        jaw_template_set_var('show_register', '0');
                        echo jaw_get_template_part('login', 'simple-shortcodes');
                        ?>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
</div>
<?php } ?>