<?php

$args = jaw_template_get_var('args');
$instance = jaw_template_get_var('instance');

if (!empty($instance)) {

    extract($args);

    echo $before_widget;

    $title = apply_filters('widget_title', empty($instance['widget_title']) ? '' : $instance['widget_title'], $instance, '');

    if (!empty($title)) {
        echo $before_title . $title . $after_title;
    }

    $social = array(
        "facebook" => array("var" => $instance['fb_username'],
            "type" => "user",
        ),
        "twitter" => array("var" => $instance['tw_username'],
            "type" => "user",
        ),
        "vimeo" => array("var" => $instance['vimeo_username'],
            "type" => "user",
        ),
        "instagram" => array("var" => $instance['i_username'],
            "type" => "user",
        ),
        "tumblr" => array("var" => $instance['tumblr_username'],
            "type" => "user",
        ),
        "youtube" => array("var" => $instance['youtube_username'],
            "type" => "user",
        ),
        "google" => array("var" => $instance['g_username'],
            "type" => "user",
        ),
        "rss" => array("var" => $instance['rss_link'],
            "type" => "link",
            "text" => esc_html__("Subscribe To", "gdn-theme"),
            "subtext" => esc_html__("RSS", "gdn-theme")
        ),
    );

    $social_active = array();
    foreach ($social as $service => $vars) {
        if (!empty($vars["var"])) {
            $social_active[$service] = $social[$service];
        }
    }
    
    if(!isset($instance['show_errors'])){
        $show_errors = '1';
    }else{
        $show_errors = $instance['show_errors'];
    }

    $row = 0;

    foreach ($social_active as $service => $vars) {

        if ($vars["type"] == 'user') {
            if (!empty($vars["var"])) {

                $username_hash = jwUtils::jaw_base64_enc($vars["var"]);
                $namespace = $service . '_' . $username_hash;

                $service_vars = unserialize(jaw_template_call('_getOption', array($namespace, '_vars')));
                $cache_time = jaw_template_call('_getOption', array($namespace, '_last_actualization'));

                if ((isset($service_vars->error) && $service_vars->error != '' ) || $cache_time == null || ( $cache_time + ( 60 * $instance['cache_time'] ) ) < time() || $service_vars == null) {
                    //nemam cache
                    $service_vars = jaw_template_call($service . '_followers_counter', array($vars["var"]));

                    jaw_template_call('_setOption', array($namespace, '_vars', serialize($service_vars)));
                    jaw_template_call('_setOption', array($namespace, '_last_actualization', time()));
                }
                if (isset($service_vars)) {
                    echo "<div class='social " . $service . "'>";
                    if (isset($service_vars->error) && $service_vars->error !== '' && $show_errors === '1') {
                        echo '<div class="jaw_msg jaw_msg_type_warning">'.esc_attr($service_vars->error).esc_html__(' Please check Theme Options -> Api keys','gdn-theme').'</div>';
                    } else {
                        echo "<a href='" . esc_url($service_vars->url) . "' class='" . esc_attr($vars["type"]) . "'>";
                        echo "<div class='jaw-social-icon-box'>";
                        echo "<div class='jaw-social-icon'>";
                        echo '<span class="jaw-icon-' . esc_attr($service) . '"></span>';
                        echo "</div>";
                        echo "<div class='jaw-social-content'>";
                        echo '<span class="social-text">';
                        switch ($service) {
                            case "google": esc_html_e("followers", "gdn-theme");
                                break;
                            case "twitter": esc_html_e("followers", "gdn-theme");
                                break;
                            case "facebook": esc_html_e("fans", "gdn-theme");
                                break;
                            case "instagram": esc_html_e("followers", "gdn-theme");
                                break;
                            case "flickr": esc_html_e("photos", "gdn-theme");
                                break;
                            case "youtube": esc_html_e("subscribers", "gdn-theme");
                                break;
                            case "tumblr": esc_html_e("followers", "gdn-theme");
                                break;
                            case "vimeo": esc_html_e("followers", "gdn-theme");
                                break;
                            default: esc_html_e("followers", "gdn-theme");
                        }
                        echo '</span>';
                        echo '<span class="jaw-counter" data-from="0" data-to="' . esc_attr($service_vars->followers) . '">0</span>';
                        echo "</div>";
                        echo "</div>"; 
                        echo '</a>';
                    }
                    echo "</div>";
                }
            }
        } else {
            if (!empty($vars["var"])) {
                echo "<div class='social " . esc_attr($service) . "'>";
                echo "<a href='" . esc_url($vars["var"]) . "' class='" . esc_attr($vars["type"]) . "'>";
                echo "<div class='jaw-social-icon-box'>";
                echo "<div class='jaw-social-icon'>";
                echo '<div class="jaw-icon-feed2"></div>';
                echo "</div>";
                echo "<div class='jaw-social-content'>";
                echo "<span class='social-subtext'>" . esc_attr($vars["subtext"]) . "</span>"."<span class='social-text'>" . $vars["text"] . "</span>";
                echo "</div>";
                echo "</div>";
                echo "</a>";
                echo "</div>";
            }
        }

        $row++;
    }
    echo "<div class='clear'></div>";

    echo $after_widget;
}