<?php
global $jaw_data, $post, $wp_query;
$wp_query = jaw_template_get_data();
$counter = jaw_template_inc_counter("slider_5");

$class = array();
$class[] = jwLayout::col_class(12);
$class[] = 'fullwidth-'.jaw_template_get_var('fullwidth', 'fw_color'); 

$class_slider = array();
$class_slider[] = 'slider-preset-'.jaw_template_get_var('slider_preset_color', 'default'); 

echo jwUtils::customizer_preview_preset("Slider", jaw_template_get_var('slider_preset_color', ''));

$interval = 'false';
if(jaw_template_get_var('automatic_slide', 'false') == 'true'){
    $interval = jaw_template_get_var("slider_interval",5000);
}
?>
<div class="jaw-slider-5-wrapper jaw-preset-helper <?php echo esc_attr(implode(' ', $class_slider));?>">
    <div class="row jaw-main-slider">
        <div id="jaw-slider5-main-<?php echo esc_attr($counter); ?>" class="jaw_blog jaw-blog-slider slider_5_main carousel-sync carousel fade slide <?php echo esc_attr(implode(' ', $class));?>" data-interval="<?php echo esc_attr($interval);?>">
            <div class="carousel-inner row">
            <?php
            $first = 'active';
            $count_main = 0;
            while (have_posts()) {
                the_post();
                if(has_post_thumbnail()) {
                ?>
                <div class="item <?php echo esc_attr($first); ?>">
                    <?php 
                    $first = '';
                    ?>
                    <div class="jaw-slider-img jaw-mediabg">
                        <?php
                        echo jwMedia::getPostThumbnail(get_the_ID(), array('full'), null, null, array('class' => 'jaw-bg-item'));
                        ?>
                    </div>
                    <div class="jaw-slider-desc-container-main">
                        <div class="post-categories-labels">
                            <?php
                            if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                                echo jwRender::get_meta_category();
                            }
                            ?>
                        </div>
                        <div class="title">
                            <a href="<?php echo get_permalink(); ?>"><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></a>
                        </div>
                        <div class="meta">
                            <?php echo jaw_get_template_part('meta', 'meta'); ?>
                        </div>
                    </div>
                </div>
                <?php 
                    $count_main++;
                    if($count_main == 3){
                        break;
                    }
                }
            }  ?>  
            </div>        

        <div class="slider_5_navigate carousel-indicators">
            <?php
            $count = 0;
            //@todo celkem prasacky - chtelo by to udelat jinak
            $wp_query = new WP_Query($wp_query->query);
            while (have_posts()) {
                the_post();
                if(has_post_thumbnail()) {
                ?>
                <a href="<?php echo get_permalink(); ?>" class="jaw-slider-item" data-target="#jaw-slider5-main-<?php echo esc_attr($counter); ?>" data-slide-to="<?php echo esc_attr($count); ?>">
                    <div class="jaw-slider-desc-container-main">
                        <div class="title">
                            <span><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></span>
                        </div>
                    </div>
                </a>
            <?php 
            $count++;
            if($count == 3){
                break;
            }
            }
            } ?>

        </div>
        <div class="blog-slider-arrows">
            <a class="left slide_5_arr" href="#jaw-slider5-main-<?php echo esc_attr($counter); ?>" data-slide="prev">
                <span class="jaw-icon-sipka-gallery-left"></span>
            </a>
            <a class="right slide_5_arr" href="#jaw-slider5-main-<?php echo esc_attr($counter); ?>" data-slide="next">
                <span class="jaw-icon-sipka-gallery-right"></span>
            </a>
        </div>
    </div>
    </div>
    <div class="clear"></div>
</div>
<?php
wp_reset_query();
