<?php
global $jaw_data, $post, $wp_query;
$active = 'active';
$counter = 1;
$wp_query = jaw_template_get_data();
$slider_arrows = jaw_template_get_var('slider_arrows');
$post_in_cols = jaw_template_get_var('columns');
$total_post = $wp_query->post_count;
$class = array();
$class[] = jwLayout::col_class(12);
$class[] = 'clickable_image-'.jaw_template_get_var('clickable_image', '1');
$class[] = 'slider-preset-'.jaw_template_get_var('slider_preset_color', 'default'); 
$class[] = 'size-' . jaw_template_get_var('columns');
$check_sum = $post_in_cols+3-$total_post;
echo jwUtils::customizer_preview_preset("Slider", jaw_template_get_var('slider_preset_color', ''));
$approved = true;

if ($total_post <= $post_in_cols+3 && $check_sum != 0) {
    echo jwUtils::jaw_msg(sprintf(esc_html__('Row Slider - You should probably add more posts with featured images (%s at least).','gdn-theme'),$check_sum));
    $approved = false;
}

if($approved) {

$interval = 'false';
if(jaw_template_get_var('automatic_slide', 'false') == 'true'){
    $interval = jaw_template_get_var("slider_interval",5000);
}
$video_class = array();
if($post_in_cols > 3){
    $video_class[] = 'small';
}
?>
<div class="row">
    <div id="jaw-slider_4-<?php echo esc_attr(jaw_template_inc_counter('jaw-slider_4')); ?>" class="jaw-slider_4 jaw-preset-helper <?php echo esc_attr(implode(' ', $class)); ?>">
        <div class="slider-wrapper jaw_blog">
            <div class="slider-row ">
                <?php
                $konec = true;
                while (have_posts()) {
                    the_post();
                    if(has_post_thumbnail() || get_post_format() == "video") {
                    ?>
                    <div class="slider-item content-slider_4 shown <?php echo esc_attr($active); ?>">
                        <div class="slider-item-inner">
                            <?php
                            $link = false;
            
                            if(jaw_template_get_var('clickable_image', '1')){
                                $link = get_the_permalink();
                                ?><a class="clickable" href="<?php echo esc_url($link); ?>"></a><?php
                            }
                            $active = ''; 
                            if(get_post_format() == "video") {
                                echo '<span class="jaw-video-icon '. esc_attr(implode(' ',$video_class)) .'">'.apply_filters('jaw_default_video_icon', '<i class="jaw-icon-play4"></i>').'</span>';
                            }
                            
                            if(has_post_thumbnail()){
                                echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-16_9-big','jaw_blog-16_9'),$link);
                            }else if(get_post_format() == "video"){
                                $video = get_post_meta(get_the_ID(), 'jaw_post_video_link', true);
                                echo jwMedia::getVideoThumbnail($video, $link);
                            }
                            
                            $counter++;
                            ?>
                        </div>
                        <div class="desc-wrapper">
                            <div class="categories-slider_4">
                                <div class="post-categories-labels">
                                    <?php
                                    if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                                        echo jwRender::get_meta_category();
                                    }
                                    ?>
                                </div>
                            </div>
                            <div class="slider-item-title">
                                <h3><a href="<?php the_permalink(); ?>"><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></a></h3>
                            </div>
                            <div class="slider-item-desc">
                                <div class="slider-item-description-excerpt"><?php echo jwUtils::crop_length(get_the_excerpt(), jaw_template_get_var('letter_excerpt', 150)); ?></div>
                            </div>
                        </div>
                    </div>
                <?php 
                }
                }
                 ?>   
            </div>
            <?php
                if($slider_arrows) {
            ?>
            <div class="jaw-slider_4-arrows">
                <span class="left jaw-slider_4-arrow" data-direction="right">
                    <i class="jaw-icon-sipka-gallery-left"></i>
                </span>
                <span class="right jaw-slider_4-arrow"  data-direction="left">
                    <i class="jaw-icon-sipka-gallery-right"></i>
                </span>
            </div>
            <?php } ?>
        </div>
    </div>
    <script> 
    document.addEventListener("jaw-RunSliders", function(e) {
        jQuery('#jaw-slider_4-<?php echo jaw_template_get_counter('jaw-slider_4'); ?>').slider({autoSlide:<?php echo jaw_template_get_var('automatic_slide','true'); ?>,interval:<?php echo jaw_template_get_var('slider_interval','5000'); ?>});
    });
    </script>
</div>
<div class="clear"></div>
<?php
}



wp_reset_query();
