<?php
global $jaw_data, $post;
$query = jaw_template_get_data();
$counter = jaw_template_inc_counter("slider_3");
$link = false;
$disable_fadein = "";
if(jaw_template_get_var('disable_fadein', '1')) {
    $disable_fadein='jaw-fadein';
}

$class = array();
$class[] = jwLayout::col_class(12);
$class[] = 'autoslide-'.jaw_template_get_var('automatic_slide', '0');
$class[] = 'clickable_image-'.jaw_template_get_var('clickable_image', '1');
$class[] = 'navigation-'.jaw_template_get_var('carousel_style', 'bar');
$class[] = 'slider-preset-'.jaw_template_get_var('slider_preset_color', 'default'); 

echo jwUtils::customizer_preview_preset("Slider", jaw_template_get_var('slider_preset_color', ''));

$interval = 'false';
if(jaw_template_get_var('automatic_slide', 'false') == 'true'){
    $interval = jaw_template_get_var("slider_interval",5000);
}
?>
<div class="jaw-slider-3-wrapper">
    <div class="row jaw-main-slider">
        <div id="jaw-slider3-main-<?php echo esc_attr($counter); ?>" class="jaw_blog jaw-blog-slider slider_3 jaw-preset-helper slider_3_main carousel-sync carousel horizontal slide navigation-<?php echo esc_attr(implode(' ', $class));?>">
            <div class="carousel-inner row">
            <?php
            $first = 'active';
            $count_main = 0;
            while ($query->have_posts()) {
                $query->the_post();
                if(has_post_thumbnail()) {
                ?>
                <div class="item <?php echo esc_attr($first); ?>">
                    <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?> jaw-slider-img-item">
                        <div class="jaw-slider-img-list">
                            <?php
                            $first = '';
                            if(jaw_template_get_var('clickable_image', '1')){
                                $link = get_the_permalink(get_the_ID());
                                ?><a class="clickable" href="<?php echo esc_url($link); ?>"><?php
                                if(get_post_format() == "video") {
                                    echo '<span class="jaw-video-icon">'.apply_filters('jaw_default_video_icon', '<i class="jaw-icon-play4"></i>').'</span>';
                                }
                                ?></a><?php
                            }
                            echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-16_9-big','jaw_blog-16_9'));
                            ?>
                            <div class="<?php echo esc_attr($disable_fadein); ?>"></div>
                            <div class="jaw-slider-desc-container-main">
                                <div class="title">
                                    <span><a href="<?php echo get_permalink(); ?>"><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></a></span>
                                </div>
                                <div class="desc">
                                    <span><a href="<?php echo get_permalink(); ?>"><?php echo jwUtils::crop_length(get_the_excerpt(), jaw_template_get_var('letter_excerpt', 275)); ?></a></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php 
            $count_main++;
            }} ?>   
            </div>
            <script type="text/javascript">
                jQuery(document).ready(function() {
                    jQuery("#jaw-slider3-main-<?php echo esc_attr($counter); ?>").carousel({
                        interval: <?php echo jaw_template_get_var("slider_interval",5000); ?>
                    });
                });
            </script>
        </div>
    </div>
    <div class="row jaw-navigate-slider">
        <div id="jaw-slider3-slide-<?php echo esc_attr($counter); ?>" class="jaw_blog jaw-blog-slider slider_3 slider_3_slide carousel carousel-sync horizontal slide autoslide-0 navigation-<?php echo jaw_template_get_var('carousel_style', 'bar'); echo esc_attr(jwLayout::col_class(12)); ?>">
            <div class="carousel-inner row">
            <?php
            $query->posts=array_reverse($query->posts);
            $count = 0;
            while ($query->have_posts()) {
                $query->the_post();
                // second main img default
                if($count == 0) {
                    $first = "active";
                }
                if(has_post_thumbnail()) {
                ?>
                <div class="item <?php echo esc_attr($first); ?>">
                    <div class="col-xs-4 col-sm-4 col-md-4 col-lg-4 jaw-slider-img-item">
                        <div class="jaw-slider-img-list">
                            <?php
                            $first = '';
                            if(jaw_template_get_var('clickable_image', '1')){
                                $link = get_the_permalink(get_the_ID());
                                ?><a class="clickable" href="<?php echo esc_attr($link); ?>">
                                    <?php if(get_post_format() == "video") {
                                    echo '<span class="jaw-video-icon small">'.apply_filters('jaw_default_video_icon', '<i class="jaw-icon-play4"></i>').'</span>';
                                }?></a><?php
                            }
                            echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-special'));
                            ?>
                            <div class="<?php echo esc_attr($disable_fadein); ?>"></div>
                            <div class="jaw-slider-desc-container-main">
                                <div class="title">
                                    <span><a href="<?php echo get_permalink(); ?>"><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></a></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php 
            $count++;
            }} ?>
            </div>
            <div class="blog-slider-arrows">
                <a class="left slide_3_arr" href="#jaw-slider3-main-<?php echo esc_attr($counter); ?>" data-slide="prev">
                    <span class="jaw-icon-sipka-gallery-left"></span>
                </a>
                <a class="right slide_3_arr" href="#jaw-slider3-main-<?php echo esc_attr($counter); ?>" data-slide="next">
                    <span class="jaw-icon-sipka-gallery-right"></span>
                </a>
            </div>
        </div>
    </div>
    <div class="clear"></div>
</div>
<?php
wp_reset_query();
