<?php
global $jaw_data, $post, $wp_query;
$active = 'active';
$counter = 1;
$wp_query = jaw_template_get_data();
$post_in_cols = jaw_template_get_var('columns');
$approved=true;
$total_post = $wp_query->post_count;

$class = array();
$class[] = jwLayout::col_class(12);
$class[] = 'size-' . jaw_template_get_var('columns');
$class[] = 'clickable_image-'.jaw_template_get_var('clickable_image', '1');
$class[] = 'slider-preset-'.jaw_template_get_var('slider_preset_color', 'default'); 

echo jwUtils::customizer_preview_preset("Slider", jaw_template_get_var('slider_preset_color', ''));

if ($total_post < $post_in_cols+3) {
    echo jwUtils::jaw_msg(sprintf(esc_html__('Squares Slider - You should probably add more posts with featured images (%s at least).','gdn-theme'),$post_in_cols+3-$total_post));
    $approved = false;
}

if($approved) {
    
$interval = 'false';
if(jaw_template_get_var('automatic_slide', 'false') == 'true'){
    $interval = jaw_template_get_var("slider_interval",5000);
}
?>
<div class="row">
    <div id="jaw-slider_2-<?php echo esc_attr(jaw_template_inc_counter('jaw-slider_2')); ?>" class="jaw-slider_2 jaw-preset-helper <?php echo esc_attr(implode(' ',$class));?>">
        <div class="slider-wrapper jaw_blog">
            <div class="slider-row ">
                <?php
                $konec = true;
                while (have_posts()) {
                    the_post();
                    ?>
                    <div class="slider-item content-slider_2 shown <?php echo esc_attr($active); ?>">
                        <div class="slider-item-inner">
                            <?php 
                            $link = false;
                            if(jaw_template_get_var('clickable_image', '1')){
                                $link = get_the_permalink();
                                ?><a class="clickable" href="<?php echo esc_url($link); ?>"></a><?php
                            }
                            $active = '';
                            echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-special', 'jaw_slider-square'),$link);
                            $counter++;
                            ?>
                        </div>
                        <div class="slider-item-description <?php echo esc_attr($active); ?>">
                            <h3><a href="<?php the_permalink(); ?>"><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></a></h3>
                            <?php echo jaw_get_template_part('meta', 'meta'); ?>
                        </div>
                    </div>

                <?php 
                    }
                ?>   
            </div>
            <?php if($approved) { ?>
            <div class="jaw-slider_2-arrows">
                <span class="left jaw-slider_2-arrow" data-direction="right">
                    <i class="jaw-icon-sipka-gallery-left"></i>
                </span>
                <span class="right jaw-slider_2-arrow"  data-direction="left">
                    <i class="jaw-icon-sipka-gallery-right"></i>
                </span>
            </div>
            <?php  }?>
        </div>
 
    </div>
    <script>
    document.addEventListener("jaw-RunSliders", function(e) { 
        jQuery('#jaw-slider_2-<?php echo jaw_template_get_counter('jaw-slider_2'); ?>').slider({autoSlide:<?php echo jaw_template_get_var('automatic_slide','true'); ?>,interval:<?php echo jaw_template_get_var('slider_interval','5000'); ?>});
    });
    </script>
    
</div>
<div class="clear"></div>

<?php
}
wp_reset_query();
