<?php
global $post, $wp_query, $jaw_data, $content_width;
$first = 'active';
$col_count = jaw_template_get_var("columns", 12);
$main_title = jaw_template_get_var('ticker_title', 'default');
$random = jaw_template_inc_counter("ticker");
$query = jaw_template_get_data();
$type = jaw_template_get_var('ticker_type', 'classic');
$direction = jaw_template_get_var('ticker_direction', 'horizontal');

echo jwUtils::customizer_preview_preset("Breaking news", jaw_template_get_var('ticker_preset_color', ''));
?>

<div class="row jaw-ticker <?php echo esc_attr('ticker-preset-' . jaw_template_get_var('ticker_preset_color','')); ?> <?php echo esc_attr($type); ?>">
    <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
        <div class="jaw-ticker-wrapper">
            <div class="main-title"><span><?php echo esc_attr($main_title); ?></span></div>
            <div class="ticker-carousel-wrapper">
                <div id="jaw-carousel-ticker-<?php echo esc_attr($random); ?>" class="carousel <?php echo esc_attr($direction); ?>  slide navigation-<?php echo jaw_template_get_var('carousel_style', 'bar'); echo ' autoslide-'.jaw_template_get_var('automatic_slide', '0') ?>">
                    <div class="carousel-inner">
                    <?php
                        while ($query->have_posts()) {
                            $query->the_post(); ?>
                        <div class="item <?php echo esc_attr($first); ?>">
                            <a href="<?php the_permalink(); ?>"><?php
                                $first = "";
                                echo jaw_get_template_part('ticker_item', 'simple-shortcodes');?>
                            </a>
                        </div>
                            <?php
                        } ?>
                    </div>
                </div>
                <?php if($type != "classic") { ?>
                <div class="ticker-switcher ticker-switcher-closed">
                    <i class="jaw-icon-menu2"></i>
                </div>
                <?php  } else { ?>
                <div class="ticker-arrows">
                    <a class="left" href="#jaw-carousel-ticker-<?php echo esc_attr($random); ?>" data-slide="prev">
                        <span class="jaw-icon-sipka-gallery-left"></span>
                    </a>
                    <a class="right" href="#jaw-carousel-ticker-<?php echo esc_attr($random); ?>" data-slide="next">
                        <span class="jaw-icon-sipka-gallery-right"></span>
                    </a>
                </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>