<?php
global $multipage, $numpages, $page;
if($multipage) { // has post links
	$title = jaw_template_get_var("table_of_content_title");
	$items = explode(",",jaw_template_get_var("table_of_content_list"));
    $icon = jaw_template_get_var("icon");
    $format = "";
	if(count($items) == $numpages) { // must be equal bruh
	?>
		<div class="jaw-table-of-content-wrapper">
			<div class="row">
				<div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
					<div class="title"><h3><?php echo esc_attr($title); ?></h3></div>
					<div class="items">
						<?php 
						foreach($items as $i => $item) {
                            if(!empty($icon)) {
                                $format = '<i class="'.$icon.'"></i>';
                            } else {
                                $format = ($i+1).'. ';
                            }
							if($page == ($i+1)) { // active current page
								echo '<div class="item active">'.esc_attr($format).esc_attr($item).'</div>';
							} else {
								echo '<div class="item"><a href="'.add_query_arg( 'page', $i + 1, get_the_permalink()).'">'.esc_attr($format).esc_attr($item).'</a></div>';
							}
						} ?>
					</div>
				</div>
			</div>
		</div>
	<?php
	} else {
		echo jwUtils::jaw_msg(sprintf(esc_html__('The items and the page links should be the equal. You have %s items and %s page links','gdn-theme'),esc_attr(count($items)),
		esc_attr($numpages)),"warning");
	}
}