<?php global $jaw_data; ?>
<?php
$fw_style = '';
if (jaw_template_get_var('fullwidth') == '1' && jaw_template_get_var('size') == 12) {
    $fullwidth = 'row-fullwidth';
} else if (jaw_template_get_var('fullwidth') == 'full-item' && jaw_template_get_var('size') == 12) {
    $fullwidth = 'row-fullwidth-item';
} else {
    $fullwidth = '';
}

//default pro bartypy
$bar_type = jwOpt::checkDefault(array(jaw_template_get_var('bar_type', ''), jwOpt::get_option('global_header_style','bar_type_1')));
jaw_template_set_var('bar_type', $bar_type);

if (jaw_template_get_var('full_back_color') != '') {
    $fw_style = 'background: ' . jaw_template_get_var('full_back_color') . '; ';
}
$class = array();
$class[] =  jwLayout::col_class(jaw_template_get_var('size'));
$class[] = jaw_template_get_var('class');
$class[] = 'show-on-'.jaw_template_get_var('show_on_devices');
$class[] = $fullwidth;
$class[] = jaw_template_get_var('space_after', 'space_after');

$id="";
if(jaw_template_get_var('el_id') != null) {
    $id = 'id='.esc_attr(jaw_template_get_var('el_id'));
    $class[] = "has-onepage-id";
}
// image caption
$class[] = 'image_caption_toggle-' . jwOpt::get_option('image_caption_toggle');

?>
<div <?php echo esc_attr($id); ?> class="builder-section <?php echo esc_attr(implode(' ',$class)); ?>" >

    <?php
    if ($fullwidth == 'row-fullwidth') {
        echo '<div class="fullwidth-block row" style="' . esc_attr($fw_style) . '">';
    }
    $content = jaw_template_get_var('content'); 
    if (jaw_template_get_var('bar_type', '') != '') {
        echo jaw_get_template_part('section_bar', 'simple-shortcodes');
    }
    ?>
    <?php
    echo do_shortcode($content);
    if ($fullwidth == 'row-fullwidth') {
        echo '</div>';
    }
    ?>

</div>
<?php 
unset($class);
unset($fw_style);
unset($bar_type);
unset($fullwidth);
?>