<?php if (!is_user_logged_in() && get_option('users_can_register')) { ?>

    <div class="row">
        <div class="col-lg-12">
            <div class="jaw_login">
                <div class="login-content registration-form-wrapper">
                    <?php
                    if (isset($_POST['svalue']) && $_POST['svalue'] != jaw_template_get_var('answer', '2')) {
                        echo do_shortcode('[jaw_message message_style="warning" show_close="0" message_text="' . esc_html__('Wrong answer', "gdn-theme") . '"]');
                    } else if (defined('REGISTRATION_ERROR')) {
                        foreach (unserialize(REGISTRATION_ERROR) as $error) {
                            echo do_shortcode('[jaw_message message_style="warning" show_close="0" message_text="<strong>' . esc_html__('Error: ', "gdn-theme") . '</strong>' . esc_attr($error) . '"]');
                        }
                    } elseif (defined('REGISTERED_A_USER')) {
                        echo do_shortcode('[jaw_message message_style="success" show_close="0" message_text="<strong>' . esc_html__('Congratulations you have been registered.', "gdn-theme") . '</strong><br>' . esc_html__('Please check your e-mail box: ', "gdn-theme") . REGISTERED_A_USER . '"]');
                    }
                    ?>

                    <form id="jaw-registration-form" method="post" action="<?php echo add_query_arg('do', 'register', get_permalink($post->ID)); ?>#jaw_login">
                        <p>
                            <label for="username">Username</label>
                            <input type="text" class="input" id="username" name="user" value=""/>
                        </p><p>
                            <label for="email">E-mail</label>
                            <input type="text" class="input" id="email" name="email" value="" />
                        </p><p>
                            <label for="svalue"><?php echo jaw_template_get_var('question', 'What is a result of 1+1?'); ?></label>
                            <input type="text"  class="input" name="svalue" value="" />
                        </p><p class="jw-margin-bottom">
                            <?php echo esc_html__('A password will be e-mailed to you.', "gdn-theme"); ?>
                        </p><p >
                            <input type="hidden" value="<?php echo esc_attr(jaw_template_get_var('answer', '2')); ?>" name="jaw-register" /> 
                            <?php wp_nonce_field('jaw_register', 'jaw_register_nonce'); ?>
                            <input type="submit" class="reg-submit service-link regiter-button btn" value="<?php echo esc_html__('Register', "gdn-theme"); ?>" />
                            <div class="clear"></div>
                        </p>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <?php
}