<?php

$args = array(
    'echo' => true,
    'form_id' => 'loginform',
    'label_username' => esc_html__('Username','gdn-theme'),
    'label_password' => esc_html__('Password','gdn-theme'),
    'label_remember' => esc_html__('Remember Me','gdn-theme'),
    'label_log_in' => esc_html__('Log In','gdn-theme'),
    'id_username' => 'user_login',
    'id_password' => 'user_pass', 
    'id_remember' => 'rememberme',
    'id_submit' => 'wp-submit',
    'remember' => true,
    'value_remember' => false
);

if((int) jwOpt::get_option('user_bar_login_pageid', '') > 0){
    $args['redirect'] = get_permalink((int) jwOpt::get_option('user_bar_login_pageid', ''));
} 
?>
 
<div class="row">
    <div class="col-lg-12">
        <div class="jaw_login">
            <?php if (is_user_logged_in()) { ?>              
                <div class="login-content" >
                    <?php
                    $current_user = wp_get_current_user();
                    $user_id = $current_user->ID;
                    echo get_avatar($user_id, 60);
                    ?>
                    <p><?php echo esc_html__('Welcome, ', "gdn-theme"); ?></p><p class="user-name"><?php echo esc_attr($current_user->display_name) . '!'; ?></p>

                    <div class="clear"></div>
                    <p class="service-link jaw-user-logoutlink  btn"><a href="<?php echo wp_logout_url(); ?>"><?php esc_html_e('Log Out', "gdn-theme"); ?></a></p>
                    <p class="service-link jaw-user-settings  btn"><a href="<?php echo esc_url(get_permalink(jwOpt::get_option('user_account_pageid'))); ?>"><?php esc_html_e('Settings', "gdn-theme"); ?></a></p>
                    <?php jaw_template_inc_counter('login'); ?>
                </div>
            <?php } else { ?>
                <?php jaw_template_dec_counter('login'); ?>
                <div class="login-content" >
                    <div class="login">
                        <?php
                        wp_login_form($args);
                        ?>
                        <?php if (jaw_template_get_var('show_register', '1') == '1') { ?>
                            
                                <?php
                                $register_link = esc_url(wp_registration_url());
                                ?>
                                <?php echo apply_filters('register', sprintf('<a class="service-link regiter-button button-primary" href="%s">%s</a>', $register_link, esc_html__('Register', "gdn-theme"))); ?>
                            
                        <?php } ?>
                    </div>
                    <?php jaw_template_inc_counter('login'); ?>
                </div>
            <?php } ?>
        </div>
    </div>  
</div>