<?php
$class = '';

$bg_image = jaw_template_get_var('bg_image', '');
$bg_video_mp4 = jaw_template_get_var('bg_video_mp4', '');
$bg_video_url = jaw_template_get_var('bg_video_url', '');

$bg_paralax = jaw_template_get_var('bg_paralax', 'none');

$class .= jaw_template_get_var('bg_pattern', '1');


?>
<div class="jaw-mediabg <?php echo esc_attr($class) . ' jw-paralax-' . esc_attr($bg_paralax); ?>">
    <div class="background-wrap" >
        <?php
        if ($bg_video_url != '') {
            $video = jwMedia::getVideoInfo($bg_video_url);
            $video_frame_id = jaw_template_inc_counter('bg_item');
            if ($video->domain == 'youtube') {
                ?>
                <div id="bg_item_<?php echo esc_attr($video_frame_id); ?>" class="video jaw-keep-ratio jaw-bg-item"></div>
                <script>
                    var tag = document.createElement('script');
                    tag.src = "http://www.youtube.com/player_api";
                    var firstScriptTag = document.getElementsByTagName('script')[0];
                    firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);

                    var player;
                    function onYouTubePlayerAPIReady() {
                        player = new YT.Player('bg_item_<?php echo esc_attr($video_frame_id); ?>', {
                            playerVars: {'autoplay': 1, 'controls': 0, 'loop': 1, 'playlist': '<?php echo esc_attr($video->id); ?>'},
                            videoId: '<?php echo esc_attr($video->id); ?>',
                            events: {
                                'onReady': onPlayerReady}
                        });
                    }
                    function onPlayerReady(event) {
                        event.target.mute();
                    }
                </script>
                <?php
            }
        } else if ($bg_video_mp4 != '') {

            $width = 1920;
            $height = 1080;

            $meta = wp_get_attachment_metadata($bg_video_mp4);
            if (isset($meta['width'])) {
                $width = $meta['width'];
            }
            if (isset($meta['height'])) {
                $height = $meta['height'];
            }
            $mp4 = wp_get_attachment_url($bg_video_mp4);

            ?>
            <video  class="jaw-bg-video jaw-bg-item" width="<?php echo esc_attr($width); ?>" height="<?php echo esc_attr($height); ?>"  preload="auto" loop="true" data-setup="{}"  autoplay="" >
                <source src="<?php echo esc_url($mp4); ?>" type="video/mp4">

            </video>
            <?php
            if ($bg_image != '') {
                echo jwMedia::getAttachment($bg_image, array('full'), false, array(), array("class" => "jaw-bg-item jaw-bg-video-image"));
            }
        } else if ($bg_image != '') {
            
            if($bg_paralax == 'static'){
                echo '<div class="jaw-bg-item jaw-bg-paralax-static" style="background-image:url(\''.esc_url(jwMedia::getAttachmentSrc($bg_image, 'full')).'\')"></div>';
            }else{
                echo jwMedia::getAttachment($bg_image, array('full'), false, array(), array("class" => "jaw-bg-item"));
            }
            
        }
        ?>


    </div>
</div>
