<?php
global $jaw_data;

$size = jaw_template_get_var('button_size','default');
if ($size == "default") {
    $size = "";
}
$span_class = array();
$span_class[] = 'jw-align-'.jaw_template_get_var('align','none');

$style = array();

$rgba = jaw_template_get_var('button_bg_color');
$rgb = jwUtils::rgba2rgb($rgba);

if ($rgba == $rgb) {
    $style[] = 'background-color: ' . $rgba;
} else {
    $style[] = 'background-color: ' . $rgb;
    $style[] = 'background-color: ' . $rgba;
}
$style[] = 'color: ' . jaw_template_get_var('button_font_color');
?>
<span class="jaw_button <?php echo esc_attr(implode( ' ', $span_class)); ?>">
    <a type="button" class="btn <?php echo esc_attr($size); ?> jw-effect-ripple" href="<?php echo esc_url(jaw_template_get_var('link')); ?>" target="<?php echo esc_attr(jaw_template_get_var('target')); ?>" style="<?php echo esc_attr(implode(';', $style)); ?>">
        <?php echo jaw_template_get_var('label'); ?>
    </a>
</span>
