<?php

/*
  Name: Simple Breadcrumb Navigation
  Description: A simple and very lightweight breadcrumb navigation that covers nested pages and categories
  Version: 1
  Author: Christian "Kriesi" Budschedl
  Author URI: http://www.kriesi.at/
 */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//SUPPORT FOR YOAST SEO PLUGIN
if (function_exists('yoast_breadcrumb')) {
    $options = get_option('wpseo_internallinks');
}
if (isset($options['breadcrumbs-enable']) && $options['breadcrumbs-enable'] === true) {
    yoast_breadcrumb('<span id="breadcrumbs" class="breadcrumb">', '</span>');
} else {//CLASSICAL BREADCRUMBS
    global $post, $blog_page;

    $markup = '';
    
    do_action("jaw_before_breadcrumbs");

    echo '<span class="breadcrumb" itemtype="http://data-vocabulary.org/Breadcrumb">';

    if (jwOpt::get_option('breadcrumb_show_home', '1') == '1') {
        echo '<a href="' . home_url('/') . '" itemprop="url">';
        echo '<span itemprop="title">' . apply_filters('jaw_breadcrumbs_title' , esc_html__('Home', "gdn-theme")) . '</span>';
        echo "</a>";
    }

    if (!is_front_page()) {
        echo esc_attr($markup);
    }

    if (is_page()) {
        $link = '';
        if ($post->post_parent) {
            $anc = array_reverse(get_post_ancestors($post->ID));
            $title = get_the_title();
            foreach ($anc as $ancestor) {
                $link .= '<a itemprop="url" href="' . get_permalink($ancestor) . '" title="' . get_the_title($ancestor) . '"><span itemprop="title">' . apply_filters('jaw_breadcrumbs_text' , get_the_title($ancestor), "page_parents" ) . '</span></a>' . esc_attr($markup);
            }
            echo esc_url($link);
        }
    }

    if (is_tag()) {
        echo '<a href="#">' . apply_filters('jaw_breadcrumbs_text' , esc_html__('Tag:', "gdn-theme") . ' ' . single_tag_title('', FALSE), "tag") . '</a>';
    } else if (is_author()) {
        $curauth = get_user_by('id', get_query_var('author'));
        echo '<a href="#">' . apply_filters('jaw_breadcrumbs_text' , esc_html__('Author:', "gdn-theme") . ' ' . esc_attr($curauth->display_name) , "author" ) . '</a>';
    } else if (is_year()) {
        $k_year = get_the_time('Y');
        echo "<a href='" . get_year_link($k_year) . "'>" . apply_filters('jaw_breadcrumbs_text' , $k_year, "year") . "</a>";
    } else if (is_month()) {
        $k_year = get_the_time('Y');
        $k_month = get_the_time('F');
        echo "<a href='" . get_year_link($k_year) . "'>" . apply_filters('jaw_breadcrumbs_text' , $k_year, "year") . "</a>";
        echo "<a href='" . get_month_link($k_year, $k_year) . "'>" . apply_filters('jaw_breadcrumbs_text' ,$k_month, "month") . "</a>";
    } else if (is_day() || is_time()) {
        $k_year = get_the_time('Y');
        $k_month = get_the_time('F');
        $k_day = get_the_time('j');
        echo "<a href='" . get_year_link($k_year) . "'>" . apply_filters('jaw_breadcrumbs_text' , $k_year, "year") . "</a>";
        echo "<a href='" . get_month_link($k_year, $k_year) . "'>" . apply_filters('jaw_breadcrumbs_text' ,$k_month, "month") . "</a>";
        echo "<a href='" . get_day_link($k_year, $k_year, $k_day) . "'>" . apply_filters('jaw_breadcrumbs_text' ,$k_day, "day") . "</a>";
    } else if (is_404()) {
        echo '<a href="#">' . apply_filters('jaw_breadcrumbs_text' , esc_html__('File not found', "gdn-theme") , "404") . '</a>';
    } else if (is_search()) {
        echo '<a href="#">' . apply_filters('jaw_breadcrumbs_text' , esc_html__('Search:', "gdn-theme") . ' ' . get_search_query() , "search" ) . '</a>';
    } else if (is_category()) {
        //POST | CATEGORY
        global $wp_query;
        $cat_id = 0;
        if (isset($wp_query->query_vars['cat'])) {
            $cat_id = $wp_query->query_vars['cat'];
        }
        if ($cat_id > 0) { // pokud neni v kategorii post neyobrazi se breadcrumb
            $cats = get_category($cat_id);
            if (isset($cats->name)) {
                $category = $cats->name;
            }
            if (sizeof($category) > 0 && $category != '') {
                echo get_category_parents($cat_id, TRUE, $markup, FALSE);
            }
        }
    } else if (is_single()) {
        $cats = get_the_category();
        if (isset($cats[0])) { // pokud neni v kategorii post neyobrazi se breadcrumb
            //Post
            $category = $cats[0]->name;
            $cat_id = $cats[0]->term_id;

            if (sizeof($category) > 0 && $category != '') {

                echo get_category_parents($cat_id, TRUE, $markup, FALSE);
            }
        }
    }
    
    if (is_singular() && jwOpt::get_option('breadcrumb_show_article', '1') == '1') {
        echo '<a href="' . get_permalink() . '">' . apply_filters('jaw_breadcrumbs_text' , jwUtils::crop_length(strip_tags(get_the_title()), jwOpt::get_option('blog_cut_breadcrumb', '-1')), "single") . '</a>';
    }
    
    do_action("jaw_after_breadcrumbs");
}
