<?php
$has_soc_icons = (get_the_author_meta('facebook', jaw_template_get_var('id')) ||
                    get_the_author_meta('twitter', jaw_template_get_var('id')) ||
                    get_the_author_meta('google', jaw_template_get_var('id')) ||
                    get_the_author_meta('youtube', jaw_template_get_var('id')) ||
                    get_the_author_meta('linkedin', jaw_template_get_var('id')) ||
                    get_the_author_meta('vimeo', jaw_template_get_var('id')) ||
                    get_the_author_meta('flickr', jaw_template_get_var('id')));
?>
<div class="row jaw-author-shortcode">
    <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
        <div class="admin_info" role="main" itemtype="http://schema.org/Person" itemscope itemprop="author">
            <div class="author_info">
                <div class="author_desc">
                    <div class="author_image">
                        <div class="author_image_wrap <?php echo esc_attr(($has_soc_icons) ? 'has-social-icons' : 'no-social-icons'); ?>">
                            <a href="<?php echo get_author_posts_url(jaw_template_get_var('id')); ?>"><?php echo get_avatar(jaw_template_get_var('id')); ?></a>
                            <div class="author_social">
                                <?php
                                if ($has_soc_icons) { 
                                    ?>
                                    <ul class="socialshare-icon">
                                        <?php if (get_the_author_meta('facebook', jaw_template_get_var('id'))) { ?>
                                            <li>
                                                <a class="link-facebook" target="_blank" href="<?php echo esc_url(get_the_author_meta('facebook', jaw_template_get_var('id'))) ?>">
                                                    <span class="jaw-icon-facebook4"></span>
                                                </a>
                                            </li>
                                        <?php } ?>
                                        <?php if (get_the_author_meta('twitter', jaw_template_get_var('id'))) { ?>
                                            <li>
                                                <a class="link-twitter" target="_blank" href="<?php echo esc_url(get_the_author_meta('twitter', jaw_template_get_var('id'))) ?>">
                                                    <span class="jaw-icon-twitter3"></span>
                                                </a>
                                            </li>
                                        <?php } ?>                            
                                        <?php if (get_the_author_meta('google', jaw_template_get_var('id'))) { ?>
                                            <li>
                                                <a class="link-google" target="_blank" href="<?php echo esc_url(get_the_author_meta('google', jaw_template_get_var('id'))) ?>">
                                                    <span class="jaw-icon-google-plus4"></span>
                                                </a>
                                            </li>
                                        <?php } ?>

                                        <?php if (get_the_author_meta('youtube', jaw_template_get_var('id'))) { ?>
                                            <li>
                                                <a class="link-youtube" target="_blank" href="<?php echo esc_url(get_the_author_meta('youtube', jaw_template_get_var('id'))) ?>">
                                                    <span class="jaw-icon-youtube"></span>
                                                </a>
                                            </li>
                                        <?php } ?>

                                        <?php if (get_the_author_meta('linkedin', jaw_template_get_var('id'))) { ?>
                                            <li>
                                                <a class="link-linkedin" target="_blank" href="<?php echo esc_url(get_the_author_meta('linkedin', jaw_template_get_var('id'))) ?>">
                                                    <span class="jaw-icon-linkedin"></span>
                                                </a>
                                            </li>
                                        <?php } ?> 

                                        <?php if (get_the_author_meta('vimeo', jaw_template_get_var('id'))) { ?>
                                            <li>
                                                <a class="link-vimeo" target="_blank" href="<?php echo esc_url(get_the_author_meta('vimeo', jaw_template_get_var('id'))) ?>">
                                                    <span class="jaw-icon-vimeo3"></span>
                                                </a>
                                            </li>
                                        <?php } ?>  

                                        <?php if (get_the_author_meta('flickr', jaw_template_get_var('id'))) { ?>
                                            <li>
                                                <a class="link-flickr" target="_blank" href="<?php echo esc_url(get_the_author_meta('flickr', jaw_template_get_var('id'))) ?>">
                                                    <span class="jaw-icon-flickr4"></span>
                                                </a>
                                            </li>
                                        <?php } ?>  

                                        <?php if (get_the_author_meta('pinterest', jaw_template_get_var('id'))) { ?>
                                            <li>
                                                <a class="link-pinterest" target="_blank" href="<?php echo esc_url(get_the_author_meta('pinterest', jaw_template_get_var('id'))) ?>">
                                                    <span class="jaw-icon-pinterest"></span>
                                                </a>
                                            </li>
                                        <?php } ?>  
                                        <?php if (get_the_author_meta('instagram', jaw_template_get_var('id'))) { ?>
                                            <li>
                                                <a class="link-instagram" target="_blank" href="<?php echo esc_url(get_the_author_meta('instagram', jaw_template_get_var('id'))) ?>">
                                                    <span class="jaw-icon-instagram"></span>
                                                </a>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <div class="author-details">
                        <div class="author_name"  itemprop="name"><a href="<?php echo esc_url(get_author_posts_url(jaw_template_get_var('id'))); ?>"  ><?php echo jaw_template_get_var('name'); ?></a></div>
                        <?php if (get_the_author_meta('profession', jaw_template_get_var('id'))) { ?>
                            <div class="author_proff"><?php echo get_the_author_meta('profession', jaw_template_get_var('id')); ?></div>
                        <?php } ?> 
                        <div class="author_description"><p><?php echo get_the_author_meta("description", jaw_template_get_var('id')); ?></p></div>
                        <div class="clear"></div>
                    </div>

                    <div class="clear"></div>
                </div>
            </div>
            <div class="clear"></div>
        </div><!-- End Content row -->

    </div>
</div>