<?php 
global $post;
wp_reset_postdata();

// PREV/NEXT posts navigation
$prevnextnav_allowed = jwOpt::get_option("prevnextnav_show", "true");
if($prevnextnav_allowed == "true") {
	$prevnextnav_excerpt_title = jwOpt::get_option("prevnextnav_excerpt_title", 60);
	$prevnextnav_thumbs = 'prevnextnav_thumbs-'.jwOpt::get_option("prevnextnav_thumbs", 1);
	$prevnextnav_meta = 'prevnextnav_meta-'.jwOpt::get_option("prevnextnav_meta", 1);
	$previous_post = get_adjacent_post(false, "", true); 
	$next_post = get_adjacent_post(false, "", false);
	$post_types="";
	$post_types_cls = "";
	$clear="";
	$link = "";
	$print_content="";
	$gallery="";
	$ids="";
	// Meta
	$single_preset = jaw_template_get_var('single_preset');
	$meta_date = jwOpt::getPresetValue('meta_date', '1', 'single', $single_preset);
	$meta_comments_count = jwOpt::getPresetValue('meta_comments_count', '1', 'single', $single_preset);
	?>
	<nav id="nav-single" class="row <?php echo esc_attr($prevnextnav_thumbs.' '.$prevnextnav_meta);?>">
		<div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
			<?php if (!empty($previous_post)) { ?>
				<div class="nav-previous-container navi-next-prev">
					<span class="nav-prev-icon"><?php previous_post_link('%link', '<i class="jaw-icon-next-post-left"></i> '); ?></span>
					<div class="nav-previous">
						<div class="box">
							<?php 
							$post_types = get_post_format($previous_post->ID);
							switch($post_types) {
								case "quote" :
									$post_types_cls="jaw-icon-quotes-right";
									$link="";
									$print_content="";
									break;
								case "link" :
									$post_types_cls="jaw-icon-new-tab";
									$link="";
									$print_content="";
									break;
								case "gallery" :
									$post_types_cls="";
									$link="";
									$gallery = get_post_meta($previous_post->ID, 'jaw_post_gallery', true);
									if(empty($gallery)) {
										$clear="nocont";
									}
									$ids = jwMedia::parseJson($gallery);
									foreach ($ids as $key => $id) {
										$print_content.=jwMedia::getAttachment($id, array('jaw_blog-mini'), false, array(false, 'full', jaw_template_get_counter('pagination')));
										if($key == 0) {
											break;
										}
									}
									break;
								case "video":
									$link = get_post_meta($previous_post->ID, 'jaw_post_video_link', true);
									$print_content = jwMedia::getVideoThumbnail($link);
									break;
								default:
									$post_types_cls="";
									$link="";
									$print_content="";
									break;
							}
							?>
							<div class="image <?php echo esc_attr($post_types_cls.' '.$post_types); ?>">
								<?php
								if (has_post_thumbnail($previous_post->ID)) {
									if(get_post_format($previous_post->ID) == 'video') {
										echo '<a href="'.get_permalink($previous_post->ID).'">'.jwMedia::getPostThumbnail($previous_post->ID, array('jaw_blog-mini'), false, array(false, 'full', jaw_template_get_counter('pagination'))).'<span class="jaw-video-icon small">
										'.apply_filters('jaw_default_video_icon', '<i class="jaw-icon-play4"></i>').'
										</span></a>';
									} else {
										echo '<a href="'.get_permalink($previous_post->ID).'">'.jwMedia::getPostThumbnail($previous_post->ID, array('jaw_blog-mini'), false, array(false, 'full', jaw_template_get_counter('pagination'))).'</a>';
									}
								} else {
									echo $print_content; 
									if(!$post_types) {
										$clear="nocont";
									}
								}
								?>
							</div>
							<div class="content-box <?php echo esc_attr($clear); ?> <?php echo esc_attr($post_types); ?>">
								<header>
									<h4>
										<?php previous_post_link("%link", jwUtils::crop_length(get_the_title($previous_post->ID), $prevnextnav_excerpt_title)); ?>
									</h4>
								</header>
								<ul class="blog-meta-info-top">
									<?php if ($meta_date == '1') { ?>
										<li class="post-meta-date">
											<span class="date">
												<?php echo jwRender::get_meta_date($previous_post->ID); ?>
											</span>
										</li>
									<?php } ?>
									<?php if ($meta_comments_count == '1') { ?>  
										<li class="post-meta-comments">
											<?php echo jwRender::get_meta_comments($previous_post->ID); ?>
										</li>    
									<?php } ?>
								</ul>
							</div>
						</div>
					</div>
				</div>
			<?php } ?>
			<?php if (!empty($next_post)) { ?>
				<div class="nav-next-container navi-next-prev">
					<span class="nav-next-icon"><?php next_post_link('%link', '<i class="jaw-icon-next-post-right"></i> '); ?></span>
					<div class="nav-next">
						<div class="box">
							<?php 
							$post_types = get_post_format($next_post->ID);
							switch($post_types) {
								case "quote" :
									$post_types_cls="jaw-icon-quotes-right";
									$link="";
									$print_content="";
									break;
								case "link" :
									$post_types_cls="jaw-icon-new-tab";
									$link="";
									$print_content="";
									break;
								case "gallery" :
									$post_types_cls="";
									$link="";
									$gallery = get_post_meta($next_post->ID, 'jaw_post_gallery', true);
									if(empty($gallery)) {
										$clear="nocont";
									}
									$ids = jwMedia::parseJson($gallery);
									foreach ($ids as $key => $id) {
										$print_content.=jwMedia::getAttachment($id, array('jaw_blog-mini'), false, array(false, 'full', jaw_template_get_counter('pagination')));
										if($key == 0) {
											break;
										}
									}
									break; 
								case "video":
									$link = get_post_meta($next_post->ID, 'jaw_post_video_link', true);
									$print_content = jwMedia::getVideoThumbnail($link);
									break;
								default:
									$post_types_cls="";
									$link="";
									$print_content="";
									break;
							}
							?>
							<div class="image <?php echo esc_attr($post_types_cls . ' ' . $post_types); ?>">
								<?php
								if (has_post_thumbnail($next_post->ID)) {
									if(get_post_format($next_post->ID) == 'video') {
										echo '<a href="'.get_permalink($next_post->ID).'">'.jwMedia::getPostThumbnail($next_post->ID, array('jaw_blog-mini'), false, array(false, 'full', jaw_template_get_counter('pagination'))).'<span class="jaw-video-icon small">
										'.apply_filters('jaw_default_video_icon', '<i class="jaw-icon-play4"></i>').'
										</span></a>';
									} else {
										echo '<a href="'.get_permalink($next_post->ID).'">'.jwMedia::getPostThumbnail($next_post->ID, array('jaw_blog-mini'), false, array(false, 'full', jaw_template_get_counter('pagination'))).'</a>';
									}
								} else {
									echo $print_content;
									if(!$post_types) {
										$clear="nocont";
									}
								}
								?>
							</div>
							<div class="content-box <?php echo esc_attr($clear); ?> <?php echo esc_attr($post_types); ?>">
								<header>
									<h4>
										<?php next_post_link("%link", jwUtils::crop_length(get_the_title($next_post->ID), $prevnextnav_excerpt_title)); ?>
									</h4>
								</header>
								<ul class="blog-meta-info-top">
									<?php if ($meta_date == '1') { ?>
										<li class="post-meta-date">
											<span class="date">
												<?php echo jwRender::get_meta_date($next_post->ID); ?>
											</span>
										</li>
									<?php } ?>
									<?php if ($meta_comments_count == '1') { ?>  
										<li class="post-meta-comments">
											<?php echo jwRender::get_meta_comments($next_post->ID); ?>
										</li>    
									<?php } ?>
								</ul>
							</div>
						</div>
					</div>
				</div>
			<?php } ?>
		</div>
	</nav>
<?php
}