<div class="jaw-user-panel <?php echo 'user-preset-' . jwOpt::get_option('my_news_color', jwOpt::get_option('main_color')); ?> ">
    <?php
    if (is_user_logged_in()) {
        $class = 'user-loggedin';
    } else {
        $class = 'np-user-loggedin';
    }
    ?>
    <div class="jaw-user-buttons <?php echo esc_attr($class); ?>">
        <div class="jaw-user-item jaw-user-item-favorites" data-content=".jaw-user-favorites">
            <?php  if (!is_user_logged_in()) { // link to settigs page ?>
                <a href="<?php echo esc_url(get_permalink(jwOpt::get_option('user_account_pageid'))); ?>">
                    <i class="jaw-icon-star3"></i>
                </a>
            <?php } else { ?>
                <i class="jaw-icon-star3"></i>
            <?php } ?>
        </div>

        <div class="jaw-user-item jaw-user-item-time" data-content=".jaw-user-time">
            <?php  if (!is_user_logged_in()) { // link to settigs page ?>
                <a href="<?php echo esc_url(get_permalink(jwOpt::get_option('user_account_pageid'))); ?>">
                    <i class="jaw-icon-clock"></i>
                </a>
            <?php } else { ?>
                <i class="jaw-icon-clock"></i>
            <?php } ?>
        </div>

        <div class="jaw-user-item jaw-user-settings">
                <a href="<?php echo esc_url(get_permalink(jwOpt::get_option('user_account_pageid'))); ?>">
                    <i class="jaw-icon-settings-new"></i>
                </a>
                    <?php if (!is_user_logged_in()) { ?>
                        <div class="jaw-user-content">
                        <?php echo jaw_get_template_part('banner', array('header', 'user_panel')); ?>
                        </div>
                    <?php } ?>
                
        </div>
    </div>
    <div class="jaw-user-login">
        <?php if (is_user_logged_in()) { ?>
            <div class="jaw-user-loggedin">
                <div class="jaw-user-button jaw_button jaw-user-logout btn">
                    <a href="<?php echo wp_logout_url(get_permalink(esc_attr(jwOpt::get_option('user_bar_logout_pageid', '')))); ?>" title="login"><?php esc_html_e('Log Out', "gdn-theme"); ?></a>
                </div>
                <div class="jaw-user-name">
                    <div class="jaw-greetings">
                        <?php esc_html_e('Welcome,', "gdn-theme"); ?>
                    </div>
                    <div class="jaw-name">
                        <?php $current_user = wp_get_current_user(); ?>
                        <?php echo esc_attr($current_user->display_name); ?>
                    </div>
                </div>
            </div>
        <?php } else { ?>
            <div class="jaw-user-loggedout">
            <?php
                do_action("jaw_before_register_button");
                if (get_option('users_can_register')) { ?>
                    <div class="jaw-user-item">
                        <div class="jaw-user-button jaw_button jaw-user-register btn">
                            <a href="#" title="register"><?php esc_html_e('Register', "gdn-theme"); ?></a>
                        </div>
                        <div class="jaw-user-content-register jaw-user-content <?php echo (defined('REGISTERED_A_USER')) ? 'jaw-user-registered-now' : ''; ?>">
                            <?php
                            echo jaw_get_template_part('register', 'simple-shortcodes');
                            ?>
                        </div>
                    </div>
                <?php } 
                ?>
                <div class="jaw-user-item">
                    <div class="jaw-user-button jaw_button jaw-user-log-in btn">
                        <a href="#" title="login"><?php esc_html_e('Log In', "gdn-theme"); ?></a>
                    </div>
                    <div class="jaw-user-content-login jaw-user-content">
                        <?php
                        jaw_template_set_var('show_register', '0');
                        echo jaw_get_template_part('login', 'simple-shortcodes');
                        ?>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
</div>