<?php
$featured_class = 6;
$comments_count = 3;
if (jwOpt::get_option('fbcomments_switch', '0') == '1' || (defined('DISQUS_DOMAIN') && get_option('disqus_active'))) {
    $featured_class = 9;
    $comments_count = 0;
}
?>

    <div class="jaw-user-item jaw-user-favorites">
        <div class="jaw-user-content row">
            <div class="<?php echo esc_attr(jwLayout::col_class($featured_class)); ?> jw-uc-interested-posts">
                <?php
                $atts = array(
                    'box_title' => esc_html__('Interested posts', "gdn-theme"),
                    'bar_type' => jwOpt::get_option('global_header_style', 'bar_type_1')
                );
                jaw_template_set_data($atts);
                echo jaw_get_template_part('section_bar', 'simple-shortcodes');
                if ($comments_count) {
                    jaw_template_set_var('columns', '6');
                } else {
                    jaw_template_set_var('columns', '4');
                }
                echo jaw_get_template_part('interested_posts', array('header', 'user_panel'));
                ?>
            </div>
            <?php if ($comments_count) { ?>
                <div class="<?php echo esc_attr(jwLayout::col_class($comments_count)); ?> jw-uc-interested-comments">
                    <?php
                    $atts = array(
                        'box_title' => esc_html__('Interested comments', "gdn-theme"),
                        'bar_type' => jwOpt::get_option('global_header_style', 'bar_type_1')
                    );
                    jaw_template_set_data($atts);
                    echo jaw_get_template_part('section_bar', 'simple-shortcodes');
                    echo jaw_get_template_part('interested_disscussions', array('header', 'user_panel'));
                    ?>
                </div>
            <?php } ?>
            <div class="<?php echo esc_attr(jwLayout::col_class(3)); ?> jw-uc-reading-list">
                <?php
                $atts = array(
                    'box_title' => esc_html__('Reading List', "gdn-theme"),
                    'bar_type' => jwOpt::get_option('global_header_style', 'bar_type_1')
                );
                jaw_template_set_data($atts);
                echo jaw_get_template_part('section_bar', 'simple-shortcodes');
                echo jaw_get_template_part('featured_posts', array('header', 'user_panel'));
                ?>
            </div>
        </div>
        <div class="clear"></div>
        <div class="jaw_user_hide"><span class="jaw_user_hide_button"><i class="jaw-icon-arrow-slide-up jaw-hide-first"></i><i class="jaw-icon-arrow-slide-up jaw-hide-second"></i><i class="jaw-icon-arrow-slide-up jaw-hide-third"></i></span></div>
    </div>

    <div class="jaw-user-item jaw-user-time">
        <div class="jaw-user-content row">
            <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
                <?php
                $atts = array(
                    'box_title' => esc_html__('History', "gdn-theme"),
                    'bar_type' => jwOpt::get_option('global_header_style', 'bar_type_1')
                );
                jaw_template_set_data($atts);
                echo jaw_get_template_part('section_bar', 'simple-shortcodes');
                echo jaw_get_template_part('recent_posts', array('header', 'user_panel'));
                ?>
                <div class="row jwjs-clear-history" >
                    <a class=" jaw_button " href="#" title="<?php esc_html_e('Delete history', "gdn-theme"); ?>"><i class="jaw-icon-remove"></i> Delete history</a>
                </div>
                <div class="clear"></div>
            </div>
            <div class="clear"></div>
        </div>
        <div class="clear"></div>
        <div class="jaw_user_hide"><span class="jaw_user_hide_button"><i class="jaw-icon-arrow-slide-up jaw-hide-first"></i><i class="jaw-icon-arrow-slide-up jaw-hide-second"></i><i class="jaw-icon-arrow-slide-up jaw-hide-third"></i></span></div>
    </div>
