<form id="jwjs_user_settings">
    <h3 class="jaw-user-settings-title"><i class="jaw-icon-star3"></i><?php esc_html_e("Choose what you're interested in:", "gdn-theme"); ?></h3>
    <?php
    $interest_post = get_user_meta(get_current_user_id(), 'jaw_interest_posts', true);
    $interest_coments = get_user_meta(get_current_user_id(), 'jaw_interest_comments', true); // jen pro prehled jiz odebiranych a odhlaseni odberu

    /* JAW_CATEGORIES************************************ */
    $args = array(
        'type' => 'post',
        'hide_empty' => 1,
        'taxonomy' => 'category'
    );
    $terms = get_categories($args);
    if (!empty($terms)) {
        ?>
        <div class="jaw-user-settings-item">
            <h4><?php esc_html_e("Categories:", "gdn-theme"); ?></h4>
            <?php
            foreach ((array) $terms as $term) {
                $check = "";
                $class = "";
                if (!empty($interest_post['cat']) && in_array($term->term_id, $interest_post['cat'])) {
                    $check = 'checked="checked"';
                    $class = "checked";
                }
                echo '<span class="jaw-settings-checkbox ' . esc_attr($class) . '">';
                echo '<input type="checkbox" id="cat-' . esc_attr($term->term_id) . '" ' . esc_attr($check) . ' name="cat[' . esc_attr($term->term_id) . ']" />';
                echo '<label for="cat-' . esc_attr($term->term_id) . '"><i class="jaw-icon-checkbox-unchecked2"></i><i class="jaw-user-checkmark jaw-icon-checkmark"></i>' . esc_attr($term->name) . '</label>';
                echo '<br>';
                echo '</span>';
            }
            ?>
        </div>
        <?php
    }

    /* TAGS************************************ */
    $args = array(
        'type' => 'post',
        'hide_empty' => 1,
        'taxonomy' => 'post_tag'
    );
    $terms = get_categories($args);
    if (!empty($terms)) {
        ?>
        <div class="jaw-user-settings-item">
            <h4><?php esc_html_e("Tags:", "gdn-theme"); ?></h4>
            <?php
            foreach ((array) $terms as $term) {
                $check = '';
                $class = "";
                if (!empty($interest_post['tag']) && in_array($term->term_id, $interest_post['tag'])) {
                    $check = 'checked="checked"';
                    $class = "checked";
                }
                echo '<span class="jaw-settings-checkbox ' . esc_attr($class) . '">';
                echo '<input type="checkbox" id="tag-' . esc_attr($term->term_id) . '" ' . esc_attr($check) . ' name="tag[' . esc_attr($term->term_id) . ']" />';
                echo '<label for="tag-' . esc_attr($term->term_id) . '"><i class="jaw-icon-checkbox-unchecked2"></i><i class="jaw-user-checkmark jaw-icon-checkmark"></i>' . esc_attr($term->name) . '</label>';
                echo '<br>';
                echo '</span>';
            }
            ?>
        </div>
        <?php
    }



    /* AUTHORS ************************************ */
    $args = array(
        'who' => 'authors'
    );
    $users = get_users($args);
    if (!empty($users)) {
        ?>
        <div class="jaw-user-settings-item">
            <h4><?php esc_html_e("Authors:", "gdn-theme"); ?></h4>
            <?php
            foreach ((array) $users as $usr) {
                $check = '';
                $class = "";
                if (!empty($interest_post['usr']) && in_array($usr->data->ID, $interest_post['usr'])) {
                    $check = 'checked="checked"';
                    $class = "checked";
                }
                echo '<span class="jaw-settings-checkbox ' . esc_attr($class) . '">';
                echo '<input type="checkbox" id="usr-' . esc_attr($usr->data->ID) . '" ' . esc_attr($check) . ' name="usr[' . esc_attr($usr->data->ID) . ']" />';
                echo '<label for="usr-' . esc_attr($usr->data->ID) . '"><i class="jaw-icon-checkbox-unchecked2"></i><i class="jaw-user-checkmark jaw-icon-checkmark"></i>' . esc_attr($usr->data->display_name) . '</label>';
                echo '<br>';
                echo '</span>';
            }
            ?>
        </div>
    <?php } ?>

    <?php
    /* POSTS ************************************ */
    if (empty($interest_coments['posts'])) {
        $interest_coments['posts'] = array();
    } else {
        ?>
        <div class="jaw-user-settings-item">
            <h4><?php esc_html_e("Comments:", "gdn-theme"); ?></h4>
            <?php
            foreach ((array) $interest_coments['posts'] as $post_id) {

                $check = 'checked="checked"';
                $class = "checked";
                echo '<span class="jaw-settings-checkbox ' . esc_attr($class) . '">';
                echo '<input type="checkbox" id="pst-' . esc_attr($post_id) . '" ' . esc_attr($check) . ' name="pst[' . esc_attr($post_id) . ']" />';
                echo '<label for="pst-' . esc_attr($post_id) . '"><i class="jaw-icon-checkbox-unchecked2"></i><i class="jaw-user-checkmark jaw-icon-checkmark"></i>' . get_the_title($post_id) . '</label>';
                echo '<br>';
                echo '</span>';
            }
            ?>
        </div>
    <?php } ?>


</form>