<?php
$recent_posts = get_user_meta(get_current_user_id(), 'jaw_visited_posts', true);

if (!empty($recent_posts)) {
    global $wp_query, $jaw_data, $content_width;
    $old_query = $wp_query;
    $archive_preset = jwOpt::get_option('archive_preset', '_default');
    $qs = array();

    $qs['paged'] =  1;
    $ids = array_reverse(array_keys($recent_posts));
    $qs['post__in'] = $ids;
    $qs['posts_per_page'] = jwOpt::get_option('user_history_posts','3');
    $qs['post_type'] = 'post';
    $qs['orderby'] = 'post__in';
    $qs['post_status'] = 'publish';

    $blog_query = new WP_Query($qs);
    $blog_query->pagination = 'none';
    $blog_query->type = jwOpt::get_option('user_history_boxes_type','simple');
    $blog_query->columns = 12/jwOpt::get_option('user_history_columns','3');
    $blog_query->letter_excerpt =  jwOpt::get_option('user_history_letter_excerpt','300');
    $blog_query->title_h = jwOpt::get_option('user_history_title_h','3');
    $blog_query->letter_excerpt_title = jwOpt::get_option('user_history_letter_excerpt_title','150');
    $blog_query->blog_category_inimage = jwOpt::getPresetValue('blog_category_inimage', '1', 'category', $archive_preset);
    $blog_query->blog_comments_inimage = jwOpt::getPresetValue('blog_comments_inimage', '1', 'category', $archive_preset);
    $blog_query->blog_metadate = '1';
    $blog_query->blog_meta_author = '0';
    $blog_query->blog_comments_count = '0';   
    $blog_query->blog_meta_category = '0';
    $blog_query->blog_meta_like = '0';
    $blog_query->blog_ratings = '0';
    $blog_query->blog_readers = '1';  
    $blog_query->blog_featured_post = '1';  
    
    $blog_query->use_isotope = '1';
    $blog_query->blog_color = jwOpt::checkDefaultPreset(array(jwOpt::get_option('menu_color', '_default'), jwOpt::get_option('main_color')),'color');

    jaw_template_set_data($blog_query);
    echo jaw_get_template_part('blog');

    wp_reset_query();
    $wp_query = $old_query;
}