<div class="jaw-user-panel ">
    <?php
    if (is_user_logged_in()) {
        $class = 'user-loggedin';
    } else {
        $class = 'np-user-loggedin';
    }
    ?>
    <div class="jaw-user-buttons mobile-menu-item <?php echo esc_attr($class); ?>">
        <div class="jaw-user-login">
            <?php if (is_user_logged_in()) { ?>
                <div class="jaw-user-loggedin">
                    <div class="jaw-user-button jaw_button jaw-user-logout btn">
                        <a href="<?php echo wp_logout_url(get_permalink(esc_attr(jwOpt::get_option('user_bar_logout_pageid', '')))); ?>" title="login"><?php esc_html_e('Log Out', "gdn-theme"); ?></a>
                    </div>
                    <div class="jaw-user-name">
                        <div class="jaw-greetings">
                            <?php esc_html_e('Welcome,', "gdn-theme"); ?>
                        </div>
                        <div class="jaw-name" >
                            <?php $current_user = wp_get_current_user(); ?>
                            <?php echo esc_attr($current_user->display_name); ?>
                        </div>
                    </div>
                </div>
            <?php } else { ?>
                <div class="jaw-user-loggedout">
                    <?php if (get_option('users_can_register')) { ?>
                        <div class="jaw-user-item">
                            <div class="jaw-user-button jaw_button jaw-user-register-mobile btn">
                                <a href="#" title="register"><?php esc_html_e('Register', "gdn-theme"); ?></a>
                            </div>

                        </div>
                    <?php } ?>
                    <div class="jaw-user-item">
                        <div class="jaw-user-button jaw_button jaw-user-log-in-mobile btn">
                            <a href="#" title="login"><?php esc_html_e('Log In', "gdn-theme"); ?></a>
                        </div>
                       
                    </div>
                </div>
            <?php } ?>
        </div>
        <?php if (is_user_logged_in() && jwOpt::get_option('mobile_menu_show_login', '1') == '2') { ?>
            <ul class="sub-menu user-sub-menu  depth-0">

                <li class="menu-item menu-item-type-custom mobile-menu-item">

                    <div class="jaw-user-item" data-content=".jaw-user-favorites">
                        <?php if (jaw_template_get_var('settings_as_link', '0') == '1') { // link to settigs page ?>
                            <a href="#">
                                <i class="jaw-icon-star3"></i><?php esc_html_e("Favorites", "gdn-theme"); ?>
                            </a>                        
                        <?php } ?>
                    </div>
                </li>
                <li class="menu-item menu-item-type-custom mobile-menu-item">

                    <div class="jaw-user-item" data-content=".jaw-user-time">
                        <?php if (jaw_template_get_var('settings_as_link', '0') == '1') { // link to settigs page ?>
                            <a href="#">
                                <i class="jaw-icon-clock"></i><?php esc_html_e("History", "gdn-theme"); ?>
                            </a>                        
                        <?php } ?>
                    </div>
                </li>
                <li class="menu-item menu-item-type-custom mobile-menu-item">

                    <div class="jaw-user-item jaw-user-settings">
                        <?php if (jaw_template_get_var('settings_as_link', '0') == '1') { // link to settigs page ?>
                            <a href="<?php echo esc_url(get_permalink(jwOpt::get_option('user_account_pageid'))); ?>">
                                <i class="jaw-icon-settings-new"></i><?php esc_html_e("Settings", "gdn-theme"); ?>
                            </a>
                        <?php } ?>
                    </div>
                </li>
            </ul>

        <?php } else { ?>

            <ul class="sub-menu logged-out-menu depth-0">

                <li class="menu-item jaw-register-mobile-content menu-item-type-custom mobile-menu-item">

                    <div class="jaw-user-content-register jaw-user-content <?php echo (defined('REGISTERED_A_USER')) ? 'jaw-user-registered-now' : ''; ?>">
                        <?php
                        echo jaw_get_template_part('register', 'simple-shortcodes');
                        ?>
                    </div>
                </li>
                <li class="menu-item jaw-login-mobile-content menu-item-type-custom mobile-menu-item">

                     <div class="jaw-user-content-login jaw-user-content">
                            <?php
                            jaw_template_set_var('show_register', '0');
                            echo jaw_get_template_part('login', 'simple-shortcodes');
                            ?>
                        </div>
                </li>
            </ul>
        <?php } ?>

    </div>

</div>
