<?php

$interest_post = get_user_meta(get_current_user_id(), 'jaw_interest_posts', true);

global $wp_query, $jaw_data, $content_width;
$old_query = $wp_query;
$archive_preset = jwOpt::get_option('archive_preset', '_default');
$qs = array();

$qs['paged'] = (get_query_var('paged')) ? get_query_var('paged') : 1;
$qs['tax_query'] = array();
$qs['tax_query']['relation'] = 'OR';
if (!empty($interest_post['cat'])) {
    $qs['tax_query'][] = array(
        'taxonomy' => 'category',
        'field' => 'ID',
        'terms' => $interest_post['cat'],
        'include_children' => false 
    );
}
if (!empty($interest_post['tag'])) {
    $qs['tax_query'][] = array(
        'taxonomy' => 'post_tag',
        'field' => 'ID',
        'terms' => $interest_post['tag'],
        'include_children' => false 
    );
}
$qs['posts_per_page'] = esc_attr(jwOpt::get_option('user_interest_posts','4'));
$qs['post_type'] = 'post';
$qs['post_status'] = 'publish';
$blog_query = new WP_Query($qs);

$blog_query->pagination = 'none';
$blog_query->type = jwOpt::get_option('user_interest_boxes_type','vertical');
$blog_query->columns = 12/jwOpt::get_option('user_interest_columns','2');
$blog_query->letter_excerpt = jwOpt::get_option('user_interest_letter_excerpt','0');
$blog_query->title_h = jwOpt::get_option('user_interest_title_h','3');
$blog_query->letter_excerpt_title = jwOpt::get_option('user_interest_letter_excerpt_title','-1');
$blog_query->blog_category_inimage = jwOpt::getPresetValue('blog_category_inimage', '1', 'category', $archive_preset);
$blog_query->blog_comments_inimage = jwOpt::getPresetValue('blog_comments_inimage', '1', 'category', $archive_preset);
$blog_query->blog_metadate = '1';
$blog_query->blog_meta_author = '0';
$blog_query->blog_comments_count = '0';   
$blog_query->blog_meta_category = '0';
$blog_query->blog_meta_like = '0';
$blog_query->blog_ratings = '0';
$blog_query->blog_readers = '1';   
$blog_query->blog_featured_post = '1';   

$blog_query->use_isotope = '1';
$blog_query->blog_color = jwOpt::checkDefaultPreset(array(jwOpt::get_option('menu_color', '_default'), jwOpt::get_option('main_color')),'color');


jaw_template_set_data($blog_query);
echo jaw_get_template_part('blog');

wp_reset_query();
$wp_query = $old_query;
