<?php
$interest_coments = get_user_meta(get_current_user_id(), 'jaw_interest_comments', true);
$interested_posts = array();
if (isset($interest_coments['posts'])) {
    $interested_posts = $interest_coments['posts'];
}
if (!empty($interested_posts)) {
    global $wp_query, $jaw_data, $content_width;
    $old_query = $wp_query;
    $archive_preset = jwOpt::get_option('archive_preset', '_default');
    
    add_filter('posts_join', array('jwUtils','join_last_comment'));
    add_filter('posts_orderby', array('jwUtils', 'orderby_last_comment'));
    $qs = array();

    $qs['paged'] = (get_query_var('paged')) ? get_query_var('paged') : 1;
    $qs['post__in'] = $interested_posts;
    $qs['posts_per_page'] = jwOpt::get_option('user_comments_number_posts', 5);
    $qs['post_type'] = 'post';
 
    $qs['post_status'] = 'publish';
    $blog_query = new WP_Query($qs);
    
    remove_filter('posts_join', array('jwUtils','join_last_comment'));
    remove_filter('posts_orderby', array('jwUtils', 'orderby_last_comment'));

    $blog_query->pagination = 'none';
    $blog_query->type = 'simple';
    $blog_query->columns = jaw_template_get_var('columns', '12');
    $blog_query->letter_excerpt = jwOpt::getPresetValue('letter_excerpt', '-1', 'category', $archive_preset);
    $blog_query->title_h = jwOpt::getPresetValue('title_h', '3', 'category', $archive_preset);
    $blog_query->letter_excerpt_title = jwOpt::getPresetValue('letter_excerpt_title', '-1', 'category', $archive_preset);
    $blog_query->blog_category_inimage = '0';
    $blog_query->blog_comments_inimage = '0';
    $blog_query->blog_metadate = '0';
    $blog_query->blog_meta_author = '0';
    $blog_query->blog_comments_count = '0';   
    $blog_query->blog_meta_category = '0';
    $blog_query->blog_meta_like = '0';
    $blog_query->blog_ratings = '0';
    $blog_query->blog_readers = '0';   
    $blog_query->blog_last_comment_date = '1';   
    $blog_query->blog_featured_post = '0';   
    
    $blog_query->use_isotope = '1';
    $blog_query->blog_color = jwOpt::checkDefaultPreset(array(jwOpt::get_option('menu_color', '_default'), jwOpt::get_option('main_color')),'color');

    jaw_template_set_data($blog_query);  
    echo jaw_get_template_part('blog');
    wp_reset_query();
    $wp_query = $old_query;
}