<?php
/* Nepouziva se */


$interest_coments = get_user_meta(get_current_user_id(), 'jaw_interest_comments', true);
$authors = array();
if (isset($interest_coments['authors'])) {
    $authors = $interest_coments['authors'];
}
$interested_posts = array();
if (isset($interest_coments['posts'])) {
    $interested_posts = $interest_coments['posts'];
}
$args = array(
    'author__in' => $authors,
    'post__in' => $interested_posts,
    'status' => 'approve',
    'number' => 3
);
// The Query
$comments_query = new WP_Comment_Query();
$comments = $comments_query->query($args);

// Comment Loop
if ($comments) {
    foreach ((array) $comments as $comment) {
        $url = get_comment_link($comment->comment_ID);
        echo '<div class="jaw-interest-one-comment">';
        echo '<div><span class="jaw-interest-one-comment-author"><i class="jaw-icon-user"></i><a href="' . $url . '">' . esc_attr($comment->comment_author) . '</a></span></div>';
        echo '<div><span class="jaw-interest-one-comment-title"><i class="jaw-icon-pencil"></i><a href="' . $url . '">' . esc_attr(get_the_title($comment->comment_post_ID)) . '</a></span></div>';
        echo '<div><span class="jaw-interest-one-comment-content">"' . esc_attr(substr($comment->comment_content, 0, 50)) . '..."</span></div>';
        echo '<div><span class="jaw-interest-one-comment-date">' . esc_attr(get_comment_date(get_option('date_format'), $comment->comment_ID)) . '</span></div>';
        echo '</div>';
    }
} else {
    echo 'No comments found.';
}
wp_reset_query();
