<?php

$featured_posts = get_user_meta(get_current_user_id(), 'jaw_featured_posts', true);
if (!empty($featured_posts)) {
    global $wp_query, $jaw_data, $content_width;
    $old_query = $wp_query;
    $archive_preset = jwOpt::get_option('archive_preset', '_default');
    $qs = array();

    $qs['paged'] = (get_query_var('paged')) ? get_query_var('paged') : 1;

    $qs['post__in'] = $featured_posts;
    $qs['posts_per_page'] = jwOpt::get_option('user_reading_list_number_posts', 5);
    $qs['post_type'] = 'post';

    $blog_query = new WP_Query($qs);


    $blog_query->pagination = 'none';
    $blog_query->type = 'simple';
    $blog_query->columns = jaw_template_get_var('columns', '12');
    $blog_query->letter_excerpt = jwOpt::getPresetValue('letter_excerpt', '-1', 'category', $archive_preset);
    $blog_query->title_h = jwOpt::getPresetValue('title_h', '3', 'category', $archive_preset);
    $blog_query->letter_excerpt_title = jwOpt::getPresetValue('letter_excerpt_title', '-1', 'category', $archive_preset);
    $blog_query->blog_category_inimage = jwOpt::getPresetValue('blog_category_inimage', '1', 'category', $archive_preset);
    $blog_query->blog_comments_inimage = jwOpt::getPresetValue('blog_comments_inimage', '1', 'category', $archive_preset);
    $blog_query->blog_metadate = '1';
    $blog_query->blog_meta_author = '0';
    $blog_query->blog_comments_count = '0';   
    $blog_query->blog_meta_category = '0';
    $blog_query->blog_meta_like = '0';
    $blog_query->blog_ratings = '0';
    $blog_query->blog_readers = '1';  
    $blog_query->blog_featured_post = '1';  
    
    $blog_query->use_isotope = '1';
    $blog_query->blog_color = jwOpt::checkDefaultPreset(array(jwOpt::get_option('menu_color', '_default'), jwOpt::get_option('main_color')),'color');

    jaw_template_set_data($blog_query);  
    echo jaw_get_template_part('blog');
    
    if(jwOpt::get_option('user_bar_reading_list_page', '') !== '' || jwOpt::get_option('user_bar_reading_list_page', '') !== '_default' ){
        echo '<div class="jaw-mynews-show-all-reading">';
        echo '<a href="'.get_the_permalink(esc_attr(jwOpt::get_option('user_bar_reading_list_page', '')) ).'">';
        esc_html_e('show all posts', "gdn-theme"); 
        echo '<i class=" jaw-icon-arrow-right3"></i>';
        echo '</a>';
        echo '</div>';
    }

    wp_reset_query();
    $wp_query = $old_query;
}