<?php
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
$template_logo_mobile = jwOpt::get_option('custom_mobile_logo', $template_logo);
if (strlen($template_logo) == 0) {
    $template_logo = JAW_THEME_URI . '/images/logo/logo.png';
}
if (strlen($template_logo_mobile) == 0) {
    $template_logo_mobile = $template_logo;
}
?>
<?php if (jwOpt::get_option('use_jaw_seo_logo', '1') == '1') { ?>
    <h1>
    <?php } else { ?>
        <p>
        <?php } ?>
        <a href="<?php echo home_url('/'); ?>" title="<?php bloginfo('name'); ?>">
            <img class="template-logo" src="<?php echo esc_url($template_logo); ?>">
            <img class="template-logo-mobile" src="<?php echo esc_url($template_logo_mobile); ?>">
        </a>
        <?php if (jwOpt::get_option('use_jaw_seo_logo', '1') == '1') { ?>
    </h1>
<?php } else { ?>
    </p>
<?php } ?>

<span itemprop="publisher" itemscope itemtype="https://schema.org/Organization">
    <meta itemprop="name" content="<?php echo get_bloginfo(); ?>"/>
            <span itemprop="logo" itemscope itemtype="http://schema.org/ImageObject">             <meta itemprop="url" content="<?php echo esc_url($template_logo); ?>" />         </span>    
    <meta itemprop="url" content="<?php echo home_url('/'); ?>"/>    
</span>