<?php
global $post, $wp_query, $jaw_data;
$post_meta = get_post_meta(get_the_ID(), 'fw_rating_position', true);
$totalrat = array('final' => "");
if(class_exists('ratingManager')){
    $ratingManager = ratingManager::getInstance();
    $ratings = $ratingManager->getRatings(get_the_ID());
    $totalrat = $ratingManager->getRatingsScore($ratings);
}
$ratingtype=jwOpt::get_option('rating_maximal_value');
$ratingmaxvalue=jwOpt::get_option('rating_maximal_value_show');
$col_count = jaw_template_get_var("columns", 4);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-vertical';
$single_class[] = 'jaw-post-box';
$single_class[] = 'format-review';
$attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?> >
    <div class="box ">
        <div class="image ">
            <?php
            $link = false;
            $pp = false;
            switch (jaw_template_get_var('clickable_image', '0')) {
                case '1': $link = get_permalink();
                echo "<a href=".$link.">";
                    break;
                case '2': $link = jwMedia::getPostThumbnailSrc(get_the_ID());
                echo "<a href=".$link." rel='prettyPhoto[".jaw_template_get_counter('pagination')."]'>";
                $pp = true;
                break;
            }
            echo "<span class='jaw-fadein'></span>";
            echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-16_9-small', 'jaw_blog-16_9-middle', 'jaw_blog-16_9', 'jaw_blog-16_9-big'));
            echo '<span class="post-categories-labels">';
                if ($post_meta == '1') { ?>
                    <span class="post-review-total">
                        <?php
                        switch($ratingtype) {
                            case "100" :
                                    echo esc_attr(round($totalrat['final'], 0)).'<span>%</span>';
                            break;
                            default:
                                if($ratingmaxvalue) {
                                    echo esc_attr(round($totalrat['final'], 1)).'<span>/'.esc_attr($ratingtype).'</span>';
                                } else {
                                    echo esc_attr(round($totalrat['final'], 1));
                                }
                            break;
                        }
                         ?>
                    </span>
                <?php }
            echo '</span>';
            if(has_post_thumbnail()){
                if(isset($attachement["width"]) && isset($attachement["height"])){
                    $width = $attachement["width"];
                    $height = $attachement["height"];
                }
            }?>
            <?php 
            if(jaw_template_get_var('clickable_image', '0')) {
                echo "</a>";
            }
            ?>
            <div class="post-comments-labes">
                <?php
                if (jaw_template_get_var('blog_comments_inimage', '1') == '1') {
                    echo jwRender::get_meta_comments();
                }
                ?>
            </div>
            <div class="post-categories-labels">
                <?php
                if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                    echo jwRender::get_meta_category();
                }
                ?>
            </div>
            
        </div>
        <div class="content-box">
            <?php do_action( 'jaw_postbox_vertical', 'review' ); ?>
        </div>
        <?php do_action('jaw_after_postbox_content'); ?>
    </div>
</article>
