<?php
global $post, $wp_query, $jaw_data, $content_width;
$col_count = jaw_template_get_var("columns", 12);
//class
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-special-big';
$single_class[] = 'jaw-post-box';
$attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article id="post-<?php the_ID(); ?>"  <?php post_class($single_class); ?>>
    <div class="box">
        <div class="content-box">
            
            <div class="image video">
                <?php
                $video = get_post_meta(get_the_ID(), 'jaw_post_video_link', true);
                $link = false;
                $pp = false;
                $rel = '';
                switch (jaw_template_get_var('clickable_image', '0')) {
                    case '1': $link = get_permalink();
                        $rel = ''; 
                        break;
                    case '2': $link = $video;
                        $pp = true;
                        $rel = 'prettyPhoto[]';
                        break;
                }
                if (has_post_thumbnail()) {
                    echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-16_9-small', 'jaw_blog-16_9-middle', 'jaw_blog-16_9', 'large','full'), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
                    if(isset($attachement["width"]) && isset($attachement["height"])){
                        $width = $attachement["width"];
                        $height = $attachement["height"];
                    }
                } else {
                    echo jwMedia::getVideoThumbnail($video, $link, array($pp, 'full', jaw_template_get_counter('pagination')));
                }
                if($link){
                    echo '<a href="'.$link.'" rel="'.$rel.'" >';
                }
                echo '<span class="jaw-video-icon">'.apply_filters('jaw_default_video_icon', '<i class="jaw-icon-play4"></i>').'</span>';
                if($link){
                    echo '</a>';
                }
                ?>
            </div>
            <div class="jw-container">
                <div class="categories-special-big">
                    <div class="post-categories-labels">
                        <div class="post-categories-links">
                        <?php
                        if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                            echo jwRender::get_meta_category();
                        }
                        ?>
                        </div>
                    </div>
                </div>
                <div class="content-border-wrapper">
                    <div class="title-special">
                        <h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?> class="jw-title">
                            <a href="<?php the_permalink(); ?>" class="post_name"><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></a>
                        </h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?>>
                    </div>
                    <?php do_action( 'jaw_postbox_special_big_after_title', get_post_format() ); ?>
                    <div class="content-box">
                        <p> 
                            <?php
                            echo jwUtils::crop_length(get_the_excerpt(), jaw_template_get_var('letter_excerpt', 275));
                            ?>
                        </p>
                    </div>
                    <div class="meta-special">
                        <?php
                        echo jaw_get_template_part('meta', 'meta');
                        ?>
                    </div>
                </div>
            </div>
            <?php do_action('jaw_after_postbox_content'); ?>
        </div>
    </div>
</article>