<?php
global $content_width, $wp_query, $post;


$terms = get_the_category();
$post_meta = get_post_meta(get_the_id(), '');

$totalrat = array('final' => "");
if(class_exists('ratingManager')){
    $ratingManager = ratingManager::getInstance();
    $ratings = $ratingManager->getRatings(get_the_ID());
    $totalrat = $ratingManager->getRatingsScore($ratings);
}
$ratingtype=jwOpt::get_option('rating_maximal_value');
$ratingmaxvalue=jwOpt::get_option('rating_maximal_value_show');

if (isset($terms[0]->term_id)) {
    $term_id = $terms[0]->term_id;
} else {
    $term_id = 0;
}
$single_preset = jwOpt::checkDefaultPreset(array(jwOpt::get_option('single_preset', jwOpt::get_option('single_preset'), 'category', $term_id), jwOpt::get_option('single_preset')),'single');
jaw_template_set_var('single_preset',$single_preset);

if (jwLayout::content_layout() == 'fullwidth_sidebar') {
    $layout = 'fullwidth';
} else {
    $layout = 'sidebar';
}
// with perex
$with_perex = false;
if (strpos(get_the_content(), 'more')) {
    $with_perex = true;
}
// image caption
$image_caption_toggle = 'image_caption_toggle-' . jwOpt::get_option('image_caption_toggle');
$columns = jaw_template_get_var("columns", 4);
//clases
$single_class = array();
$single_class[] = jwLayout::col_class($columns);
$single_class[] = 'content-full';
$single_class[] = 'jaw-post-box';
$single_class[] = 'bar_type_1';
$single_class[] = 'jaw-single';
$single_class[] = 'format-review';
$single_class[] = $layout;
$single_class[] = 'post-preset-' . jwOpt::checkDefaultPreset(array(jwOpt::get_option('content_color', '_default', 'category', $term_id), jwOpt::get_option('main_color')),'color');
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');

//review
$review = false;
if (isset($post_meta['fw_rating_position']) && implode($post_meta['fw_rating_position']) == '1') {
    $review = true;
} else {
    $review = false;
}

// META
$meta_date = jwOpt::getPresetValue('meta_date', '1', 'single', $single_preset);
$meta_comments_count = jwOpt::getPresetValue('meta_comments_count', '1', 'single', $single_preset);
$meta_author = jwOpt::getPresetValue('meta_author', '1', 'single', $single_preset);
$meta_category = jwOpt::getPresetValue('meta_category', '1', 'single', $single_preset);
$meta_likes = jwOpt::getPresetValue('meta_likes', '1', 'single', $single_preset);
$meta_ratings = jwOpt::getPresetValue('meta_ratings', '1', 'single', $single_preset);
$meta_featured = jwOpt::getPresetValue('meta_featured', '1', 'single', $single_preset);
$meta_print = jwOpt::getPresetValue('meta_print', '1', 'single', $single_preset);
$meta_font_resize = jwOpt::getPresetValue('meta_font_resize', '1', 'single', $single_preset);
    
                
//Side Box

$col_content = 12;

$show_after_perex_box = false;
$side_box_position = jwOpt::getPresetValue('perex_box', 'left', 'single', $single_preset);
$side_box_visibility = jwOpt::getPresetValue('perex_box_visibility', 'tablet', 'single', $single_preset);
if ($side_box_visibility != '0') {
    jaw_template_set_var('bar_type', jwOpt::getPresetValue('post_layout_style', 'bar_type_1', 'single', $single_preset));
    jaw_template_set_var('single_preset', $single_preset);

    $gallery_show = jwOpt::getPresetValue('perex_gallery', '4', 'single', $single_preset);
    $perex_gallery_content = jwMedia::getGallery("vertical",$gallery_show);
    $perex_featured = jwOpt::getPresetValue('perex_featured', '1', 'single', $single_preset);
    $perex_shares = jwOpt::getPresetValue('perex_shares', '0', 'single', $single_preset);
    $perex_related_posts = jwOpt::getPresetValue('perex_related_posts', '1', 'single', $single_preset);
    $perex_tags = jwOpt::getPresetValue('perex_tags', '0', 'single', $jaw_single_preset);
    $perex_rating = jwOpt::getPresetValue('perex_rating', '1', 'single', $single_preset);
    $perex_banner = jwOpt::getPresetValue('perex_banner', '1', 'single', $single_preset);
    if($perex_gallery_content || $perex_featured || $perex_shares || $perex_related_posts || ($perex_rating && $review) || $perex_banner || $perex_tags) {
        $show_after_perex_box = true;
        $col_content = 9;
        
        $after_perex_box_class = array();
        $after_perex_box_class[] = jwLayout::col_class(3);
        $after_perex_box_class[] = 'show-on-'.$side_box_visibility;
        $after_perex_box_class[] = 'fixed_'.jwOpt::getPresetValue('perex_box_fixed', '0', 'single', $single_preset);
                        
    }
}

$main_content_class = array();
$main_content_class[] = 'jaw-after-perex';
$main_content_class[] = 'jaw-sidebox-position-'.$side_box_position;
$main_content_class[] = jwLayout::col_class($col_content);
$attachement = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
?>
<article  <?php post_class($single_class); ?> id="post-<?php the_ID(); ?>">
    <div class="entry-content <?php echo esc_attr($image_caption_toggle); ?>" >
        <h3 class="entry-title perex" >
            <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
            <?php the_title(); ?>
            </a>
        </h3>
                <div class="image">
            <?php
            $link = false;
            $pp = false;
            switch (jaw_template_get_var('clickable_image', '0')) {
                case '1': $link = get_permalink();
                    break;
                case '2': $link = jwMedia::getPostThumbnailSrc(get_the_ID());
                    $pp = true;
                    break;
            }
            ?><span class="jaw-fadein"></span><?php 
            echo jwMedia::getPostThumbnail(get_the_ID(), array('jaw_blog-16_9-big','jaw_blog-16_9-small', 'jaw_blog-16_9-middle', 'jaw_blog-16_9',  'large'), $link, array($pp, 'full', jaw_template_get_counter('pagination')));
            if(has_post_thumbnail()){
                if(isset($attachement["width"]) && isset($attachement["height"])){
                    $width = $attachement["width"];
                    $height = $attachement["height"];
                }
            }?>
            <div class="post-comments-labes">
                <?php
                if (jaw_template_get_var('blog_comments_inimage', '1') == '1') {
                    echo jwRender::get_meta_comments();
                }
                ?>
            </div>
            <div class="post-categories-labels">
                <?php if (isset($post_meta['fw_rating_position'][0]) && $post_meta['fw_rating_position'][0] == '1') {
                    ?>
                    <div class="post-review-total">
                        <?php
                        switch($ratingtype) {
                            case "100" :
                                    echo esc_attr(round($totalrat['final'], 0)).'<span>%</span>';
                            break;
                            default:
                                if($ratingmaxvalue) {
                                    echo esc_attr(round($totalrat['final'], 1)).'<span>/'.esc_attr($ratingtype).'</span>';
                                } else {
                                    echo esc_attr(round($totalrat['final'], 1));
                                }
                            break;
                        }
                         ?>
                    </div>
                <?php } ?>
                <?php
                if (jaw_template_get_var('blog_category_inimage', '1') == '1') {
                    echo jwRender::get_meta_category();
                }
                ?>
            </div>
        </div>
        <?php
        if ($with_perex) {
            global $more;
            $more = 0;
            ?>
            <div class="perex">   
                <div class="row">
                    <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?> jaw-perex-content">
                        <?php the_content('', true); ?>
                    </div>
                </div>

            <?php } else { ?>
                <div  class="perex ">   
                <?php } ?>
                <?php
                // META
                echo jaw_get_template_part('meta', 'meta') 
                // END META
                ?>
            </div>
            <div  class="more-text">
                <?php
                if ($with_perex) {
                    $more = 1;
                }
                // ========================== CONTENT =================================
            ?>
                <div class="row">
                    <div class="<?php echo esc_attr(implode(' ', $main_content_class)); ?> jaw-after-perex">
                        <div class="row">
                            <?php jwRender::get_banner('posttop'); ?>
                            <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
                                <?php the_content('', true); ?>
                            </div>
                            <?php jwRender::get_banner('postbottom'); ?>
                             <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
                             <?php 
                                 //multipages
                               wp_link_pages(array('before' => '<div id="page-nav">', 'after' => '</div>', 'link_before' => '<span class="post_page">', 'link_after' => '</span>'));
                             ?>
                            </div>
                        </div>
                    </div>
                    <?php
                    
                        
                    // ========================================== BOX AFTER PEREX ===================================================
                    jaw_template_set_var('single_preset', $single_preset);
                    jaw_template_set_var('bar_type', jwOpt::getPresetValue('post_layout_style', 'bar_type_1', 'single', $single_preset));
                    
                    if ($show_after_perex_box) { // perex on
                        $count = 0;
                        ?>
                        <div class="<?php echo esc_attr(implode( ' ',$after_perex_box_class)); ?> jaw-box perex-box jw-rating-slim">
                            <?php do_action('jaw_before_perex_box'); ?>
                            <!-- Featured post area -->
                            <?php
                            /*                                 * ****************** GALLERY PEREX BOX ******************* */
                            if($perex_gallery_content) {
                                echo $perex_gallery_content;
                                echo '<div class="meta_divider"></div>';
                            }
                            /*                                 * ****************** Featured post ******************* */
                            if ($perex_featured) {
                                echo jaw_get_template_part('featured_post', 'blog');
                                $count++;
                            }
                            /*                                 * ****************** Share post ******************* */
                            if ($perex_shares) {
                                echo jaw_get_template_part('shareit', 'blog');
                                $count++;
                            }
                            /*                                 * ****************** Related posts ******************* */
                            if ($perex_related_posts) {
                                echo jaw_get_template_part('related-post_box', 'blog');
                                $count++;
                            }
                            /*                                 * ****************** Rate post ******************* */
                            if ($perex_rating && $review) {
                                echo jaw_get_template_part('rating', 'blog');
                                $count++;
                            }
                            /*                                 * ****************** TAGS  ******************* */
                               
                                if (has_tag() && $perex_tags) { 
                                    echo jaw_get_template_part('tags', 'blog');
                                    $count++;
                                }
                            /*                                 * ****************** banner ******************* */
                            if ($perex_banner) {
                                ?>
                                <div class="row"> 
                                    <?php
                                    jwRender::get_banner('postside');
                                    ?>
                                </div>
                                <?php
                                $count++;
                            }
                            ?>
                            <?php if($count > 0){ ?>
                                <div class="meta_divider"></div>
                            <?php } ?>
                            <?php do_action('jaw_after_side_box'); ?>
                        </div>
                    <?php } // CONTENT Side Box
                    jaw_template_set_var("columns", $columns);
                    ?>
                </div>

            </div>
            <div class="clear"></div>
            <!-- Pagination -->
            </article>
            <?php

        