<?php
global $post, $wp_query, $jaw_data;

if (jwLayout::content_layout() == 'fullwidth_sidebar') {
    $layout = 'fullwidth';
} else {
    $layout = 'sidebar';
}

$col_count = jaw_template_get_var("columns", 4);
//clases
$single_class = array();
$single_class[] = jwLayout::col_class($col_count);
$single_class[] = 'content-full';
$single_class[] = 'jaw-post-box';
$single_class[] = 'bar_type_1';
$single_class[] = 'jaw-single';
$single_class[] = $layout;
$template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
?>
<article  <?php post_class($single_class); ?> id="post-<?php the_ID(); ?>">
    <div class="box ">        
        <div class="image link">
            <i class="jaw-icon-new-tab"></i>
        </div>
        <div class="content-box">
            <header>
                <h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?> class="jw-title">
                    <a href="<?php echo esc_url(get_post_meta(get_the_ID(), 'jaw_post_link', true)); ?>" class="post_name"><?php echo jwUtils::crop_length(get_the_title(), jaw_template_get_var('letter_excerpt_title', 60)); ?></a>
                </h<?php echo esc_attr(jaw_template_get_var('title_h', '3')); ?>>
            </header>
            <?php
            echo jaw_get_template_part('meta', 'meta');
            ?>
        </div>
        <div class="clear"></div>
    </div>
</article>

