<?php
global $wp_query, $post, $more;

// loop
while (have_posts()) : the_post();

//MODEL ============================================================================================

    // Classes for the content types
    $jaw_single_class = array();
    if (jwLayout::content_layout() == 'fullwidth_sidebar') {
        $jaw_single_class[] = 'fullwidth';
    } else {
        $jaw_single_class[] = 'sidebar';
    }
    $jaw_single_class[] = jwLayout::col_class(12);
    $jaw_single_class[] = 'content';
    $jaw_single_class[] = 'jaw-single';

    //get meta
    $post_meta = get_post_meta(get_the_id(), '');
    
    //get preset
    $jaw_gallery_id = "_defualt";
    $jaw_single_preset = jaw_template_get_var('single_preset');
    if(isset($post_meta['jaw_perex_gallery_box'][0])){
        $jaw_gallery_id = $post_meta['jaw_perex_gallery_box'][0];
    }
   
    // get category ID
    $jaw_terms = get_the_category();
    if (isset($jaw_terms[0]->term_id)) {
        $term_id = $jaw_terms[0]->term_id;
    } else {
        $term_id = 0;
    }
    
    // has this post review
    $review = false;
    $microdata = "";
    $rating_title="";
    if (isset($post_meta['fw_rating_position']) && implode($post_meta['fw_rating_position']) == '1') {
        $review = true;
        $microdata = ' itemscope itemtype="http://schema.org/Review" ';
    } else {
        $review = false;
        $microdata = ' itemscope itemtype="http://schema.org/Article" ';
    }
    if(isset($post_meta['fw_rating_title'][0]) && !empty($post_meta['fw_rating_title'][0])) {
        $rating_title = $post_meta['fw_rating_title'][0];
    }
    
    // with perex
    $with_perex = false;
    if (strpos(get_the_content(), 'id="more-')) {
        $with_perex = true;
    }
    
    // image caption
    $jaw_single_class[] = 'image_caption_toggle-' . jwOpt::get_option('image_caption_toggle');
    
    
    // META
    $jaw_meta_date = jwOpt::getPresetValue('meta_date', '1', 'single', $jaw_single_preset);
    $jaw_meta_comments_count = jwOpt::getPresetValue('meta_comments_count', '1', 'single', $jaw_single_preset);
    $jaw_meta_author = jwOpt::getPresetValue('meta_author', '1', 'single', $jaw_single_preset);
    $jaw_meta_category = jwOpt::getPresetValue('meta_category', '1', 'single', $jaw_single_preset);
    $jaw_meta_likes = jwOpt::getPresetValue('meta_likes', '1', 'single', $jaw_single_preset);
    $jaw_meta_ratings = jwOpt::getPresetValue('meta_ratings', '1', 'single', $jaw_single_preset);
    $jaw_meta_featured = jwOpt::getPresetValue('meta_featured', '1', 'single', $jaw_single_preset);
    $jaw_meta_print = jwOpt::getPresetValue('meta_print', '1', 'single', $jaw_single_preset);
    $jaw_meta_font_resize = jwOpt::getPresetValue('meta_font_resize', '1', 'single', $jaw_single_preset);
    
                    
    //Side Box
    
    $col_content = 12;
    
    $show_after_perex_box = false;
    $side_box_position = jwOpt::getPresetValue('perex_box', 'left', 'single', $jaw_single_preset);
    $side_box_visibility = jwOpt::getPresetValue('perex_box_visibility', 'tablet', 'single', $jaw_single_preset);
    $perex_next_to_content_shares = jwOpt::getPresetValue('perex_next_to_content_shares', '0', 'single', $jaw_single_preset);
    if ($side_box_visibility != '0') {
        jaw_template_set_var('bar_type', jwOpt::getPresetValue('post_layout_style', 'bar_type_1', 'single', $jaw_single_preset));
        jaw_template_set_var('single_preset', $jaw_single_preset);

        $gallery_show = jwOpt::getPresetValue('perex_gallery', '4', 'single', $jaw_single_preset);
        $perex_gallery_content = jwMedia::getGallery("vertical",$gallery_show);
        $perex_featured = jwOpt::getPresetValue('perex_featured', '1', 'single', $jaw_single_preset);
        $perex_shares = jwOpt::getPresetValue('perex_shares', '0', 'single', $jaw_single_preset);
        $perex_related_posts = jwOpt::getPresetValue('perex_related_posts', '1', 'single', $jaw_single_preset);
        $perex_tags = jwOpt::getPresetValue('perex_tags', '0', 'single', $jaw_single_preset);
        $perex_rating = jwOpt::getPresetValue('perex_rating', '1', 'single', $jaw_single_preset);
        $perex_banner = jwOpt::getPresetValue('perex_banner', '1', 'single', $jaw_single_preset);
        if($perex_gallery_content || $perex_featured || $perex_shares || $perex_related_posts || ($perex_rating && $review) || $perex_banner || $perex_tags) {
            $show_after_perex_box = true;
            $col_content = 9;
            
            $after_perex_box_class = array();
            $after_perex_box_class[] = jwLayout::col_class(3);
            $after_perex_box_class[] = 'show-on-'.$side_box_visibility;
            $after_perex_box_inner_class = array();
            $after_perex_box_inner_class[] = 'fixed_'.jwOpt::getPresetValue('perex_box_fixed', '0', 'single', $jaw_single_preset);
                            
        }
    }
    
    $main_content_class = array();
    $main_content_class[] = 'jaw-after-perex';
    $main_content_class[] = 'jaw-sidebox-position-'.$side_box_position;
    $main_content_class[] = jwLayout::col_class($col_content);

    // microdata
    $template_logo = jwOpt::get_option('custom_logo', JAW_THEME_URI . '/images/logo/logo.png');
    
    
    
    //VIEW ======================================================================================
    ?>
    <article  <?php post_class($jaw_single_class); ?> id="post-<?php the_ID(); ?>"  <?php echo $microdata; ?> >
        <meta itemscope itemprop="mainEntityOfPage"  itemType="https://schema.org/WebPage" itemid="<?php echo get_permalink(); ?>"/>
        <span itemprop="publisher" itemscope itemtype="https://schema.org/Organization">
            <meta itemprop="name" content="<?php echo get_bloginfo(); ?>"/>    
            <meta itemprop="url" content="<?php echo get_permalink(); ?>"/>
            <span itemprop="logo" itemscope itemtype="http://schema.org/ImageObject">
                <meta itemprop="url" content="<?php echo esc_url($template_logo); ?>" />
            </span>    
        </span>
        <div class="entry-content" >
            <?php
            if (jwOpt::getPresetValue('post_title_placement', 'under_image', 'single', $jaw_single_preset) == 'under_image') {
                echo jaw_get_template_part('single-post-featured-img', 'blog');
            }
            ?>
            <?php
            if ($with_perex) {
                $more = 0; //WP global
                ?>
                <div class="perex">
                    <?php echo jaw_get_template_part('post_title', 'blog'); ?>
                    <div class="row">
                        <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?> jaw-perex-content">
                            <?php do_action('jaw_before_single_perex'); ?>
                            <?php the_content('', true); ?>
                            <?php do_action('jaw_after_single_perex'); ?>
                        </div>
                    </div>

                <?php } else { ?>
                    <div  class="perex ">   
                        <?php echo jaw_get_template_part('post_title', 'blog'); ?>
                    <?php } ?>
                    <?php
                    
                    // META
                    if (($jaw_meta_date == '1') ||
                        ($jaw_meta_comments_count == '1') ||
                        ($jaw_meta_author == '1') ||
                        ($jaw_meta_category == '1') ||
                        ($jaw_meta_likes == '1') ||
                        ($jaw_meta_ratings == '1') ||
                        ($jaw_meta_featured == '1') ||
                        ($jaw_meta_print == '1') ||
                        ($jaw_meta_font_resize == '1')) {
                        ?>
                        <div class="row">
                            <ul class="<?php echo esc_attr(jwLayout::col_class(12)); ?> blog-meta-info-top blog-meta-info">
                                <?php if ($jaw_meta_date == '1') { ?>
                                    <li class="post-meta-date">
                                        <span class="date">
                                            <?php echo jwRender::get_meta_date(); ?>
                                        </span>
                                    </li>
                                <?php } ?>
                                <?php if ($jaw_meta_comments_count == '1') { ?>  
                                    <li class="post-meta-comments">
                                        <?php echo jwRender::get_meta_comments(); ?>
                                    </li>    
                                <?php } ?>
                                <?php if ($jaw_meta_author == '1') { ?>
                                    <li class="post-meta-author">
                                        <?php echo jwRender::get_meta_author(); ?>
                                    </li>
                                <?php } ?>
                                <?php if ($jaw_meta_category == '1') { ?>
                                    <li class="post-meta-catagory">
                                        <span><?php esc_html_e('Posted in ', "gdn-theme"); ?></span>
                                        <?php echo jwRender::get_meta_category(); ?>
                                    </li>
                                <?php } ?>
                            <?php //  ?>
                                <?php if ($jaw_meta_likes == '1') { ?>
                                    <?php echo jwRender::get_likes(); ?>
                                <?php } ?>
                                <?php if ($jaw_meta_ratings == '1') { ?>    
                                    <?php echo jwRender::metaRating(); ?>  <!-- RATING -->
                                <?php } ?>
                                <?php if ($jaw_meta_featured == '1' && jwOpt::get_option('use_my_news', '1') && is_user_logged_in()) { ?>
                                    <li class="post-meta-featured">
                                        <?php echo jaw_get_template_part('featured_post', 'blog'); ?>  
                                    </li>
                                <?php } ?>
                                <?php if ($jaw_meta_print == '1') { ?>
                                    <li class="post-meta-print">
                                        <a href="#"><i class="jaw-icon-print"></i></a> 
                                    </li>
                                <?php } ?>
                                <?php if ($jaw_meta_font_resize == '1') { ?>
                                <li class="post-meta-font-resizer">
                                    <ul class="blog-meta-info-top">
                                        <li class="post-meta-font-resize normal">
                                            <a href="#"><i class="jaw-icon-a-letter"></i></a> 
                                        </li>
                                        <li class="post-meta-font-resize bigger">
                                            <a href="#"><i class="jaw-icon-a-letter"></i></a> 
                                        </li>
                                        <li class="post-meta-font-resize biggest">
                                            <a href="#"><i class="jaw-icon-a-letter"></i></a> 
                                        </li>
                                    </ul>
                                </li>
                                <?php } ?>
                            <?php //  ?>
                                <?php edit_post_link( '<i class="jaw-icon-pen"></i> '. esc_html__( 'Edit', "gdn-theme" ), '<li class="post-meta-edit">', '</li>' ); ?>
                                <?php do_action('jaw_after_single_meta'); ?>
                            </ul>
                        </div>
                    <?php } // END META
                    ?>
                </div>
                <?php
                if (jwOpt::getPresetValue('post_title_placement', 'under_image', 'single', $jaw_single_preset) == 'above_image') {
                    echo jaw_get_template_part('single-post-featured-img', 'blog');
                }
                ?>
                <div  class="more-text">
                    <?php
                    if ($with_perex) {
                        $more = 1; //WP global
                    }
                    
                    // ========================== CONTENT =================================
                    ?>
                    <div class="row jw-fixed-sidebar-box">
                        <div class="<?php echo esc_attr(implode(' ', $main_content_class)); ?> jaw-after-perex">
                            <div class="row">
                                <?php do_action('jaw_before_single_content'); ?>
                                <?php 
                                if(jwOpt::getPresetValue('post_top_banner', '1', 'single', $jaw_single_preset) == '1'){  
                                    jwRender::get_banner('posttop'); 
                                }
                                ?>
                                <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
                                    <?php
                                    if (class_exists('mashshare') && $perex_next_to_content_shares) {
                                        echo do_shortcode("[mashshare]");
                                    }
                                    ?>
                                    <?php the_content('', true); ?>
                                </div>
                                <?php if(jwOpt::getPresetValue('post_bottom_banner', '1', 'single', $jaw_single_preset) == '1'){  
                                    jwRender::get_banner('postbottom'); 
                                } ?>
                                <?php do_action('jaw_after_single_content'); ?>
                                 <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>">
                                 <?php 
                                    wp_link_pages(array('before' => '<div id="page-nav">', 'after' => '</div>', 'link_before' => '<span class="post_page">', 'link_after' => '</span>'));
                                ?>
                                </div>
                            </div>
                        </div>
                        <?php
                        
                        
                        
                        // ========================================== BOX AFTER PEREX ===================================================
                        jaw_template_set_var('single_preset', $jaw_single_preset);
                        jaw_template_set_var('bar_type', jwOpt::getPresetValue('post_layout_style', 'bar_type_1', 'single', $jaw_single_preset));
                        
                        if ($show_after_perex_box) { // perex on
                            $count = 0;
                            ?>
                            <div class="<?php echo esc_attr(implode( ' ',$after_perex_box_class)); ?> jaw-box perex-box jw-rating-slim">
                             <div class="<?php echo esc_attr(implode( ' ',$after_perex_box_inner_class)); ?> perex-box-inner">
                                <?php do_action('jaw_before_perex_box'); ?>
                                <!-- Featured post area -->
                                <?php
                        // 
                                /*                                 * ****************** GALLERY PEREX BOX ******************* */
                                if($perex_gallery_content) { 
                                    echo $perex_gallery_content; 
                                    echo '<div class="meta_divider"></div>';
                                }
                                /*                                 * ****************** Featured post ******************* */
                                if ($perex_featured) {
                                    echo jaw_get_template_part('featured_post', 'blog');
                                    $count++;
                                }
                        // 
                                /*                                 * ****************** Share post ******************* */
                                if ($perex_shares) {
                                    if (class_exists('mashshare')) { // mashare plugin
                                        echo jaw_get_template_part('shareit-advanced', 'blog');
                                    } else {
                                        echo jaw_get_template_part('shareit', 'blog');
                                    }
                                    $count++;
                                }
                                /*                                 * ****************** Related posts ******************* */
                                if ($perex_related_posts) {
                                    echo jaw_get_template_part('related-post_box', 'blog');
                                    $count++;
                                }
                        // 
                                /*                                 * ****************** Rate post ******************* */
                                if ($perex_rating && $review) {
                                    jaw_template_set_var('title', $rating_title);
                                    echo jaw_get_template_part('rating', 'blog');
                                    $count++;
                                }
                        // 
                                /*                                 * ****************** TAGS  ******************* */
                               
                                if (has_tag() && $perex_tags) { 
                                    echo jaw_get_template_part('tags', 'blog');
                                    $count++;
                                }

                                /*                                 * ****************** banner ******************* */
                                if ($perex_banner) {
                                    ?>
                                    <div class="row"> 
                                        <?php
                                        jwRender::get_banner('postside');
                                        ?>
                                    </div>
                                    <?php
                                    $count++;
                                }
                                ?>
                                <?php if($count > 0){ ?>
                                    <div class="meta_divider"></div>
                                <?php } ?>
                                <?php do_action('jaw_after_side_box'); ?>
                            </div>
                            </div>
                        <?php } // CONTENT Side Box ?>
                    </div>
                </div>
                <div class="clear"></div>
                
                <?php // PAGINATION ?>
                <?php echo jaw_get_template_part('pagination', 'pagination'); ?>
                <?php // END PAGINATION ?>
                
                <?php
        // 
                // GALLERY BOTTOM
                $gallery_bottom_count = jwOpt::getPresetValue('post_gallery_bottom', '4', 'single', $jaw_single_preset);
                if($jaw_gallery_id != "_default" && $gallery_bottom_count) {
                    echo jwMedia::getGallery("horizontal",$gallery_bottom_count,$jaw_gallery_id);
                    echo '<div class="meta_divider"></div>';
                }
                // END GALLERY BOTTOM
        // 
                ?>
                
                <?php // BOTTOM SHARE POST ?>
                <?php if (jwOpt::getPresetValue('post_bottom_share', '1', 'single', $jaw_single_preset) == '1') { ?>
                    <div class="share-single-bottom">
                        <div class="row">
                            <?php
                                if (class_exists('mashshare')) { // mashare plugin
                                    echo jaw_get_template_part('shareit-advanced_bottom', 'blog'); 
                                } else {
                                    echo jaw_get_template_part('shareit_bottom', 'blog');
                                }
                            ?>
                        </div>
                    </div>
                    <div class="meta_divider"></div>
                <?php } ?>
                <?php // END BOTTOM SHARE POST ?>
                
                <?php // BOTTOM ABOUT AUTHOR ?>
                <?php if (jwOpt::getPresetValue('post_bottom_author', '1', 'single', $jaw_single_preset) == '1') { ?>
                    <?php
                    jaw_template_set_var('box_title', esc_html__('About author', "gdn-theme"));
                    echo jaw_get_template_part('section_bar', 'simple-shortcodes');
                    jaw_template_set_var('id', get_the_author_meta('ID'));
                    jaw_template_set_var('nicename', get_the_author());
                    echo jaw_get_template_part('author-bottom', 'blog');
                    ?>
                    <div class="meta_divider"></div>
                <?php } ?>
                <div class="clear"></div>
                <?php // BOTTOM ABOUT AUTHOR ?>
                
                <?php /* BOTTOM Related posts */ ?>
                <?php if (jwOpt::getPresetValue('post_bottom_relatedpost', '1', 'single', $jaw_single_preset) == '1') { ?>
                    <div class="related_bottom">
                        <?php echo jaw_get_template_part('related-post', 'blog'); ?>
                    </div>
                <?php } ?>
                <?php /* BOTTOM tags */ ?>
                <?php if (has_tag() && jwOpt::getPresetValue('post_tags_bottom', '1', 'single', $jaw_single_preset) == '1') { ?>
                    <?php echo jaw_get_template_part('tags', 'blog'); ?>
                    <div class="meta_divider"></div>
                <?php } ?>
    <?php //  ?>
                <?php /* BOTTOM Rating */ ?>
                <?php if ($review && jwOpt::getPresetValue('post_rating_bottom', '1', 'single', $jaw_single_preset) == '1') { ?>
                    <div class="jw-rating-bottom">
                    <?php
                    jaw_template_set_var('title', $rating_title);
                     echo jaw_get_template_part('rating', 'blog'); ?>
                    </div>
                    <div class="meta_divider"></div>
                <?php } ?>
    <?php  ?>
                <?php do_action('jaw_after_single'); ?>
                <?php /* BOTTOM Comments */ ?>
                <?php
                if (jwOpt::getPresetValue('show_comments', '1', 'single', $jaw_single_preset) == '1') {
                    comments_template();
                }
                ?>
                <?php
                // SHOW UP POST
                if(jwOpt::get_option("showup_post", 0)) {
                    echo jaw_get_template_part('related-post_showup', 'blog');
                }
                ?>
                <meta itemprop="name" content="<?php echo get_the_author(); ?>"/>
                <meta itemprop="datePublished" content="<?php echo get_the_date(); ?>"/>
                <meta itemprop="mainEntityOfPage" content="<?php echo get_the_permalink(); ?>"/>
                <span itemprop="author" itemscope itemtype="https://schema.org/Person">
                    <meta itemprop="name" content="<?php  echo get_the_author(); ?>"/>  
                </span>
                <meta itemprop="dateModified" content="<?php echo get_the_modified_date(); ?>"/>
                <input type="hidden" class="jw_readers_post_id" value="<?php  echo get_the_ID(); ?>" />
                </article>
                <?php
            endwhile;