<?php
// Featured image/gallery/video in SINGLE post

$single_preset = jaw_template_get_var('single_preset');
$featured_img = jwOpt::getPresetValue('post_use_featured', '1', 'single', $single_preset);
$attachment = wp_get_attachment_metadata(get_post_thumbnail_id(get_the_ID()));
$itemprop="";
if($attachment) {
$itemprop = 'itemprop="image" itemscope itemtype="https://schema.org/ImageObject"';
}
// Should I show FEATURED IMAGE
if ($featured_img === '1') {
    $post_meta = get_post_meta(get_the_id(), ''); // tohle bylo vyvanyšované
    $col_class = jwLayout::col_class(12);
    
    ?>
    <!-- Image / video / gallery -->
    <div class="jaw_single_img row " <?php echo $itemprop; ?>>
        <div class="<?php echo esc_attr($col_class); ?> "  >
            <?php
            switch (get_post_format()) {
                case 'video':
                    if (isset($post_meta['jaw_post_video_link'][0])) {
                        echo jwMedia::getVideoPlayer($post_meta['jaw_post_video_link'][0], 720);
                    }
                    break;
                case 'gallery':
                    if (isset($post_meta['jaw_post_gallery'][0])) {
                        //TADY BUDE JINA GALEIRE
                        $gallery = $post_meta['jaw_post_gallery'][0];
                        $ids = jwMedia::parseJson($gallery);
                        if(!empty($ids)){
                            echo do_shortcode('[jaw_gallery gallery="' . esc_attr( implode(',', $ids) ) . '" ]');
                        }else if(has_post_thumbnail()){
                            echo jwMedia::getPostThumbnail(get_the_ID(), array('large','full') );
                        } 
                    }
                    break;
                default:
                    echo jwMedia::getPostThumbnail(get_the_ID(), array('large','full') );
                    if(jwOpt::get_option('featured_image_caption')) {
                        $thumb_id = get_post(get_post_thumbnail_id());
                        $featured_img_caption = $thumb_id->post_excerpt;
                        if(!empty($featured_img_caption)) {
                            echo '<p class="featured_img_caption">'.$featured_img_caption.'</p>'; 
                        }
                    }
            }
            if(!empty($attachment)){
                ?>
                <meta itemprop="url" content="<?php echo esc_url(jwMedia::getPostThumbnailSrc(get_the_ID())); ?>">
                <meta itemprop="width" content="<?php echo esc_attr($attachment["width"]); ?>">
                <meta itemprop="height" content="<?php echo esc_attr($attachment["height"]); ?>">
            <?php } ?>
        </div>
    </div>
    <?php
}
