<?php
// SHARE IT BOX
global $post;
?>
<div class="row">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="share_post" role="main">
            <?php
            jaw_template_set_var('box_title', esc_html__('Share this', "gdn-theme"));
            echo jaw_get_template_part('section_bar', 'simple-shortcodes');
            ?>
            <?php
            $title = htmlentities(urlencode(get_the_title()));
            $link = urlencode(get_permalink());
            $media = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'large-size');
            $media = urlencode($media[0]);
            $desc = urlencode($post->post_excerpt);
            
            if ((jwOpt::get_option('post_share_fb','1') != '1')
                && (jwOpt::get_option('post_share_tw','1') != '1')
                && (jwOpt::get_option('post_share_g','1') != '1')
                && (jwOpt::get_option('post_share_pi','1') != '1')
                && (jwOpt::get_option('post_share_re','1') != '1')
                && (jwOpt::get_option('post_share_mail','1') != '1')){
                    echo '<div class="jaw_msg jaw_msg_type_warning">';
                    sprintf(esc_html__('You have disabled all social sites in %s Theme Options -> Single Post -> Sharing Options %s','gdn-theme'),'<a href="'.admin_url("themes.php?page=optionsframework").'">','</a>');
                    echo '</div>';
                }
            ?>
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <ul class="socialshare-icon">
                            <?php if (jwOpt::get_option('post_share_fb','1') == '1') { ?>
                                <li>
                                    <a class="link-facebook" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo $link; ?>&t=<?php echo $title; ?>">
                                        <span class="jaw-icon-facebook4"></span>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if (jwOpt::get_option('post_share_tw','1') == '1') { ?>
                                <li>
                                    <a class="link-twitter" target="_blank" href="https://twitter.com/intent/tweet?original_referer=<?php echo $link; ?>&text=<?php echo $title; ?>&url=<?php echo $link; ?>">
                                        <span class="jaw-icon-twitter3"></span>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if (jwOpt::get_option('post_share_g','1') == '1') { ?>
                                <li>
                                    <a class="link-google" target="_blank" href="https://plus.google.com/share?url=<?php echo $link; ?>">
                                        <span class="jaw-icon-google-plus4"></span>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if (jwOpt::get_option('post_share_pi','1') == '1') { ?>
                                <li>
                                    <a class="link-pinterest" target="_blank" href="http://www.pinterest.com/pin/create/button/?url=<?php echo $link; ?>&media=<?php echo urlencode($media) ?>&description=<?php echo urlencode($desc); ?>">
                                        <span class="jaw-icon-pinterest"></span>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if (jwOpt::get_option('post_share_re','1') == '1') { ?>
                                <li>
                                    <a class="link-reddit" target="_blank" href="//www.reddit.com/submit" onclick="window.location = '//www.reddit.com/submit?url=' + + encodeURIComponent(window.location); return false">
                                        <span class="jaw-icon-reddit3"></span>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if (jwOpt::get_option('post_share_mail','1') == '1') { ?>
                                <li>
                                    <a class="link-email" target="_blank" href="mailto:<?php echo jwOpt::get_option('post_share_mail_content', 'youremail@addresshere.com'); ?>?subject=<?php echo $title; ?>&body=<?php echo urldecode($desc) . ' ' . urlencode($link); ?>">
                                        <span class="jaw-icon-mail4 "></span>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    <div class="clear"></div>
                </div>
            </div>

        </div>
    </div>
</div>
    <?php
// END SHARE IT