 <?php
global $wp_query,$post;
list($primary, $secondary) = jwRender::get_related_post(get_the_ID(), 1);
wp_reset_query();
$wp_query = new WP_Query($primary);
if (!(have_posts())) {
    wp_reset_query();
    $wp_query = new WP_Query($secondary);
}

$blog_classes[] = "blog_vertical";
jaw_template_set_var("columns", 3);
jaw_template_set_var('letter_excerpt', 0);
jaw_template_set_var('title_h', 3);
jaw_template_set_var('letter_excerpt_title', -1);
jaw_template_set_var("clickable_image",1);
jaw_template_set_var("columns", 12);
if (have_posts()) {
    
    $blog_classes = implode(" ", $blog_classes);
    $col_class = jwLayout::col_class(2);
    $columns = round(12 / jaw_template_get_var("columns", 4));
    
    ?>
    <div class="row">
        <div class="<?php echo esc_attr($col_class); ?> jaw-blog-wraper jaw-showup">
                <?php
                jaw_template_set_var('box_title', esc_html__('Do not miss', "gdn-theme"));
                echo jaw_get_template_part('section_bar', 'simple-shortcodes');
                ?>
                <i class="jaw-icon-close"></i>
                <div class="row jaw_blog <?php echo esc_attr($blog_classes); ?>" data-columns="<?php echo esc_attr($columns); ?>">
                    <?php while (have_posts()) : the_post(); ?>
                        <?php
                            if (get_post_meta(get_the_ID(), 'fw_rating_position', true) == '1') {
                                $format = 'review';
                            } else {
                                $format = get_post_format();
                            }
                            $format = apply_filters( 'jaw_post_format', $format );
                            echo jaw_get_template_part('content-vertical', 'content', $format);

                            break; //show only 1 post
                        ?>
                    <?php endwhile; ?>
                </div>
                <div class="clear"></div>
        </div>
    </div>
    <?php
}
wp_reset_postdata();
wp_reset_query(); 