<?php
$single_preset = jaw_template_get_var('single_preset');
list($primary, $secondary) = jwRender::get_related_post(get_the_ID(), jwOpt::getPresetValue('perex_number_of_related_posts', '3', 'single', $single_preset));
$query = new WP_Query($primary);
if (!($query->have_posts())) {
    wp_reset_query();
    $query = new WP_Query($secondary);
}
$blog_classes[] = "blog_vertical-small";
jaw_template_set_var("columns", 12);
jaw_template_set_var('title_h', 3);
jaw_template_set_var('letter_excerpt', 0);
jaw_template_set_var('letter_excerpt_title', -1);
jaw_template_set_var("clickable_image",1);
if ($query->have_posts()) {
    
    $col_class = jwLayout::col_class(12);
    $columns = round(12 / jaw_template_get_var("columns", 4));
    $blog_classes = implode(" ", $blog_classes);
    jaw_template_set_var("columns",array(12,12,4,12));
    ?>
    <div class="row">
        <div class="<?php echo esc_attr($col_class); ?> jaw-blog-wraper">
            
                <?php
                jaw_template_set_var('box_title', esc_html__('Related Posts', "gdn-theme"));
                echo jaw_get_template_part('section_bar', 'simple-shortcodes');
                ?>
                <div class="row jaw_blog <?php echo esc_attr($blog_classes); ?>" data-columns="<?php echo esc_attr($columns); ?>">
                    <?php
                    while ($query->have_posts()) : $query->the_post();
                   
                            if (get_post_meta(get_the_ID(), 'fw_rating_position', true) == '1') {
                                $format = 'review';
                            } else {
                                $format = get_post_format();
                            }
                            $format = apply_filters( 'jaw_post_format', $format );
                            echo jaw_get_template_part('content-vertical-small', 'content', $format);
                            
                    endwhile;
                    ?></div>
                <div class="clear"></div>
            </div>
    </div>
    <?php 
}
wp_reset_query();

