<?php
$post_id = jaw_template_get_var('post_id', '0');
if($post_id === '0' || $post_id === ''){
    $post_id = get_the_ID();
}
$ratingManager = ratingManager::getInstance();
$ratings = $ratingManager->getRatings($post_id);
$totalrat = $ratingManager->getRatingsScore($ratings);
$total = $totalrat;
if (jaw_template_get_var('title', '') == '0') {
    $ratingTitle = $ratingManager->getRatignsTitle($post_id);
}else{
    $ratingTitle = jaw_template_get_var('title', '');
}
$ratingsCount = 0;
$ratingtype=jwOpt::get_option('rating_maximal_value');
$ratingmaxvalue=jwOpt::get_option('rating_maximal_value_show');
?>
<?php if ($ratingManager->getShowRatigns($post_id)) { ?>

    <?php    
    if (!is_null($ratingTitle) && strlen($ratingTitle) > 0) {
        ?>
        <?php
        jaw_template_set_var('box_title', $ratingTitle);
        echo jaw_get_template_part('section_bar', 'simple-shortcodes');
        ?>
        <?php
    }
    ?>
    <div class="clear"></div>
    <div class="jw-rating-box">
        <?php foreach ($ratings as $oneRating) { ?>
            <?php if ($oneRating->useredit != "1") { ?>
                <?php $ratingsCount++;
        $one_round="";
        switch($ratingtype) {
            case "100" :
                    $one_round = esc_attr(round($oneRating->finalScore, 0)).'<span>%</span>';
            break;
            default:
                    $one_round = esc_attr(round($oneRating->finalScore, 1));

            break;
        }
                ?>
                <div class="jaw-one-rating-row">
                    <div class="jaw-one-rating-name"><?php echo esc_attr($oneRating->name); ?></div>
                    <div class="jaw-one-rating-number"><?php echo $one_round; ?></div> 
                    <div class="jaw-one-rating-graphic-wrapper">
                        <div class="jaw-one-rating-graphic" style="width:<?php echo esc_attr($oneRating->score); ?>%" ></div>
                    </div>
                </div>
            <?php } ?>
        <?php } ?>

        <div class="jaw-rating-cont">
            <?php if (strlen($ratingManager->getRatignsPositives($post_id)) > 0) { ?>
                <div class="jaw-rating-positives jaw-one-rating-row">
                    <div class="jaw-rating-text-title"><i class="jaw-icon-thumbs-up2"></i><?php esc_html_e('Positives', "gdn-theme"); ?></div>
                    <p><?php echo esc_attr($ratingManager->getRatignsPositives($post_id)); ?></p>
                </div>
            <?php } ?>
            <?php if (strlen($ratingManager->getRatignsNegatives($post_id)) > 0) { ?>
                <div class="jaw-rating-negatives jaw-one-rating-row">
                    <div class="jaw-rating-text-title"><i class="jaw-icon-thumbs-down2"></i><?php esc_html_e('Negatives', "gdn-theme"); ?></div>
                    <p><?php echo esc_attr($ratingManager->getRatignsNegatives($post_id)); ?></p>
                </div>
            <?php } ?>
        </div>
        <div class="clear"></div>
        <?php if (strlen($ratingManager->getRatignsConclusion($post_id)) > 0) { ?>
            <div class="jaw-rating-conclusion jaw-one-rating-row" >
                <p><?php echo esc_attr($ratingManager->getRatignsConclusion($post_id)); ?></p>
            </div>
        <?php } ?>    



        <div class="jaw-total-rating-row ">  
            <span itemprop="itemreviewed" style="display:none"> <?php echo esc_attr($oneRating->name); ?></span>
            <span itemprop="datePublished" style="display:none"> <?php echo get_the_date(); ?></span>

            <?php if ($ratingsCount > 0) { ?>
                <?php
                    $final_round="";
                switch($ratingtype) {
                    case "100" :
                            $final_round = round($totalrat['final'], 0).'<span>%</span>';
                    break;
                    default:
                        if($ratingmaxvalue) {
                            $final_round = round($totalrat['final'], 1).'<span>/'.$ratingtype.'</span>';
                        } else {
                            $final_round = round($totalrat['final'], 1);
                        }
                    break;
                }
                 ?>
                <div class="jw-rating-row-overall jaw-one-rating-row"  itemprop="reviewRating" itemscope itemtype="http://schema.org/Rating">  
                    <div class="jaw-one-rating-name"><?php esc_html_e('Total Rating', "gdn-theme"); ?></div>
                    <div class="jaw-one-rating-number" itemprop="ratingValue"><?php echo $final_round; ?></div>
                    <div class="jaw-one-rating-graphic-wrapper">
                        <div class="jaw-one-rating-graphic" style="width:<?php echo esc_attr($total['score']); ?>%" ></div>
                    </div>
                    <meta itemprop="worstRating" content = "0"/>
                    <meta itemprop="bestRating" content = "<?php echo esc_attr(jwOpt::get_option('rating_maximal_value', 10)); ?>"/>
                </div>
            <?php } ?>
            <div class="clear"></div>
        </div>

        <!-- END TOTAL RATING -->


        <!-- USER RATING -->
        <?php if ($ratingManager->getRatignsShowUserRating($post_id)) { ?>
            <div class="jaw-one-rating-row jaw-user-rating">                  
                <?php
                $userRating = $ratingManager->getOneRating($post_id, 'UsersRatings');
                if (isset($userRating->finalScore)) {
                    $userScore = round($userRating->finalScore, 2);
                } else {
                    $userScore = jwOpt::get_option('rating_maximal_value', 10);
                }
                if (isset($userRating->voted)) {
                    $voted = $userRating->voted;
                } else {
                    $voted = 0;
                }
                ?>
                <div class="jaw-one-rating-name"><?php echo esc_html__('Users rating', "gdn-theme") . ' (<span class="jaw-one-rating-weight">' . esc_attr($voted) . '</span>)'; ?></div>
                <div class="jaw-one-rating-number"><?php echo esc_attr($userScore); ?></div>
                <div class="jaw-one-rating-graphic-wrapper">                    
                    <div class="jaw-one-rating-graphic user_editable" style="width:<?php echo esc_attr($userRating->score); ?>%">
                        <input type="hidden" class="jw_rating_name" name="jw_rating_name" value="<?php echo esc_attr($userRating->name); ?>">
                        <input type="hidden" class="jw_rating_id" name="jw_rating_id" value="<?php echo esc_attr($userRating->id); ?>">
                        <input type="hidden" class="jw_rating_value" name="jw_rating_value" value="<?php echo esc_attr($userRating->score); ?>">
                        <input type="hidden" class="jw_rating_final_value" name="jw_rating_final_value" value="<?php echo esc_attr($userScore); ?>">
                        <input type="hidden" class="jw_rating_maximal_value" name="jw_rating_maximal_value" value="<?php echo esc_attr($userRating->maximalValue); ?>">
                        <input type="hidden" class="jw_rating_post_id" name="jw_rating_post_id" value="<?php echo esc_attr($post_id); ?>">
                        <input type="hidden" class="jw_rating_user_value" name="jw_rating_user_value" value="0">
                    </div>
                </div>
            </div>


            <!-- END USER RATING -->
        <?php } ?>
    </div>

<?php } ?>
