<?php if (is_user_logged_in() && jwOpt::get_option('use_my_news', '1')) { ?>
    <?php
    $f_post = '';
    $class = '';
    $user = get_user_by('email', get_comment_author_email());
    if ($user) {
        $featured_post = get_user_meta(get_current_user_id(), 'jaw_interest_comments', true);
        if (!empty($featured_post['authors']) && in_array($user->ID, $featured_post['authors'])) {
            $f_post = 'checked="checked"';
            $class = 'interested';
        }
        ?>
        <div class="jaw-featured-comentator jaw-featured <?php echo esc_attr($class); ?>">
            <label for="comentator_featured_<?php echo esc_attr($user->ID); ?>" title="<?php esc_html_e('Mark this commentator as featured', "gdn-theme"); ?>" >
                <span class="jaw-featured-added"><i class="jaw-icon-star3"></i><?php esc_html_e('Featured commentator', "gdn-theme"); ?></span>
                <span class="jaw-featured-wait"><i class="jaw-icon-busy2"></i><?php esc_html_e('Featured commentator', "gdn-theme"); ?></span>
                <span class="jaw-featured-add"><i class="jaw-featured-add jaw-icon-plus"></i><?php esc_html_e('Add to Featured', "gdn-theme"); ?></span>
            </label>
            <input id="comentator_featured_<?php echo esc_attr($user->ID); ?>" class="jwjs_interest_comentator jaw-featured-input comentator_featured_<?php echo esc_attr($user->ID); ?>" data-interest="<?php echo esc_attr($user->ID); ?>" type="checkbox" name="comentator_featured" value="<?php echo esc_attr($user->ID); ?>" <?php echo esc_attr($f_post); ?> />
        </div>
        <?php
    }
}