<?php
global $jaw_data, $post;
jaw_template_inc_counter('pagination');
$query = jaw_template_get_data();
$type = jaw_template_get_var('type', 'classical');
$pagination = jaw_template_get_var('blog_pagination', 'number');
// preset for content
$first = true;
if (!$query->have_posts()) {
        echo jaw_get_template_part('no_posts','blog');
}
if (jaw_template_get_var('bar_type', 'bar_type_1') != 'bar_type_big_left' && jaw_template_get_var('bar_type', 'bar_type_1') != 'bar_type_big_center' && jaw_template_get_var('bar_type', 'bar_type_1') != 'bar_type_big_right' && jaw_template_get_var('bar_show_categories', '0') && !empty($query->query_vars['category__in'])) {
    ?> <div class="list_of_categories <?php echo esc_attr(jaw_template_get_var('bar_type', 'bar_type_1')); ?>"> <?php
    if (sizeof($query->query_vars['category__in']) == 1) {
        $category = $query->query_vars['category__in'][0];
        echo '<a href="' . get_category_link($category) . '" title="' . get_cat_name($category) . '">' . esc_html__('see all', "gdn-theme") . '<i class="jaw-icon-arrow-right3"></i>' . '</a>';
    } else {
        foreach ($query->query_vars['category__in'] as $category) {
            echo '<a href="' . get_category_link($category) . '" title="' . get_cat_name($category) . '">' . get_cat_name($category) . '</a>';
        }
    }
    ?> </div> <?php 
}

$top_blog_image = jaw_template_get_var("url");
$top_blog_image_id = jaw_template_get_var("top_image_id");
$top_blog_image_link = jaw_template_get_var("blog_top_image_link", "");
if (isset($top_blog_image_id) && $top_blog_image_id != '') {
    ?>
    <div class="row blog-top-image">
        <div class="col-12 col-sm-12 col-lg-12">
            <?php echo jwMedia::getAttachment($top_blog_image_id, array('full'), $top_blog_image_link); ?> 
        </div>
    </div>
<?php } else if (isset($top_blog_image) && $top_blog_image != '') { ?>
    <div class="row blog-top-image">
        <div class="col-12 col-sm-12 col-lg-12">
            <?php if (strlen($top_blog_image_link) > 0) { ?>
                <img src="<?php echo esc_url($top_blog_image); ?>">
            <?php } else { ?>
                <img src="<?php echo esc_url($top_blog_image); ?>">
            <?php } ?>
        </div>
    </div>
<?php } ?>
<?php
$blog_classes = array();
$blog_classes[] = "jaw_paginated_" . jaw_template_get_counter('pagination');
$blog_classes[] = "blog_" . $type;
if (jaw_template_get_var('use_isotope', '1') == '1') {
    $blog_classes[] = 'jaw-isotope';
}
//jaw_template_set_var("clickable_image",1); // 16/11/2016 - Na vsech blozich byl natvrdo link v obrazku navzdory vsem nastavenim. 
?> 
<div class="row">
    <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?> jaw-blog-wraper">
        <div class="row jaw_blog <?php echo esc_attr(implode(" ", $blog_classes)); ?>" data-columns="<?php echo esc_attr(round(12 / jaw_template_get_var("columns", 4))); ?>" itemscope itemtype="http://schema.org/Blog">
            <?php do_action('jaw_before_blog'); ?>
            <?php    
            while ($query->have_posts()) {
                $query->the_post();
                if (get_post_meta(get_the_ID(), 'fw_rating_position', true) == '1') {
                    $format = 'review';
                } else {
                    $format = get_post_format();
                }
                $format = apply_filters( 'jaw_post_format', $format );
                if ($type == 'mix') {
                    if ($first) {
                        echo jaw_get_template_part('content-vertical', 'content', $format);
                        $first = false;
                    } else {
                        echo jaw_get_template_part('content-simple', 'content', $format);
                    }
                } else {
                    echo jaw_get_template_part('content-' . $type, 'content', $format);
                }
            }
            ?>
            <?php do_action('jaw_after_blog'); ?>
        </div>
    </div>
</div>
<?php echo jwRender::pagination(jaw_template_get_var('pagination', $pagination), $query); ?>
<?php
wp_reset_query();
