<?php
global $wp_query;

$term_id = jaw_template_get_var('termid','0');

$singlepost_preset = 'post-preset-' . jwOpt::get_option('main_color');

if (is_category()) {
    
   
    $singlepost_preset = 'post-preset-' . jwOpt::checkDefaultPreset(array(jwOpt::get_option('content_color', '_default', 'category', $term_id), jwOpt::get_option('main_color')),'color');
  
    echo jwUtils::customizer_preview_preset("Archive", jwOpt::checkDefaultPreset(array(jwOpt::get_option('content_color', '_default', 'category', $term_id), jwOpt::get_option('main_color')),'color'));

    if (jwOpt::get_option('cat_title_bar', '1', 'category', $term_id) != '0' && jwOpt::get_option('title_position', 'content', 'category', $term_id) == 'top') {
        echo jaw_get_template_part('category-header', 'blog');
    }
    $content = jwOpt::get_option('featured_top_revo_shortcodes', '', 'category', $term_id);
    if (isset($content['2_content']) && $content['2_content'] != '') {
        echo '<div class="builder-section jw-tax-featured-top ' . esc_attr(jwLayout::col_class(12)) . ' '.esc_attr($singlepost_preset).'">';
        echo '<div class="row">';
		echo do_shortcode($content['2_content']);
	    echo '</div>';
        echo '</div>'; 
    }
}

echo '<div id="content" class="' . esc_attr(jwLayout::content_class() . ' ' . jwLayout::content_layout() . ' builder-section archive-content ' . jwOpt::get_option('blog_bar_type') . ' ' . get_post_type() . ' '. $singlepost_preset).'">';
?>
<div  class="row"> 

    <?php    $archive_preset = jwOpt::get_option('archive_preset', '_default');

    if (is_category()) {
        $archive_preset = jwOpt::checkDefaultPreset(array(jwOpt::get_option('category_preset', '_default', 'category', $term_id), jwOpt::get_option('archive_preset')),'category');
     
        if (jwOpt::get_option('cat_title_bar', '1', 'category', $term_id) != '0' && jwOpt::get_option('title_position', 'content', 'category', $term_id) == 'content') {
            echo jaw_get_template_part('category-header', 'blog');
        }
        
        $content = jwOpt::get_option('featured_content_revo_shortcodes', '', 'category', $term_id);
        if (isset($content['2_content']) && $content['2_content'] != '') {
            echo '<div class="builder-section jw-tax-featured-content ' . esc_attr(jwLayout::col_class(12) . ' '. $singlepost_preset).'">';
            echo '<div class="row">';
    		echo do_shortcode($content['2_content']);
    	    echo '</div>';
            echo '</div>'; 
        }
    } else if (is_tag()) {
        ?>
        <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?>  builder-section jw-page-title">
            <h1 ><?php echo single_cat_title('', false); ?></h1>
        </div>
        <?php
        $cat_desc = tag_description();
        if (strlen($cat_desc) > 0) {
            echo '<div class="' . esc_attr(jwLayout::col_class(12)) . ' builder-section">';
            echo '<div class="row">';
            echo '<div class="' . esc_attr(jwLayout::col_class(12)) . ' jw-tax-description">';
            ?>

            <?php echo $cat_desc; ?>

            <?php
            echo '</div>';
            echo '</div>';
            echo '</div>';
        }
    }
    $wp_query->pagination = jwOpt::getPresetValue('blog_pagination', 'infinitemore', 'category', $archive_preset);
    $wp_query->type = jwOpt::getPresetValue('boxes_type', 'classical', 'category', $archive_preset);
    $wp_query->columns = round(12 / jwOpt::getPresetValue('posts_columns', '1', 'category', $archive_preset));
    $wp_query->letter_excerpt = jwOpt::getPresetValue('letter_excerpt', '-1', 'category', $archive_preset);
    $wp_query->title_h = jwOpt::getPresetValue('title_h', '3', 'category', $archive_preset);
    $wp_query->letter_excerpt_title = jwOpt::getPresetValue('letter_excerpt_title', '-1', 'category', $archive_preset);
    $wp_query->blog_category_inimage = jwOpt::getPresetValue('blog_category_inimage', '1', 'category', $archive_preset);
    $wp_query->blog_comments_inimage = jwOpt::getPresetValue('blog_comments_inimage', '1', 'category', $archive_preset);

    $wp_query->blog_metadate = jwOpt::getPresetValue('blog_metadate', '1', 'category', $archive_preset);
    $wp_query->blog_meta_author = jwOpt::getPresetValue('blog_meta_author', '0', 'category', $archive_preset);
    $wp_query->blog_comments_count = jwOpt::getPresetValue('blog_comments_count', '0', 'category', $archive_preset);
    $wp_query->blog_meta_category = jwOpt::getPresetValue('blog_meta_category', '0', 'category', $archive_preset);
    $wp_query->blog_meta_like = jwOpt::getPresetValue('blog_meta_like', '0', 'category', $archive_preset);
    $wp_query->blog_ratings = jwOpt::getPresetValue('blog_ratings', '0', 'category', $archive_preset);
    $wp_query->blog_readers = jwOpt::getPresetValue('blog_readers', '1', 'category', $archive_preset);
    $wp_query->blog_featured_post = jwOpt::getPresetValue('blog_featured_post', '1', 'category', $archive_preset);
    $wp_query->clickable_image = jwOpt::getPresetValue('clickable_image', '0', 'category', $archive_preset);

    echo '<div class="' . esc_attr(jwLayout::col_class(12)) . ' builder-section">';  
    echo '<div class="row">';
    echo '<div class="' . esc_attr(jwLayout::col_class(12)) . ' ' . esc_attr($singlepost_preset) . '">';

    if (is_category() || is_tag() || is_date()) {
        jaw_template_set_data($wp_query);
        echo jaw_get_template_part('blog');
    } else {
        echo jaw_get_template_part('custom', 'custom-posts');
    }
    echo '</div>';
    echo '</div>';
    echo '</div>';
    ?>  
</div>



</div><!-- End Content row -->