<?php get_header(); ?>
<?php
global $wp_query;
$jaw_singlepost_preset = 'post-preset-' . jwOpt::get_option('main_color');

echo '<div id="content" class="' . esc_attr(jwLayout::content_class()) . ' ' . esc_attr(jwLayout::content_layout()) . ' builder-section archive-content ' . jwOpt::get_option('blog_bar_type') . ' ' . get_post_type() . ' '.esc_attr($jaw_singlepost_preset).'">';

if(get_search_query() == ""){
?>
    <div  class="row"> 
        <div class="builder-section <?php echo esc_attr(jwLayout::col_class(12)); ?> ">
            <h1 class="jw-page-title"><?php esc_html_e( 'No results', "gdn-theme" ); ?></h1>
            <p><?php  esc_html_e('Please enter a keyword',  "gdn-theme"); ?></p>
            <?php get_search_form();?>
        </div>
    </div>
<?php
} else {
?>
    <div  class="row"> 
        <?php
        if ($wp_query->have_posts()) { ?>
        <div class="builder-section <?php echo esc_attr(jwLayout::col_class(12)); ?> ">
            <h1 class="jw-page-title"><?php printf( esc_html__( 'Search Results for: %s', "gdn-theme" ), get_search_query() ); ?></h1><?php get_search_form();?>
        </div>
        <?php
        }
        ?>


        <?php
        echo jwUtils::customizer_preview_preset("Archive",jwOpt::get_option('main_color'));
        $archive_preset = jwOpt::get_option('archive_preset', '_default');


        $wp_query->pagination = jwOpt::getPresetValue('blog_pagination', 'infinitemore', 'category', $archive_preset);
        $wp_query->type = jwOpt::getPresetValue('boxes_type', 'classical', 'category', $archive_preset);
        $wp_query->columns = round(12 / jwOpt::getPresetValue('posts_columns', '1', 'category', $archive_preset));
        $wp_query->letter_excerpt = jwOpt::getPresetValue('letter_excerpt', '-1', 'category', $archive_preset);
        $wp_query->title_h = jwOpt::getPresetValue('title_h', '3', 'category', $archive_preset);
        $wp_query->letter_excerpt_title = jwOpt::getPresetValue('letter_excerpt_title', '-1', 'category', $archive_preset);
        $wp_query->blog_category_inimage = jwOpt::getPresetValue('blog_category_inimage', '1', 'category', $archive_preset);
        $wp_query->blog_comments_inimage = jwOpt::getPresetValue('blog_comments_inimage', '1', 'category', $archive_preset);

        $wp_query->blog_metadate = jwOpt::getPresetValue('blog_metadate', '1', 'category', $archive_preset);
        $wp_query->blog_meta_author = jwOpt::getPresetValue('blog_meta_author', '0', 'category', $archive_preset);
        $wp_query->blog_comments_count = jwOpt::getPresetValue('blog_comments_count', '0', 'category', $archive_preset);
        $wp_query->blog_meta_category = jwOpt::getPresetValue('blog_meta_category', '0', 'category', $archive_preset);
        $wp_query->blog_meta_like = jwOpt::getPresetValue('blog_meta_like', '0', 'category', $archive_preset);
        $wp_query->blog_ratings = jwOpt::getPresetValue('blog_ratings', '0', 'category', $archive_preset);
        $wp_query->blog_readers = jwOpt::getPresetValue('blog_readers', '1', 'category', $archive_preset);
        $wp_query->blog_featured_post = jwOpt::getPresetValue('blog_featured_post', '1', 'category', $archive_preset);

        echo '<div class="' . esc_attr(jwLayout::col_class(12)) . ' builder-section">';
        echo '<div class="row">';
        echo '<div class="' . esc_attr(jwLayout::col_class(12)) . ' ' . esc_attr($jaw_singlepost_preset) . '">';

        jaw_template_set_data($wp_query);
        echo jaw_get_template_part('blog');

        echo '</div>';
        echo '</div>';
        echo '</div>';
        ?>  
    </div>

<?php } ?>

</div><!-- End Content row -->
<?php get_sidebar(); ?>

<?php
get_footer();