<?php
/*
  Template Name: MyNews User manager
 */

get_header();

$singlepost_preset = "";
if ($jaw_page_color = get_post_meta(get_the_ID(), 'jaw_page_color', true)) {
    echo jwUtils::customizer_preview_preset("Page", $jaw_page_color);
    $singlepost_preset = 'post-preset-' . $jaw_page_color . ' ';
} else {
    echo jwUtils::customizer_preview_preset("Page",jwOpt::get_option('main_color', 'default'));
    $singlepost_preset = 'post-preset-' . jwOpt::get_option('main_color', 'default') . ' ';
}
?>
<?php
echo '<div id="content" class="' . esc_attr(jwLayout::content_class()) . ' ' . esc_attr(jwLayout::content_layout()) . ' page jaw-user-settings '.esc_attr($singlepost_preset).'">';
global $more;
if (!is_user_logged_in()) {
    while (have_posts()) : the_post();
        if (get_post_meta(get_the_id(), '_display_page_name', '1') == '1') {
            ?>
            <h1><?php the_title(); ?></h1>

            <?php
        }
        $more = 0;
        echo jwBuilder::jwPbPrint(get_the_content('' ,true), 'header');
        ?>
    <div class="row">
        <div class="<?php echo esc_attr(jwLayout::col_class(6)); ?> builder-section">
            <?php
            jaw_template_set_var('bar_type', jwOpt::get_option('global_header_style', 'bar_type_1'));
            jaw_template_set_var('box_title', esc_html__('Log In','gdn-theme')); 
            echo jaw_get_template_part('section_bar', 'simple-shortcodes'); 
            jaw_template_set_var('show_register', '0');
            echo jaw_get_template_part('login', 'simple-shortcodes');
            ?>
        </div>
        <?php if(get_option('users_can_register')){ ?>
            <div class="<?php echo esc_attr(jwLayout::col_class(6)); ?> builder-section">
                <?php    
                jaw_template_set_var('bar_type', jwOpt::get_option('global_header_style', 'bar_type_1')); 
                jaw_template_set_var('box_title', esc_html__('Register','gdn-theme')); 
                echo jaw_get_template_part('section_bar', 'simple-shortcodes'); 
                echo jaw_get_template_part('register', 'simple-shortcodes');
                ?>
            </div>
        <?php } ?>
    </div>
    <?php
    endwhile;
    get_sidebar();
} else {
    while (have_posts()) : the_post();
        if (get_post_meta(get_the_id(), '_display_page_name', '1') == '1') {
            ?>
            <h1><?php the_title(); ?></h1>

            <?php
        }
        add_filter('the_content', array('jwBuilder', 'jwPbPrint'), 10); 
        $more = 1;
        the_content('' ,true);
        remove_filter('the_content', array('jwBuilder', 'jwPbPrint'), 10); 
        ?>
        <?php do_action('jaw_before_usermanagement'); ?>
        <form method="post" >
            <div class="interest_posts">
                <?php
                $interest_post = get_user_meta(get_current_user_id(), 'jaw_interest_posts', true);
                $interest_coments = get_user_meta(get_current_user_id(), 'jaw_interest_comments', true); // jen pro prehled jiz odebiranych a odhlaseni odberu

                /* JAW_CATEGORIES************************************ */
                $args = array(
                    'type' => 'post',
                    'hide_empty' => 1,
                    'taxonomy' => 'category'
                );
                $terms = get_categories($args);
                $terms = apply_filters('jaw_usermanagement_categories', $terms);                
                if (!empty($terms)) {
                    ?>
                    <div class="choose_class jaw-user-settings-item  builder-section">
                        <?php 
                            jaw_template_set_var('bar_type', jwOpt::get_option('global_header_style', 'bar_type_1')); 
                            jaw_template_set_var('box_title', esc_html__("Choose categories you're interested in:",'gdn-theme'));
                            echo jaw_get_template_part('section_bar', 'simple-shortcodes'); 
                         ?>
                        <?php
                        foreach ((array) $terms as $term) {
                            $check = '';
                            $class= "";
                            if (!empty($interest_post['cat']) && in_array($term->term_id, $interest_post['cat'])) {
                                $check = 'checked="checked"';
                                $class = "checked";
                            }
                            echo '<div class="jaw-settings-checkbox '.esc_attr($class).'">';
                            echo '<input type="checkbox" id="set-cat-' . esc_attr($term->term_id) . '" ' . esc_attr($check) . ' name="cat[' . esc_attr($term->term_id) . ']" />';
                            echo '<label for="set-cat-' . esc_attr($term->term_id) . '"><i class="jaw-icon-checkbox-unchecked2"></i><i class="jaw-user-checkmark jaw-icon-checkmark"></i>' . esc_attr($term->name) . '</label>';
                            echo '</div>';
                        }
                        ?>
                    </div>
                    <div class="clear"></div>
                    <?php
                }

                /* TAGS************************************ */
                $args = array(
                    'type' => 'post',
                    'hide_empty' => 1,
                    'taxonomy' => 'post_tag'
                );
                $terms = get_categories($args);
                $terms = apply_filters('jaw_usermanagement_tags', $terms);      
                if (!empty($terms)) {
                    ?>
                    <div class="choose_class jaw-user-settings-item builder-section">
                         <?php 
                            jaw_template_set_var('bar_type', jwOpt::get_option('global_header_style', 'bar_type_1')); 
                            jaw_template_set_var('box_title', esc_html__("Choose tags you're interested in:",'gdn-theme'));
                            echo jaw_get_template_part('section_bar', 'simple-shortcodes'); 
                         ?>
                        <?php
                        foreach ((array) $terms as $term) {
                            $check = '';
                            $class= "";
                            if (!empty($interest_post['tag']) && in_array($term->term_id, $interest_post['tag'])) {
                                $check = 'checked="checked"';
                                $class = "checked";
                            }
                            echo '<div class="jaw-settings-checkbox '.esc_attr($class).'">';
                            echo '<input type="checkbox" id="set-tag-' . esc_attr($term->term_id) . '" ' . esc_attr($check) . ' name="tag[' . esc_attr($term->term_id) . ']" />';
                            echo '<label for="set-tag-' . esc_attr($term->term_id) . '"><i class="jaw-icon-checkbox-unchecked2"></i><i class="jaw-user-checkmark jaw-icon-checkmark"></i>' . esc_attr($term->name) . '</label>';
                            echo '</div>';
                        }
                        ?>
                    </div>
                    <div class="clear"></div>
                    <?php
                }



                /* AUTHORS ************************************ */
                $args = array(
                    'who' => 'authors'
                );
                $users = get_users($args);
                $users = apply_filters('jaw_usermanagement_authors', $users);    
                if (!empty($users)) {
                    ?>
                    <div class="choose_class jaw-user-settings-item builder-section">
                        <?php 
                            jaw_template_set_var('bar_type', jwOpt::get_option('global_header_style', 'bar_type_1')); 
                            jaw_template_set_var('box_title', esc_html__("Choose authors you want follow:",'gdn-theme'));
                            echo jaw_get_template_part('section_bar', 'simple-shortcodes'); 
                         ?>
                        <?php
                        foreach ((array) $users as $user) {
                            $check = '';
                            $class= "";
                            if (!empty($interest_post['user']) && in_array($user->data->ID, $interest_post['user'])) {
                                $check = 'checked="checked"';
                                $class = "checked";
                            }
                            echo '<div class="jaw-settings-checkbox '.esc_attr($class).'">';
                            echo '<input type="checkbox" id="set-user-' . esc_attr($user->data->ID) . '" ' . esc_attr($check) . ' name="user[' . esc_attr($user->data->ID) . ']" />';
                            echo '<label for="set-user-' . esc_attr($user->data->ID) . '"><i class="jaw-icon-checkbox-unchecked2"></i><i class="jaw-user-checkmark jaw-icon-checkmark"></i>' . esc_attr($user->data->display_name) . '</label>';
                            echo '</div>';
                        }
                        ?>
                    </div>
                    <div class="clear"></div>
                <?php } ?>

            </div>

<?php /**** COMMENTS ****/ ?>

            <div class="interest_comments">
                <?php
                /* POSTS ************************************ */
                if (empty($interest_coments['posts'])) {
                    $interest_coments['posts'] = array();
                } else {
                    ?>
                    <div class="choose_posts_comment jaw-user-settings-item builder-section">
                        <?php 
                            jaw_template_set_var('bar_type', jwOpt::get_option('global_header_style', 'bar_type_1')); 
                            jaw_template_set_var('box_title', esc_html__("Choose post's comments you want follow:",'gdn-theme'));
                            echo jaw_get_template_part('section_bar', 'simple-shortcodes'); 
                         ?>
                        <?php
                        $interest_coments['posts'] = array_unique($interest_coments['posts']);
                        foreach ((array) $interest_coments['posts'] as $post_id) {

                            $check = 'checked="checked"';
                            $class = "checked";
                            
                            echo '<div class="jaw-settings-checkbox '.esc_attr($class).'">';
                            echo '<input type="checkbox" id="set-user-' . esc_attr($post_id) . '" ' . esc_attr($check) . ' name="user[' . esc_attr($post_id) . ']" />';
                            echo '<label for="set-user-' . esc_attr($post_id) . '"><i class="jaw-icon-checkbox-unchecked2"></i><i class="jaw-user-checkmark jaw-icon-checkmark"></i>' . get_the_title($post_id) . '</label>';
                            echo '</div>';
                        }
                        ?>
                    </div>
                    <div class="clear"></div>
                <?php } ?>
                
            </div>


            <?php wp_nonce_field('usermanagment'); ?>
            <input type="hidden" value="<?php echo get_current_user_id(); ?>" name="userID"/>
            <input type="hidden" value="jaw-usermanagment" name="jaw-usermanagment"/>
        </form>
        <?php do_action('jaw_after_usermanagement'); ?>
        <?php
    endwhile;
   
}

echo '</div>';
 get_sidebar();
?>
<?php get_footer(); ?>