<?php
/*
  Template Name: Reading List
 */

get_header();

$singlepost_preset = "";
if ($jaw_page_color = get_post_meta(get_the_ID(), 'jaw_page_color', true)) {
    echo jwUtils::customizer_preview_preset("Page", $jaw_page_color);
    $singlepost_preset = 'post-preset-' . $jaw_page_color . ' ';
} else {
    echo jwUtils::customizer_preview_preset("Page",jwOpt::get_option('main_color', 'default'));
    $singlepost_preset = 'post-preset-' . jwOpt::get_option('main_color', 'default') . ' ';
}
?>
<?php
echo '<div id="content" class="' . esc_attr(jwLayout::content_class()) . ' ' . esc_attr(jwLayout::content_layout()) . ' page jaw-user-settings '.esc_attr($singlepost_preset).'">';
global $wp_query, $more;

if (!is_user_logged_in()) {
    while (have_posts()) : the_post();
        if (get_post_meta(get_the_id(), '_display_page_name', '1') == '1') {
            ?>
            <h1><?php the_title(); ?></h1>

            <?php
        }
        $more = 0;
        echo jwBuilder::jwPbPrint(get_the_content('' ,true), 'header');
        ?>
    <div class="row">
        <div class="<?php echo esc_attr(jwLayout::col_class(6)); ?> builder-section">
            <?php
            jaw_template_set_var('bar_type', jwOpt::get_option('global_header_style', 'bar_type_1'));
            jaw_template_set_var('box_title', esc_html__('Log In','gdn-theme')); 
            echo jaw_get_template_part('section_bar', 'simple-shortcodes'); 
            jaw_template_set_var('show_register', '0');
            echo jaw_get_template_part('login', 'simple-shortcodes');
            ?>
        </div>
        <?php if(get_option('users_can_register')){ ?>
            <div class="<?php echo esc_attr(jwLayout::col_class(6)); ?> builder-section">
                <?php    
                jaw_template_set_var('bar_type', jwOpt::get_option('global_header_style', 'bar_type_1')); 
                jaw_template_set_var('box_title', esc_html__('Register','gdn-theme')); 
                echo jaw_get_template_part('section_bar', 'simple-shortcodes'); 
                echo jaw_get_template_part('register', 'simple-shortcodes');
                ?>
            </div>
        <?php } ?>
    </div>
    <?php
    endwhile;
    get_sidebar();
} else {
    while (have_posts()) : the_post();
        if (get_post_meta(get_the_id(), '_display_page_name', '1') == '1') {
            ?>
            <h1><?php the_title(); ?></h1>

            <?php
        }
        add_filter('the_content', array('jwBuilder', 'jwPbPrint'), 10); 
        $more = 1;
        the_content('' ,true);
        remove_filter('the_content', array('jwBuilder', 'jwPbPrint'), 10); 
        ?>
        <?php

            $singlepost_preset = 'post-preset-' . jwOpt::get_option('main_color');
            
            ?>
            <div  class="row"> 
            
                <?php    
                $archive_preset = jwOpt::get_option('archive_preset', '_default');
                $featured_posts = get_user_meta(get_current_user_id(), 'jaw_featured_posts', true);
                $qs = array();

                $qs['paged'] = (get_query_var('paged')) ? get_query_var('paged') : 1;
            
                $qs['post__in'] = $featured_posts;
                $qs['posts_per_page'] = jwOpt::get_option('user_reading_list_number_posts', 5);
                $qs['post_type'] = 'post';
            
                $query = new WP_Query($qs);
            
                $query->pagination = jwOpt::getPresetValue('blog_pagination', 'infinitemore', 'category', $archive_preset);
                $query->type = jwOpt::getPresetValue('boxes_type', 'classical', 'category', $archive_preset);
                $query->columns = round(12 / jwOpt::getPresetValue('posts_columns', '1', 'category', $archive_preset));
                $query->letter_excerpt = jwOpt::getPresetValue('letter_excerpt', '-1', 'category', $archive_preset);
                $query->title_h = jwOpt::getPresetValue('title_h', '3', 'category', $archive_preset);
                $query->letter_excerpt_title = jwOpt::getPresetValue('letter_excerpt_title', '-1', 'category', $archive_preset);
                $query->blog_category_inimage = jwOpt::getPresetValue('blog_category_inimage', '1', 'category', $archive_preset);
                $query->blog_comments_inimage = jwOpt::getPresetValue('blog_comments_inimage', '1', 'category', $archive_preset);
            
                $query->blog_metadate = jwOpt::getPresetValue('blog_metadate', '1', 'category', $archive_preset);
                $query->blog_meta_author = jwOpt::getPresetValue('blog_meta_author', '0', 'category', $archive_preset);
                $query->blog_comments_count = jwOpt::getPresetValue('blog_comments_count', '0', 'category', $archive_preset);
                $query->blog_meta_category = jwOpt::getPresetValue('blog_meta_category', '0', 'category', $archive_preset);
                $query->blog_meta_like = jwOpt::getPresetValue('blog_meta_like', '0', 'category', $archive_preset);
                $query->blog_ratings = jwOpt::getPresetValue('blog_ratings', '0', 'category', $archive_preset);
                $query->blog_readers = jwOpt::getPresetValue('blog_readers', '1', 'category', $archive_preset);
                $query->blog_featured_post = jwOpt::getPresetValue('blog_featured_post', '1', 'category', $archive_preset);
                $query->clickable_image = jwOpt::getPresetValue('clickable_image', '0', 'category', $archive_preset);
            
                echo '<div class="' . esc_attr(jwLayout::col_class(12)) . ' builder-section">';
                echo '<div class="row">';
                echo '<div class="' . esc_attr(jwLayout::col_class(12)) . ' ' . esc_attr($singlepost_preset) . '">';
            
                jaw_template_set_data($query);
                echo jaw_get_template_part('blog');

                echo '</div>';
                echo '</div>';
                echo '</div>';
                ?>  
            </div>

        <?php
    endwhile;
    
}

echo '</div>';
get_sidebar();
?>
<?php get_footer(); ?>