<?php
global $wp_query,$jaw_data, $content_width;
$old_query = $wp_query;
$qs = array();

$preset = jwOpt::get_option('blog_preset', '_default');

$qs['paged'] = (get_query_var('paged')) ? get_query_var('paged') : 1;
$qs['category__in'] = jwOpt::get_option('blog_cat', '');
$qs['post_type'] = 'post';
$qs['order'] = jwOpt::get_option('blog_order', 'desc');
$qs['orderby'] = jwOpt::get_option('blog_orderby', 'date');


$blog_query = new WP_Query($qs);
$blog_query->pagination = jwOpt::getPresetValue('blog_pagination', 'number', 'category', $preset);
$blog_query->type = jwOpt::getPresetValue('boxes_type', 'vertical-big', 'category', $preset);
$blog_query->columns = round(12 / jwOpt::getPresetValue('posts_columns', '1', 'category', $preset));
$blog_query->letter_excerpt = jwOpt::getPresetValue('letter_excerpt', '-1', 'category', $preset);
$blog_query->title_h = jwOpt::getPresetValue('title_h', '3', 'category', $preset);
$blog_query->letter_excerpt_title = jwOpt::getPresetValue('letter_excerpt_title', '-1', 'category', $preset);
$blog_query->blog_category_inimage = jwOpt::getPresetValue('blog_category_inimage', '1', 'category', $preset);
$blog_query->blog_comments_inimage = jwOpt::getPresetValue('blog_comments_inimage', '1', 'category', $preset);

$blog_query->blog_metadate = jwOpt::getPresetValue('blog_metadate', '1', 'category', $preset);
$blog_query->blog_meta_author = jwOpt::getPresetValue('blog_meta_author', '0', 'category', $preset);
$blog_query->blog_comments_count = jwOpt::getPresetValue('blog_comments_count', '0', 'category', $preset);
$blog_query->blog_meta_category = jwOpt::getPresetValue('blog_meta_category', '0', 'category', $preset);
$blog_query->blog_meta_like = jwOpt::getPresetValue('blog_meta_like', '0', 'category', $preset);
$blog_query->blog_ratings = jwOpt::getPresetValue('blog_ratings', '0', 'category', $preset);
$blog_query->blog_readers = jwOpt::getPresetValue('blog_readers', '1', 'category', $preset);
$blog_query->blog_featured_post = jwOpt::getPresetValue('blog_featured_post', '1', 'category', $preset);
$blog_query->clickable_image = jwOpt::getPresetValue('clickable_image', '0', 'category', $preset);

?>

<div class="builder-section  <?php echo esc_attr(jwLayout::col_class(12)); ?>">
    <div class="row">
        <?php echo jwUtils::customizer_preview_preset("Archive", jwOpt::get_option('main_color')); ?>
        <div class="<?php echo esc_attr(jwLayout::col_class(12)) . ' ' . 'post-preset-' . jwOpt::get_option('main_color'); ?> ">
            <?php
            jaw_template_set_data($blog_query);
            echo jaw_get_template_part('blog');
            ?>
        </div>
    </div>
</div>

<?php
$wp_query = $old_query;

