/* JAW Utils
 *
 * contains utils for gdaynews only
 */
'use strinct';
(function ($) {

    JawApp.prototype.utils = {
        init: function () {
            var $that = this;

            //spusteni bootstrap carouselu
            $('.carousel').carousel();

            // IE fallback
            if ($("html").hasClass("ie8")) {
                $('*:last-child').addClass('last-child');
                $('#sidebar #searchform #searchsubmit').val(' ');
            }
            //registration
            $('.jaw-user-registered-now').addClass('jaw-user-registered-now-after');
            $('.jaw-user-registered-now-after').one("transitionend MSTransitionEnd webkitTransitionEnd oTransitionEnd", function (e) {
                $(this).removeClass('jaw-user-registered-now');
                $(this).removeClass('jaw-user-registered-now-after');
            });

            $that.checkBrowser(navigator.userAgent);
            $that.nextprevPost();

            $that.keepRatio();
            $that.search.init();
            $that.totop();
            $that.toSection();
            $that.prettyPhoto();
            $that.reviewFontSize();
            $that.fullwidth();
            $that.paralax.init();
            $that.dividerTotop();
            $that.print();
            $that.fontResizer();
            $that.singleFeatures();
            $that.backgroundBannerWidth();
            $('body').on('jaw-DOMchanged', $that.fullwidth);
            $('body').on('jaw-scroll-optimize', $that.showUpPost);
            $('body').on('jaw-scroll-optimize', $that.showUpVideo);

            $that.tweetIt.init();
            $that.mashshareOnOffSwitch();
            $that.getSpoiler();
        },
        checkBrowser: function (userAgent) {
            //flexbox fallback
            var notSupportMenu = ['Safari/534', 'MSIE'];
            $.each(notSupportMenu, function (key, browser) {
                if (userAgent.search(browser) >= 0) {
                    $('body').addClass('jaw-fallback-menu');
                }
            });
        },

        // Previous, next post - fix for blank img
        nextprevPost: function () {
            var img_prev = "#nav-single .nav-previous-container img";
            var img_next = "#nav-single .nav-next-container img";
            if ($(img_prev).height() === 1 && $(img_prev).width() === 1) {
                $(".nav-img-previous").hide();
            }
            if ($(img_next).height() === 1 && $(img_next).width() === 1) {
                $(".nav-img-next").hide();
            }
        },
        keepRatio: function () {
            //video 16:9 na kazdem device
            $('.jaw-keep-ratio').each(function () {
                $(this).height($(this).width() / 1.78);
                $(this).find('.jaw-sub-keep-ratio').css('max-height', ($(this).width() / 1.78));
            });
        },
        // Jaw search
        search: {
            init: function () {
                var $that = this;
                $that.searchOpen();
            },
            // open input after click on it
            searchOpen: function () {
                var $that = this;
                //kliknuti na search icon v topbaru/menu
                $('.jaw-popup-serarch').find("#searchform").on('click', function (e) {
                    var $searchForm = $(this);
                    e.stopPropagation();
                    if (!$(this).find('.search-box').hasClass("jaw-search-opened")) {
                        e.preventDefault();
                    }
                    $(this).parents(".jaw-user-panel-search").addClass("jaw-clicked");
                    $searchForm.find('.search-box').removeClass("jaw-search-closed").addClass("jaw-search-opened");
                    $searchForm.find("#s").focus();
                    $that.searchClosed($searchForm);
                });
            },
            // hide input after click around
            searchClosed: function ($searchForm) {
                $(document).on('click', function (e) {
                    if ($searchForm.find(".jaw-search-opened").length > 0) {
                        $searchForm.find('.search-box').removeClass("jaw-search-opened").addClass("jaw-search-closing");
                        $(".jaw-user-panel-search").removeClass("jaw-clicked");
                        $searchForm.find('.search-input').one("transitionend webkitTransitionEnd oTransitionEnd MSTransitionEnd", function () {
                            $searchForm.find('.search-box').removeClass("jaw-search-closing").addClass("jaw-search-closed");
                        });
                    }
                });
            },
        },
        totop: function () {
            $('body').on('jaw-scroll-optimize', function (e, scrollTop) {
                if (scrollTop >= 50) {
                    $('#totop').show(250);
                } else {
                    $('#totop').hide(250);
                }
            });
            $('#totop').click(function () {
                $('html, body').animate({
                    scrollTop: 0
                }, 350);
            });

        },
        checkScroll: function (el, scrollTop, fixedHeight) {
            var $el = $(el);
            var docViewTop = scrollTop + fixedHeight,
                docViewBottom = docViewTop + $(window).height(),
                elemTop = $el.offset().top,
                elemBottom = elemTop + $el.height();
            return ((elemBottom >= docViewTop) && (elemTop <= docViewBottom));
        },
        toSection: function () {
            var $that = this;
            if ($(".one-page-menu-item").length) { // is set
                var fixedHeight = 10;
                if ($('.admin-bar').length) {
                    fixedHeight = fixedHeight + 30;
                }
                $('.jaw-fixed-bar').each(function (key, element) {
                    fixedHeight = fixedHeight + $(this).height();
                });

                $("a.one-page-menu-item").parent("li").removeClass("current-menu-item");
                var actual_id = "";
                var getScroll = function (id) {
                    if ($(id).length) {
                        $('html,body').animate({
                            scrollTop: $(id).offset().top - fixedHeight // scroll to that position
                        }, 1000);
                    }
                    return false;
                };
                // outside
                if (window.location.hash) {
                    actual_id = window.location.hash;
                    var getoff = actual_id.substr(1);
                    $('*[data-onepage-id=' + getoff + ']').parent("li").addClass("current-menu-item");
                    if (actual_id.length) {
                        getScroll(actual_id);
                    } 
                }  
                // inside
                $("a.one-page-menu-item").click(function (e) {
                    if ($("a.one-page-menu-item").parent("li").hasClass("current-menu-item")) {
                        $("a.one-page-menu-item").parent("li").removeClass("current-menu-item");
                    }
                    $(this).parent("li").addClass("current-menu-item");
                    $('body').removeClass('mobile-menu-open'); // pro mobile menu
                    actual_id = '#' + $(this).data("onepage-id"); // current menu item
                    if (actual_id.length) {
                        getScroll(actual_id);
                    }
                    e.preventDefault();
                });
                // scroll
                var ids = [];
                $('.has-onepage-id').each(function () {
                    ids.push($(this).attr("id"));
                });
                $('body').on('jaw-scroll-optimize', function (e, scrollTop) {
                    for (var i = 0; i < ids.length; i++) {
                        if (ids[i].length) {
                            if ($that.checkScroll('#' + ids[i], scrollTop, fixedHeight)) {
                                $('a.one-page-menu-item').parent("li").removeClass("current-menu-item");
                                $('*[data-onepage-id=' + ids[i] + ']').parent("li").addClass("current-menu-item");
                                break;
                            } else {
                                $('*[data-onepage-id=' + ids[i] + ']').parent("li").removeClass("current-menu-item");
                            }
                        }
                    }
                });
            }
        },

        prettyPhoto: function () {
            $("a[rel^='prettyPhoto'], a[data-rel^='prettyPhoto'] ").prettyPhoto({
                social_tools: false,
                default_width: 800,
                default_height: 500,
                show_title: false,
                deeplinking: false,
                theme: 'jaw_scheme'
            });
        },
        reviewFontSize: function () {
            $('.jaw_blog').each(function () {
                var font_sum = $(this).find('.format-review .image').width() * 0.5 / 1.78;
                $(this).find('.format-review').each(function (key, val) {
                    $(this).find('.post-review-total').css('font-size', font_sum);
                    $(this).find('.post-review-total span').css('font-size', font_sum / 2);
                });
            });
        },
        fullwidth: function () { 
            var window_width = $(document).width() + 2;
            var offset_left = 0;
            if ($('#main').length) {
                offset_left = $('#main').offset().left + 15;
                $('.fullwidth-fw_content').each(function () {
                    $(this).outerWidth(window_width);
                    $(this).css('left', -(offset_left));
                    $(this).addClass("jw-fw-initialized");
                });
                offset_left = $('#container').offset().left + 1;
                $('.fullwidth-fw_edge').each(function () {
                    $(this).width(window_width);
                    $(this).css('left', -(offset_left));
                    $(this).addClass("jw-fw-initialized");
                });
                $('.fullwidth-fw_color').each(function () {
                    var $jawMediabg = $(this).children().children().children('.jaw-mediabg');
                    $jawMediabg.outerWidth(window_width);
                    $jawMediabg.css('left', -(offset_left));
                    $(this).addClass("jw-fw-initialized");
                });
                ///recalculate width of google Maps
                jQuery("body").trigger("jaw_g_maps");
            }
        },
        paralax: {
            init: function () {
                var $that = this;
                $that.resize();
                $('body').on('jaw-scroll', $that.paralax);
                $('.jw-paralax-dynamic').find('.jaw-bg-item').load(function () {
                    $that.paralax(null, window.pageYOffset);
                });
            },
            resize: function () {
                var $that = this;
                $that.height = $(window).height();
            },
            paralax: function (e, scrollTop) {
                //osetreni
                if (scrollTop === undefined) {
                    scrollTop = window.pageYOffset;
                }
                var $that = this;
                $('.jw-paralax-dynamic').find('.jaw-bg-item').each(function () {
                    var scrolled = ($(this).parent().height() - $(this).height()) / $(window).height() * (scrollTop - $(this).parent().offset().top);
                    $(this).css('top', (-(scrolled * 0.5)) + 'px');
                });
                $('.jw-paralax-static').find('.jaw-bg-item').each(function () {
                    $(this).css('top', (scrollTop - $(this).parent().offset().top) + 'px');
                    $(this).css('min-height', $that.height);
                });
            }
        },
        dividerTotop: function () {
            $('.divider_to_top').click(function () {
                $('body,html').animate({
                    scrollTop: 0
                }, 300);
                return false;
            });
        },
        print: function () {
            var $that = "body";
            var $printClass = "jaw-print";
            $(".post-meta-print").each(function (key, element) {
                $(this).on("click", function () {
                    $($that).addClass($printClass);
                    window.print();
                    $($that).removeClass($printClass);
                });
            });
        },
        fontResizer: function () {
            var $that = {
                main: "body",
                printClass: "jaw-font-resize",
                size: "normal"
            };
            $(".post-meta-font-resize").on("click", function (e) {
                $($that.main).removeClass($that.printClass + ' ' + $that.size);
                $that.size = $(this).attr('class').split(' ')[1];
                $($that.main).addClass($that.printClass + ' ' + $that.size);
                e.preventDefault();
            });

        },
        /**
         * Show up related post
         */
        showUpPost: function (e, scrollTop) {
            var $that = {
                main: "body",
                printClass: "jaw-showup-post",
                class: ".jaw-after-perex",
                show: false
            };
            if (!$($that.class).length) {
                return;
            }
            if ($($that.main).hasClass($that.printClass)) {
                return;
            }
            // check state
            if (scrollTop >= $($that.class).offset().top + $($that.class).outerHeight() - window.innerHeight) {
                $that.show = true;
            } else {
                $that.show = false;
            }
            // add class
            if ($that.show) {
                $($that.main).addClass($that.printClass);
                $(".jaw-icon-close").on("click", function () { // hide element after click close btn
                    $(".jaw-blog-wraper.jaw-showup").addClass("jaw-hide");
                });
            }
        },
        showUpVideo: function (e, scrollTop) {
            if ($(window).width() - $('#container').width() > 600) {
                if ($(".single-post .jaw-showup-video-on").length && $(".jaw-single.format-video").length) {
                    var $that = {
                        class: ".single-post .jaw-showup-video-on .jaw-single .jaw_single_img iframe",
                        topSpace: 30,
                        fixedHeight: 10,
                        show: false
                    };
                    if ($('.admin-bar').length) {
                        $that.fixedHeight = $that.fixedHeight + $that.topSpace;
                    }
                    $(".jaw-fixed-bar[class*='jw-fullwidth-on']").each(function (key, element) {
                        $that.fixedHeight = $that.fixedHeight + $(this).height();
                    });
                    if ($($that.class).length > 0 && scrollTop >= $($that.class).offset().top + $($that.class).outerHeight()) {
                        $that.show = true;
                    } else {
                        $that.show = false;
                    }
                    if ($that.show) {
                        $(".jaw-single .jaw_single_img").css("height", $(".jaw-single .jaw_single_img").height()); // placeholder
                        $($that.class).removeAttr('style');
                        $($that.class).addClass("jaw-sticked-video");
                        $($that.class).css({
                            "width": $(".container").offset().left - $that.topSpace,
                            "position": "fixed",
                            "right": 0,
                            "top": $that.fixedHeight - ($that.topSpace / 2)
                        });
                        $('.jaw-keep-ratio').each(function () {
                            $(this).height($(this).width() / 1.78);
                            $(this).find('.jaw-sub-keep-ratio').css('max-height', ($(this).width() / 1.78));
                        });
                    }
                    // if header exists
                    if ($(".jaw_header_wrapper").length) {
                        $that.fixedHeight = $that.fixedHeight + $(".jaw_header_wrapper").height() + ($that.topSpace * 3);
                    }
                    if ($($that.class).hasClass("jaw-sticked-video") && scrollTop < $(".jaw-single .jaw_single_img").height() + $that.fixedHeight) {
                        $($that.class).removeAttr('style');
                        $('.jaw-keep-ratio').each(function () {
                            $(this).height($(this).width() / 1.78);
                            $(this).find('.jaw-sub-keep-ratio').css('max-height', ($(this).width() / 1.78));
                        });
                    }
                }
            }
        },
        singleFeatures: function () {
            jQuery('.post-meta-rating').on('click', function () {
                jQuery('html, body').animate({
                    scrollTop: jQuery(".jw-rating-box").offset().top - 200
                }, 500);
            });
        },
        modernizr: function () {
            if (!Modernizr.csstransforms3d) {
                $('body').addClass('no-transform3d');
            }
        },
        tweetIt: {
            init: function () {
                var $that = this;
                var x, y;
                $(document).mousemove(function (e) {
                    x = e.pageX;
                    y = e.pageY;
                });
                $('.jaw-single .perex, .jaw-single .jaw-after-perex').on("click", function (e) {
                    if ($that.getHighlightedText() !== "" && $("#jaw-tweet-me").length) {
                        $("#jaw-tweet-me").attr("href", 'https://twitter.com/intent/tweet?text=' + encodeURI($that.getHighlightedText()) + '&url=' + encodeURI(document.URL));
                        $("#jaw-tweet-me").attr("target", '_blank');
                        $('#jaw-tweet-me').css({
                            'top': y - 50,
                            'left': x
                        }).fadeIn('slow');
                    } else {
                        $('#jaw-tweet-me').hide();
                    }
                });
            },
            getHighlightedText: function () {
                var text = "";
                if (window.getSelection) {
                    text = window.getSelection().toString();
                } else if (document.selection && document.selection.type != "Control") {
                    text = document.selection.createRange().text;
                }
                if (!text.trim()) {
                    return '';
                } else {
                    return text;
                }
            }
        },
        mashshareOnOffSwitch: function () {
            // Toggle @mash in jaw gallery
            $(".jaw-media-gallery .mashShareIcon.jaw-icon-share2").on("click", function (e) {
                $(".jaw-media-gallery .mashsb-box").toggle();
            });
        },
        // spoiler alert
        getSpoiler: function () {
            $(".jaw-spoiler").hover(function () {
                $(this).addClass("hideColors");
            }, function () {
                $(this).removeClass("hideColors");
            });
        },
        backgroundBannerWidth: function () {
            var offset_left = 0;
            if (jQuery('.container').offset() !== undefined) {
                offset_left = jQuery('.container').offset().left;
            } else {
                offset_left = 0;
            }
            var banner_left_width = jQuery('.background_banner_link.left').width();
            var banner_right_width = jQuery('.background_banner_link.right').width();
            if (banner_left_width > 0) {
                jQuery('.background_banner_link.left').css({
                    left: (offset_left - banner_left_width) + 'px',
                    height: '100%'
                });
            } else {
                jQuery('.background_banner_link.left').css({
                    width: offset_left + 'px',
                    height: '100%'
                });
            }

            if (banner_right_width > 0) {
                jQuery('.background_banner_link.right').css({
                    right: (offset_left - banner_right_width) + 'px',
                    height: '100%'
                });
            } else {
                jQuery('.background_banner_link.right').css({
                    width: offset_left + 'px',
                    height: '100%'
                });
            }
        }
    };
})(jQuery);