(function($, window, undefined) {
    JawApp.prototype.userRating = function() {
        $('.jaw-user-rating') 
                .mousemove(function(e) {
                    var jw_rating_id = $(this).find(".jw_rating_id").val();
                    var jw_rating_post_id = $(this).find(".jw_rating_post_id").val();
                    var cookieName = "jw_user_rating_" + jw_rating_post_id + "_" + jw_rating_id;
                    if ($.cookie(cookieName) == 1) {
                        $(this).find(".jaw-one-rating-graphic").removeClass("user_editable");
                    }
                    if ($(this).find('.jaw-one-rating-graphic').hasClass("user_editable")) {
                        var maximalValue = $(this).find('.jw_rating_maximal_value').val();
                        var userRating = (e.pageX - $(this).find('.jaw-one-rating-graphic-wrapper').offset().left);
                        var widthRating = $(this).find('.jaw-one-rating-graphic-wrapper').outerWidth();
                        var actualRating = userRating / widthRating * 100;
                        if (actualRating > 100)
                            actualRating = 100;
                        if (actualRating < 0)
                            actualRating = 0; 

                        $(this).find('.jaw-one-rating-number').text(Math.round(actualRating * maximalValue));
                        $(this).find('.jaw-one-rating-graphic').css({
                            width: actualRating + "%"
                        });
                        $(this).find('.jw_rating_user_value').val(Math.round(actualRating * maximalValue) / maximalValue);
                    }

                })
                .mouseleave(function() {
                    if ($(this).find('.jaw-one-rating-graphic').hasClass("user_editable")) {
                        var ratingScore = $(this).find(".jw_rating_value").val();
                        var ratingFinalScore = $(this).find(".jw_rating_final_value").val();
                        $(this).find('.jaw-one-rating-graphic').css({
                            width: ratingScore + "%"
                        });
                        $(this).find('.jaw-one-rating-number').text(Math.round(ratingFinalScore * 100) / 100);
                    }
                })
                .on('click', function() {
                    var jw_rating_id = $(this).find(".jw_rating_id").val();
                    var jw_rating_post_id = $(this).find(".jw_rating_post_id").val();
                    var cookieName = "jw_user_rating_" + jw_rating_post_id + "_" + jw_rating_id;
                    
                    if ($(this).find('.jaw-one-rating-graphic').hasClass("user_editable")) {
                        var data = {
                            postId: jw_rating_post_id,
                            ratingId: jw_rating_id,
                            score: $(this).find('.jw_rating_user_value').val()
                        };
                        $.post(
                                ajax_object.ajax_url, {
                                    'action': 'jwrating_vote', // nebo jwrating_get
                                    'data': data
                                },
                        function(response) {
                            var resp = $.parseJSON(response);
                            var $this = $('.jaw-user-rating');
                            if($this.find('.jw_rating_post_id').val() == jw_rating_post_id){
                                $this.find(".jw_rating_value").val(resp.score);
                                $this.find(".jw_rating_final_value").val(resp.finalScore);
                                $this.find('.jaw-one-rating-graphic').css({
                                    width: resp.score + "%"
                                });
                                $this.find('.jaw-one-rating-number').text(Math.round(resp.finalScore * 100) / 100);
                                $this.find('.jaw-one-rating-weight').text(resp.voted);
                                $this.find('.jaw-one-rating-graphic').removeClass('user_editable');
                                $.cookie(cookieName, 1, {
                                    expires: 1,
                                    path: '/'
                                });
                            }
                        });
                    }
                });
    };
})(jQuery, window); 