/*lazyload by JAW templates*/
(function($, window, undefined) {
    var default_options = {
      autoSlide: true,
      interval: 5000  
    };
    var jaw_slider = {
        init: function($slider, atts) {
            var options = $.extend({}, default_options, atts);
            var $that = this;
            
            var interval;
            
            setInterval( function(){
                $slider.addClass('initialized');
            }, 500);
            
            $slider.find('.slider-item').last().addClass('shown').prependTo($slider.find('.slider-row'));
            $slider.find('.slider-item').last().addClass('shown').prependTo($slider.find('.slider-row'));

            //autoslide
            if(options.autoSlide){
                interval = setInterval(function() {
                    $slider.removeClass('slid');
                    $that.slid($slider, 'left');
                }, options.interval);
    
                $slider.on('mouseenter', function() {
                    clearInterval(interval);
                });
                
                $slider.on('mouseleave', function() {
                    clearInterval(interval);
                    interval = setInterval(function() {
                        $slider.removeClass('slid');
                        $that.slid($slider, 'left');
                    }, options.interval);
                });
            }
            
            //click on arrow
            $slider.find('.jaw-slider_2-arrow,.jaw-slider_4-arrow').on('click', function() {
                $that.slid($slider, $(this).data('direction'));
            });
            
            //touch
            $slider.hammer().on("swipeleft swiperight", function(ev) {
                switch(ev.type) {
                    case "swipeleft" :
                        $that.slid($slider, 'left');
                        break;
                    case "swiperight" :
                        $that.slid($slider, 'right');
                        break;
                    default:
                        break;
                }
            });
            
            $slider.one("transitionend MSTransitionEnd webkitTransitionEnd oTransitionEnd", function(e) {
                $(window).jawOptimize('jaw-DOMchanged',function(){
                    $('body').trigger('jaw-DOMchanged');
                }); 
            });

        },
        slid: function($slider, direction) {


            if (!$slider.hasClass('slid')) {
                $slider.addClass('slid');
                if (direction == 'left') {
                    $slider.find('.slider-item').first().appendTo($slider.find('.slider-row'));
                } else {
                    $slider.find('.slider-item').last().prependTo($slider.find('.slider-row'));
                }

                $slider.find('.slider-item').removeClass('active');
                $slider.find('.slider-item').eq(2).addClass('active');
                $slider.find('.slider-item').removeClass('before');
                $slider.find('.slider-item').eq(1).addClass('before');
                $slider.find('.slider-item').removeClass('after');
                $slider.find('.slider-item').eq(3).addClass('after');

                $slider.find('.slider-item').one("transitionend MSTransitionEnd webkitTransitionEnd oTransitionEnd", function(e) {
                    $slider.removeClass('slid');
                });
            }

        }
    };
   $.fn.slider = function(options) {
       var $slider = this;
        jaw_slider.init($slider, options);
        return this;
    }; 
    
})(jQuery, window); 