/* JAW Responsive  */
'use strinct';
(function($, undefined) {
    JawApp.prototype.responsive = {
        init: function() {
            var $that = this;
            $that.singlepost();
            $that.responsiveImg.init();
        },
                
        // Single post
        singlepost: function() {
            // Single post gallery - fix for 6 pics in gallery box / bottom
            var $bottomGallery = $(".jaw-media-gallery-bottom .jaw-gal-container .item-bottom.col-mob-6");
            var galleryCount = 6;
            if($bottomGallery.length > galleryCount) {
                $bottomGallery.each(function() {
                    if ($(window).width() <= 991) {
                        $(this).removeClass("col-lg-12-7");
                        $bottomGallery.last().hide();
                    } else {
                        $(this).addClass("col-lg-12-7");
                        $bottomGallery.last().show();
                    }
                });
            }

            // Single post gallery - fix long string in title
            if ($(window).width() <= 414) {
                $(".jaw-gallery-bottom-text").addClass("jaw-excerpt");
            } else {
                $(".jaw-gallery-bottom-text").removeClass("jaw-excerpt");
            }
        },
        
        // All responsive imgs - lazy load
        responsiveImg: {
            retina: 1,
            init: function() {
                var $that = this;
                var $body = $('body');
                
                //retina 
                if($body.hasClass('jaw-retina-images') && window.devicePixelRatio && $that.typeOfConnection() != 'cellular'){
                    $that.retina = window.devicePixelRatio;
                } 
            
                // jaw-hide-image tridu maji obrazky, ktery se zobrazi az po nascrolovani na ne
                $('.jw-responsive-img').not('.jaw-hide-image').each(function(id, img) {
                    $that.loadImage($(img));
                });
                if ($body.hasClass('jaw-hide-image')) {
                    $that.scroolOnImage(window.pageYOffset);
                
                    $body.on('jaw-scroll-optimize', function(e,scrollTop){
                        $that.scroolOnImage(scrollTop);
                    } );  
                }
                $body.on('jaw-responsiveImg', function(e,$img,callback, injectWidth) {
                        $img.each(function(id,image){ 
                           $that.loadImage($(image), callback, injectWidth); 
                        });
                });  
            },  
            typeOfConnection: function(){
                //get type of connection
                var connection = navigator.connection || navigator.mozConnection || navigator.webkitConnection;
                var type_of_connection = 'wifi';
                if(connection !== undefined){
                    type_of_connection = connection.type;
                }
                return type_of_connection;
            },
            loadImage: function($img, callback, injectWidth) {
                var $that = this;
                var data = $img.data('src');
                var img_width = $img.width()*$that.retina;
                var choosed = false;                
                if(injectWidth !== undefined){
                    //pokud chci retina rozliseni
                    img_width = injectWidth*$that.retina;
                }
                for (var img_data in data) {
                    //obrazky v "data" jsou poskladany od nejmensiho po nejvetsi
                    //projedu vsechny a jakmile narazim na vetsi obrazek, nez je jeho fyzicka velikost, tak ho naladuju
                    if (data[img_data] !== undefined && data[img_data].width >= img_width) {
                        choosed = img_data;
                        $img.one('load', function() { 
                            $img.removeClass('jaw-hide-image');
                            $img.parents('.image').addClass('initialized');
                            $img.css('opacity','1'); 
                            $(window).jawOptimize('jaw-DOMchanged',function(){
                                $('body').trigger('jaw-DOMchanged');
                            }); 
                            if(callback !== undefined){
                                callback();
                            }  
                        });  
                        //zmenim src na vybrany obrazek
                        if ($img.attr('src') != data[img_data].file) {
                            $img.attr('src', data[img_data].file);
                        }
                        break;
                    } 
                }
                // pokud neni zadny obrazek dostatecne velky, tak naloaduju ten nejvetsi mozny
                if (data !== undefined && data[img_data] !== undefined && !choosed) {
                    $img.load(function() {
                        $img.removeClass('jaw-hide-image');
                        $img.css('opacity','1');
                        $img.parents('.image').addClass('initialized');
                        $(window).jawOptimize('jaw-DOMchanged',function(){
                            $('body').trigger('jaw-DOMchanged');
                        }); 
                    });
                    $img.attr('src', data[img_data].file);
                }
            },  
            checkScroll: function(el,scrollTop) {
                var $el = $(el);
                var docViewTop = scrollTop,
                        docViewBottom = docViewTop + $(window).height(),
                        elemTop = $el.offset().top,
                        elemBottom = elemTop + $el.height();
                // Pokud je vrchni hrana elementu (fotky) nad spodni hranou obrazovky
                // a zaroven spodni hrana elementu (fotky) je pod horni hranou obrazovky.
                // + 300 rezerva
                return ((elemTop <= docViewBottom + 300) && (elemBottom >= docViewTop - 300));
            },
            scroolOnImage: function(scrollTop) {
                var $that = this;
                $('.jw-responsive-img.jaw-hide-image').each(function(id, img) {
                    if ($that.checkScroll(img,scrollTop)) {
                        $that.loadImage($(img));
                    }
                });
            }
            
        }
    };
})(jQuery);