/**
 * Pokud uzivatel najede na polozku v menu/login button(v menu)/my-news ikonky (neprihlasen)
 * - ma se zobrazit nejake submenu/prihlasovaci login/banner
 * - tento script pocka 300ms (zda-li na tom prvku dany uzivatel zustal) a pote ho teprve otevre. 
 */
(function ($, window, undefined) {
    JawApp.prototype.layzOpenItem = {
        init: function () {
            var $that = this;
            //otevirani sub-menu
            $('.jw-menu-bar .top-nav > .menu-item.has-dropdown').each(function () {
                $that.doLazyOpen(this);
            });
            //otevirani login formu
            $that.doLazyOpen('.jaw-user-login .jaw-user-item');
            //otevirani my menu
            $that.doLazyOpen('.jaw-user-buttons');
        },
        doLazyOpen: function (element) {
            //pockani, zda-li uzivatel opravdu chce otevrit item(menu) - vydrzi na tom policku 300ms
            //pokud jen prejede -> nic se nestane 
            var timeoutEnter = 0;
            var timeoutLeave = 0;
            var canOpen = true;
            
            var openMenu = function ($actualItem, e) {
                clearTimeout(timeoutEnter); 
                if (canOpen) {//pokudse menu zavira (opacity), tak ho nemuzu otevrit.
                    //pokud najedu na jinej item, tak vymazu canOpen pro vsechny
                    $('body').trigger('layzOpenItem_canOpen');
                    clearTimeout(timeoutLeave);
                    $('body').trigger('jaw-responsiveImg', [$actualItem.find('img')]);
                    timeoutEnter = setTimeout(function () {
                        $actualItem.addClass('open');
                    }, 300);
                }
            };
            var closeMenu = function ($actualItem, e) {
                //firefox - Mouseout event triggered for parent when mouseover on autocomplete drop down
                if ($(e.target).is('input')) {
                    return;
                };
                clearTimeout(timeoutLeave);
                clearTimeout(timeoutEnter);
                canOpen = false;
                if (!$actualItem.hasClass('open')) {
                    canOpen = true;
                    return;
                }
                timeoutLeave = setTimeout(function () { //zavru item - se zpozdenim
                    $actualItem.addClass('closing');
                    $actualItem.removeClass('open');
                    setTimeout(function () { //cekam na dobehnuti animace
                        $actualItem.removeClass('closing');
                        canOpen = true;
                    }, 300);
                }, 300);
            }; 


            var $menu = $(element);
            $menu
                .on('mouseenter', function(e){
                    openMenu($(this), e);
                })
                .on('mouseleave', function(e){
                    closeMenu($(this), e);
                });
            $('body').on('layzOpenItem_canOpen', function ($element) {
                canOpen = true;
                $menu.removeClass('closing');
            });
            
            var mobileTouch = function(){
                    $menu.one("click",  function(e){
                        if ("ontouchstart" in document.documentElement) {
                            var $actualItem = $(this); 
                            e.preventDefault();
                            e.stopPropagation();
                            $(this).off('click');
                            openMenu($actualItem, e);   
                            $("html").one("touchstart tap click", function(e){
                                if(!$menu.is(e.target) && $menu.has(e.target).length === 0){
                                    e.preventDefault();
                                    e.stopPropagation(); 
                                    closeMenu($actualItem, e); 
                                    mobileTouch();  
                                }
                            });  
                        }   
                    });
            };
            mobileTouch();
        }
    };
})(jQuery, window); 