(function ($, window, undefined) {
    JawApp.prototype.isotope = {
        options: {
            isotope_grid: 'masonry',
            transformsEnabled: false,
            animationEngine: 'css'
        },
        init: function () {
            var $that = this;

            //Když je IE 8 nebo RTL     - $.cookie("rtl_support")  - pro panel
            if ($.browser.msie === true && parseInt($.browser.version, 10) === 8) {
                $that.options.transformsEnabled = false;
                $that.options.animationEngine = 'css';
            } else {
                $that.options.transformsEnabled = true;
                $that.options.animationEngine = 'jquery';
            }
            
            $that.infinityScroll();


            $('.jaw-isotop-on .jaw-isotope').each(function (key, el) {
                $that.oneIsotope(el);
            });
            //kazdych 5s se prelayoutuje isotope (aby tam nebylo neco rozbiteho)
            setInterval($that.reLayout, 5000);
        },
        oneIsotope: function (el) {
            var $that = this;

            var $container = $(el).isotope({
                layoutMode: $that.options.isotope_grid,
                animationEngine: $that.options.animationEngine,
                transformsEnabled: $that.options.transformsEnabled,
                itemSelector: '.jaw-isotope > .element',
                resizable: true,
                isInitLayout: false
            });
            $container.isotope();
        },
        reLayout: function () {
            $('.jaw-isotop-on .jaw-isotope').each(function (key, el) {
                $(el).isotope();
            });
        },
        infinityScroll: function () {

            var count_page = 0;
            var num_page_on_page = 2; // <<--- Number of ajax section on page
            if (typeof infinite_scroll != 'undefined') {

                jQuery.each(infinite_scroll, function (i, in_sc) {
                    jQuery(in_sc.contentSelector).infinitescroll(in_sc, function (newElements) {
                        jQuery(this).isotope("appended", jQuery(newElements)); //>>>>> Speed gallery slider (on the main page) for next pages in infinite list<<<<<
                        jQuery('#infinite_load_' + in_sc.id + ' .morebutton').show();
                        if (in_sc.type == 'ajax') {
                            count_page++;
                            if (count_page >= (num_page_on_page - 1)) {
                                jQuery(in_sc.contentSelector).infinitescroll({
                                    state: {
                                        isDone: true
                                    }
                                });
                                jQuery("#infinite_load_" + in_sc.id).append(window.next_page);
                                jQuery("#infinite_load_" + in_sc.id).append(jQuery('#infinite_load_' + in_sc.id + ' #post-nav-infinite .post-next-infinite').html());
                            }
                        }
                        jQuery('body').trigger('jaw-IsotopeLoaded');
                        jQuery('body').trigger('jaw-responsiveImg',[jQuery(this).find('img')]);
                    });
                    if (in_sc.type == 'infinitemore') {
                        jQuery('#infinite_load_' + in_sc.id + ' #post-nav-infinite').hide();
                        if(jQuery('#infinite_load_' + in_sc.id + ' .morebutton').length === 0){
                            jQuery("#infinite_load_" + in_sc.id).append(more);
                        }
                        jQuery(in_sc.contentSelector).infinitescroll('pause');
                        jQuery('#infinite_load_' + in_sc.id + ' .morebutton').click(function () {
                            jQuery(in_sc.contentSelector).infinitescroll('retrieve');
                            jQuery('#infinite_load_' + in_sc.id + ' .morebutton').hide();
                        });
                    } else if (in_sc.type == 'infinite') {
                        jQuery('#infinite_load_' + in_sc.id + ' #post-nav-infinite').hide();
                    }
                });
            }
        }
    };
})(jQuery, window); 