
'use strinct';
(function ($) {
    JawApp.prototype.interest = {
        hooks: function (jawUtils/*DI-utils*/) {
            var $that = this;
            
            // otevirani banneruje v jaw utils
           
            
            $('.jwjs_interest_comments').on('change', function () {
                $that.featuredAjax('jaw_discussion', '.jwjs_interest_comments');
            });
            $('.jwjs_interest_comentator').on('change', function () {
                $that.featuredAjax('jaw_comentator', '.comentator_featured_' + $(this).data('interest'));
            });
            $('.jwjs_featured_post').on('change', function () {
                $that.featuredAjax('jaw_featured_post', '.jwjs_featured_post');
            });

            /* otevreni panelu s history/interest items ... */
            $('.logged-in').find('.jaw-user-panel').find('.jaw-user-item').not('.jaw-user-settings').on('click', function (event) {
                //Nejdriv zavru vse ostatni
                $('.jaw-user-panel-content').find('.jaw-user-item').removeClass('open');
                $('.jaw-user-panel-content').find('.jaw-user-item').css('max-height', '0');
                //pokud kliknu na ikonku
                var $content = $('.jaw-user-panel-content').find($(this).data('content'));
                var scrollTop = 0;
                if($('.main-menu').length > 0){
                    scrollTop = $('.main-menu').offset().top;
                }
                if (!$content.length) {
                    //zobrazeni spin ikonky (v chrome to blblo)
                    $('.jaw-user-panel-content .jaw-user-content .jaw-icon-spinner2').addClass('show-icon');
                    $('body,html').animate({
                            scrollTop: scrollTop
                    }, 300);
                    //zobrazim kolecko
                    $('.jaw-user-panel-content').find('.jaw-user-item').css('max-height', $('.jaw-user-panel-content').find('.jaw-user-content').outerHeight(true));
                    $that.showUserContent($('.jaw-user-panel-content'), $(this).data('content'));
                   
                } else {
                    if (!$content.hasClass('open')) {
                        //otevře se panelu 
                        $content.addClass('open');
                        $('body,html').animate({
                            scrollTop: scrollTop
                        }, 300);
                    }
                    $content.css('max-height', $content.find('.jaw-user-content').outerHeight(true) + $('.jaw_user_hide').outerHeight(true));
                } 
                $content.find('.jaw-user-content').one('transitionend webkitTransitionEnd oTransitionEnd otransitionend MSTransitionEnd', 
                function() {
                    //end of
                });
                
                $(window).jawOptimize('jaw-DOMchanged',function(){
                    $('body').trigger('jaw-DOMchanged');
                }); 
                $('.jaw-user-panel-content').find('.jaw-user-item.open').find('.jaw-user-content').on('click', function (event) {
                    event.stopPropagation();
                });
                event.stopPropagation();
            });

            
            /* obsluha nastaveni MY NEWS */
            $('.jaw-user-settings-item input').on('change', function () {
                if ($(this).attr('checked') === 'checked') {
                    $(this).parents('.jaw-settings-checkbox').addClass('checked');
                } else {
                    $(this).parents('.jaw-settings-checkbox').removeClass('checked');
                }
                $that.settingsAjax('jaw_user_settings', $(this).parents('form'));
            });

            /* vycisteni historie */
            $('.jaw-user-panel-content').on('click','.jwjs-clear-history', function (event) {
                $that.cleanHistoryAjax($('.jaw-user-time .jaw_blog'));
                event.preventDefault();
            });


        },
        /* provedeni akce "add to featured" */ 
        featuredAjax: function (action, element) {
            var $element = $(element);
            var $parent = $element.parents('.jaw-featured');

            $parent.addClass('waiting');
            var data = {
                'action': action,
                'type': $element.data('type'),
                'interest': $element.data('interest'),
                'value': $element.prop("checked"),
                'security': ajax_object.ajax_nonce
            };

            $.post(ajax_object.ajax_url, data, function (response) {
                $parent.removeClass('waiting');
                if (response == 'true') {
                    $parent.addClass('interested');
                } else if (response == 'false') {
                    $parent.removeClass('interested');
                }

            });
        },
        /* pokud zaskrtnu nejaky policko v nastaveni */
        settingsAjax: function (action, $element) {
            var data = {
                'action': action,
                'value': $element.serializeArray(),
                'security': ajax_object.ajax_nonce
            };
            $.post(ajax_object.ajax_url, data, function (response) {

                $element.removeClass('waiting');
                if (response == 'true') {
                    $element.addClass('interested');
                } else if (response == 'false') {
                    $element.removeClass('interested');
                }

            });
        },
        /* vycisti data o prohlizeni */
        cleanHistoryAjax: function (element) {

            var data = {
                'action': 'jaw_user_clear_history',
                'security': ajax_object.ajax_nonce
            };

            $.post(ajax_object.ajax_url, data, function (response) {
                element.html('');
            });
        },

        /* nacti content history/interested items/... */
        showUserContent: function ($content, typ) {
            var data = {
                'action': 'jaw_user_get_content',
                'security': ajax_object.ajax_nonce
            };

            $.post(ajax_object.ajax_url, data, function (response) {
                $content.html(response);
                $content.find('.jaw-isotope').each(function(key,el){
                    $('body').trigger('jaw-oneIsotope', [el]);
                });
                $('body').trigger('jaw-responsiveImg',[$content.find('img')], function(){
                    $content.find(typ).css('max-height', $content.find(typ).find('.jaw-user-content').outerHeight(true) + $('.jaw_user_hide').outerHeight(true));
                });
                $('body').trigger('jaw-scroll',[window.pageYOffset]); 
                
                if (!$content.find(typ).hasClass('open')) {
                    //otevře se dialog 
                    $content.find(typ).addClass('open');
                }
                
                $('.jaw_user_hide').on('click', function (e) {
                    // zavru po kliku na hide
                    $('.jaw-user-panel-content').find('.jaw-user-item').removeClass('open');
                    $('.jaw-user-panel-content').find('.jaw-user-item').css('max-height', '0');
                });
                    
            });
        }

    };
})(jQuery);
